/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.net;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import org.teiid.core.util.ArgCheck;
import org.teiid.core.util.HashCodeUtil;

public class HostInfo {
    private String hostName;
    private int portNumber = 0;
    private InetAddress inetAddress;
    private boolean ssl;

    public HostInfo(String hostName, InetSocketAddress addr) {
        this.hostName = hostName;
        this.portNumber = addr.getPort();
        this.inetAddress = addr.getAddress();
    }

    public HostInfo(String host, int port) {
        ArgCheck.isNotNull(host);
        this.hostName = host.toLowerCase();
        this.portNumber = port;
        try {
            InetAddress addr = InetAddress.getByName(this.hostName);
            if (addr.getHostAddress().equalsIgnoreCase(this.hostName)) {
                this.inetAddress = addr;
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    public InetAddress getInetAddress() throws UnknownHostException {
        if (this.inetAddress != null) {
            return this.inetAddress;
        }
        return InetAddress.getByName(this.hostName);
    }

    public String getHostName() {
        return this.hostName;
    }

    public int getPortNumber() {
        return this.portNumber;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.hostName).append(":").append(this.portNumber);
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof HostInfo)) {
            return false;
        }
        HostInfo hostInfo = (HostInfo)obj;
        if (this.portNumber != hostInfo.getPortNumber()) {
            return false;
        }
        if (this.ssl != hostInfo.ssl) {
            return false;
        }
        if (this.inetAddress != null && hostInfo.inetAddress != null) {
            return this.inetAddress.equals(hostInfo.inetAddress);
        }
        return this.hostName.equals(hostInfo.getHostName());
    }

    public int hashCode() {
        int hc = HashCodeUtil.hashCode(0, this.hostName);
        return HashCodeUtil.hashCode(hc, this.portNumber);
    }

    public boolean isResolved() {
        return this.inetAddress != null;
    }

    public boolean isSsl() {
        return this.ssl;
    }

    public void setSsl(boolean ssl) {
        this.ssl = ssl;
    }
}

