/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.net.socket;

import java.io.EOFException;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.teiid.client.security.Secure;
import org.teiid.client.util.ExceptionHolder;
import org.teiid.client.util.ExceptionUtil;
import org.teiid.client.util.ResultsFuture;
import org.teiid.client.util.ResultsReceiver;
import org.teiid.core.crypto.CryptoException;
import org.teiid.core.crypto.Cryptor;
import org.teiid.core.crypto.DhKeyGenerator;
import org.teiid.core.crypto.NullCryptor;
import org.teiid.jdbc.JDBCPlugin;
import org.teiid.net.CommunicationException;
import org.teiid.net.HostInfo;
import org.teiid.net.socket.AuthenticationType;
import org.teiid.net.socket.Handshake;
import org.teiid.net.socket.Message;
import org.teiid.net.socket.ObjectChannel;
import org.teiid.net.socket.ObjectChannelFactory;
import org.teiid.net.socket.ServiceInvocationStruct;
import org.teiid.net.socket.SingleInstanceCommunicationException;
import org.teiid.net.socket.SocketServerInstance;

public class SocketServerInstanceImpl
implements SocketServerInstance {
    static final int HANDSHAKE_RETRIES = 10;
    private static Logger log = Logger.getLogger("org.teiid.client.sockets");
    private static AtomicInteger MESSAGE_ID = new AtomicInteger();
    private Map<Serializable, ResultsReceiver<Object>> asynchronousListeners = new ConcurrentHashMap<Serializable, ResultsReceiver<Object>>();
    private long synchTimeout;
    private HostInfo info;
    private ObjectChannel socketChannel;
    private Cryptor cryptor;
    private String serverVersion;
    private AuthenticationType authType = AuthenticationType.CLEARTEXT;
    private HashMap<Class<?>, Object> serviceMap = new HashMap();
    private boolean hasReader;

    public SocketServerInstanceImpl(HostInfo info, long synchTimeout) {
        if (!info.isResolved()) {
            throw new AssertionError((Object)"Expected HostInfo to be resolved");
        }
        this.info = info;
        this.synchTimeout = synchTimeout;
    }

    public synchronized void connect(ObjectChannelFactory channelFactory) throws CommunicationException, IOException {
        this.socketChannel = channelFactory.createObjectChannel(new InetSocketAddress(this.info.getInetAddress(), this.info.getPortNumber()), this.info.isSsl());
        try {
            this.doHandshake();
        }
        catch (CommunicationException e) {
            this.socketChannel.close();
            throw e;
        }
        catch (IOException e) {
            this.socketChannel.close();
            throw e;
        }
    }

    @Override
    public HostInfo getHostInfo() {
        return this.info;
    }

    private void doHandshake() throws IOException, CommunicationException {
        Handshake handshake = null;
        boolean sentInit = false;
        for (int i = 0; i < 10; ++i) {
            try {
                Object obj = this.socketChannel.read();
                if (!(obj instanceof Handshake)) {
                    throw new SingleInstanceCommunicationException(JDBCPlugin.Event.TEIID20009, null, JDBCPlugin.Util.gs(JDBCPlugin.Event.TEIID20009, new Object[0]));
                }
                handshake = (Handshake)obj;
                break;
            }
            catch (ClassNotFoundException e1) {
                throw new SingleInstanceCommunicationException(JDBCPlugin.Event.TEIID20010, e1, e1.getMessage());
            }
            catch (SocketTimeoutException e) {
                if (!sentInit && !this.info.isSsl()) {
                    this.socketChannel.write(null);
                    sentInit = true;
                }
                if (i != 9) continue;
                throw e;
            }
            catch (IOException e) {
                if (sentInit && !this.info.isSsl()) {
                    throw new SingleInstanceCommunicationException(JDBCPlugin.Event.TEIID20032, e, JDBCPlugin.Util.gs(JDBCPlugin.Event.TEIID20032, new Object[0]));
                }
                throw e;
            }
        }
        try {
            this.serverVersion = handshake.getVersion();
            this.authType = handshake.getAuthType();
            handshake.setVersion();
            byte[] serverPublicKey = handshake.getPublicKey();
            if (serverPublicKey != null) {
                DhKeyGenerator keyGen = new DhKeyGenerator();
                byte[] publicKey = keyGen.createPublicKey();
                this.cryptor = keyGen.getSymmetricCryptor(serverPublicKey, "08.03".compareTo(this.serverVersion) > 0, this.getClass().getClassLoader());
                handshake.setPublicKey(publicKey);
            } else {
                this.cryptor = new NullCryptor();
            }
            this.socketChannel.write(handshake);
        }
        catch (CryptoException e) {
            throw new CommunicationException(JDBCPlugin.Event.TEIID20012, e, e.getMessage());
        }
    }

    @Override
    public String getServerVersion() {
        return this.serverVersion;
    }

    @Override
    public boolean isOpen() {
        return this.socketChannel.isOpen();
    }

    @Override
    public void send(Message message, ResultsReceiver<Object> listener, Serializable messageKey) throws CommunicationException, InterruptedException {
        if (listener != null) {
            this.asynchronousListeners.put(messageKey, listener);
        }
        message.setMessageKey(messageKey);
        boolean success = false;
        try {
            Future<?> writeFuture = this.socketChannel.write(message);
            writeFuture.get();
            success = true;
        }
        catch (ExecutionException e) {
            throw new SingleInstanceCommunicationException(JDBCPlugin.Event.TEIID20013, e, e.getMessage());
        }
        finally {
            if (!success) {
                this.asynchronousListeners.remove(messageKey);
            }
        }
    }

    private void exceptionOccurred(Throwable e) {
        if (e instanceof CommunicationException) {
            if (e.getCause() instanceof InvalidClassException) {
                log.log(Level.SEVERE, "Unknown class or incorrect class version:", e);
            } else {
                log.log(Level.FINE, "Unable to read: socket was already closed.", e);
            }
        } else if (e instanceof EOFException) {
            log.log(Level.FINE, "Unable to read: socket was already closed.", e);
        } else {
            log.log(Level.WARNING, "Unable to read: unexpected exception", e);
        }
        if (!(e instanceof SingleInstanceCommunicationException)) {
            e = new SingleInstanceCommunicationException(e);
        }
        Set<Map.Entry<Serializable, ResultsReceiver<Object>>> entries = this.asynchronousListeners.entrySet();
        Iterator<Map.Entry<Serializable, ResultsReceiver<Object>>> iterator = entries.iterator();
        while (iterator.hasNext()) {
            Map.Entry<Serializable, ResultsReceiver<Object>> entry = iterator.next();
            iterator.remove();
            entry.getValue().exceptionOccurred(e);
        }
    }

    private void receivedMessage(Object packet) {
        log.log(Level.FINE, "reading packet");
        if (packet instanceof Message) {
            Message messagePacket = (Message)packet;
            Serializable messageKey = messagePacket.getMessageKey();
            ExceptionHolder holder = null;
            if (messageKey instanceof ExceptionHolder) {
                holder = (ExceptionHolder)messageKey;
                messageKey = (Serializable)messagePacket.getContents();
            }
            log.log(Level.FINE, "read asynch message:" + messageKey);
            ResultsReceiver<Object> listener = this.asynchronousListeners.remove(messageKey);
            if (listener != null) {
                if (holder != null) {
                    listener.exceptionOccurred(holder.getException());
                } else {
                    listener.receiveResults(messagePacket.getContents());
                }
            }
        } else {
            log.log(Level.FINE, "packet ignored:" + packet);
        }
    }

    @Override
    public void shutdown() {
        this.socketChannel.close();
    }

    @Override
    public Cryptor getCryptor() {
        return this.cryptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void read(long timeout, TimeUnit unit, ResultsFuture<?> future) throws TimeoutException, InterruptedException {
        long timeoutMillis = (int)Math.min(unit.toMillis(timeout), Integer.MAX_VALUE);
        long start = System.currentTimeMillis();
        while (!future.isDone()) {
            long now;
            boolean reading = false;
            SocketServerInstanceImpl socketServerInstanceImpl = this;
            synchronized (socketServerInstanceImpl) {
                if (!this.hasReader) {
                    this.hasReader = true;
                    reading = true;
                } else if (!future.isDone()) {
                    this.wait(Math.max(1L, timeoutMillis));
                }
            }
            if (reading) {
                SocketServerInstanceImpl e2;
                try {
                    if (!future.isDone()) {
                        this.receivedMessage(this.socketChannel.read());
                    }
                }
                catch (SocketTimeoutException e2) {
                    e2 = this;
                    synchronized (e2) {
                        this.hasReader = false;
                        this.notifyAll();
                    }
                }
                catch (Exception e3) {
                    this.exceptionOccurred(e3);
                }
                finally {
                    e2 = this;
                    synchronized (e2) {
                        this.hasReader = false;
                        this.notifyAll();
                    }
                }
            }
            if (future.isDone() || (timeoutMillis -= (now = System.currentTimeMillis()) - (start = now)) > 0L) continue;
            throw new TimeoutException("Read timeout after " + timeout + " milliseconds.");
        }
    }

    @Override
    public synchronized <T> T getService(Class<T> iface) {
        Object service = this.serviceMap.get(iface);
        if (service == null) {
            service = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{iface}, (InvocationHandler)new RemoteInvocationHandler(iface, false){

                @Override
                protected SocketServerInstanceImpl getInstance() {
                    return SocketServerInstanceImpl.this;
                }
            });
            this.serviceMap.put(iface, service);
        }
        return iface.cast(service);
    }

    @Override
    public long getSynchTimeout() {
        return this.synchTimeout;
    }

    @Override
    public AuthenticationType getAuthenticationType() {
        return this.authType;
    }

    public static abstract class RemoteInvocationHandler
    implements InvocationHandler {
        private Class<?> targetClass;
        private boolean secureOptional;

        public RemoteInvocationHandler(Class<?> targetClass, boolean secureOptional) {
            this.targetClass = targetClass;
            this.secureOptional = secureOptional;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Throwable t = null;
            try {
                final SocketServerInstance instance = this.getInstance();
                Message message = new Message();
                message.setContents(new ServiceInvocationStruct(args, method.getName(), this.targetClass));
                Secure secure = method.getAnnotation(Secure.class);
                if (secure != null && (!secure.optional() || this.secureOptional)) {
                    message.setContents(instance.getCryptor().sealObject(message.getContents()));
                }
                ResultsFuture<Object> results = new ResultsFuture<Object>(){

                    @Override
                    protected Object convertResult() throws ExecutionException {
                        try {
                            Object result = instance.getCryptor().unsealObject(super.convertResult());
                            if (result instanceof ExceptionHolder) {
                                throw new ExecutionException(((ExceptionHolder)result).getException());
                            }
                            if (result instanceof Throwable) {
                                throw new ExecutionException((Throwable)result);
                            }
                            return result;
                        }
                        catch (CryptoException e) {
                            throw new ExecutionException(e);
                        }
                    }

                    @Override
                    public Object get() throws InterruptedException, ExecutionException {
                        try {
                            return this.get(instance.getSynchTimeout(), TimeUnit.MILLISECONDS);
                        }
                        catch (TimeoutException e) {
                            throw new ExecutionException(e);
                        }
                    }

                    @Override
                    public Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                        instance.read(timeout, unit, this);
                        return super.get(timeout, unit);
                    }
                };
                ResultsReceiver<Object> receiver = results.getResultsReceiver();
                instance.send(message, receiver, Integer.valueOf(MESSAGE_ID.getAndIncrement()));
                if (ResultsFuture.class.isAssignableFrom(method.getReturnType())) {
                    return results;
                }
                return results.get(instance.getSynchTimeout(), TimeUnit.MILLISECONDS);
            }
            catch (ExecutionException e) {
                t = e.getCause();
            }
            catch (TimeoutException e) {
                t = new SingleInstanceCommunicationException(e);
            }
            catch (Throwable e) {
                t = e;
            }
            throw ExceptionUtil.convertException(method, t);
        }

        protected abstract SocketServerInstance getInstance() throws CommunicationException;
    }
}

