/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.visitor;

import java.util.Map;
import org.teiid.core.util.Assertion;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.navigator.DeepPreOrderNavigator;
import org.teiid.query.sql.symbol.Symbol;
import org.teiid.query.sql.visitor.AbstractSymbolMappingVisitor;

public class StaticSymbolMappingVisitor
extends AbstractSymbolMappingVisitor {
    private Map symbolMap;

    public StaticSymbolMappingVisitor(Map symbolMap) {
        Assertion.isNotNull(symbolMap);
        this.symbolMap = symbolMap;
    }

    @Override
    protected Symbol getMappedSymbol(Symbol symbol) {
        return (Symbol)this.symbolMap.get(symbol);
    }

    public static void mapSymbols(LanguageObject obj, Map symbolMap) {
        if (obj == null || symbolMap.isEmpty()) {
            return;
        }
        StaticSymbolMappingVisitor ssmv = new StaticSymbolMappingVisitor(symbolMap);
        DeepPreOrderNavigator.doVisit(obj, ssmv);
    }
}

