/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.xquery.saxon;

import java.util.LinkedList;
import java.util.List;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.expr.AxisExpression;
import net.sf.saxon.expr.PathMap;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trans.XPathException;

class PathMapFilter
extends ProxyReceiver {
    private boolean closed;
    private LinkedList<MatchContext> matchContext = new LinkedList();

    public PathMapFilter(PathMap.PathMapRoot root) {
        MatchContext mc = new MatchContext();
        mc.bulidContext((PathMap.PathMapNode)root);
        this.matchContext.add(mc);
    }

    public void startElement(int nameCode, int typeCode, int locationId, int properties) throws XPathException {
        MatchContext mc = this.matchContext.getLast();
        MatchContext newContext = new MatchContext();
        if (mc.elementArcs != null) {
            for (PathMap.PathMapArc arc : mc.elementArcs) {
                AxisExpression ae = arc.getStep();
                NodeTest test = ae.getNodeTest();
                if (test == null || test.matches(1, nameCode, typeCode)) {
                    newContext.bulidContext(arc.getTarget());
                    newContext.matchedElement = true;
                }
                if (ae.getAxis() != 4 && ae.getAxis() != 5) continue;
                newContext.processArc(arc);
            }
        }
        this.matchContext.add(newContext);
        if (newContext.matchedElement) {
            super.startElement(nameCode, typeCode, locationId, properties);
        }
    }

    public void attribute(int nameCode, int typeCode, CharSequence value, int locationId, int properties) throws XPathException {
        MatchContext mc = this.matchContext.getLast();
        if (!mc.matchedElement) {
            return;
        }
        int fp = nameCode & 0xFFFFF;
        if (fp == 642 || fp == 641) {
            super.attribute(nameCode, typeCode, value, locationId, properties);
            return;
        }
        if (mc.attributeArcs != null) {
            for (PathMap.PathMapArc arc : mc.attributeArcs) {
                AxisExpression ae = arc.getStep();
                NodeTest test = ae.getNodeTest();
                if (test != null && !test.matches(2, nameCode, typeCode)) continue;
                super.attribute(nameCode, typeCode, value, locationId, properties);
                return;
            }
        }
    }

    public void characters(CharSequence chars, int locationId, int properties) throws XPathException {
        MatchContext context = this.matchContext.getLast();
        if (context.matchedElement && context.matchesText) {
            super.characters(chars, locationId, properties);
        }
    }

    public void comment(CharSequence chars, int locationId, int properties) throws XPathException {
        MatchContext context = this.matchContext.getLast();
        if (context.matchedElement && context.matchesComment) {
            super.comment(chars, locationId, properties);
        }
    }

    public void processingInstruction(String target, CharSequence data, int locationId, int properties) throws XPathException {
        MatchContext context = this.matchContext.getLast();
        if (context.matchedElement) {
            super.processingInstruction(target, data, locationId, properties);
        }
    }

    public void namespace(int namespaceCode, int properties) throws XPathException {
        MatchContext context = this.matchContext.getLast();
        if (context.matchedElement) {
            super.namespace(namespaceCode, properties);
        }
    }

    public void endElement() throws XPathException {
        MatchContext context = this.matchContext.removeLast();
        if (context.matchedElement) {
            super.endElement();
        }
    }

    public void startContent() throws XPathException {
        MatchContext context = this.matchContext.getLast();
        if (context.matchedElement) {
            super.startContent();
        }
    }

    public void close() throws XPathException {
        if (!this.closed) {
            super.close();
            this.closed = true;
        }
    }

    static class MatchContext {
        List<PathMap.PathMapArc> elementArcs;
        List<PathMap.PathMapArc> attributeArcs;
        boolean matchedElement;
        boolean matchesText;
        boolean matchesComment;

        MatchContext() {
        }

        void bulidContext(PathMap.PathMapNode node) {
            for (PathMap.PathMapArc arc : node.getArcs()) {
                this.processArc(arc);
            }
        }

        void processArc(PathMap.PathMapArc arc) {
            AxisExpression ae = arc.getStep();
            NodeTest test = ae.getNodeTest();
            if (test == null) {
                this.addAnyNodeArc(arc);
            } else {
                switch (test.getPrimitiveType()) {
                    case 3: {
                        this.matchesText = true;
                    }
                    case 0: {
                        this.addAnyNodeArc(arc);
                        break;
                    }
                    case 8: {
                        this.matchesComment = true;
                        break;
                    }
                    case 1: {
                        this.addElementArc(arc);
                        break;
                    }
                    case 2: {
                        this.addAttributeArc(arc);
                    }
                }
            }
        }

        private void addAnyNodeArc(PathMap.PathMapArc arc) {
            if (arc.getStep().getAxis() == 2) {
                this.addAttributeArc(arc);
                return;
            }
            this.addElementArc(arc);
            this.addAttributeArc(arc);
            this.matchesText = true;
            this.matchesComment = true;
        }

        private void addAttributeArc(PathMap.PathMapArc arc) {
            if (this.attributeArcs == null) {
                this.attributeArcs = new LinkedList<PathMap.PathMapArc>();
            }
            this.attributeArcs.add(arc);
        }

        private void addElementArc(PathMap.PathMapArc arc) {
            if (this.elementArcs == null) {
                this.elementArcs = new LinkedList<PathMap.PathMapArc>();
            }
            this.elementArcs.add(arc);
        }
    }
}

