/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator;

import java.io.File;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import org.teiid.core.util.FileUtils;

public interface FileConnection
extends Connection {
    public File getFile(String var1) throws ResourceException;

    public static class Util {
        public static File[] getFiles(String location, FileConnection fc) throws ResourceException {
            File datafile = fc.getFile(location);
            if (datafile.isDirectory()) {
                return datafile.listFiles();
            }
            String fname = datafile.getName();
            String ext = FileUtils.getExtension(fname);
            File parentDir = datafile.getParentFile();
            if (ext != null && "*".equals(FileUtils.getBaseFileNameWithoutExtension(fname))) {
                return FileUtils.findAllFilesInDirectoryHavingExtension(parentDir.getAbsolutePath(), "." + ext);
            }
            if (!datafile.exists()) {
                return null;
            }
            return new File[]{datafile};
        }
    }
}

