/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.common.buffer.impl;

import java.nio.ByteBuffer;

public class BlockByteBuffer {
    private BlockByteBufferData data;
    private ByteBuffer[] origBuffers;
    private ByteBuffer[] buffers;

    public BlockByteBuffer(int segmentAddressBits, int blockCount, int blockAddressBits, boolean direct) {
        this.data = new BlockByteBufferData();
        this.data.segmentAddressBits = segmentAddressBits;
        this.data.blockAddressBits = blockAddressBits;
        this.data.blockSize = 1 << blockAddressBits;
        this.data.segmentSize = 1 << this.data.segmentAddressBits;
        this.data.blockCount = blockCount;
        long size = (long)blockCount << blockAddressBits;
        int fullSegments = (int)size >> segmentAddressBits;
        int lastSegmentSize = (int)(size & (long)(this.data.segmentSize - 1));
        int segments = fullSegments;
        if (lastSegmentSize > 0) {
            ++segments;
        }
        this.origBuffers = new ByteBuffer[segments];
        this.buffers = new ByteBuffer[segments];
        for (int i = 0; i < fullSegments; ++i) {
            this.origBuffers[i] = BlockByteBuffer.allocate(this.data.segmentSize, direct);
        }
        if (lastSegmentSize > 0) {
            this.origBuffers[fullSegments] = BlockByteBuffer.allocate(lastSegmentSize, direct);
        }
    }

    private BlockByteBuffer() {
    }

    public static ByteBuffer allocate(int size, boolean direct) {
        if (direct) {
            ByteBuffer newBuffer = ByteBuffer.allocateDirect(size);
            int longsPerSegment = size >> 3;
            for (int j = 0; j < longsPerSegment; ++j) {
                newBuffer.putLong(0L);
            }
            return newBuffer;
        }
        return ByteBuffer.allocate(size);
    }

    public BlockByteBuffer duplicate() {
        BlockByteBuffer dup = new BlockByteBuffer();
        dup.data = this.data;
        dup.origBuffers = this.origBuffers;
        dup.buffers = new ByteBuffer[dup.origBuffers.length];
        return dup;
    }

    public ByteBuffer getByteBuffer(int block) {
        if (block < 0 || block >= this.data.blockCount) {
            throw new IndexOutOfBoundsException("Invalid block " + block);
        }
        int segment = block >> this.data.segmentAddressBits - this.data.blockAddressBits;
        ByteBuffer bb = this.buffers[segment];
        if (bb == null) {
            bb = this.buffers[segment] = this.origBuffers[segment].duplicate();
        } else {
            bb.rewind();
        }
        int position = block << this.data.blockAddressBits & this.data.segmentSize - 1;
        bb.limit(position + this.data.blockSize);
        bb.position(position);
        return bb;
    }

    private static class BlockByteBufferData {
        int blockAddressBits;
        int segmentAddressBits;
        int segmentSize;
        int blockSize;
        int blockCount;

        private BlockByteBufferData() {
        }
    }
}

