/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.TimeZone;
import org.teiid.core.types.BinaryType;
import org.teiid.core.types.BlobType;
import org.teiid.core.types.ClobType;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.types.JDBCSQLTypeInfo;
import org.teiid.core.types.NullType;
import org.teiid.core.types.XMLType;
import org.teiid.core.types.basic.ObjectToAnyTransform;
import org.teiid.core.util.TimestampWithTimezone;

public class TypeFacility {
    public static Class<?> getDataTypeClass(String type) {
        return DataTypeManager.getDataTypeClass(type);
    }

    public static String getDataTypeName(Class<?> type) {
        return DataTypeManager.getDataTypeName(type);
    }

    public static Class<?> getRuntimeType(Class<?> type) {
        if (type.isPrimitive()) {
            return TypeFacility.convertPrimitiveToObject(type);
        }
        return DataTypeManager.getRuntimeType(type);
    }

    public static final int getSQLTypeFromRuntimeType(Class<?> type) {
        return JDBCSQLTypeInfo.getSQLTypeFromRuntimeType(type);
    }

    public static final String getDataTypeNameFromSQLType(int sqlType) {
        if (sqlType == 2003) {
            return "object";
        }
        return JDBCSQLTypeInfo.getTypeName(sqlType);
    }

    public Object convertToRuntimeType(Object value) {
        return DataTypeManager.convertToRuntimeType(value, true);
    }

    public Object convertDate(java.util.Date date, TimeZone initial, Calendar target, Class<?> targetType) {
        return TimestampWithTimezone.create(date, initial, target, targetType);
    }

    public static Class<?> convertPrimitiveToObject(Class<?> clazz) {
        return ObjectToAnyTransform.convertPrimitiveToObject(clazz);
    }

    public static final class RUNTIME_NAMES {
        public static final String STRING = "string";
        public static final String BOOLEAN = "boolean";
        public static final String BYTE = "byte";
        public static final String SHORT = "short";
        public static final String CHAR = "char";
        public static final String INTEGER = "integer";
        public static final String LONG = "long";
        public static final String BIG_INTEGER = "biginteger";
        public static final String FLOAT = "float";
        public static final String DOUBLE = "double";
        public static final String BIG_DECIMAL = "bigdecimal";
        public static final String DATE = "date";
        public static final String TIME = "time";
        public static final String TIMESTAMP = "timestamp";
        public static final String OBJECT = "object";
        public static final String NULL = "null";
        public static final String BLOB = "blob";
        public static final String CLOB = "clob";
        public static final String XML = "xml";
        public static final String VARBINARY = "varbinary";
    }

    public static interface RUNTIME_TYPES {
        public static final Class<String> STRING = DataTypeManager.DefaultDataClasses.STRING;
        public static final Class<Boolean> BOOLEAN = DataTypeManager.DefaultDataClasses.BOOLEAN;
        public static final Class<Byte> BYTE = DataTypeManager.DefaultDataClasses.BYTE;
        public static final Class<Short> SHORT = DataTypeManager.DefaultDataClasses.SHORT;
        public static final Class<Character> CHAR = DataTypeManager.DefaultDataClasses.CHAR;
        public static final Class<Integer> INTEGER = DataTypeManager.DefaultDataClasses.INTEGER;
        public static final Class<Long> LONG = DataTypeManager.DefaultDataClasses.LONG;
        public static final Class<BigInteger> BIG_INTEGER = DataTypeManager.DefaultDataClasses.BIG_INTEGER;
        public static final Class<Float> FLOAT = DataTypeManager.DefaultDataClasses.FLOAT;
        public static final Class<Double> DOUBLE = DataTypeManager.DefaultDataClasses.DOUBLE;
        public static final Class<? extends BigDecimal> BIG_DECIMAL = DataTypeManager.DefaultDataClasses.BIG_DECIMAL;
        public static final Class<Date> DATE = DataTypeManager.DefaultDataClasses.DATE;
        public static final Class<Time> TIME = DataTypeManager.DefaultDataClasses.TIME;
        public static final Class<Timestamp> TIMESTAMP = DataTypeManager.DefaultDataClasses.TIMESTAMP;
        public static final Class<Object> OBJECT = DataTypeManager.DefaultDataClasses.OBJECT;
        public static final Class<BlobType> BLOB = DataTypeManager.DefaultDataClasses.BLOB;
        public static final Class<ClobType> CLOB = DataTypeManager.DefaultDataClasses.CLOB;
        public static final Class<XMLType> XML = DataTypeManager.DefaultDataClasses.XML;
        public static final Class<NullType> NULL = DataTypeManager.DefaultDataClasses.NULL;
        public static final Class<BinaryType> VARBINARY = DataTypeManager.DefaultDataClasses.VARBINARY;
    }

    public static final class RUNTIME_CODES {
        public static final int STRING = 0;
        public static final int CHAR = 1;
        public static final int BOOLEAN = 2;
        public static final int BYTE = 3;
        public static final int SHORT = 4;
        public static final int INTEGER = 5;
        public static final int LONG = 6;
        public static final int BIG_INTEGER = 7;
        public static final int FLOAT = 8;
        public static final int DOUBLE = 9;
        public static final int BIG_DECIMAL = 10;
        public static final int DATE = 11;
        public static final int TIME = 12;
        public static final int TIMESTAMP = 13;
        public static final int OBJECT = 14;
        public static final int BLOB = 15;
        public static final int CLOB = 16;
        public static final int XML = 17;
        public static final int NULL = 18;
        public static final int VARBINARY = 19;
    }
}

