/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.types;

import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLXML;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.teiid.core.types.DataTypeManager;

public final class JDBCSQLTypeInfo {
    public static final Integer DEFAULT_RADIX = 10;
    public static final Integer DEFAULT_SCALE = 0;
    public static final Integer XML_COLUMN_LENGTH = Integer.MAX_VALUE;
    private static Map<String, TypeInfo> NAME_TO_TYPEINFO = new LinkedHashMap<String, TypeInfo>();
    private static Map<Integer, TypeInfo> TYPE_TO_TYPEINFO = new HashMap<Integer, TypeInfo>();
    private static Map<String, TypeInfo> CLASSNAME_TO_TYPEINFO = new HashMap<String, TypeInfo>();

    private JDBCSQLTypeInfo() {
    }

    private static TypeInfo addType(String typeName, int maxDisplaySize, int precision, String javaClassName, int ... sqlTypes) {
        TypeInfo ti = new TypeInfo(maxDisplaySize, precision, typeName, javaClassName, sqlTypes);
        NAME_TO_TYPEINFO.put(typeName, ti);
        if (javaClassName != null) {
            CLASSNAME_TO_TYPEINFO.put(javaClassName, ti);
        }
        for (int i : sqlTypes) {
            TYPE_TO_TYPEINFO.put(i, ti);
        }
        return ti;
    }

    private static void addType(String[] typeNames, int maxDisplaySize, int precision, String javaClassName, int ... sqlTypes) {
        TypeInfo ti = JDBCSQLTypeInfo.addType(typeNames[0], maxDisplaySize, precision, javaClassName, sqlTypes);
        for (int i = 1; i < typeNames.length; ++i) {
            NAME_TO_TYPEINFO.put(typeNames[i], ti);
        }
    }

    public static final int getSQLType(String typeName) {
        if (typeName == null) {
            return 0;
        }
        TypeInfo sqlType = NAME_TO_TYPEINFO.get(typeName);
        if (sqlType == null) {
            if (DataTypeManager.isArrayType(typeName)) {
                return 2003;
            }
            return 2000;
        }
        return sqlType.jdbcTypes[0];
    }

    public static final int getSQLTypeFromClass(String className) {
        if (className == null) {
            return 0;
        }
        TypeInfo sqlType = CLASSNAME_TO_TYPEINFO.get(className);
        if (sqlType == null) {
            return 2000;
        }
        return sqlType.jdbcTypes[0];
    }

    public static final int getSQLTypeFromRuntimeType(Class<?> type) {
        if (type == null) {
            return 0;
        }
        String name = DataTypeManager.getDataTypeName(type);
        if (name == null) {
            return 2000;
        }
        return JDBCSQLTypeInfo.getSQLType(name);
    }

    public static final String getJavaClassName(int jdbcSQLType) {
        TypeInfo typeInfo = TYPE_TO_TYPEINFO.get(jdbcSQLType);
        if (typeInfo == null) {
            return DataTypeManager.DefaultDataClasses.OBJECT.getName();
        }
        return typeInfo.javaClassName;
    }

    public static final String getTypeName(int sqlType) {
        TypeInfo typeInfo = TYPE_TO_TYPEINFO.get(sqlType);
        if (typeInfo == null) {
            return "object";
        }
        return typeInfo.name;
    }

    public static Set<String> getMMTypeNames() {
        return NAME_TO_TYPEINFO.keySet();
    }

    public static Integer getMaxDisplaySize(Class<?> dataTypeClass) {
        return JDBCSQLTypeInfo.getMaxDisplaySize(DataTypeManager.getDataTypeName(dataTypeClass));
    }

    public static Integer getMaxDisplaySize(String typeName) {
        TypeInfo ti = NAME_TO_TYPEINFO.get(typeName);
        if (ti == null) {
            return null;
        }
        return ti.maxDisplaySize;
    }

    public static Integer getDefaultPrecision(Class<?> dataTypeClass) {
        return JDBCSQLTypeInfo.getDefaultPrecision(DataTypeManager.getDataTypeName(dataTypeClass));
    }

    public static Integer getDefaultPrecision(String typeName) {
        TypeInfo ti = NAME_TO_TYPEINFO.get(typeName);
        if (ti == null) {
            return null;
        }
        return ti.defaultPrecision;
    }

    static {
        JDBCSQLTypeInfo.addType("biginteger", 20, 19, DataTypeManager.DefaultDataClasses.BIG_INTEGER.getName(), 2);
        JDBCSQLTypeInfo.addType(new String[]{"bigdecimal", "decimal"}, 22, 20, DataTypeManager.DefaultDataClasses.BIG_DECIMAL.getName(), 2, 3);
        JDBCSQLTypeInfo.addType("blob", Integer.MAX_VALUE, Integer.MAX_VALUE, Blob.class.getName(), 2004, -4);
        JDBCSQLTypeInfo.addType("boolean", 5, 1, DataTypeManager.DefaultDataClasses.BOOLEAN.getName(), -7, 16);
        JDBCSQLTypeInfo.addType(new String[]{"byte", "tinyint"}, 4, 3, DataTypeManager.DefaultDataClasses.BYTE.getName(), -6);
        JDBCSQLTypeInfo.addType("char", 1, 1, DataTypeManager.DefaultDataClasses.CHAR.getName(), 1);
        JDBCSQLTypeInfo.addType("clob", Integer.MAX_VALUE, Integer.MAX_VALUE, Clob.class.getName(), 2005, 2011, -16, -1);
        JDBCSQLTypeInfo.addType("date", 10, 10, DataTypeManager.DefaultDataClasses.DATE.getName(), 91);
        JDBCSQLTypeInfo.addType("double", 22, 20, DataTypeManager.DefaultDataClasses.DOUBLE.getName(), 8, 6);
        JDBCSQLTypeInfo.addType(new String[]{"float", "real"}, 22, 20, DataTypeManager.DefaultDataClasses.FLOAT.getName(), 7);
        JDBCSQLTypeInfo.addType("integer", 11, 10, DataTypeManager.DefaultDataClasses.INTEGER.getName(), 4);
        JDBCSQLTypeInfo.addType(new String[]{"long", "bigint"}, 20, 19, DataTypeManager.DefaultDataClasses.LONG.getName(), -5);
        JDBCSQLTypeInfo.addType("object", Integer.MAX_VALUE, Integer.MAX_VALUE, DataTypeManager.DefaultDataClasses.OBJECT.getName(), 2000);
        JDBCSQLTypeInfo.addType(new String[]{"short", "smallint"}, 6, 5, DataTypeManager.DefaultDataClasses.SHORT.getName(), 5);
        JDBCSQLTypeInfo.addType(new String[]{"string", "varchar"}, DataTypeManager.MAX_STRING_LENGTH, DataTypeManager.MAX_STRING_LENGTH, DataTypeManager.DefaultDataClasses.STRING.getName(), 12, -9, 1, -15);
        JDBCSQLTypeInfo.addType("time", 8, 8, DataTypeManager.DefaultDataClasses.TIME.getName(), 92);
        JDBCSQLTypeInfo.addType("timestamp", 29, 29, DataTypeManager.DefaultDataClasses.TIMESTAMP.getName(), 93);
        JDBCSQLTypeInfo.addType("xml", Integer.MAX_VALUE, Integer.MAX_VALUE, SQLXML.class.getName(), 2009);
        JDBCSQLTypeInfo.addType("null", 4, 1, null, 0);
        JDBCSQLTypeInfo.addType("varbinary", DataTypeManager.MAX_LOB_MEMORY_BYTES, DataTypeManager.MAX_LOB_MEMORY_BYTES, byte[].class.getName(), -3, -2);
        JDBCSQLTypeInfo.addType("varbinary", DataTypeManager.MAX_LOB_MEMORY_BYTES, DataTypeManager.MAX_LOB_MEMORY_BYTES, byte[].class.getName(), -3, -2);
        TypeInfo typeInfo = new TypeInfo(Integer.MAX_VALUE, 0, "ARRAY", Array.class.getName(), new int[2003]);
        CLASSNAME_TO_TYPEINFO.put(Array.class.getName(), typeInfo);
        TYPE_TO_TYPEINFO.put(2003, typeInfo);
    }

    public static class TypeInfo {
        String name;
        int maxDisplaySize;
        int defaultPrecision;
        String javaClassName;
        int[] jdbcTypes;

        public TypeInfo(int maxDisplaySize, int precision, String name, String javaClassName, int[] jdbcTypes) {
            this.maxDisplaySize = maxDisplaySize;
            this.defaultPrecision = precision;
            this.name = name;
            this.javaClassName = javaClassName;
            this.jdbcTypes = jdbcTypes;
        }
    }
}

