/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.function.aggregate;

import java.io.IOException;
import java.io.Writer;
import java.sql.Array;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import javax.sql.rowset.serial.SerialBlob;
import org.teiid.common.buffer.FileStore;
import org.teiid.common.buffer.FileStoreInputStreamFactory;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.types.BlobImpl;
import org.teiid.core.types.BlobType;
import org.teiid.query.QueryPlugin;
import org.teiid.query.function.aggregate.SingleArgumentAggregateFunction;
import org.teiid.query.sql.symbol.DerivedColumn;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.TextLine;
import org.teiid.query.util.CommandContext;

public class TextAgg
extends SingleArgumentAggregateFunction {
    private FileStoreInputStreamFactory result;
    private TextLine textLine;

    public TextAgg(TextLine textLine) {
        this.textLine = textLine;
    }

    private FileStoreInputStreamFactory buildResult(CommandContext context) throws TeiidProcessingException {
        try {
            FileStore fs = context.getBufferManager().createFileStore("textagg");
            FileStoreInputStreamFactory fisf = new FileStoreInputStreamFactory(fs, this.textLine.getEncoding() == null ? "UTF-8" : this.textLine.getEncoding());
            Writer w = fisf.getWriter();
            if (this.textLine.isIncludeHeader()) {
                Object[] header = TextLine.evaluate(this.textLine.getExpressions(), new TextLine.ValueExtractor<DerivedColumn>(){

                    @Override
                    public Object getValue(DerivedColumn t) {
                        if (t.getAlias() == null && t.getExpression() instanceof ElementSymbol) {
                            return ((ElementSymbol)t.getExpression()).getShortName();
                        }
                        return t.getAlias();
                    }
                }, this.textLine);
                this.writeList(w, header);
            }
            w.flush();
            return fisf;
        }
        catch (IOException e) {
            throw new TeiidProcessingException((BundleUtil.Event)QueryPlugin.Event.TEIID30420, (Throwable)e);
        }
    }

    private void writeList(Writer w, Object[] list) throws IOException {
        for (int i = 0; i < list.length; ++i) {
            w.write(list[i].toString());
        }
    }

    @Override
    public void reset() {
        this.result = null;
    }

    @Override
    public void addInputDirect(Object input, List<?> tuple, CommandContext commandContext) throws TeiidComponentException, TeiidProcessingException {
        try {
            if (this.result == null) {
                this.result = this.buildResult(commandContext);
            }
            Array in = (Array)input;
            Writer w = this.result.getWriter();
            this.writeList(w, (Object[])in.getArray());
            w.flush();
        }
        catch (SQLException e) {
            throw new TeiidProcessingException((BundleUtil.Event)QueryPlugin.Event.TEIID30421, (Throwable)e);
        }
        catch (IOException e) {
            throw new TeiidProcessingException((BundleUtil.Event)QueryPlugin.Event.TEIID30421, (Throwable)e);
        }
    }

    @Override
    public Object getResult(CommandContext commandContext) throws TeiidProcessingException {
        if (this.result == null) {
            this.result = this.buildResult(commandContext);
        }
        try {
            FileStore.FileStoreOutputStream fs = this.result.getOuputStream();
            fs.close();
            if (fs.bytesWritten()) {
                return new BlobType(new BlobImpl(this.result));
            }
            return new BlobType(new SerialBlob(Arrays.copyOf(fs.getBuffer(), fs.getCount())));
        }
        catch (IOException e) {
            throw new TeiidProcessingException((BundleUtil.Event)QueryPlugin.Event.TEIID30422, (Throwable)e);
        }
        catch (SQLException e) {
            throw new TeiidProcessingException((BundleUtil.Event)QueryPlugin.Event.TEIID30423, (Throwable)e);
        }
    }
}

