/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.lang;

import java.util.ArrayList;
import java.util.List;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.util.EquivalenceUtil;
import org.teiid.metadata.BaseColumn;
import org.teiid.metadata.Column;
import org.teiid.metadata.Table;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.TargetedCommand;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.visitor.SQLStringVisitor;

public class Create
extends Command
implements TargetedCommand {
    private GroupSymbol table;
    private List<ElementSymbol> primaryKey = new ArrayList<ElementSymbol>();
    private List<Column> columns = new ArrayList<Column>();
    private List<ElementSymbol> columnSymbols;
    private Table tableMetadata;
    private String on;

    public GroupSymbol getTable() {
        return this.table;
    }

    @Override
    public GroupSymbol getGroup() {
        return this.table;
    }

    public void setTable(GroupSymbol table) {
        this.table = table;
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    public List<ElementSymbol> getPrimaryKey() {
        return this.primaryKey;
    }

    public List<ElementSymbol> getColumnSymbols() {
        if (this.columnSymbols == null) {
            this.columnSymbols = new ArrayList<ElementSymbol>(this.columns.size());
            for (Column column : this.columns) {
                ElementSymbol es = new ElementSymbol(column.getName());
                es.setType(DataTypeManager.getDataTypeClass(column.getRuntimeType()));
                es.setGroupSymbol(this.table);
                this.columnSymbols.add(es);
            }
        }
        return this.columnSymbols;
    }

    @Override
    public int getType() {
        return 11;
    }

    @Override
    public Object clone() {
        Create copy = new Create();
        GroupSymbol copyTable = this.table.clone();
        copy.setTable(copyTable);
        copy.columns = new ArrayList<Column>(this.columns.size());
        for (Column column : this.columns) {
            Column copyColumn = new Column();
            copyColumn.setName(column.getName());
            copyColumn.setRuntimeType(column.getRuntimeType());
            copyColumn.setAutoIncremented(column.isAutoIncremented());
            copyColumn.setNullType(column.getNullType());
            copy.columns.add(copyColumn);
        }
        copy.primaryKey = LanguageObject.Util.deepClone(this.primaryKey, ElementSymbol.class);
        this.copyMetadataState(copy);
        copy.setTableMetadata(this.tableMetadata);
        copy.on = this.on;
        return copy;
    }

    public List getProjectedSymbols() {
        return Command.getUpdateCommandSymbol();
    }

    @Override
    public boolean areResultsCachable() {
        return false;
    }

    @Override
    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    public void setElementSymbolsAsColumns(List<ElementSymbol> columns) {
        this.columns.clear();
        for (ElementSymbol elementSymbol : columns) {
            Column c = new Column();
            c.setName(elementSymbol.getShortName());
            c.setRuntimeType(DataTypeManager.getDataTypeName(elementSymbol.getType()));
            c.setNullType(BaseColumn.NullType.Nullable);
            this.columns.add(c);
        }
    }

    public int hashCode() {
        return this.table.hashCode();
    }

    @Override
    public String toString() {
        return SQLStringVisitor.getSQLString(this);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Create)) {
            return false;
        }
        Create other = (Create)obj;
        if (other.columns.size() != this.columns.size()) {
            return false;
        }
        for (int i = 0; i < this.columns.size(); ++i) {
            Column c = this.columns.get(i);
            Column o = other.columns.get(i);
            if (c.getName().equalsIgnoreCase(o.getName()) && DataTypeManager.getDataTypeClass(c.getRuntimeType().toLowerCase()) == DataTypeManager.getDataTypeClass(o.getRuntimeType().toLowerCase()) && c.isAutoIncremented() == o.isAutoIncremented() && c.getNullType() == o.getNullType()) continue;
            return false;
        }
        return EquivalenceUtil.areEqual(this.getTable(), other.getTable()) && EquivalenceUtil.areEqual(this.getPrimaryKey(), other.getPrimaryKey()) && EquivalenceUtil.areEqual(this.on, other.on) && (this.tableMetadata == null && other.tableMetadata == null || this.tableMetadata != null && other.tableMetadata != null && this.toString().equals(other.toString()));
    }

    public String getOn() {
        return this.on;
    }

    public void setOn(String on) {
        this.on = on;
    }

    public Table getTableMetadata() {
        return this.tableMetadata;
    }

    public void setTableMetadata(Table tableMetadata) {
        if (tableMetadata != null) {
            this.columns = tableMetadata.getColumns();
            this.table = new GroupSymbol(tableMetadata.getName());
        }
        this.tableMetadata = tableMetadata;
    }
}

