/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.teiid.core.util.ArgCheck;

public class Permutation {
    private Object[] items;

    public Permutation(Object[] items) {
        ArgCheck.isNotNull(items);
        this.items = items;
    }

    public Iterator<Object[]> generate() {
        return new PermutationIterator(this.items, this.items.length);
    }

    public Iterator<Object[]> generate(int size) {
        if (size > this.items.length) {
            throw new IllegalArgumentException("Size is larger than length");
        }
        if (size < 0) {
            throw new IllegalArgumentException("Size is negative");
        }
        return new PermutationIterator(this.items, size);
    }

    private static class PermutationIterator
    implements Iterator<Object[]> {
        private Object[] items;
        private int k;
        private int n;
        private int[] j;
        private boolean more = true;
        private int[] last;

        private PermutationIterator(Object[] items, int k) {
            this.items = items;
            this.k = k;
            this.n = items.length;
            if (this.n == 0 || k == 0) {
                this.more = false;
            } else {
                this.j = new int[this.n];
                this.j[0] = -1;
                this.last = new int[this.n];
                for (int i = this.n - 1; i >= 0; --i) {
                    this.last[this.n - 1 - i] = i;
                }
            }
        }

        @Override
        public boolean hasNext() {
            return this.more;
        }

        @Override
        public Object[] next() {
            int t;
            int i;
            if (!this.more) {
                throw new NoSuchElementException();
            }
            if (this.j[0] < 0) {
                for (i = 0; i < this.n; ++i) {
                    this.j[i] = i;
                }
                int start = this.k;
                int end = this.n - 1;
                while (start < end) {
                    t = this.j[start];
                    this.j[start++] = this.j[end];
                    this.j[end--] = t;
                }
            } else {
                for (i = this.n - 2; i >= 0 && this.j[i] >= this.j[i + 1]; --i) {
                }
                if (i >= 0) {
                    int least = i + 1;
                    for (int m = i + 2; m < this.n; ++m) {
                        if (this.j[m] >= this.j[least] || this.j[m] <= this.j[i]) continue;
                        least = m;
                    }
                    t = this.j[i];
                    this.j[i] = this.j[least];
                    this.j[least] = t;
                    if (this.k - 1 > i) {
                        int start = i + 1;
                        int end = this.n - 1;
                        while (start < end) {
                            t = this.j[start];
                            this.j[start++] = this.j[end];
                            this.j[end--] = t;
                        }
                        start = this.k;
                        end = this.n - 1;
                        while (start < end) {
                            t = this.j[start];
                            this.j[start++] = this.j[end];
                            this.j[end--] = t;
                        }
                    }
                }
            }
            this.more = false;
            for (int x = 0; x < this.n; ++x) {
                if (this.j[x] == this.last[x]) continue;
                this.more = true;
            }
            return this.getPermutation(this.j);
        }

        private Object[] getPermutation(int[] index) {
            Object[] perm = new Object[this.k];
            for (int i = 0; i < this.k; ++i) {
                perm[i] = this.items[index[i]];
            }
            return perm;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

