/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.mapping.xml;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;
import junit.framework.TestCase;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.query.mapping.xml.MappingAttribute;
import org.teiid.query.mapping.xml.MappingBaseNode;
import org.teiid.query.mapping.xml.MappingChoiceNode;
import org.teiid.query.mapping.xml.MappingCriteriaNode;
import org.teiid.query.mapping.xml.MappingDocument;
import org.teiid.query.mapping.xml.MappingElement;
import org.teiid.query.mapping.xml.MappingException;
import org.teiid.query.mapping.xml.MappingLoader;
import org.teiid.query.mapping.xml.MappingNode;
import org.teiid.query.mapping.xml.MappingRecursiveElement;
import org.teiid.query.mapping.xml.Namespace;

public class TestMappingLoader
extends TestCase {
    private static final boolean VALID = true;
    private static final boolean INVALID = false;
    private static final String MAPPING_FILE = "LicenseMappingExample.xml";
    private static final String PARTS_MAPPING_FILE = "PartsMappingExample.xml";

    public TestMappingLoader(String name) {
        super(name);
    }

    static String getFilePathInDataDir(String filename) {
        File file = new File(UnitTestUtil.getTestDataPath(), filename);
        return file.getAbsolutePath();
    }

    private static MappingNode loadFromFile(String filename) throws Exception {
        String fileAbsolutePath = TestMappingLoader.getFilePathInDataDir(filename);
        MappingLoader loader = new MappingLoader();
        return loader.loadDocument(fileAbsolutePath);
    }

    private static MappingNode loadFromStream(String filename) throws Exception {
        InputStream istream = TestMappingLoader.getResourceStream(MappingLoader.class, filename);
        if (istream == null) {
            throw new IllegalStateException("File " + filename + " is not in the application's classpath.");
        }
        MappingLoader loader = new MappingLoader();
        return loader.loadDocument(istream);
    }

    private static InputStream getResourceStream(Class appClass, String filename) {
        return appClass.getResourceAsStream(filename);
    }

    private MappingNode helpLoad(String filename, boolean fromStream, boolean shouldSucceed) {
        block6: {
            if (fromStream) {
                try {
                    return TestMappingLoader.loadFromStream(filename);
                }
                catch (Exception e) {
                    if (shouldSucceed) {
                        TestMappingLoader.fail((String)("File " + filename + " could not be loaded from the application's classpath:" + e.getMessage()));
                    }
                    break block6;
                }
            }
            try {
                return TestMappingLoader.loadFromFile(filename);
            }
            catch (Exception e) {
                if (!shouldSucceed) break block6;
                TestMappingLoader.fail((String)("File " + filename + " could not be loaded from the file system: " + e.getMessage()));
            }
        }
        return null;
    }

    public void testPos_LoadFromStream() {
        this.helpLoad(MAPPING_FILE, true, true);
    }

    public void testNeg_LoadFromFile() {
        this.helpLoad("InValidFile.yada", false, false);
    }

    public void testNeg_LoadFromStream() {
        this.helpLoad("InValidFile.yada", true, false);
    }

    public void testSourceAtRootXML50() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<xmlMapping>\r\n    <mappingNode>\r\n        <name>license</name>\r\n        <source>licenseSource</source>\r\n        <minOccurs>0</minOccurs>\r\n        <maxOccurs>unbounded</maxOccurs>\r\n        <tempGroup>testTempGroup1</tempGroup>\r\n        <tempGroup>testTempGroup2</tempGroup>\r\n    </mappingNode>\r\n</xmlMapping>\r\n\r\n";
        MappingDocument doc = this.loadMappingDocument(xml);
        MappingBaseNode root = doc.getRootNode();
        TestMappingLoader.assertTrue((boolean)(root instanceof MappingElement));
        MappingElement element = (MappingElement)root;
        List list = element.getStagingTables();
        TestMappingLoader.assertEquals((int)2, (int)list.size());
        TestMappingLoader.assertEquals((Object)"testTempGroup1", list.get(0));
        TestMappingLoader.assertEquals((Object)"testTempGroup2", list.get(1));
        TestMappingLoader.assertEquals((String)"license", (String)element.getName());
        TestMappingLoader.assertEquals((int)1, (int)element.getMinOccurence());
        TestMappingLoader.assertEquals((int)1, (int)element.getMaxOccurence());
        TestMappingLoader.assertEquals((String)"licenseSource", (String)element.getSource());
    }

    public void testSourceBelowRootXML50() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<xmlMapping>\r\n    <mappingNode>\r\n        <name>parentNode</name>\r\n        <minOccurs>0</minOccurs>\r\n        <maxOccurs>unbounded</maxOccurs>\r\n        <tempGroup>testTempGroup1</tempGroup>\r\n       <mappingNode>\r\n        <name>childNode</name>\r\n        <source>childNodeSource</source>\r\n        <tempGroup>testTempGroup2</tempGroup>\r\n       </mappingNode>\r\n    </mappingNode>\r\n</xmlMapping>\r\n\r\n";
        MappingDocument doc = this.loadMappingDocument(xml);
        MappingBaseNode node = doc.getRootNode();
        TestMappingLoader.assertTrue((boolean)(node instanceof MappingElement));
        MappingElement element = (MappingElement)node;
        List list = element.getStagingTables();
        TestMappingLoader.assertEquals((int)1, (int)list.size());
        TestMappingLoader.assertEquals((Object)"testTempGroup1", list.get(0));
        TestMappingLoader.assertEquals((String)"parentNode", (String)element.getName());
        TestMappingLoader.assertEquals((int)1, (int)element.getMinOccurence());
        TestMappingLoader.assertEquals((int)1, (int)element.getMaxOccurence());
        MappingNode node1 = (MappingNode)element.getNodeChildren().get(0);
        TestMappingLoader.assertTrue((boolean)(node1 instanceof MappingElement));
        element = (MappingElement)node1;
        list = element.getStagingTables();
        TestMappingLoader.assertEquals((int)1, (int)list.size());
        TestMappingLoader.assertEquals((Object)"testTempGroup2", list.get(0));
        TestMappingLoader.assertEquals((String)"childNode", (String)element.getName());
        TestMappingLoader.assertEquals((String)"childNodeSource", (String)element.getSource());
    }

    public void testCriteriaXML50() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<xmlMapping>\r\n    <mappingNode>\r\n        <name>parentNode</name>\r\n       <mappingNode>\r\n           <nodeType>choice</nodeType>\r\n           <exceptionOnDefault>true</exceptionOnDefault>           <mappingNode>\r\n               <name>childNode</name>\r\n               <criteria>childNodeCriteria</criteria>\r\n           </mappingNode>\r\n       </mappingNode>\r\n    </mappingNode>\r\n</xmlMapping>\r\n\r\n";
        MappingDocument doc = this.loadMappingDocument(xml);
        MappingBaseNode node = doc.getRootNode();
        TestMappingLoader.assertTrue((boolean)(node instanceof MappingElement));
        MappingElement element = (MappingElement)node;
        TestMappingLoader.assertEquals((String)"parentNode", (String)element.getName());
        node = (MappingNode)element.getNodeChildren().get(0);
        TestMappingLoader.assertTrue((boolean)(node instanceof MappingChoiceNode));
        MappingChoiceNode choice = (MappingChoiceNode)node;
        TestMappingLoader.assertTrue((boolean)choice.throwExceptionOnDefault());
        node = (MappingNode)choice.getNodeChildren().get(0);
        TestMappingLoader.assertTrue((boolean)(node instanceof MappingCriteriaNode));
        MappingCriteriaNode criteria = (MappingCriteriaNode)node;
        TestMappingLoader.assertEquals((String)"childNodeCriteria", (String)criteria.getCriteria());
        node = (MappingNode)criteria.getNodeChildren().get(0);
        TestMappingLoader.assertTrue((boolean)(node instanceof MappingElement));
        element = (MappingElement)node;
        TestMappingLoader.assertEquals((String)"childNode", (String)element.getName());
    }

    public void testCriteriaXML55() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<xmlMapping>\r\n    <mappingNode>\r\n        <name>parentNode</name>\r\n       <mappingNode>\r\n           <nodeType>choice</nodeType>\r\n           <exceptionOnDefault>true</exceptionOnDefault>           <mappingNode>\r\n               <nodeType>criteria</nodeType>\r\n               <criteria>childNodeCriteria</criteria>\r\n               <mappingNode>\r\n                   <name>childNode</name>\r\n               </mappingNode>\r\n           </mappingNode>\r\n       </mappingNode>\r\n    </mappingNode>\r\n</xmlMapping>\r\n\r\n";
        MappingDocument doc = this.loadMappingDocument(xml);
        MappingBaseNode node = doc.getRootNode();
        TestMappingLoader.assertTrue((boolean)(node instanceof MappingElement));
        MappingElement element = (MappingElement)node;
        TestMappingLoader.assertEquals((String)"parentNode", (String)element.getName());
        node = (MappingNode)element.getNodeChildren().get(0);
        TestMappingLoader.assertTrue((boolean)(node instanceof MappingChoiceNode));
        MappingChoiceNode choice = (MappingChoiceNode)node;
        TestMappingLoader.assertTrue((boolean)choice.throwExceptionOnDefault());
        node = (MappingNode)choice.getNodeChildren().get(0);
        TestMappingLoader.assertTrue((boolean)(node instanceof MappingCriteriaNode));
        MappingCriteriaNode criteria = (MappingCriteriaNode)node;
        TestMappingLoader.assertEquals((String)"childNodeCriteria", (String)criteria.getCriteria());
        node = (MappingNode)criteria.getNodeChildren().get(0);
        TestMappingLoader.assertTrue((boolean)(node instanceof MappingElement));
        element = (MappingElement)node;
        TestMappingLoader.assertEquals((String)"childNode", (String)element.getName());
    }

    public void testElement() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<xmlMapping>\r\n    <mappingNode>\r\n        <name>parentNode</name>\r\n        <isNillable>TRUE</isNillable>\r\n        <isExcluded>TRUE</isExcluded>\r\n        <default>ddd</default>\r\n        <fixed>fff</fixed>\r\n        <optional>TRUE</optional>\r\n        <textNormalization>replace</textNormalization>\r\n        <builtInType>decimal</builtInType>\r\n    </mappingNode>\r\n</xmlMapping>\r\n\r\n";
        MappingDocument doc = this.loadMappingDocument(xml);
        MappingBaseNode node = doc.getRootNode();
        TestMappingLoader.assertTrue((boolean)(node instanceof MappingElement));
        MappingElement element = (MappingElement)node;
        TestMappingLoader.assertEquals((String)"parentNode", (String)element.getName());
        TestMappingLoader.assertFalse((boolean)element.isRootRecursiveNode());
        TestMappingLoader.assertFalse((boolean)element.isRecursive());
        TestMappingLoader.assertTrue((boolean)element.isNillable());
        TestMappingLoader.assertTrue((boolean)element.isExcluded());
        TestMappingLoader.assertTrue((boolean)element.isOptional());
        TestMappingLoader.assertEquals((String)"ddd", (String)element.getDefaultValue());
        TestMappingLoader.assertEquals((String)"fff", (String)element.getValue());
        TestMappingLoader.assertEquals((String)"replace", (String)element.getNormalizeText());
        TestMappingLoader.assertEquals((String)"decimal", (String)element.getType());
    }

    public void testRecursiveNodeXML50() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<xmlMapping>\r\n    <mappingNode>\r\n        <name>parentNode</name>\r\n        <source>parentNodeSource</source>\r\n       <mappingNode>\r\n           <name>childNode</name>\r\n           <mappingNode>\r\n               <nodeType>attribute</nodeType>\r\n               <name>attributename</name>\r\n               <default>ddd</default>\r\n               <fixed>fff</fixed>\r\n           </mappingNode>\r\n           <mappingNode>\r\n               <name>recursivenodename</name>\r\n               <isRecursive>TRUE</isRecursive>\r\n               <recursionLimit>8</recursionLimit>\r\n               <recursionCriteria>rrr</recursionCriteria>\r\n               <recursionRootMappingClass>parentNodeSource</recursionRootMappingClass>\r\n           </mappingNode>\r\n       </mappingNode>\r\n    </mappingNode>\r\n</xmlMapping>\r\n\r\n";
        MappingDocument doc = this.loadMappingDocument(xml);
        MappingBaseNode node = doc.getRootNode();
        TestMappingLoader.assertTrue((boolean)(node instanceof MappingElement));
        MappingElement element = (MappingElement)node;
        TestMappingLoader.assertEquals((String)"parentNode", (String)element.getName());
        TestMappingLoader.assertTrue((boolean)element.isRootRecursiveNode());
        TestMappingLoader.assertFalse((boolean)element.isRecursive());
        TestMappingLoader.assertEquals((String)"parentNodeSource", (String)element.getSource());
        node = (MappingNode)element.getNodeChildren().get(0);
        TestMappingLoader.assertTrue((boolean)(node instanceof MappingElement));
        element = (MappingElement)node;
        TestMappingLoader.assertEquals((String)"childNode", (String)element.getName());
        List attrs = element.getAttributes();
        TestMappingLoader.assertEquals((int)1, (int)attrs.size());
        MappingAttribute attribute = (MappingAttribute)attrs.get(0);
        TestMappingLoader.assertEquals((String)"attributename", (String)attribute.getName());
        TestMappingLoader.assertEquals((String)"ddd", (String)attribute.getDefaultValue());
        TestMappingLoader.assertEquals((String)"fff", (String)attribute.getValue());
        node = (MappingNode)element.getNodeChildren().get(0);
        TestMappingLoader.assertTrue((boolean)(node instanceof MappingRecursiveElement));
        MappingRecursiveElement recursive = (MappingRecursiveElement)node;
        TestMappingLoader.assertEquals((String)"recursivenodename", (String)recursive.getName());
        TestMappingLoader.assertEquals((int)8, (int)recursive.getRecursionLimit());
        TestMappingLoader.assertFalse((boolean)recursive.isRootRecursiveNode());
        TestMappingLoader.assertTrue((boolean)recursive.isRecursive());
    }

    public void testParseNamespaces() {
        this.helpLoad(PARTS_MAPPING_FILE, false, true);
    }

    private MappingDocument loadMappingDocument(String xml) throws MappingException {
        MappingLoader reader = new MappingLoader();
        byte[] bytes = xml.getBytes();
        ByteArrayInputStream istream = new ByteArrayInputStream(bytes);
        return reader.loadDocument((InputStream)istream);
    }

    public void testMoveNamespaceDeclaration() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<xmlMapping>\r\n    <mappingNode>\r\n        <name>license</name>\r\n        <mappingNode>\r\n            <name>xsi</name>\r\n            <nodeType>attribute</nodeType>\r\n            <namespace>xmlns</namespace>\r\n            <fixed>http://some.uri/</fixed>\r\n        </mappingNode>\r\n    </mappingNode>\r\n</xmlMapping>\r\n\r\n";
        MappingDocument doc = this.loadMappingDocument(xml);
        Properties namespaceDeclarations = ((MappingElement)doc.getRootNode()).getNamespacesAsProperties();
        TestMappingLoader.assertNotNull((Object)namespaceDeclarations);
        String uri = namespaceDeclarations.getProperty("xsi");
        TestMappingLoader.assertEquals((String)"http://some.uri/", (String)uri);
    }

    public void testMoveDefaultNamespaceDeclaration() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<xmlMapping>\r\n    <mappingNode>\r\n        <name>license</name>\r\n        <mappingNode>\r\n            <name>xmlns</name>\r\n            <nodeType>attribute</nodeType>\r\n            <fixed>http://some.uri/</fixed>\r\n        </mappingNode>\r\n    </mappingNode>\r\n</xmlMapping>\r\n\r\n";
        MappingDocument doc = this.loadMappingDocument(xml);
        Properties namespaceDeclarations = ((MappingElement)doc.getRootNode()).getNamespacesAsProperties();
        TestMappingLoader.assertNotNull((Object)namespaceDeclarations);
        String uri = namespaceDeclarations.getProperty("");
        TestMappingLoader.assertEquals((String)"http://some.uri/", (String)uri);
    }

    public void testMoveNamespaceDeclarations() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<xmlMapping>\r\n    <mappingNode>\r\n        <name>license</name>\r\n        <mappingNode>\r\n            <name>xsi</name>\r\n            <nodeType>attribute</nodeType>\r\n            <namespace>xmlns</namespace>\r\n            <fixed>http://some.uri/</fixed>\r\n        </mappingNode>\r\n        <mappingNode>\r\n            <name>xmlns</name>\r\n            <nodeType>attribute</nodeType>\r\n            <fixed>http://some.uri2/</fixed>\r\n        </mappingNode>\r\n    </mappingNode>\r\n</xmlMapping>\r\n\r\n";
        MappingDocument doc = this.loadMappingDocument(xml);
        Properties namespaceDeclarations = ((MappingElement)doc.getRootNode()).getNamespacesAsProperties();
        TestMappingLoader.assertNotNull((Object)namespaceDeclarations);
        String uri = namespaceDeclarations.getProperty("xsi");
        TestMappingLoader.assertEquals((String)"http://some.uri/", (String)uri);
        String uri2 = namespaceDeclarations.getProperty("");
        TestMappingLoader.assertEquals((String)"http://some.uri2/", (String)uri2);
    }

    public void testUseNamespaceBeforeDeclaration() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<xmlMapping>\r\n    <mappingNode>\r\n        <name>license</name>\r\n        <mappingNode>\r\n            <name>usenamespace</name>\r\n            <nodeType>attribute</nodeType>\r\n            <namespace>foo</namespace>\r\n        </mappingNode>\r\n        <mappingNode>\r\n            <name>foo</name>\r\n            <nodeType>attribute</nodeType>\r\n            <namespace>xmlns</namespace>\r\n            <fixed>http://some.uri/</fixed>\r\n        </mappingNode>\r\n        <mappingNode>\r\n            <name>xmlns</name>\r\n            <nodeType>attribute</nodeType>\r\n            <fixed>http://some.uri2/</fixed>\r\n        </mappingNode>\r\n    </mappingNode>\r\n</xmlMapping>\r\n\r\n";
        MappingDocument doc = this.loadMappingDocument(xml);
        TestMappingLoader.assertEquals((String)"license", (String)doc.getRootNode().getName());
        MappingElement license = (MappingElement)doc.getRootNode();
        MappingAttribute usenamespace = (MappingAttribute)license.getAttributes().get(0);
        TestMappingLoader.assertEquals((String)"usenamespace", (String)usenamespace.getName());
        Namespace ns = usenamespace.getNamespace();
        TestMappingLoader.assertEquals((String)"foo", (String)ns.getPrefix());
        TestMappingLoader.assertEquals((String)"http://some.uri/", (String)ns.getUri());
    }

    public void testRecursiveElementXML50() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<xmlMapping>\r\n   <mappingNode>\r\n       <name>parentNode</name>\r\n       <source>parentSource</source>\r\n       <mappingNode>           <name>childNode</name>\r\n           <source>childSource</source>\r\n           <recursionRootMappingClass>parentSource</recursionRootMappingClass>           <isRecursive>true</isRecursive>           <recursionLimit>6</recursionLimit>           <recursionCriteria>foo</recursionCriteria>       </mappingNode>   </mappingNode>\r\n</xmlMapping>\r\n\r\n";
        MappingDocument doc = this.loadMappingDocument(xml);
        MappingBaseNode node = doc.getRootNode();
        TestMappingLoader.assertTrue((boolean)(node instanceof MappingElement));
        MappingElement element = (MappingElement)node;
        TestMappingLoader.assertEquals((String)"parentNode", (String)element.getName());
        TestMappingLoader.assertTrue((boolean)element.isRootRecursiveNode());
        TestMappingLoader.assertFalse((boolean)element.isRecursive());
        TestMappingLoader.assertEquals((String)"parentSource", (String)element.getSource());
        node = (MappingNode)element.getNodeChildren().get(0);
        TestMappingLoader.assertTrue((boolean)(node instanceof MappingRecursiveElement));
        MappingRecursiveElement relement = (MappingRecursiveElement)node;
        TestMappingLoader.assertTrue((boolean)relement.isRecursive());
        TestMappingLoader.assertEquals((String)"childNode", (String)relement.getName());
        TestMappingLoader.assertEquals((String)"foo", (String)relement.getCriteria());
        TestMappingLoader.assertEquals((int)6, (int)relement.getRecursionLimit());
        TestMappingLoader.assertEquals((String)"childSource", (String)relement.getSource());
        TestMappingLoader.assertEquals((String)"parentSource", (String)relement.getMappingClass());
    }

    public void testEncoding() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<xmlMapping>\r\n    <documentEncoding>windows-1252</documentEncoding>>\r\n    <mappingNode>\r\n       <name>parentNode</name>\r\n       <source>parentSource</source>\r\n    </mappingNode>\r\n</xmlMapping>\r\n\r\n";
        MappingDocument doc = this.loadMappingDocument(xml);
        TestMappingLoader.assertEquals((String)"windows-1252", (String)doc.getDocumentEncoding());
    }

    public void testEncoding1() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<xmlMapping>\r\n   <mappingNode>\r\n       <documentEncoding>foo</documentEncoding>>\r\n       <name>parentNode</name>\r\n       <source>parentSource</source>\r\n    </mappingNode>\r\n</xmlMapping>\r\n\r\n";
        MappingDocument doc = this.loadMappingDocument(xml);
        TestMappingLoader.assertEquals((String)"foo", (String)doc.getDocumentEncoding());
    }

    public void testDocumentFormatted() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<xmlMapping>\r\n    <formattedDocument>true</formattedDocument>>\r\n    <mappingNode>\r\n       <name>parentNode</name>\r\n       <source>parentSource</source>\r\n    </mappingNode>\r\n</xmlMapping>\r\n\r\n";
        MappingDocument doc = this.loadMappingDocument(xml);
        TestMappingLoader.assertTrue((boolean)doc.isFormatted());
    }

    public void testDocumentFormatted1() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<xmlMapping>\r\n    <formattedDocument>false</formattedDocument>>\r\n    <mappingNode>\r\n       <name>parentNode</name>\r\n       <source>parentSource</source>\r\n    </mappingNode>\r\n</xmlMapping>\r\n\r\n";
        MappingDocument doc = this.loadMappingDocument(xml);
        TestMappingLoader.assertFalse((boolean)doc.isFormatted());
    }

    public void testDocumentFormatted2() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<xmlMapping>\r\n    <mappingNode>\r\n       <formattedDocument>true</formattedDocument>>\r\n       <name>parentNode</name>\r\n       <source>parentSource</source>\r\n    </mappingNode>\r\n</xmlMapping>\r\n\r\n";
        MappingDocument doc = this.loadMappingDocument(xml);
        TestMappingLoader.assertTrue((boolean)doc.isFormatted());
    }

    public void testLoadNodeWithoutNameOrType() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<xmlMapping>\r\n    <mappingNode>\r\n       <mappingNode>\r\n           <formattedDocument>true</formattedDocument>>\r\n           <name>parentNode</name>\r\n           <source>parentSource</source>\r\n       </mappingNode>\r\n   </mappingNode>\r\n</xmlMapping>\r\n\r\n";
        try {
            this.loadMappingDocument(xml);
            TestMappingLoader.fail((String)"must have failed to node, since the parent node does not have either name or type");
        }
        catch (MappingException e) {
            TestMappingLoader.assertEquals((String)"Null or blank name found in the Mapping Document, Must have valid name. Re-build the VDB", (String)e.getMessage());
        }
    }
}

