/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.proc;

import java.util.Arrays;
import java.util.List;
import javax.transaction.Transaction;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.teiid.api.exception.query.QueryResolverException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.dqp.service.TransactionContext;
import org.teiid.dqp.service.TransactionService;
import org.teiid.jdbc.TeiidSQLException;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TempMetadataAdapter;
import org.teiid.query.metadata.TempMetadataStore;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.processor.HardcodedDataManager;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.processor.TestProcessor;
import org.teiid.query.processor.proc.TestProcedureProcessor;
import org.teiid.query.resolver.TestProcedureResolving;
import org.teiid.query.unittest.RealMetadataFactory;
import org.teiid.query.util.CommandContext;

public class TestProcErrors {
    @Test
    public void testInvalidException() throws Exception {
        String ddl = "create virtual procedure vproc (x integer) returns integer as begin declare object e = sqlexception 'hello'; raise e; raise sqlexception 'hello world' sqlstate 'abc', 1 chain e; end;";
        try {
            TestProcedureResolving.createMetadata(ddl);
            Assert.fail();
        }
        catch (RuntimeException e) {
            Assert.assertEquals((Object)"TEIID31080 test.vproc validation error: TEIID31120 An exception may only be chained to another exception. e is not valid.", (Object)e.getMessage());
        }
    }

    @Test
    public void testExceptionAndWarning() throws Exception {
        String ddl = "create virtual procedure vproc (x integer) returns integer as begin declare exception e = sqlexception 'hello'; raise sqlwarning e; raise sqlexception 'hello world' sqlstate 'abc', 1 chain e; end;";
        TransformationMetadata tm = TestProcedureResolving.createMetadata(ddl);
        String sql = "call vproc(1)";
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(sql, (QueryMetadataInterface)tm);
        HardcodedDataManager dataManager = new HardcodedDataManager((QueryMetadataInterface)tm);
        try {
            TestProcedureProcessor.helpTestProcess(plan, null, dataManager, (QueryMetadataInterface)tm);
            Assert.fail();
        }
        catch (TeiidProcessingException e) {
            TeiidSQLException tsw = (TeiidSQLException)plan.getContext().getAndClearWarnings().get(0);
            Assert.assertEquals((Object)"hello", (Object)tsw.getMessage());
            Assert.assertEquals((Object)e.getCause().getCause(), (Object)tsw);
            TeiidSQLException tse = (TeiidSQLException)e.getCause();
            Assert.assertEquals((Object)"hello world", (Object)tse.getMessage());
            Assert.assertEquals((Object)"abc", (Object)tse.getSQLState());
            Assert.assertEquals((long)1L, (long)tse.getErrorCode());
        }
    }

    @Test
    public void testExceptionGroup() throws Exception {
        String ddl = "create virtual procedure vproc () returns string as begin select 1/0; exception e \"return\" = e.state || ' ' || e.errorcode || ' ' || e.teiidcode || ' ' || cast(e.exception as string) || ' ' || cast(e.chain as string); end;";
        TransformationMetadata tm = TestProcedureResolving.createMetadata(ddl);
        String sql = "call vproc()";
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(sql, (QueryMetadataInterface)tm);
        HardcodedDataManager dataManager = new HardcodedDataManager((QueryMetadataInterface)tm);
        TestProcedureProcessor.helpTestProcess(plan, new List[]{Arrays.asList("50000 30328 TEIID30328 org.teiid.jdbc.TeiidSQLException: TEIID30328 Unable to evaluate (1 / 0): TEIID30384 Error while evaluating function / : root error null org.teiid.api.exception.query.ExpressionEvaluationException: TEIID30328 Unable to evaluate (1 / 0): TEIID30384 Error while evaluating function / : root error null")}, dataManager, (QueryMetadataInterface)tm);
    }

    @Test
    public void testExceptionHandling() throws Exception {
        String ddl = "create virtual procedure vproc (x integer) returns integer as begin raise sqlexception 'hello world' sqlstate 'abc', 1;exception e raise sqlwarning sqlexception 'caught' chain e.exception; \"return\" = 1;end;";
        TransformationMetadata tm = TestProcedureResolving.createMetadata(ddl);
        String sql = "call vproc(1)";
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(sql, (QueryMetadataInterface)tm);
        HardcodedDataManager dataManager = new HardcodedDataManager((QueryMetadataInterface)tm);
        TestProcedureProcessor.helpTestProcess(plan, new List[]{Arrays.asList(1)}, dataManager, (QueryMetadataInterface)tm);
        TeiidSQLException tse = (TeiidSQLException)plan.getContext().getAndClearWarnings().get(0);
        Assert.assertEquals((Object)"caught", (Object)tse.getMessage());
        Assert.assertEquals((Object)"hello world", (Object)tse.getCause().getMessage());
    }

    @Test
    public void testExceptionHandlingWithResultSet() throws Exception {
        String ddl = "create virtual procedure proc2 (x integer) returns table(y integer) as begin atomic select 1; begin select 1/x; end exception e end;";
        TransformationMetadata tm = TestProcedureResolving.createMetadata(ddl);
        String sql = "call proc2(0)";
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(sql, (QueryMetadataInterface)tm);
        HardcodedDataManager dataManager = new HardcodedDataManager((QueryMetadataInterface)tm);
        TestProcedureProcessor.helpTestProcess(plan, new List[]{Arrays.asList(1)}, dataManager, (QueryMetadataInterface)tm);
    }

    @Test
    public void testExceptionHandlingWithResultSet1() throws Exception {
        String ddl = "create virtual procedure proc2 (x integer) as begin create local temporary table t (i integer); insert into t (i) values (1); declare integer y = 0; while (y < 16) begin insert into t (i) select 1 from t; y = y+1; end insert into t (i) values (0); select cast(1/i as string) from t; exception e end;";
        TransformationMetadata tm = TestProcedureResolving.createMetadata(ddl);
        String sql = "call proc2(0)";
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(sql, (QueryMetadataInterface)tm);
        HardcodedDataManager dataManager = new HardcodedDataManager((QueryMetadataInterface)tm);
        TestProcedureProcessor.helpTestProcess(plan, new List[0], dataManager, (QueryMetadataInterface)tm);
    }

    @Test
    public void testExceptionHandlingWithDynamic() throws Exception {
        String ddl = "create virtual procedure vproc (x integer) returns integer as begin raise sqlexception 'hello world' sqlstate 'abc', 5;exception e execute immediate 'select \"ERRORCODE\"' as x integer into #temp; \"return\" = (select x from #temp);end;";
        TransformationMetadata tm = TestProcedureResolving.createMetadata(ddl);
        String sql = "call vproc(1)";
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(sql, (QueryMetadataInterface)tm);
        HardcodedDataManager dataManager = new HardcodedDataManager((QueryMetadataInterface)tm);
        TestProcedureProcessor.helpTestProcess(plan, new List[]{Arrays.asList(5)}, dataManager, (QueryMetadataInterface)tm);
    }

    @Test
    public void testDynamicAnon() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        String query = "BEGIN atomic\n declare string VARIABLES.RESULT = 1/0;\n select VARIABLES.RESULT;exception e execute immediate 'select \"ERRORCODE\"' as x string into #temp; select x from #temp; end";
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(query, (QueryMetadataInterface)metadata);
        List[] expected = new List[]{Arrays.asList("30328")};
        TestProcedureProcessor.helpTestProcess(plan, expected, new HardcodedDataManager(), (QueryMetadataInterface)metadata);
    }

    @Test(expected=QueryResolverException.class)
    public void testErrorResolving() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        String query = "BEGIN atomic\n declare string VARIABLES.RESULT = 1/0;\n select VARIABLES.RESULT;exception e execute immediate 'select \"ERRORCODE\"' || VARIABLES.RESULT as x string into #temp; select x from #temp; end";
        TestProcedureProcessor.getProcedurePlan(query, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testNestedBeginAtomicException() throws Exception {
        TransformationMetadata tm = RealMetadataFactory.example1Cached();
        String query = "BEGIN atomic\n declare string VARIABLES.RESULT;\n begin atomic select 1/0; exception e end end";
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(query, (QueryMetadataInterface)tm);
        List[] expected = new List[]{};
        CommandContext context = new CommandContext((Object)"pID", null, null, null, 1);
        TempMetadataAdapter metadata = new TempMetadataAdapter((QueryMetadataInterface)tm, new TempMetadataStore());
        context.setMetadata((QueryMetadataInterface)metadata);
        TransactionContext tc = new TransactionContext();
        Transaction txn = (Transaction)Mockito.mock(Transaction.class);
        tc.setTransaction(txn);
        tc.setTransactionType(TransactionContext.Scope.REQUEST);
        TransactionService ts = (TransactionService)Mockito.mock(TransactionService.class);
        context.setTransactionService(ts);
        context.setTransactionContext(tc);
        TestProcessor.helpProcess(plan, context, new HardcodedDataManager(), expected);
        ((Transaction)Mockito.verify((Object)txn, (VerificationMode)Mockito.times((int)3))).setRollbackOnly();
    }

    @Test
    public void testExceptionHandlingWithLoops() throws Exception {
        String ddl = "create virtual procedure proc2 (out x integer result) as begin create local temporary table t (i integer); insert into t (i) values (0); begin loop on (select * from t) as x select 1/0; exception e end insert into t (i) values (1); declare integer result = 0; loop on (select * from t) as x result = result + 1; x = result;select result; end;";
        TransformationMetadata tm = TestProcedureResolving.createMetadata(ddl);
        String sql = "call proc2()";
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(sql, (QueryMetadataInterface)tm);
        HardcodedDataManager dataManager = new HardcodedDataManager((QueryMetadataInterface)tm);
        TestProcedureProcessor.helpTestProcess(plan, new List[]{Arrays.asList(2)}, dataManager, (QueryMetadataInterface)tm);
    }
}

