/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.mapping.xml;

import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.util.Assertion;
import org.teiid.query.QueryPlugin;
import org.teiid.query.mapping.xml.MappingAllNode;
import org.teiid.query.mapping.xml.MappingBaseNode;
import org.teiid.query.mapping.xml.MappingChoiceNode;
import org.teiid.query.mapping.xml.MappingElement;
import org.teiid.query.mapping.xml.MappingNodeConstants;
import org.teiid.query.mapping.xml.MappingSequenceNode;
import org.teiid.query.mapping.xml.MappingSourceNode;
import org.teiid.query.mapping.xml.MappingVisitor;

public class MappingDocument
extends MappingBaseNode {
    MappingBaseNode root;
    boolean formatted;
    String encoding;
    String name;

    public MappingDocument(boolean formatted) {
        this("UTF-8", formatted);
    }

    public MappingDocument(String encoding, boolean formatted) {
        if (encoding == null) {
            encoding = "UTF-8";
        }
        this.setDocumentEncoding(encoding);
        this.setFormatted(formatted);
    }

    @Override
    public void acceptVisitor(MappingVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getFullyQualifiedName() {
        return this.name;
    }

    public MappingBaseNode getRootNode() {
        return this.root;
    }

    public MappingElement getTagRootElement() {
        if (this.root instanceof MappingSourceNode) {
            return (MappingElement)this.root.getNodeChildren().get(0);
        }
        return (MappingElement)this.root;
    }

    void setRoot(MappingBaseNode root) {
        if (root != null) {
            this.root = root;
            this.getChildren().clear();
            this.addChild(root);
        }
    }

    public String getDocumentEncoding() {
        return this.encoding;
    }

    public boolean isFormatted() {
        return this.formatted;
    }

    @Override
    public boolean isDocumentNode() {
        return true;
    }

    public void setDocumentEncoding(String encoding) {
        this.encoding = encoding;
        this.setProperty(MappingNodeConstants.Properties.DOCUMENT_ENCODING, this.encoding);
    }

    public void setFormatted(boolean formatted) {
        this.formatted = formatted;
        this.setProperty(MappingNodeConstants.Properties.FORMATTED_DOCUMENT, this.formatted);
    }

    private void fixCardinality(MappingElement root) {
        root.setMaxOccurrs(1);
        root.setMinOccurrs(1);
    }

    @Override
    public MappingAllNode addAllNode(MappingAllNode elem) {
        throw new TeiidRuntimeException((BundleUtil.Event)QueryPlugin.Event.TEIID30452, QueryPlugin.Util.gs(QueryPlugin.Event.TEIID30452, new Object[0]));
    }

    @Override
    public MappingChoiceNode addChoiceNode(MappingChoiceNode elem) {
        throw new TeiidRuntimeException((BundleUtil.Event)QueryPlugin.Event.TEIID30452, QueryPlugin.Util.gs(QueryPlugin.Event.TEIID30452, new Object[0]));
    }

    @Override
    public MappingSequenceNode addSequenceNode(MappingSequenceNode elem) {
        throw new TeiidRuntimeException((BundleUtil.Event)QueryPlugin.Event.TEIID30452, QueryPlugin.Util.gs(QueryPlugin.Event.TEIID30452, new Object[0]));
    }

    @Override
    public MappingElement addChildElement(MappingElement elem) {
        Assertion.isNotNull(elem);
        this.fixCardinality(elem);
        this.setRoot(elem);
        return elem;
    }

    @Override
    public MappingSourceNode addSourceNode(MappingSourceNode elem) {
        Assertion.isNotNull(elem);
        this.setRoot(elem);
        return elem;
    }

    @Override
    public MappingDocument clone() {
        MappingDocument clone = (MappingDocument)super.clone();
        clone.root = (MappingBaseNode)clone.getChildren().iterator().next();
        return clone;
    }
}

