/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer.relational.rules;

import java.util.ArrayList;
import java.util.List;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryPlannerException;
import org.teiid.core.TeiidComponentException;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.relational.OptimizerRule;
import org.teiid.query.optimizer.relational.RuleStack;
import org.teiid.query.optimizer.relational.plantree.NodeConstants;
import org.teiid.query.optimizer.relational.plantree.NodeEditor;
import org.teiid.query.optimizer.relational.plantree.PlanNode;
import org.teiid.query.optimizer.relational.rules.RulePushLimit;
import org.teiid.query.optimizer.relational.rules.RuleRaiseAccess;
import org.teiid.query.processor.relational.JoinNode;
import org.teiid.query.processor.relational.MergeJoinStrategy;
import org.teiid.query.sql.lang.OrderBy;
import org.teiid.query.sql.lang.OrderByItem;
import org.teiid.query.sql.lang.SetQuery;
import org.teiid.query.sql.symbol.AggregateSymbol;
import org.teiid.query.sql.symbol.AliasSymbol;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.ExpressionSymbol;
import org.teiid.query.sql.util.SymbolMap;
import org.teiid.query.util.CommandContext;

public class RulePlanSorts
implements OptimizerRule {
    @Override
    public PlanNode execute(PlanNode plan, QueryMetadataInterface metadata, CapabilitiesFinder capabilitiesFinder, RuleStack rules, AnalysisRecord analysisRecord, CommandContext context) throws QueryPlannerException, QueryMetadataException, TeiidComponentException {
        return this.optimizeSorts(false, plan, plan, metadata, capabilitiesFinder, analysisRecord, context);
    }

    private PlanNode optimizeSorts(boolean parentBlocking, PlanNode node, PlanNode root, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, AnalysisRecord record, CommandContext context) throws QueryMetadataException, TeiidComponentException, QueryPlannerException {
        if ((node = NodeEditor.findNodePreOrder(node, 422, 1)) == null) {
            return root;
        }
        switch (node.getType()) {
            case 32: {
                parentBlocking = true;
                if (node.hasBooleanProperty(NodeConstants.Info.IS_DUP_REMOVAL)) break;
                if (this.mergeSortWithDupRemoval(node)) {
                    node.setProperty(NodeConstants.Info.IS_DUP_REMOVAL, true);
                } else {
                    root = this.checkForProjectOptimization(node, root, metadata, capFinder, record, context);
                    if (NodeEditor.findParent(node, 1) != null) {
                        return root;
                    }
                }
                OrderBy orderBy = (OrderBy)node.getProperty(NodeConstants.Info.SORT_ORDER);
                List<Expression> orderColumns = orderBy.getSortKeys();
                ArrayList<Expression> sortExpressions = new ArrayList<Expression>(orderColumns.size());
                PlanNode possibleSort = NodeEditor.findNodePreOrder(node, 128, 65);
                if (possibleSort == null || possibleSort.hasBooleanProperty(NodeConstants.Info.ROLLUP)) break;
                boolean otherExpression = false;
                SymbolMap groupMap = (SymbolMap)possibleSort.getProperty(NodeConstants.Info.SYMBOL_MAP);
                for (Expression singleElementSymbol : orderColumns) {
                    Expression ex = SymbolMap.getExpression(singleElementSymbol);
                    if (ex instanceof ElementSymbol) {
                        sortExpressions.add(groupMap.getMappedExpression((ElementSymbol)ex));
                        continue;
                    }
                    otherExpression = true;
                    break;
                }
                List exprs = (List)possibleSort.getProperty(NodeConstants.Info.GROUP_COLS);
                if (otherExpression || exprs == null || !exprs.containsAll(sortExpressions)) break;
                exprs.removeAll(sortExpressions);
                exprs.addAll(0, sortExpressions);
                if (node.getParent() == null) {
                    root = node.getFirstChild();
                    root.removeFromParent();
                    node = root;
                } else {
                    PlanNode nextNode = node.getFirstChild();
                    NodeEditor.removeChildNode(node.getParent(), node);
                    node = nextNode;
                }
                possibleSort.setProperty(NodeConstants.Info.SORT_ORDER, orderBy);
                break;
            }
            case 2: {
                if (!parentBlocking) break;
                node.setType(32);
                node.setProperty(NodeConstants.Info.IS_DUP_REMOVAL, true);
                break;
            }
            case 128: {
                if (!node.hasCollectionProperty(NodeConstants.Info.GROUP_COLS)) break;
                SymbolMap map = (SymbolMap)node.getProperty(NodeConstants.Info.SYMBOL_MAP);
                boolean cardinalityDependent = false;
                boolean canOptimize = true;
                for (Expression ex : map.asMap().values()) {
                    if (ex instanceof AggregateSymbol) {
                        AggregateSymbol agg = (AggregateSymbol)ex;
                        if (!agg.isCardinalityDependent()) continue;
                        cardinalityDependent = true;
                        break;
                    }
                    if (ex instanceof ElementSymbol) continue;
                    canOptimize = false;
                    break;
                }
                if (canOptimize && this.mergeSortWithDupRemovalAcrossSource(node)) {
                    node.setProperty(NodeConstants.Info.IS_DUP_REMOVAL, true);
                    if (cardinalityDependent) {
                        PlanNode source = NodeEditor.findNodePreOrder(node, 64);
                        List sourceOutput = (List)source.getProperty(NodeConstants.Info.OUTPUT_COLS);
                        for (PlanNode child = node.getFirstChild(); child != source; child = child.getFirstChild()) {
                            child.setProperty(NodeConstants.Info.OUTPUT_COLS, sourceOutput);
                        }
                    }
                }
                parentBlocking = true;
                break;
            }
            case 4: {
                if (node.getProperty(NodeConstants.Info.JOIN_STRATEGY) == JoinNode.JoinStrategyType.NESTED_LOOP || node.getProperty(NodeConstants.Info.JOIN_STRATEGY) == JoinNode.JoinStrategyType.NESTED_TABLE) break;
                parentBlocking = true;
                PlanNode toTest = node.getFirstChild();
                if (this.mergeSortWithDupRemovalAcrossSource(toTest)) {
                    node.setProperty(NodeConstants.Info.SORT_LEFT, (Object)MergeJoinStrategy.SortOption.SORT_DISTINCT);
                    if (node.getProperty(NodeConstants.Info.SORT_RIGHT) != MergeJoinStrategy.SortOption.SORT) {
                        node.setProperty(NodeConstants.Info.JOIN_STRATEGY, (Object)JoinNode.JoinStrategyType.MERGE);
                    }
                }
                if (!this.mergeSortWithDupRemovalAcrossSource(toTest = node.getLastChild())) break;
                node.setProperty(NodeConstants.Info.SORT_RIGHT, (Object)MergeJoinStrategy.SortOption.SORT_DISTINCT);
                if (node.getProperty(NodeConstants.Info.SORT_LEFT) == MergeJoinStrategy.SortOption.SORT) break;
                node.setProperty(NodeConstants.Info.JOIN_STRATEGY, (Object)JoinNode.JoinStrategyType.MERGE);
                break;
            }
            case 256: {
                if (node.getProperty(NodeConstants.Info.SET_OPERATION) != SetQuery.Operation.UNION) {
                    parentBlocking = true;
                    break;
                }
                if (node.hasBooleanProperty(NodeConstants.Info.USE_ALL) || parentBlocking) break;
                node.setProperty(NodeConstants.Info.IS_DUP_REMOVAL, true);
            }
        }
        for (PlanNode child : node.getChildren()) {
            root = this.optimizeSorts(parentBlocking, child, root, metadata, capFinder, record, context);
        }
        return root;
    }

    private PlanNode checkForProjectOptimization(PlanNode node, PlanNode root, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, AnalysisRecord record, CommandContext context) throws QueryMetadataException, TeiidComponentException, QueryPlannerException {
        PlanNode accessNode;
        PlanNode newRoot;
        PlanNode projectNode = node.getFirstChild();
        PlanNode parent = node.getParent();
        boolean raiseAccess = false;
        if (projectNode.getType() == 1 && RuleRaiseAccess.canRaiseOverSort(projectNode, metadata, capFinder, node, record, true)) {
            if ((projectNode = NodeEditor.findNodePreOrder(projectNode, 8, 64)) == null) {
                return root;
            }
            raiseAccess = true;
        } else if (projectNode.getType() == 8 && projectNode.getFirstChild() != null) {
            boolean bl = raiseAccess = projectNode.getFirstChild().getType() == 1 && RuleRaiseAccess.canRaiseOverSort(projectNode.getFirstChild(), metadata, capFinder, node, record, false);
            if (!(raiseAccess || parent != null && parent.getType() == 1024)) {
                return root;
            }
        } else {
            return root;
        }
        List childOutputCols = (List)projectNode.getFirstChild().getProperty(NodeConstants.Info.OUTPUT_COLS);
        OrderBy orderBy = (OrderBy)node.getProperty(NodeConstants.Info.SORT_ORDER);
        List<Expression> orderByKeys = orderBy.getSortKeys();
        for (Expression ss : orderByKeys) {
            if (ss instanceof AliasSymbol) {
                ss = ((AliasSymbol)ss).getSymbol();
            }
            if (ss instanceof ExpressionSymbol) {
                return root;
            }
            if (childOutputCols.contains(ss)) continue;
            return root;
        }
        PlanNode toRepair = projectNode.getParent();
        NodeEditor.removeChildNode(projectNode.getParent(), projectNode);
        if (parent != null && parent.getType() == 1024 && parent.getParent() != null) {
            parent.addAsParent(projectNode);
        } else {
            if (parent == null) {
                root = projectNode;
            }
            if (parent != null && parent.getType() == 1024) {
                if (root == parent) {
                    root = projectNode;
                }
                projectNode.addFirstChild(parent);
            } else {
                projectNode.addFirstChild(node);
            }
        }
        List orderByOutputSymbols = (List)node.getProperty(NodeConstants.Info.OUTPUT_COLS);
        boolean unrelated = false;
        if (node.hasBooleanProperty(NodeConstants.Info.UNRELATED_SORT)) {
            node.setProperty(NodeConstants.Info.UNRELATED_SORT, false);
            unrelated = true;
        }
        for (OrderByItem item : orderBy.getOrderByItems()) {
            if (unrelated) {
                int index = childOutputCols.indexOf(item.getSymbol());
                item.setExpressionPosition(index);
            }
            if (!(item.getSymbol() instanceof AliasSymbol)) continue;
            item.setSymbol(((AliasSymbol)item.getSymbol()).getSymbol());
        }
        while (toRepair != node) {
            toRepair.setProperty(NodeConstants.Info.OUTPUT_COLS, childOutputCols);
            toRepair = toRepair.getParent();
        }
        projectNode.setProperty(NodeConstants.Info.OUTPUT_COLS, orderByOutputSymbols);
        projectNode.setProperty(NodeConstants.Info.PROJECT_COLS, orderByOutputSymbols);
        node.setProperty(NodeConstants.Info.OUTPUT_COLS, childOutputCols);
        if (parent != null) {
            parent.setProperty(NodeConstants.Info.OUTPUT_COLS, childOutputCols);
        }
        if (raiseAccess && (newRoot = RuleRaiseAccess.raiseAccessNode(root, accessNode = node.getFirstChild(), metadata, capFinder, true, record, context)) != null) {
            root = newRoot;
            if (accessNode.getParent().getType() == 1024) {
                newRoot = RulePushLimit.raiseAccessOverLimit(root, accessNode, metadata, capFinder, accessNode.getParent(), record);
            }
            if (newRoot != null) {
                root = newRoot;
            }
        }
        return root;
    }

    private boolean mergeSortWithDupRemovalAcrossSource(PlanNode toTest) {
        PlanNode source = NodeEditor.findNodePreOrder(toTest, 64, 5);
        return source != null && this.mergeSortWithDupRemoval(source);
    }

    private boolean mergeSortWithDupRemoval(PlanNode node) {
        PlanNode parentProject;
        PlanNode source;
        if (node.getFirstChild() == null) {
            return false;
        }
        switch (node.getFirstChild().getType()) {
            case 256: {
                if (node.getFirstChild().getProperty(NodeConstants.Info.SET_OPERATION) != SetQuery.Operation.UNION || node.getFirstChild().hasBooleanProperty(NodeConstants.Info.USE_ALL)) break;
                node.getFirstChild().setProperty(NodeConstants.Info.USE_ALL, true);
                return true;
            }
            case 2: {
                NodeEditor.removeChildNode(node, node.getFirstChild());
                return true;
            }
        }
        if (node.hasBooleanProperty(NodeConstants.Info.UNRELATED_SORT) && (source = NodeEditor.findNodePreOrder(node, 64)) != null && (parentProject = NodeEditor.findParent(source, 8)) != null && parentProject.getProperty(NodeConstants.Info.PROJECT_COLS).equals(source.getProperty(NodeConstants.Info.OUTPUT_COLS))) {
            return this.mergeSortWithDupRemoval(source);
        }
        return false;
    }

    public String toString() {
        return "PlanSorts";
    }
}

