/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.util;

import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import javax.security.auth.Subject;
import org.teiid.CommandListener;
import org.teiid.adminapi.DataPolicy;
import org.teiid.adminapi.impl.SessionMetadata;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.api.exception.query.QueryProcessingException;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.TupleSource;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidException;
import org.teiid.core.util.ArgCheck;
import org.teiid.core.util.ExecutorUtils;
import org.teiid.core.util.LRUCache;
import org.teiid.dqp.internal.process.AuthorizationValidator;
import org.teiid.dqp.internal.process.DQPWorkContext;
import org.teiid.dqp.internal.process.PreparedPlan;
import org.teiid.dqp.internal.process.RequestWorkItem;
import org.teiid.dqp.internal.process.SessionAwareCache;
import org.teiid.dqp.internal.process.TupleSourceCache;
import org.teiid.dqp.message.RequestID;
import org.teiid.dqp.service.TransactionContext;
import org.teiid.dqp.service.TransactionService;
import org.teiid.jdbc.ConnectionImpl;
import org.teiid.jdbc.EmbeddedProfile;
import org.teiid.jdbc.TeiidConnection;
import org.teiid.jdbc.TeiidSQLException;
import org.teiid.logging.LogManager;
import org.teiid.metadata.FunctionMethod;
import org.teiid.net.ServerConnection;
import org.teiid.query.QueryPlugin;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TempMetadataAdapter;
import org.teiid.query.parser.ParseInfo;
import org.teiid.query.processor.QueryProcessor;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.util.VariableContext;
import org.teiid.query.tempdata.GlobalTableStore;
import org.teiid.query.tempdata.GlobalTableStoreImpl;
import org.teiid.query.tempdata.TempTableStore;
import org.teiid.query.util.GeneratedKeysImpl;
import org.teiid.query.util.Options;
import org.teiid.translator.ReusableExecution;

public class CommandContext
implements Cloneable,
org.teiid.CommandContext {
    private static ThreadLocal<LinkedList<CommandContext>> threadLocalContext = new ThreadLocal<LinkedList<CommandContext>>(){

        @Override
        protected LinkedList<CommandContext> initialValue() {
            return new LinkedList<CommandContext>();
        }
    };
    private GlobalState globalState = new GlobalState();
    private VariableContext variableContext = new VariableContext();
    private TempTableStore tempTableStore;
    private LinkedList<String> recursionStack;
    private boolean nonBlocking;
    private HashSet<Object> planningObjects;
    private HashSet<Object> dataObjects = GlobalState.access$100(this.globalState);
    private TupleSourceCache tupleSourceCache;
    private VDBState vdbState = new VDBState();
    private FunctionMethod.Determinism[] determinismLevel = new FunctionMethod.Determinism[]{FunctionMethod.Determinism.DETERMINISTIC};

    public CommandContext(String connectionID, String userName, Serializable commandPayload, String vdbName, int vdbVersion, boolean collectNodeStatistics) {
        this.setConnectionID(connectionID);
        this.setUserName(userName);
        this.setCommandPayload(commandPayload);
        this.setVdbName(vdbName);
        this.setVdbVersion(vdbVersion);
        this.setCollectNodeStatistics(collectNodeStatistics);
    }

    public CommandContext(Object processorID, String connectionID, String userName, String vdbName, int vdbVersion) {
        this(connectionID, userName, null, vdbName, vdbVersion, false);
    }

    public CommandContext() {
    }

    private CommandContext(GlobalState state) {
        this.globalState = state;
        this.dataObjects = this.globalState.dataObjects;
    }

    public FunctionMethod.Determinism getDeterminismLevel() {
        return this.determinismLevel[0];
    }

    public FunctionMethod.Determinism resetDeterminismLevel(boolean detach) {
        FunctionMethod.Determinism result = this.determinismLevel[0];
        if (detach) {
            this.determinismLevel = new FunctionMethod.Determinism[1];
        }
        this.determinismLevel[0] = FunctionMethod.Determinism.DETERMINISTIC;
        return result;
    }

    public FunctionMethod.Determinism resetDeterminismLevel() {
        return this.resetDeterminismLevel(false);
    }

    public void setDeterminismLevel(FunctionMethod.Determinism level) {
        if (this.determinismLevel[0] == null || level.compareTo(this.determinismLevel[0]) < 0) {
            this.determinismLevel[0] = level;
        }
    }

    public RequestWorkItem getWorkItem() {
        if (this.globalState.processorID == null) {
            return null;
        }
        return (RequestWorkItem)this.globalState.processorID.get();
    }

    public void setWorkItem(RequestWorkItem object) {
        ArgCheck.isNotNull(object);
        this.globalState.processorID = new WeakReference<RequestWorkItem>(object);
    }

    public CommandContext clone() {
        CommandContext clone = new CommandContext(this.globalState);
        clone.variableContext = this.variableContext;
        clone.tempTableStore = this.tempTableStore;
        if (this.recursionStack != null) {
            clone.recursionStack = new LinkedList<String>(this.recursionStack);
        }
        clone.setNonBlocking(this.nonBlocking);
        clone.tupleSourceCache = this.tupleSourceCache;
        clone.vdbState = this.vdbState;
        clone.determinismLevel = this.determinismLevel;
        return clone;
    }

    public void setNewVDBState(DQPWorkContext newWorkContext) {
        this.vdbState = new VDBState();
        VDBMetaData vdb = newWorkContext.getVDB();
        GlobalTableStore actualGlobalStore = vdb.getAttachment(GlobalTableStore.class);
        this.vdbState.globalTables = actualGlobalStore;
        this.vdbState.session = newWorkContext.getSession();
        this.vdbState.classLoader = vdb.getAttachment(ClassLoader.class);
        this.vdbState.vdbName = vdb.getName();
        this.vdbState.vdbVersion = vdb.getVersion();
        this.vdbState.dqpWorkContext = newWorkContext;
        TempMetadataAdapter metadata = new TempMetadataAdapter(vdb.getAttachment(QueryMetadataInterface.class), this.globalState.sessionTempTableStore.getMetadataStore());
        metadata.setSession(true);
        this.vdbState.metadata = metadata;
    }

    public String toString() {
        return "CommandContext: " + this.globalState.processorID;
    }

    @Override
    public String getConnectionId() {
        return this.globalState.connectionID;
    }

    @Override
    public String getConnectionID() {
        return this.globalState.connectionID;
    }

    @Override
    public String getUserName() {
        return this.globalState.userName;
    }

    @Override
    public String getVdbName() {
        return this.vdbState.vdbName;
    }

    @Override
    public int getVdbVersion() {
        return this.vdbState.vdbVersion;
    }

    public void setConnectionID(String connectionID) {
        this.globalState.connectionID = connectionID;
    }

    public void setUserName(String userName) {
        this.globalState.userName = userName;
    }

    public void setVdbName(String vdbName) {
        this.vdbState.vdbName = vdbName;
    }

    public void setVdbVersion(int vdbVersion) {
        this.vdbState.vdbVersion = vdbVersion;
    }

    @Override
    public Serializable getCommandPayload() {
        return this.globalState.commandPayload;
    }

    public void setCommandPayload(Serializable commandPayload) {
        this.globalState.commandPayload = commandPayload;
    }

    public void setCollectNodeStatistics(boolean collectNodeStatistics) {
        this.globalState.collectNodeStatistics = collectNodeStatistics;
    }

    public boolean getCollectNodeStatistics() {
        return this.globalState.collectNodeStatistics;
    }

    @Override
    public int getProcessorBatchSize() {
        return this.globalState.processorBatchSize;
    }

    public int getProcessorBatchSize(List<Expression> schema) {
        return this.globalState.bufferManager.getProcessorBatchSize(schema);
    }

    public void setProcessorBatchSize(int processorBatchSize) {
        this.globalState.processorBatchSize = processorBatchSize;
    }

    @Override
    public double getNextRand() {
        if (this.globalState.random == null) {
            this.globalState.random = new Random();
        }
        return this.globalState.random.nextDouble();
    }

    @Override
    public double getNextRand(long seed) {
        if (this.globalState.random == null) {
            this.globalState.random = new Random();
        }
        this.globalState.random.setSeed(seed);
        return this.globalState.random.nextDouble();
    }

    void setRandom(Random random) {
        this.globalState.random = random;
    }

    public void pushCall(String value) throws QueryProcessingException {
        if (this.recursionStack == null) {
            this.recursionStack = new LinkedList();
        } else if (this.recursionStack.contains(value)) {
            throw new QueryProcessingException((BundleUtil.Event)QueryPlugin.Event.TEIID30347, QueryPlugin.Util.gs(QueryPlugin.Event.TEIID30347, value));
        }
        this.recursionStack.push(value);
    }

    public int getCallStackDepth() {
        if (this.recursionStack == null) {
            return 0;
        }
        return this.recursionStack.size();
    }

    public void popCall() {
        if (this.recursionStack != null) {
            this.recursionStack.pop();
        }
    }

    public void setAuthoriziationValidator(AuthorizationValidator authorizationValidator) {
        this.globalState.authorizationValidator = authorizationValidator;
    }

    public TempTableStore getTempTableStore() {
        return this.tempTableStore;
    }

    public void setTempTableStore(TempTableStore tempTableStore) {
        this.tempTableStore = tempTableStore;
        if (this.globalState.sessionTempTableStore == null) {
            this.globalState.sessionTempTableStore = tempTableStore;
        }
    }

    public TempTableStore getSessionTempTableStore() {
        return this.globalState.sessionTempTableStore;
    }

    public void setSessionTempTableStore(TempTableStore tempTableStore) {
        this.globalState.sessionTempTableStore = tempTableStore;
    }

    @Override
    public TimeZone getServerTimeZone() {
        return this.globalState.timezone;
    }

    public QueryProcessor.ProcessorFactory getQueryProcessorFactory() {
        return this.globalState.queryProcessorFactory;
    }

    public void setQueryProcessorFactory(QueryProcessor.ProcessorFactory queryProcessorFactory) {
        this.globalState.queryProcessorFactory = queryProcessorFactory;
    }

    public VariableContext getVariableContext() {
        return this.variableContext;
    }

    public void setVariableContext(VariableContext variableContext) {
        this.variableContext = variableContext;
    }

    public void pushVariableContext(VariableContext toPush) {
        toPush.setParentContext(this.variableContext);
        this.variableContext = toPush;
    }

    public Object getFromContext(Expression expression) throws TeiidComponentException {
        if (this.variableContext == null || !(expression instanceof ElementSymbol)) {
            throw new TeiidComponentException((BundleUtil.Event)QueryPlugin.Event.TEIID30328, QueryPlugin.Util.gs(QueryPlugin.Event.TEIID30328, expression, QueryPlugin.Util.getString("Evaluator.no_value")));
        }
        Object value = this.variableContext.getValue((ElementSymbol)expression);
        if (value == null && !this.variableContext.containsVariable((ElementSymbol)expression)) {
            throw new TeiidComponentException((BundleUtil.Event)QueryPlugin.Event.TEIID30328, QueryPlugin.Util.gs(QueryPlugin.Event.TEIID30328, expression, QueryPlugin.Util.getString("Evaluator.no_value")));
        }
        return value;
    }

    public Set<String> getGroups() {
        if (this.globalState.groups == null) {
            this.globalState.groups = new TreeSet(String.CASE_INSENSITIVE_ORDER);
        }
        return this.globalState.groups;
    }

    public Map<String, String> getAliasMapping() {
        if (this.globalState.aliasMapping == null) {
            this.globalState.aliasMapping = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        }
        return this.globalState.aliasMapping;
    }

    public long getTimeSliceEnd() {
        return this.globalState.timeSliceEnd;
    }

    public long getTimeoutEnd() {
        return this.globalState.timeoutEnd;
    }

    public void setTimeSliceEnd(long timeSliceEnd) {
        this.globalState.timeSliceEnd = timeSliceEnd;
    }

    public void setTimeoutEnd(long timeoutEnd) {
        this.globalState.timeoutEnd = timeoutEnd;
    }

    public void setMetadata(QueryMetadataInterface metadata) {
        this.vdbState.metadata = metadata;
    }

    public QueryMetadataInterface getMetadata() {
        return this.vdbState.metadata;
    }

    public void setValidateXML(boolean validateXML) {
        this.globalState.validateXML = validateXML;
    }

    public boolean validateXML() {
        return this.globalState.validateXML;
    }

    public BufferManager getBufferManager() {
        return this.globalState.bufferManager;
    }

    public void setBufferManager(BufferManager bm) {
        this.globalState.bufferManager = bm;
    }

    public GlobalTableStore getGlobalTableStore() {
        return this.vdbState.globalTables;
    }

    public void setGlobalTableStore(GlobalTableStore tempTableStore) {
        this.vdbState.globalTables = tempTableStore;
    }

    public boolean isNonBlocking() {
        return this.nonBlocking;
    }

    public void setNonBlocking(boolean nonBlocking) {
        this.nonBlocking = nonBlocking;
    }

    public void setPreparedPlanCache(SessionAwareCache<PreparedPlan> cache) {
        this.globalState.planCache = cache;
    }

    public PreparedPlan getPlan(String key) {
        if (this.globalState.planCache == null) {
            return null;
        }
        SessionAwareCache.CacheID id = new SessionAwareCache.CacheID(new ParseInfo(), key, this.getVdbName(), this.getVdbVersion(), this.getConnectionId(), this.getUserName());
        PreparedPlan pp = (PreparedPlan)this.globalState.planCache.get(id);
        if (pp != null) {
            if (id.getSessionId() != null) {
                this.setDeterminismLevel(FunctionMethod.Determinism.USER_DETERMINISTIC);
            } else if (id.getUserName() != null) {
                this.setDeterminismLevel(FunctionMethod.Determinism.SESSION_DETERMINISTIC);
            }
            return pp;
        }
        return null;
    }

    public void putPlan(String key, PreparedPlan plan, FunctionMethod.Determinism determinismLevel) {
        if (this.globalState.planCache == null) {
            return;
        }
        SessionAwareCache.CacheID id = new SessionAwareCache.CacheID(new ParseInfo(), key, this.getVdbName(), this.getVdbVersion(), this.getConnectionId(), this.getUserName());
        this.globalState.planCache.put(id, determinismLevel, plan, null);
    }

    public boolean isResultSetCacheEnabled() {
        return this.globalState.resultSetCacheEnabled;
    }

    public void setResultSetCacheEnabled(boolean resultSetCacheEnabled) {
        this.globalState.resultSetCacheEnabled = resultSetCacheEnabled;
    }

    public int getUserRequestSourceConcurrency() {
        return this.globalState.userRequestSourceConcurrency;
    }

    public void setUserRequestSourceConcurrency(int userRequestSourceConcurrency) {
        this.globalState.userRequestSourceConcurrency = userRequestSourceConcurrency;
    }

    @Override
    public Subject getSubject() {
        return this.globalState.subject;
    }

    public void setSubject(Subject subject) {
        this.globalState.subject = subject;
    }

    public void accessedPlanningObject(Object id) {
        if (this.planningObjects == null) {
            this.planningObjects = new HashSet();
        }
        this.planningObjects.add(id);
    }

    public Set<Object> getPlanningObjects() {
        if (this.planningObjects == null) {
            return Collections.emptySet();
        }
        return this.planningObjects;
    }

    public void accessedDataObject(Object id) {
        if (this.dataObjects != null) {
            this.dataObjects.add(id);
        }
    }

    public Set<Object> getDataObjects() {
        return this.dataObjects;
    }

    public void setDataObjects(HashSet<Object> dataObjectsAccessed) {
        this.dataObjects = dataObjectsAccessed;
    }

    @Override
    public SessionMetadata getSession() {
        return this.vdbState.session;
    }

    public void setSession(SessionMetadata session) {
        this.vdbState.session = session;
    }

    @Override
    public String getRequestId() {
        return this.globalState.requestId != null ? this.globalState.requestId.toString() : null;
    }

    public void setRequestId(RequestID requestId) {
        this.globalState.requestId = requestId;
    }

    public void setDQPWorkContext(DQPWorkContext workContext) {
        this.vdbState.dqpWorkContext = workContext;
    }

    @Override
    public Map<String, DataPolicy> getAllowedDataPolicies() {
        if (this.vdbState.dqpWorkContext == null) {
            return null;
        }
        return this.vdbState.dqpWorkContext.getAllowedDataPolicies();
    }

    @Override
    public VDBMetaData getVdb() {
        if (this.vdbState.dqpWorkContext == null) {
            return null;
        }
        return this.vdbState.dqpWorkContext.getVDB();
    }

    public DQPWorkContext getDQPWorkContext() {
        return this.vdbState.dqpWorkContext;
    }

    public TransactionContext getTransactionContext() {
        return this.globalState.transactionContext;
    }

    public void setTransactionContext(TransactionContext transactionContext) {
        this.globalState.transactionContext = transactionContext;
    }

    public TransactionService getTransactionServer() {
        return this.globalState.transactionService;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.globalState.transactionService = transactionService;
    }

    public Executor getExecutor() {
        return this.globalState.executor;
    }

    public void setExecutor(Executor e) {
        this.globalState.executor = e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReusableExecution<?> getReusableExecution(Object key) {
        GlobalState globalState = this.globalState;
        synchronized (globalState) {
            if (this.globalState.reusableExecutions == null) {
                return null;
            }
            List<ReusableExecution<?>> reusableExecutions = this.globalState.reusableExecutions.get(key);
            if (reusableExecutions != null && !reusableExecutions.isEmpty()) {
                return reusableExecutions.remove(0);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putReusableExecution(Object key, ReusableExecution<?> execution) {
        GlobalState globalState = this.globalState;
        synchronized (globalState) {
            List<ReusableExecution<?>> reusableExecutions;
            if (this.globalState.reusableExecutions == null) {
                this.globalState.reusableExecutions = new HashMap();
            }
            if ((reusableExecutions = this.globalState.reusableExecutions.get(key)) == null) {
                reusableExecutions = new LinkedList();
                this.globalState.reusableExecutions.put(key, reusableExecutions);
            }
            reusableExecutions.add(execution);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        GlobalState globalState = this.globalState;
        synchronized (globalState) {
            if (this.globalState.reservedBuffers > 0L) {
                long toRelease = this.globalState.reservedBuffers;
                this.globalState.reservedBuffers = 0L;
                this.globalState.bufferManager.releaseOrphanedBuffers(toRelease);
            }
            if (this.globalState.reusableExecutions != null) {
                for (List<ReusableExecution<?>> reusableExecutions : this.globalState.reusableExecutions.values()) {
                    for (ReusableExecution<?> reusableExecution : reusableExecutions) {
                        try {
                            reusableExecution.dispose();
                        }
                        catch (Exception e) {
                            LogManager.logWarning("org.teiid.PROCESSOR", e, QueryPlugin.Util.gs(QueryPlugin.Event.TEIID30030, new Object[0]));
                        }
                    }
                }
                this.globalState.reusableExecutions.clear();
            }
            if (this.globalState.commandListeners != null) {
                for (CommandListener listener : this.globalState.commandListeners) {
                    try {
                        listener.commandClosed(this);
                    }
                    catch (Exception e) {
                        LogManager.logWarning("org.teiid.PROCESSOR", e, QueryPlugin.Util.gs(QueryPlugin.Event.TEIID30031, new Object[0]));
                    }
                }
                this.globalState.commandListeners.clear();
            }
            if (this.globalState.lookups != null) {
                for (TupleSource ts : this.globalState.lookups.values()) {
                    ts.closeSource();
                }
                this.globalState.lookups = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(CommandListener listener) {
        if (listener != null) {
            GlobalState globalState = this.globalState;
            synchronized (globalState) {
                if (this.globalState.commandListeners == null) {
                    this.globalState.commandListeners = Collections.newSetFromMap(new IdentityHashMap());
                }
                this.globalState.commandListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(CommandListener listener) {
        if (listener != null) {
            GlobalState globalState = this.globalState;
            synchronized (globalState) {
                if (this.globalState.commandListeners != null) {
                    this.globalState.commandListeners.remove(listener);
                }
            }
        }
    }

    public static DecimalFormat getDecimalFormat(CommandContext context, String format) {
        DecimalFormat result = null;
        if (context != null) {
            if (context.globalState.decimalFormatCache == null) {
                context.globalState.decimalFormatCache = new LRUCache(32);
            } else {
                result = (DecimalFormat)context.globalState.decimalFormatCache.get(format);
            }
        }
        if (result == null) {
            result = new DecimalFormat(format);
            result.setParseBigDecimal(true);
            if (context != null) {
                context.globalState.decimalFormatCache.put(format, result);
            }
        }
        return result;
    }

    public static SimpleDateFormat getDateFormat(CommandContext context, String format) {
        SimpleDateFormat result = null;
        if (context != null) {
            if (context.globalState.dateFormatCache == null) {
                context.globalState.dateFormatCache = new LRUCache(32);
            } else {
                result = (SimpleDateFormat)context.globalState.dateFormatCache.get(format);
            }
        }
        if (result == null) {
            result = new SimpleDateFormat(format);
            if (context != null) {
                context.globalState.dateFormatCache.put(format, result);
            }
        }
        return result;
    }

    public void incrementReuseCount() {
        this.globalState.reuseCount.getAndIncrement();
    }

    @Override
    public long getReuseCount() {
        if (this.globalState.reuseCount == null) {
            return 0L;
        }
        return this.globalState.reuseCount.get();
    }

    @Override
    public boolean isContinuous() {
        return this.globalState.reuseCount != null;
    }

    public void setContinuous() {
        this.globalState.reuseCount = new AtomicLong();
    }

    @Override
    public ClassLoader getVDBClassLoader() {
        return this.vdbState.classLoader;
    }

    public void setVDBClassLoader(ClassLoader classLoader) {
        this.vdbState.classLoader = classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Exception> getAndClearWarnings() {
        if (this.globalState.warnings == null) {
            return null;
        }
        GlobalState globalState = this.globalState;
        synchronized (globalState) {
            List copied = this.globalState.warnings;
            this.globalState.warnings = null;
            return copied;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addWarning(Exception warning) {
        if (warning == null) {
            return;
        }
        GlobalState globalState = this.globalState;
        synchronized (globalState) {
            if (this.globalState.warnings == null) {
                this.globalState.warnings = new ArrayList(1);
            }
            this.globalState.warnings.add(warning);
        }
        if (!this.getOptions().isSanitizeMessages() || LogManager.isMessageToBeRecorded("org.teiid.PROCESSOR", 5)) {
            LogManager.logInfo("org.teiid.PROCESSOR", QueryPlugin.Util.gs(QueryPlugin.Event.TEIID31105, warning.getMessage()));
        }
    }

    public TupleSourceCache getTupleSourceCache() {
        return this.tupleSourceCache;
    }

    public void setTupleSourceCache(TupleSourceCache tupleSourceCache) {
        this.tupleSourceCache = tupleSourceCache;
    }

    public Options getOptions() {
        if (this.globalState.options == null) {
            this.globalState.options = new Options();
        }
        return this.globalState.options;
    }

    public void setOptions(Options options) {
        this.globalState.options = options;
    }

    @Override
    public boolean isReturnAutoGeneratedKeys() {
        return this.globalState.returnAutoGeneratedKeys;
    }

    public void setReturnAutoGeneratedKeys(boolean b) {
        this.globalState.returnAutoGeneratedKeys = b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GeneratedKeysImpl returnGeneratedKeys(String[] columnNames, Class<?>[] columnDataTypes) {
        GlobalState globalState = this.globalState;
        synchronized (globalState) {
            this.globalState.generatedKeys = new GeneratedKeysImpl(columnNames, columnDataTypes);
            return this.globalState.generatedKeys;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GeneratedKeysImpl getGeneratedKeys() {
        GlobalState globalState = this.globalState;
        synchronized (globalState) {
            return this.globalState.generatedKeys;
        }
    }

    public static CommandContext getThreadLocalContext() {
        return threadLocalContext.get().peek();
    }

    public static void pushThreadLocalContext(CommandContext context) {
        threadLocalContext.get().push(context);
    }

    public static void popThreadLocalContext() {
        threadLocalContext.get().poll();
    }

    public long addAndGetReservedBuffers(int i) {
        return this.globalState.reservedBuffers += i;
    }

    @Override
    public Object setSessionVariable(String key, Object value) {
        return this.vdbState.session.getSessionVariables().put(key, value);
    }

    @Override
    public Object getSessionVariable(String key) {
        return this.vdbState.session.getSessionVariables().get(key);
    }

    public AuthorizationValidator getAuthorizationValidator() {
        return this.globalState.authorizationValidator;
    }

    public TupleSource getCodeLookup(String matTableName, Object keyValue) {
        if (this.globalState.lookups != null) {
            return (TupleSource)this.globalState.lookups.remove(new LookupKey(matTableName, keyValue));
        }
        return null;
    }

    public void putCodeLookup(String matTableName, Object keyValue, TupleSource ts) {
        if (this.globalState.lookups == null) {
            this.globalState.lookups = new TreeMap();
        }
        this.globalState.lookups.put(new LookupKey(matTableName, keyValue), ts);
    }

    public GlobalTableStoreImpl getSessionScopedStore(boolean create) {
        GlobalTableStoreImpl impl = this.getSession().getAttachment(GlobalTableStoreImpl.class);
        if (!create) {
            return impl;
        }
        impl = this.getSession().getAttachment(GlobalTableStoreImpl.class);
        if (impl == null) {
            impl = new GlobalTableStoreImpl(this.getBufferManager(), null, this.getMetadata());
            this.getSession().addAttchment(GlobalTableStoreImpl.class, impl);
        }
        return impl;
    }

    public static GlobalTableStoreImpl removeSessionScopedStore(SessionMetadata session) {
        return session.removeAttachment(GlobalTableStoreImpl.class);
    }

    @Override
    public TeiidConnection getConnection() throws TeiidSQLException {
        ServerConnection sc;
        EmbeddedProfile ep = this.getDQPWorkContext().getConnectionProfile();
        Properties info = new Properties();
        info.put(EmbeddedProfile.DQP_WORK_CONTEXT, this.getDQPWorkContext());
        String url = "jdbc:teiid:" + this.getVdbName() + "." + this.getVdbVersion();
        try {
            sc = ep.createServerConnection(info);
        }
        catch (TeiidException e) {
            throw TeiidSQLException.create(e);
        }
        return new ConnectionImpl(sc, info, url){

            @Override
            public void close() throws SQLException {
            }

            @Override
            public void rollback() throws SQLException {
            }

            @Override
            public void setAutoCommit(boolean autoCommit) throws SQLException {
                throw new TeiidSQLException();
            }

            @Override
            public void commit() throws SQLException {
                throw new TeiidSQLException();
            }

            @Override
            public void changeUser(String userName, String newPassword) throws SQLException {
                throw new TeiidSQLException();
            }
        };
    }

    private static class GlobalState
    implements Cloneable {
        private WeakReference<RequestWorkItem> processorID;
        private String connectionID;
        private int processorBatchSize = 256;
        private String userName;
        private Serializable commandPayload;
        private boolean collectNodeStatistics;
        private Random random = null;
        private TimeZone timezone = TimeZone.getDefault();
        private QueryProcessor.ProcessorFactory queryProcessorFactory;
        private Set<String> groups;
        private Map<String, String> aliasMapping;
        private long timeSliceEnd = Long.MAX_VALUE;
        private long timeoutEnd = Long.MAX_VALUE;
        private boolean validateXML;
        private BufferManager bufferManager;
        private SessionAwareCache<PreparedPlan> planCache;
        private boolean resultSetCacheEnabled = true;
        private int userRequestSourceConcurrency;
        private Subject subject;
        private HashSet<Object> dataObjects;
        private RequestID requestId;
        private TransactionContext transactionContext;
        private TransactionService transactionService;
        private Executor executor = ExecutorUtils.getDirectExecutor();
        Map<Object, List<ReusableExecution<?>>> reusableExecutions;
        Set<CommandListener> commandListeners = null;
        private LRUCache<String, DecimalFormat> decimalFormatCache;
        private LRUCache<String, SimpleDateFormat> dateFormatCache;
        private AtomicLong reuseCount = null;
        private List<Exception> warnings = null;
        private Options options = null;
        private boolean returnAutoGeneratedKeys;
        private GeneratedKeysImpl generatedKeys;
        private long reservedBuffers;
        private AuthorizationValidator authorizationValidator;
        private Map<LookupKey, TupleSource> lookups;
        private TempTableStore sessionTempTableStore;

        private GlobalState() {
        }
    }

    private static class LookupKey
    implements Comparable<LookupKey> {
        String matTableName;
        Comparable keyValue;

        public LookupKey(String matTableName, Object keyValue) {
            this.matTableName = matTableName;
            this.keyValue = (Comparable)keyValue;
        }

        @Override
        public int compareTo(LookupKey arg0) {
            int comp = this.matTableName.compareTo(arg0.matTableName);
            if (comp != 0) {
                return comp;
            }
            return this.keyValue.compareTo(arg0.keyValue);
        }
    }

    private static class VDBState {
        private String vdbName = "";
        private int vdbVersion;
        private QueryMetadataInterface metadata;
        private GlobalTableStore globalTables;
        private SessionMetadata session;
        private ClassLoader classLoader;
        private DQPWorkContext dqpWorkContext;

        private VDBState() {
        }
    }
}

