/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jdbc;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Properties;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.teiid.adminapi.Model;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.adminapi.impl.SourceMappingMetadata;
import org.teiid.jdbc.ConnectionImpl;
import org.teiid.jdbc.TeiidDriver;
import org.teiid.jdbc.TeiidPreparedStatement;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.From;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.Select;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.runtime.EmbeddedConfiguration;
import org.teiid.runtime.EmbeddedConnection;
import org.teiid.runtime.EmbeddedRequestOptions;
import org.teiid.runtime.EmbeddedServer;
import org.teiid.translator.ExecutionFactory;
import org.teiid.translator.loopback.LoopbackExecutionFactory;

public class TestASTQueries {
    private static EmbeddedServer server;

    @BeforeClass
    public static void setUp() throws Exception {
        server = new EmbeddedServer();
        server.start(new EmbeddedConfiguration());
        LoopbackExecutionFactory loopy = new LoopbackExecutionFactory();
        loopy.setRowCount(10);
        loopy.start();
        server.addTranslator("l", (ExecutionFactory)loopy);
        String DDL = "CREATE FOREIGN TABLE G1 (e1 string, e2 integer);";
        ModelMetaData model = new ModelMetaData();
        model.setName("PM1");
        model.setModelType(Model.Type.PHYSICAL);
        model.setSchemaSourceType("DDL");
        model.setSchemaText(DDL);
        SourceMappingMetadata sm = new SourceMappingMetadata();
        sm.setName("loopy");
        sm.setTranslatorName("l");
        model.addSourceMapping(sm);
        server.deployVDB("test", new ModelMetaData[]{model});
    }

    @AfterClass
    public static void tearDown() throws Exception {
        server.stop();
    }

    @Test
    public void testAST() throws Exception {
        TeiidDriver td = server.getDriver();
        ConnectionImpl c = td.connect("jdbc:teiid:test", new Properties());
        EmbeddedConnection ec = c.unwrap(EmbeddedConnection.class);
        TeiidPreparedStatement tps = ec.prepareStatement((Command)this.sampleQuery(), new EmbeddedRequestOptions());
        ResultSet rs = tps.executeQuery();
        Assert.assertNotNull((Object)rs);
        int count = 0;
        while (rs.next()) {
            ++count;
        }
        Assert.assertEquals((long)10L, (long)count);
        rs.close();
    }

    private Query sampleQuery() {
        ArrayList<ElementSymbol> symbols = new ArrayList<ElementSymbol>();
        symbols.add(new ElementSymbol("e1"));
        symbols.add(new ElementSymbol("e2"));
        Select select = new Select(symbols);
        From from = new From();
        from.addGroup(new GroupSymbol("G1"));
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        return query;
    }
}

