/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.junit.Before;
import org.junit.Test;
import org.teiid.adminapi.impl.DataPolicyMetadata;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryPlannerException;
import org.teiid.api.exception.query.QueryProcessingException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.dqp.internal.process.DQPWorkContext;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.optimizer.TestOptimizer;
import org.teiid.query.optimizer.capabilities.BasicSourceCapabilities;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.DefaultCapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.SourceCapabilities;
import org.teiid.query.processor.HardcodedDataManager;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.processor.TestProcessor;
import org.teiid.query.unittest.RealMetadataFactory;
import org.teiid.query.util.CommandContext;

public class TestRowBasedSecurity {
    CommandContext context;
    private static DataPolicyMetadata.PermissionMetaData pmd;

    @Before
    public void setup() {
        this.context = TestRowBasedSecurity.createContext();
    }

    private static CommandContext createContext() {
        CommandContext context = TestProcessor.createCommandContext();
        DQPWorkContext workContext = new DQPWorkContext();
        HashMap<String, DataPolicyMetadata> policies = new HashMap<String, DataPolicyMetadata>();
        DataPolicyMetadata policy = new DataPolicyMetadata();
        pmd = new DataPolicyMetadata.PermissionMetaData();
        pmd.setResourceName("pm1.g1");
        pmd.setCondition("e1 = user()");
        DataPolicyMetadata.PermissionMetaData pmd1 = new DataPolicyMetadata.PermissionMetaData();
        pmd1.setResourceName("pm1.g2");
        pmd1.setCondition("foo = bar");
        DataPolicyMetadata.PermissionMetaData pmd2 = new DataPolicyMetadata.PermissionMetaData();
        pmd2.setResourceName("pm1.g4");
        pmd2.setCondition("e1 = max(e2)");
        DataPolicyMetadata.PermissionMetaData pmd3 = new DataPolicyMetadata.PermissionMetaData();
        pmd3.setResourceName("pm1.g3");
        pmd3.setAllowDelete(Boolean.valueOf(true));
        DataPolicyMetadata.PermissionMetaData pmd4 = new DataPolicyMetadata.PermissionMetaData();
        pmd4.setResourceName("pm1.sp1");
        pmd4.setCondition("e1 = 'a'");
        policy.addPermission(new DataPolicyMetadata.PermissionMetaData[]{pmd, pmd1, pmd2, pmd3, pmd4});
        policy.setName("some-role");
        policies.put("some-role", policy);
        workContext.setPolicies(policies);
        context.setDQPWorkContext(workContext);
        return context;
    }

    @Test
    public void testSelectFilter() throws Exception {
        HardcodedDataManager dataManager = new HardcodedDataManager();
        dataManager.addData("SELECT pm1.g1.e1, pm1.g1.e2 FROM pm1.g1", Arrays.asList("a", 1), Arrays.asList("b", 2));
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestProcessor.helpParse("select e2 from pm1.g1"), (QueryMetadataInterface)RealMetadataFactory.example1Cached(), (CapabilitiesFinder)new DefaultCapabilitiesFinder(), this.context);
        List[] expectedResults = new List[]{};
        TestProcessor.helpProcess(plan, this.context, dataManager, expectedResults);
    }

    @Test
    public void testSelectFilterOuterJoin() throws Exception {
        HardcodedDataManager dataManager = new HardcodedDataManager();
        dataManager.addData("SELECT pm1.g1.e1, pm1.g1.e2 FROM pm1.g1", Arrays.asList("a", 1), Arrays.asList("b", 2));
        dataManager.addData("SELECT pm1.g3.e1 FROM pm1.g3", Arrays.asList("a", 1), Arrays.asList("b", 2));
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_OUTER, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_OUTER_FULL, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_INLINE_VIEWS, true);
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestProcessor.helpParse("SELECT pm1.g1.e1, pm1.g1.e2 FROM pm1.g1 full outer join pm1.g3 on (pm1.g1.e1=pm1.g3.e1)"), (QueryMetadataInterface)RealMetadataFactory.example1Cached(), (CapabilitiesFinder)new DefaultCapabilitiesFinder((SourceCapabilities)caps), this.context);
        TestOptimizer.checkAtomicQueries(new String[]{"SELECT v_0.c_0, v_0.c_1 FROM (SELECT g_0.e1 AS c_0, g_0.e2 AS c_1 FROM pm1.g1 AS g_0 WHERE g_0.e1 = 'user') AS v_0 FULL OUTER JOIN pm1.g3 AS g_1 ON v_0.c_0 = g_1.e1"}, plan);
    }

    @Test
    public void testTransitiveFilter() throws Exception {
        HardcodedDataManager dataManager = new HardcodedDataManager();
        dataManager.addData("SELECT pm1.g1.e1, pm1.g1.e2 FROM pm1.g1", Arrays.asList("a", 1), Arrays.asList("b", 2));
        dataManager.addData("exec pm1.sq1()", Arrays.asList("a", 1), Arrays.asList("b", 2));
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestProcessor.helpParse("exec pm1.sq1()"), (QueryMetadataInterface)RealMetadataFactory.example1Cached(), (CapabilitiesFinder)new DefaultCapabilitiesFinder(), this.context);
        List[] expectedResults = new List[]{};
        TestProcessor.helpProcess(plan, this.context, dataManager, expectedResults);
    }

    @Test
    public void testProcedureFilter() throws Exception {
        HardcodedDataManager dataManager = new HardcodedDataManager();
        dataManager.addData("EXEC pm1.sp1()", Arrays.asList("a", 1), Arrays.asList("b", 2));
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestProcessor.helpParse("exec pm1.sp1()"), (QueryMetadataInterface)RealMetadataFactory.example1Cached(), (CapabilitiesFinder)new DefaultCapabilitiesFinder(), this.context);
        List[] expectedResults = new List[]{Arrays.asList("a", 1)};
        TestProcessor.helpProcess(plan, this.context, dataManager, expectedResults);
    }

    @Test
    public void testProcedureRelationalFilter() throws Exception {
        HardcodedDataManager dataManager = new HardcodedDataManager();
        dataManager.addData("EXEC pm1.sp1()", Arrays.asList("a", 1), Arrays.asList("b", 2));
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestProcessor.helpParse("select * from pm1.sp1"), (QueryMetadataInterface)RealMetadataFactory.example1Cached(), (CapabilitiesFinder)new DefaultCapabilitiesFinder(), this.context);
        List[] expectedResults = new List[]{Arrays.asList("a", 1)};
        TestProcessor.helpProcess(plan, this.context, dataManager, expectedResults);
    }

    @Test
    public void testDeleteFilter() throws Exception {
        HardcodedDataManager dataManager = new HardcodedDataManager();
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestProcessor.helpParse("delete from pm1.g1 where e1 = 'a'"), (QueryMetadataInterface)RealMetadataFactory.example1Cached(), TestOptimizer.getGenericFinder(), this.context);
        List[] expectedResults = new List[]{Arrays.asList(0)};
        TestProcessor.helpProcess(plan, this.context, dataManager, expectedResults);
    }

    @Test
    public void testInsertDisabledConstraint() throws Exception {
        pmd.setConstraint(Boolean.valueOf(false));
        HardcodedDataManager dataManager = new HardcodedDataManager();
        dataManager.addData("INSERT INTO pm1.g1 (e1) VALUES ('a')", Arrays.asList(1));
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestProcessor.helpParse("insert into pm1.g1 (e1) values ('a')"), (QueryMetadataInterface)RealMetadataFactory.example1Cached(), TestOptimizer.getGenericFinder(), this.context);
        List[] expectedResults = new List[]{Arrays.asList(1)};
        TestProcessor.helpProcess(plan, this.context, dataManager, expectedResults);
    }

    @Test(expected=QueryPlannerException.class)
    public void testInsertConstraint() throws Exception {
        HardcodedDataManager dataManager = new HardcodedDataManager();
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestProcessor.helpParse("insert into pm1.g1 (e1) values ('a')"), (QueryMetadataInterface)RealMetadataFactory.example1Cached(), TestOptimizer.getGenericFinder(), this.context);
        TestProcessor.helpProcess(plan, this.context, dataManager, null);
    }

    @Test(expected=QueryPlannerException.class)
    public void testInsertConstraint1() throws Exception {
        HardcodedDataManager dataManager = new HardcodedDataManager();
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestProcessor.helpParse("insert into pm1.g1 (e2) values (1)"), (QueryMetadataInterface)RealMetadataFactory.example1Cached(), TestOptimizer.getGenericFinder(), this.context);
        TestProcessor.helpProcess(plan, this.context, dataManager, null);
    }

    @Test(expected=TeiidProcessingException.class)
    public void testInsertConstraintCorrelatedSubquery() throws Exception {
        DataPolicyMetadata policy1 = new DataPolicyMetadata();
        DataPolicyMetadata.PermissionMetaData pmd3 = new DataPolicyMetadata.PermissionMetaData();
        pmd3.setResourceName("pm1.g1");
        pmd3.setCondition("e1 = (select min(e1) from pm1.g3 where pm1.g1.e2 = e2)");
        policy1.addPermission(new DataPolicyMetadata.PermissionMetaData[]{pmd3});
        policy1.setName("some-other-role");
        this.context.getAllowedDataPolicies().put("some-other-role", policy1);
        HardcodedDataManager dataManager = new HardcodedDataManager();
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestProcessor.helpParse("insert into pm1.g1 (e1, e2) values ('a', 1)"), (QueryMetadataInterface)RealMetadataFactory.example1Cached(), TestOptimizer.getGenericFinder(), this.context);
        List[] expectedResults = new List[]{Arrays.asList(0)};
        TestProcessor.helpProcess(plan, this.context, dataManager, expectedResults);
    }

    @Test
    public void testInsertConstraintSubquery() throws Exception {
        DataPolicyMetadata policy1 = new DataPolicyMetadata();
        DataPolicyMetadata.PermissionMetaData pmd3 = new DataPolicyMetadata.PermissionMetaData();
        pmd3.setResourceName("pm1.g1");
        pmd3.setCondition("e1 = (select min(e1) from pm1.g3)");
        policy1.addPermission(new DataPolicyMetadata.PermissionMetaData[]{pmd3});
        policy1.setName("some-other-role");
        this.context.getAllowedDataPolicies().put("some-other-role", policy1);
        HardcodedDataManager dataManager = new HardcodedDataManager();
        dataManager.addData("SELECT g_0.e1 FROM pm1.g3 AS g_0", Arrays.asList("a"), Arrays.asList("b"));
        dataManager.addData("INSERT INTO pm1.g1 (e1, e2) VALUES ('a', 1)", Arrays.asList(1));
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestProcessor.helpParse("insert into pm1.g1 (e1, e2) values ('a', 1)"), (QueryMetadataInterface)RealMetadataFactory.example1Cached(), TestOptimizer.getGenericFinder(), this.context);
        List[] expectedResults = new List[]{Arrays.asList(1)};
        TestProcessor.helpProcess(plan, this.context, dataManager, expectedResults);
    }

    @Test(expected=QueryProcessingException.class)
    public void testInsertConstraintWithQueryExpression() throws Exception {
        HardcodedDataManager dataManager = new HardcodedDataManager();
        dataManager.addData("SELECT pm1.g3.e1 FROM pm1.g3", Arrays.asList("a"), Arrays.asList("b"));
        BasicSourceCapabilities bsc = new BasicSourceCapabilities();
        bsc.setCapabilitySupport(SourceCapabilities.Capability.INSERT_WITH_QUERYEXPRESSION, true);
        DefaultCapabilitiesFinder capFinder = new DefaultCapabilitiesFinder((SourceCapabilities)bsc);
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestProcessor.helpParse("insert into pm1.g1 (e1) select e1 from pm1.g3"), (QueryMetadataInterface)RealMetadataFactory.example1Cached(), (CapabilitiesFinder)capFinder, this.context);
        List[] expectedResults = new List[]{Arrays.asList(0)};
        TestProcessor.helpProcess(plan, this.context, dataManager, expectedResults);
    }

    @Test
    public void testInsertConstraintWithQueryExpression1() throws Exception {
        HardcodedDataManager dataManager = new HardcodedDataManager();
        dataManager.addData("SELECT pm1.g3.e1 FROM pm1.g3", Arrays.asList("a"));
        dataManager.addData("INSERT INTO pm1.g1 (e1) VALUES ('user')", Arrays.asList(1));
        BasicSourceCapabilities bsc = new BasicSourceCapabilities();
        bsc.setCapabilitySupport(SourceCapabilities.Capability.INSERT_WITH_QUERYEXPRESSION, true);
        DefaultCapabilitiesFinder capFinder = new DefaultCapabilitiesFinder((SourceCapabilities)bsc);
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestProcessor.helpParse("insert into pm1.g1 (e1) select user() from pm1.g3"), (QueryMetadataInterface)RealMetadataFactory.example1Cached(), (CapabilitiesFinder)capFinder, this.context);
        List[] expectedResults = new List[]{Arrays.asList(1)};
        TestProcessor.helpProcess(plan, this.context, dataManager, expectedResults);
    }

    @Test
    public void testInsertFilter1() throws Exception {
        HardcodedDataManager dataManager = new HardcodedDataManager();
        dataManager.addData("INSERT INTO pm1.g1 (e1) VALUES ('user')", Arrays.asList(1));
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestProcessor.helpParse("insert into pm1.g1 (e1) values ('user')"), (QueryMetadataInterface)RealMetadataFactory.example1Cached(), TestOptimizer.getGenericFinder(), this.context);
        List[] expectedResults = new List[]{Arrays.asList(1)};
        TestProcessor.helpProcess(plan, this.context, dataManager, expectedResults);
    }

    @Test(expected=QueryPlannerException.class)
    public void testUpdateFilter() throws Exception {
        HardcodedDataManager dataManager = new HardcodedDataManager();
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestProcessor.helpParse("update pm1.g1 set e1 = 'a' where e2 = 5"), (QueryMetadataInterface)RealMetadataFactory.example1Cached(), TestOptimizer.getGenericFinder(), this.context);
        List[] expectedResults = new List[]{Arrays.asList(0)};
        TestProcessor.helpProcess(plan, this.context, dataManager, expectedResults);
    }

    @Test(expected=QueryPlannerException.class)
    public void testUpdateFilter1() throws Exception {
        HardcodedDataManager dataManager = new HardcodedDataManager();
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestProcessor.helpParse("update pm1.g1 set e1 = e3 where e2 = 5"), (QueryMetadataInterface)RealMetadataFactory.example1Cached(), TestOptimizer.getGenericFinder(), this.context);
        List[] expectedResults = new List[]{Arrays.asList(0)};
        TestProcessor.helpProcess(plan, this.context, dataManager, expectedResults);
    }

    @Test(expected=QueryProcessingException.class)
    public void testUpdateFilter2() throws Exception {
        HardcodedDataManager dataManager = new HardcodedDataManager();
        dataManager.addData("SELECT g_0.e3, g_0.e1 FROM pm1.g1 AS g_0 WHERE (g_0.e1 = 'user') AND (g_0.e2 = 5)", Arrays.asList(Boolean.TRUE, "user"));
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestProcessor.helpParse("update pm1.g1 set e1 = e3 || 'r' where e2 = 5"), (QueryMetadataInterface)RealMetadataFactory.example4(), TestOptimizer.getGenericFinder(), this.context);
        List[] expectedResults = new List[]{Arrays.asList(0)};
        TestProcessor.helpProcess(plan, this.context, dataManager, expectedResults);
    }

    @Test
    public void testUpdateFilter3() throws Exception {
        HardcodedDataManager dataManager = new HardcodedDataManager();
        dataManager.addData("UPDATE pm1.g1 SET e2 = 1 WHERE (e2 = 5) AND (e1 = 'user')", Arrays.asList(1));
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestProcessor.helpParse("update pm1.g1 set e2 = 1 where e2 = 5"), (QueryMetadataInterface)RealMetadataFactory.example4(), TestOptimizer.getGenericFinder(), this.context);
        List[] expectedResults = new List[]{Arrays.asList(1)};
        TestProcessor.helpProcess(plan, this.context, dataManager, expectedResults);
    }

    @Test
    public void testUpdateFilter4() throws Exception {
        DataPolicyMetadata policy1 = new DataPolicyMetadata();
        DataPolicyMetadata.PermissionMetaData pmd3 = new DataPolicyMetadata.PermissionMetaData();
        pmd3.setResourceName("pm1.g1");
        pmd3.setCondition("e2 = 1 and e3");
        policy1.addPermission(new DataPolicyMetadata.PermissionMetaData[]{pmd3});
        policy1.setName("some-role");
        this.context.getAllowedDataPolicies().put("some-role", policy1);
        HardcodedDataManager dataManager = new HardcodedDataManager();
        dataManager.addData("SELECT g_0.e4, g_0.e3, g_0.e1 FROM pm1.g1 AS g_0 WHERE (g_0.e3 = TRUE) AND (g_0.e2 = 1) AND (g_0.e1 IN ('a', 'b'))", Arrays.asList(1.0, Boolean.TRUE, "a"), Arrays.asList(1.0, Boolean.TRUE, "b"));
        dataManager.addData("UPDATE pm1.g1 SET e2 = 1 WHERE pm1.g1.e1 = 'a'", Arrays.asList(1));
        dataManager.addData("UPDATE pm1.g1 SET e2 = 1 WHERE pm1.g1.e1 = 'b'", Arrays.asList(1));
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestProcessor.helpParse("update pm1.g1 set e2 = case when e4 = 1 then 1 else 2 end where e1 in ('a', 'b')"), (QueryMetadataInterface)RealMetadataFactory.example4(), TestOptimizer.getGenericFinder(), this.context);
        List[] expectedResults = new List[]{Arrays.asList(2)};
        TestProcessor.helpProcess(plan, this.context, dataManager, expectedResults);
    }

    @Test(expected=QueryMetadataException.class)
    public void testBadFilter() throws Exception {
        HardcodedDataManager dataManager = new HardcodedDataManager();
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestProcessor.helpParse("select e2 from pm1.g2"), (QueryMetadataInterface)RealMetadataFactory.example1Cached(), (CapabilitiesFinder)new DefaultCapabilitiesFinder(), this.context);
        List[] expectedResults = new List[]{};
        TestProcessor.helpProcess(plan, this.context, dataManager, expectedResults);
    }

    @Test(expected=QueryMetadataException.class)
    public void testBadFilter1() throws Exception {
        HardcodedDataManager dataManager = new HardcodedDataManager();
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestProcessor.helpParse("select * from pm1.g4"), (QueryMetadataInterface)RealMetadataFactory.example1Cached(), (CapabilitiesFinder)new DefaultCapabilitiesFinder(), this.context);
        List[] expectedResults = new List[]{};
        TestProcessor.helpProcess(plan, this.context, dataManager, expectedResults);
    }

    @Test
    public void testMultipleRoles() throws Exception {
        HardcodedDataManager dataManager = new HardcodedDataManager();
        dataManager.addData("SELECT pm1.g1.e1, pm1.g1.e2 FROM pm1.g1", Arrays.asList("a", 1), Arrays.asList("b", 2));
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestProcessor.helpParse("select e2 from pm1.g1"), (QueryMetadataInterface)RealMetadataFactory.example1Cached(), (CapabilitiesFinder)new DefaultCapabilitiesFinder(), this.context);
        TestProcessor.helpProcess(plan, this.context, dataManager, new List[0]);
        DataPolicyMetadata policy1 = new DataPolicyMetadata();
        DataPolicyMetadata.PermissionMetaData pmd3 = new DataPolicyMetadata.PermissionMetaData();
        pmd3.setResourceName("pm1.g1");
        pmd3.setCondition("true");
        policy1.addPermission(new DataPolicyMetadata.PermissionMetaData[]{pmd3});
        policy1.setName("some-other-role");
        this.context.getAllowedDataPolicies().put("some-other-role", policy1);
        dataManager = new HardcodedDataManager();
        dataManager.addData("SELECT pm1.g1.e2 FROM pm1.g1", Arrays.asList(1), Arrays.asList(2));
        plan = TestProcessor.helpGetPlan(TestProcessor.helpParse("select e2 from pm1.g1"), (QueryMetadataInterface)RealMetadataFactory.example1Cached(), (CapabilitiesFinder)new DefaultCapabilitiesFinder(), this.context);
        List[] expectedResults = new List[]{Arrays.asList(1), Arrays.asList(2)};
        TestProcessor.helpProcess(plan, this.context, dataManager, expectedResults);
    }
}

