/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.language;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.teiid.language.AndOr;
import org.teiid.language.Condition;
import org.teiid.language.LanguageFactory;

public final class LanguageUtil {
    private LanguageUtil() {
    }

    public static final List<Condition> separateCriteriaByAnd(Condition criteria) {
        if (criteria == null) {
            return Collections.emptyList();
        }
        ArrayList<Condition> parts = new ArrayList<Condition>();
        LanguageUtil.separateCriteria(criteria, parts);
        return parts;
    }

    private static void separateCriteria(Condition crit, List<Condition> parts) {
        if (crit instanceof AndOr) {
            AndOr compCrit = (AndOr)crit;
            if (compCrit.getOperator() == AndOr.Operator.AND) {
                LanguageUtil.separateCriteria(compCrit.getLeftCondition(), parts);
                LanguageUtil.separateCriteria(compCrit.getRightCondition(), parts);
            } else {
                parts.add(crit);
            }
        } else {
            parts.add(crit);
        }
    }

    public static Condition combineCriteria(Condition primaryCrit, Condition additionalCrit, LanguageFactory languageFactory) {
        if (primaryCrit == null) {
            return additionalCrit;
        }
        if (additionalCrit == null) {
            return primaryCrit;
        }
        return languageFactory.createAndOr(AndOr.Operator.AND, primaryCrit, additionalCrit);
    }

    public static Condition combineCriteria(List<Condition> crits) {
        if (crits == null || crits.isEmpty()) {
            return null;
        }
        if (crits.size() == 1) {
            return crits.get(0);
        }
        Condition result = null;
        for (Condition crit : crits) {
            if (result == null) {
                result = crit;
                continue;
            }
            result = new AndOr(result, crit, AndOr.Operator.AND);
        }
        return result;
    }
}

