/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.netty.handler.codec.serialization;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.teiid.client.DQP;
import org.teiid.client.RequestMessage;
import org.teiid.client.ResultsMessage;
import org.teiid.client.lob.LobChunk;
import org.teiid.client.metadata.MetadataResult;
import org.teiid.client.metadata.ParameterInfo;
import org.teiid.client.plan.Annotation;
import org.teiid.client.plan.PlanNode;
import org.teiid.client.security.ILogon;
import org.teiid.client.security.InvalidSessionException;
import org.teiid.client.security.LogonException;
import org.teiid.client.security.LogonResult;
import org.teiid.client.security.SessionToken;
import org.teiid.client.security.TeiidSecurityException;
import org.teiid.client.util.ExceptionHolder;
import org.teiid.client.xa.XATransactionException;
import org.teiid.client.xa.XidImpl;
import org.teiid.core.BundleUtil;
import org.teiid.core.ComponentNotFoundException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.types.BaseLob;
import org.teiid.core.types.BlobImpl;
import org.teiid.core.types.BlobType;
import org.teiid.core.types.ClobImpl;
import org.teiid.core.types.ClobType;
import org.teiid.core.types.InputStreamFactory;
import org.teiid.core.types.SQLXMLImpl;
import org.teiid.core.types.XMLType;
import org.teiid.core.util.ReaderInputStream;
import org.teiid.jdbc.JDBCPlugin;
import org.teiid.net.socket.Handshake;
import org.teiid.net.socket.Message;
import org.teiid.net.socket.ServiceInvocationStruct;

public class CompactObjectOutputStream
extends ObjectOutputStream {
    static final int TYPE_PRIMITIVE = 0;
    static final int TYPE_NON_PRIMITIVE = 1;
    public static final Map<Class<?>, Integer> KNOWN_CLASSES = new HashMap();
    public static final Map<Integer, Class<?>> KNOWN_CODES = new HashMap();
    private List<InputStream> streams = new LinkedList<InputStream>();
    private List<InputStreamFactory.StreamFactoryReference> references = new LinkedList<InputStreamFactory.StreamFactoryReference>();

    public static void addKnownClass(Class<?> clazz, byte code) {
        KNOWN_CLASSES.put(clazz, Integer.valueOf(code));
        if (KNOWN_CODES.put(Integer.valueOf(code), clazz) != null) {
            throw new TeiidRuntimeException((BundleUtil.Event)JDBCPlugin.Event.TEIID20007, JDBCPlugin.Util.gs(JDBCPlugin.Event.TEIID20007, new Object[0]));
        }
    }

    public CompactObjectOutputStream(OutputStream out) throws IOException {
        super(out);
        this.enableReplaceObject(true);
    }

    public List<InputStream> getStreams() {
        return this.streams;
    }

    @Override
    public void reset() throws IOException {
        super.reset();
        this.streams.clear();
        this.references.clear();
    }

    public List<InputStreamFactory.StreamFactoryReference> getReferences() {
        return this.references;
    }

    @Override
    protected void writeStreamHeader() throws IOException {
        this.writeByte(5);
    }

    @Override
    protected void writeClassDescriptor(ObjectStreamClass desc) throws IOException {
        if (desc.forClass().isPrimitive() || !Externalizable.class.isAssignableFrom(desc.forClass())) {
            this.write(0);
            super.writeClassDescriptor(desc);
        } else {
            Integer b = KNOWN_CLASSES.get(desc.forClass());
            if (b != null) {
                this.write(b);
            } else {
                this.write(1);
                this.writeUTF(desc.getName());
            }
        }
    }

    @Override
    protected Object replaceObject(Object obj) throws IOException {
        block14: {
            if (obj instanceof BaseLob) {
                try {
                    if (obj instanceof SQLXMLImpl) {
                        this.streams.add(((SQLXMLImpl)obj).getBinaryStream());
                        SQLXMLImpl sfr = new SQLXMLImpl();
                        this.references.add(sfr);
                        return sfr;
                    }
                    if (obj instanceof ClobImpl) {
                        this.streams.add(new ReaderInputStream(((ClobImpl)obj).getCharacterStream(), Charset.forName("UTF-8")));
                        ClobImpl sfr = new ClobImpl();
                        this.references.add(sfr);
                        return sfr;
                    }
                    if (obj instanceof BlobImpl) {
                        this.streams.add(((Blob)obj).getBinaryStream());
                        BlobImpl sfr = new BlobImpl();
                        this.references.add(sfr);
                        return sfr;
                    }
                    break block14;
                }
                catch (SQLException e) {
                    throw new IOException(e);
                }
            }
            if (obj instanceof Serializable) {
                return obj;
            }
            try {
                if (obj instanceof Reader) {
                    this.streams.add(new ReaderInputStream((Reader)obj, Charset.forName("UTF-8")));
                    SerializableReader sfr = new SerializableReader();
                    this.references.add(sfr);
                    return sfr;
                }
                if (obj instanceof InputStream) {
                    this.streams.add((InputStream)obj);
                    SerializableInputStream sfr = new SerializableInputStream();
                    this.references.add(sfr);
                    return sfr;
                }
                if (obj instanceof SQLXML) {
                    this.streams.add(((SQLXML)obj).getBinaryStream());
                    SQLXMLImpl sfr = new SQLXMLImpl();
                    this.references.add(sfr);
                    return sfr;
                }
                if (obj instanceof Clob) {
                    this.streams.add(new ReaderInputStream(((Clob)obj).getCharacterStream(), Charset.forName("UTF-8")));
                    ClobImpl sfr = new ClobImpl();
                    this.references.add(sfr);
                    return sfr;
                }
                if (obj instanceof Blob) {
                    this.streams.add(((Blob)obj).getBinaryStream());
                    BlobImpl sfr = new BlobImpl();
                    this.references.add(sfr);
                    return sfr;
                }
            }
            catch (SQLException e) {
                throw new IOException(e);
            }
        }
        return super.replaceObject(obj);
    }

    static {
        CompactObjectOutputStream.addKnownClass(ServiceInvocationStruct.class, (byte)2);
        CompactObjectOutputStream.addKnownClass(Handshake.class, (byte)3);
        CompactObjectOutputStream.addKnownClass(Message.class, (byte)4);
        CompactObjectOutputStream.addKnownClass(SerializableReader.class, (byte)5);
        CompactObjectOutputStream.addKnownClass(SerializableInputStream.class, (byte)6);
        CompactObjectOutputStream.addKnownClass(DQP.class, (byte)10);
        CompactObjectOutputStream.addKnownClass(LobChunk.class, (byte)11);
        CompactObjectOutputStream.addKnownClass(RequestMessage.class, (byte)12);
        CompactObjectOutputStream.addKnownClass(ResultsMessage.class, (byte)13);
        CompactObjectOutputStream.addKnownClass(PlanNode.class, (byte)14);
        CompactObjectOutputStream.addKnownClass(PlanNode.Property.class, (byte)15);
        CompactObjectOutputStream.addKnownClass(Annotation.class, (byte)16);
        CompactObjectOutputStream.addKnownClass(MetadataResult.class, (byte)17);
        CompactObjectOutputStream.addKnownClass(ParameterInfo.class, (byte)18);
        CompactObjectOutputStream.addKnownClass(XidImpl.class, (byte)19);
        CompactObjectOutputStream.addKnownClass(BlobImpl.class, (byte)20);
        CompactObjectOutputStream.addKnownClass(ClobImpl.class, (byte)21);
        CompactObjectOutputStream.addKnownClass(SQLXMLImpl.class, (byte)22);
        CompactObjectOutputStream.addKnownClass(BlobType.class, (byte)23);
        CompactObjectOutputStream.addKnownClass(ClobType.class, (byte)24);
        CompactObjectOutputStream.addKnownClass(XMLType.class, (byte)25);
        CompactObjectOutputStream.addKnownClass(XATransactionException.class, (byte)26);
        CompactObjectOutputStream.addKnownClass(ILogon.class, (byte)30);
        CompactObjectOutputStream.addKnownClass(LogonResult.class, (byte)31);
        CompactObjectOutputStream.addKnownClass(SessionToken.class, (byte)32);
        CompactObjectOutputStream.addKnownClass(LogonException.class, (byte)33);
        CompactObjectOutputStream.addKnownClass(TeiidSecurityException.class, (byte)34);
        CompactObjectOutputStream.addKnownClass(InvalidSessionException.class, (byte)35);
        CompactObjectOutputStream.addKnownClass(ExceptionHolder.class, (byte)40);
        CompactObjectOutputStream.addKnownClass(TeiidRuntimeException.class, (byte)41);
        CompactObjectOutputStream.addKnownClass(TeiidComponentException.class, (byte)42);
        CompactObjectOutputStream.addKnownClass(TeiidException.class, (byte)43);
        CompactObjectOutputStream.addKnownClass(TeiidProcessingException.class, (byte)44);
        CompactObjectOutputStream.addKnownClass(ComponentNotFoundException.class, (byte)45);
    }

    static class SerializableReader
    extends Reader
    implements Externalizable,
    InputStreamFactory.StreamFactoryReference {
        private InputStreamFactory isf;
        private Reader r;

        @Override
        public void setStreamFactory(InputStreamFactory streamFactory) {
            this.isf = streamFactory;
        }

        @Override
        public void close() throws IOException {
            this.isf.free();
        }

        @Override
        public int read(char[] cbuf, int off, int len) throws IOException {
            if (this.r == null) {
                this.r = new InputStreamReader(this.isf.getInputStream(), "UTF-8");
            }
            return this.r.read(cbuf, off, len);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
        }
    }

    static class SerializableInputStream
    extends InputStream
    implements Externalizable,
    InputStreamFactory.StreamFactoryReference {
        private InputStreamFactory isf;
        private InputStream is;

        @Override
        public void setStreamFactory(InputStreamFactory streamFactory) {
            this.isf = streamFactory;
        }

        @Override
        public int read() throws IOException {
            if (this.is == null) {
                this.is = this.isf.getInputStream();
            }
            return this.is.read();
        }

        @Override
        public void close() throws IOException {
            this.isf.free();
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
        }
    }
}

