/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.symbol;

import java.util.ArrayList;
import java.util.List;
import org.teiid.core.util.EquivalenceUtil;
import org.teiid.core.util.HashCodeUtil;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.visitor.SQLStringVisitor;

public class XMLNamespaces
implements LanguageObject {
    private static final long serialVersionUID = 681076404921001047L;
    private List<NamespaceItem> namespaceItems;

    public XMLNamespaces(List<NamespaceItem> namespaceItems) {
        this.namespaceItems = namespaceItems;
    }

    public List<NamespaceItem> getNamespaceItems() {
        return this.namespaceItems;
    }

    @Override
    public XMLNamespaces clone() {
        XMLNamespaces clone = new XMLNamespaces(new ArrayList<NamespaceItem>(this.namespaceItems));
        return clone;
    }

    public int hashCode() {
        return HashCodeUtil.hashCode(this.namespaceItems.hashCode(), new Object[0]);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof XMLNamespaces)) {
            return false;
        }
        XMLNamespaces other = (XMLNamespaces)obj;
        return this.namespaceItems.equals(other.namespaceItems);
    }

    @Override
    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        return SQLStringVisitor.getSQLString(this);
    }

    public static class NamespaceItem {
        private String uri;
        private String prefix;

        public NamespaceItem(String uri, String prefix) {
            this.uri = uri;
            this.prefix = prefix;
        }

        public NamespaceItem(String defaultNamepace) {
            this.uri = defaultNamepace;
        }

        public NamespaceItem() {
        }

        public String getUri() {
            return this.uri;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public int hashCode() {
            return HashCodeUtil.hashCode(0, this.uri, this.prefix);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof NamespaceItem)) {
                return false;
            }
            NamespaceItem other = (NamespaceItem)obj;
            return EquivalenceUtil.areEqual(this.uri, other.uri) && EquivalenceUtil.areEqual(this.prefix, other.prefix);
        }
    }
}

