/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.teiid.client.metadata.ResultsMetadataConstants;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.types.JDBCSQLTypeInfo;
import org.teiid.core.util.PropertiesUtils;
import org.teiid.core.util.SqlUtil;
import org.teiid.jdbc.ConnectionImpl;
import org.teiid.jdbc.JDBCPlugin;
import org.teiid.jdbc.MetadataProvider;
import org.teiid.jdbc.PreparedStatementImpl;
import org.teiid.jdbc.ResultSetImpl;
import org.teiid.jdbc.ResultSetMetaDataImpl;
import org.teiid.jdbc.StatementImpl;
import org.teiid.jdbc.TeiidDriver;
import org.teiid.jdbc.TeiidSQLException;
import org.teiid.jdbc.WrapperImpl;

public class DatabaseMetaDataImpl
extends WrapperImpl
implements DatabaseMetaData {
    public static final String REPORT_AS_VIEWS = "reportAsViews";
    private static final String IS_NULLABLE = "CASE NullType WHEN 'Nullable' THEN 'YES' WHEN 'No Nulls' THEN 'NO' ELSE '' END AS IS_NULLABLE";
    private static final String DATA_TYPES = "DataTypes";
    private static Logger logger = Logger.getLogger("org.teiid.jdbc");
    private static final String PERCENT = "%";
    private static final int NO_LIMIT = 0;
    private static final String SCHEMA_TERM = "Schema";
    private static final String EMPTY_STRING = "";
    private static final String ESCAPE_SEARCH_STRING = "\\";
    private static final String DOUBLE_QUOTE = "\"";
    private static final String EXTRA_CHARS = ".@";
    static final String KEY_WORDS = "OPTION, BIGDECIMAL, BIGDECIMAL, BIGINTEGER, BREAK, BYTE, CRITERIA, ERROR, LIMIT, LONG, LOOP, MAKEDEP, MAKENOTDEP, NOCACHE, STRING, VIRTUAL, WHILE";
    private static final String PROCEDURE_TERM = "StoredProcedure";
    static final String NUMERIC_FUNCTIONS = "ABS, ACOS, ASIN, ATAN, ATAN2, BITAND, BITNOT, BITOR, BITXOR, CEILING, COS, COT, DEGREES, EXP, FLOOR, FORMATBIGDECIMAL, FORMATBIGINTEGER, FORMATDOUBLE, FORMATFLOAT, FORMATINTEGER, FORMATLONG, LOG, LOG10, MOD, PARSEBIGDECIMAL, PARSEBIGINTEGER, PARSEDOUBLE, PARSEFLOAT, PARSEINTEGER, PARSELONG, PI, POWER, RADIANS, RAND, ROUND, SIGN, SIN, SQRT, TAN";
    static final String STRING_FUNCTIONS = "ASCII, CHR, CHAR, CONCAT, CONCAT2, INITCAP, INSERT, LCASE, LEFT, LENGTH, LOCATE, LOWER, LPAD, LTRIM, REPEAT, REPLACE, RIGHT, RPAD, RTRIM, SUBSTRING, TRANSLATE, UCASE, UPPER";
    static final String DATE_FUNCTIONS = "CURDATE, CURTIME, NOW, DAYNAME, DAYOFMONTH, DAYOFWEEK, DAYOFYEAR, FORMATDATE, FORMATTIME, FORMATTIMESTAMP, FROM_UNIXTIME, HOUR, MINUTE, MONTH, MONTHNAME, PARSEDATE, PARSETIME, PARSETIMESTAMP, QUARTER, SECOND, TIMESTAMPADD, TIMESTAMPDIFF, WEEK, YEAR";
    static final String SYSTEM_FUNCTIONS = "CAST, COALESCE, CONVERT, DECODESTRING, DECODEINTEGER, IFNULL, NULLIF, NVL, LOOKUP, UUID, UNESCAPE, ARRAY_GET, ARRAY_LENGTH";
    private static final int MAX_CATALOG_NAME_LENGTH = 255;
    private static final int MAX_PROCEDURE_NAME_LENGTH = 255;
    private static final int MAX_TABLE_NAME_LENGTH = 255;
    private static final int MAX_COLUMN_NAME_LENGTH = 255;
    private static final int MAX_USER_NAME_LENGTH = 255;
    private static final String LIKE_ESCAPE = " LIKE ? ESCAPE '\\' ";
    private static final String NULLABILITY_MAPPING = new StringBuffer("No Nulls, ").append(0).append(", Nullable, ").append(1).append(", Unknown, ").append(2).toString();
    private static final String PROC_COLUMN_NULLABILITY_MAPPING = new StringBuffer("No Nulls, ").append(0).append(", Nullable, ").append(1).append(", Unknown, ").append(2).toString();
    private static final String PARAM_DIRECTION_MAPPING = new StringBuffer("In,").append(1).append(", Out,").append(4).append(", InOut,").append(2).append(", ReturnValue,").append(5).append(", ResultSet,").append(3).toString();
    private static final String QUERY_REFERENCE_KEYS = new StringBuffer("SELECT PKTABLE_CAT, PKTABLE_SCHEM, PKTABLE_NAME, PKCOLUMN_NAME, FKTABLE_CAT, FKTABLE_SCHEM").append(", FKTABLE_NAME, FKCOLUMN_NAME, KEY_SEQ, UPDATE_RULE, DELETE_RULE, FK_NAME, PK_NAME, DEFERRABILITY FROM ").append("SYS").append(".ReferenceKeyColumns").toString();
    private static final String QUERY_CROSS_REFERENCES = new StringBuffer(QUERY_REFERENCE_KEYS).append(" WHERE UCASE(PKTABLE_CAT)").append(" LIKE ? ESCAPE '\\' ").append("AND UCASE(FKTABLE_CAT)").append(" LIKE ? ESCAPE '\\' ").append(" AND UCASE(PKTABLE_SCHEM)").append(" LIKE ? ESCAPE '\\' ").append("AND UCASE(FKTABLE_SCHEM)").append(" LIKE ? ESCAPE '\\' ").append(" AND UCASE(PKTABLE_NAME)").append(" LIKE ? ESCAPE '\\' ").append("AND UCASE(FKTABLE_NAME)").append(" LIKE ? ESCAPE '\\' ").append("ORDER BY FKTABLE_NAME, KEY_SEQ").toString();
    private static final String QUERY_EXPORTED_KEYS = new StringBuffer(QUERY_REFERENCE_KEYS).append(" WHERE UCASE(PKTABLE_CAT)").append(" LIKE ? ESCAPE '\\' ").append(" AND UCASE(PKTABLE_SCHEM)").append(" LIKE ? ESCAPE '\\' ").append(" AND UCASE(PKTABLE_NAME)").append(" LIKE ? ESCAPE '\\' ").append("ORDER BY FKTABLE_NAME, KEY_SEQ").toString();
    private static final String QUERY_IMPORTED_KEYS = new StringBuffer(QUERY_REFERENCE_KEYS).append(" WHERE UCASE(FKTABLE_CAT)").append(" LIKE ? ESCAPE '\\' ").append(" AND UCASE(FKTABLE_SCHEM)").append(" LIKE ? ESCAPE '\\' ").append(" AND UCASE(FKTABLE_NAME)").append(" LIKE ? ESCAPE '\\' ").append("ORDER BY PKTABLE_NAME, KEY_SEQ").toString();
    private static final String QUERY_COLUMNS = new StringBuffer("SELECT VDBName AS TABLE_CAT").append(", SchemaName AS TABLE_SCHEM, TableName AS TABLE_NAME, Name AS COLUMN_NAME").append(", Length AS DATA_TYPE").append(", DataType AS TYPE_NAME").append(", e.Precision AS COLUMN_SIZE").append(", NULL AS BUFFER_LENGTH, Scale AS DECIMAL_DIGITS, Radix AS NUM_PREC_RADIX").append(", convert(decodeString(NullType, '").append(NULLABILITY_MAPPING).append("', ','), integer) AS NULLABLE").append(", Description AS REMARKS, DefaultValue AS COLUMN_DEF, NULL AS SQL_DATA_TYPE, NULL AS SQL_DATETIME_SUB").append(", CharOctetLength AS CHAR_OCTET_LENGTH, Position AS ORDINAL_POSITION").append(", CASE NullType WHEN 'Nullable' THEN 'YES' WHEN 'No Nulls' THEN 'NO' ELSE '' END AS IS_NULLABLE").append(", NULL AS SCOPE_CATALOG, NULL AS SCOPE_SCHEMA, NULL AS SCOPE_TABLE, NULL AS SOURCE_DATA_TYPE, CASE WHEN e.IsAutoIncremented = 'true' THEN 'YES' ELSE 'NO' END AS IS_AUTOINCREMENT").append(" FROM ").append("SYS").append(".Columns e").append(" WHERE UCASE(SchemaName)").append(" LIKE ? ESCAPE '\\' ").append("AND UCASE(TableName)").append(" LIKE ? ESCAPE '\\' ").append("AND UCASE(Name)").append(" LIKE ? ESCAPE '\\' ").append("AND UCASE(VDBName)").append(" LIKE ? ESCAPE '\\' ").append(" ORDER BY TABLE_NAME, ORDINAL_POSITION").toString();
    private static final String QUERY_INDEX_INFO = new StringBuffer("SELECT VDBName AS TABLE_CAT, SchemaName AS TABLE_SCHEM, TableName AS TABLE_NAME").append(", case when KeyType = 'Index' then TRUE else FALSE end AS NON_UNIQUE, NULL AS INDEX_QUALIFIER, KeyName AS INDEX_NAME").append(", 3 AS TYPE, convert(Position, short) AS ORDINAL_POSITION, k.Name AS COLUMN_NAME").append(", NULL AS ASC_OR_DESC, 0 AS CARDINALITY, 1 AS PAGES, NULL AS FILTER_CONDITION").append(" FROM ").append("SYS").append(".KeyColumns k").append(" WHERE UCASE(VDBName)").append(" LIKE ? ESCAPE '\\' ").append(" AND UCASE(SchemaName)").append(" LIKE ? ESCAPE '\\' ").append(" AND UCASE(TableName)").append(" LIKE ? ESCAPE '\\' ").append(" AND KeyType IN ('Unique', ?)").append(" ORDER BY NON_UNIQUE, TYPE, INDEX_NAME, ORDINAL_POSITION").toString();
    private static final String QUERY_PRIMARY_KEYS = new StringBuffer("SELECT VDBName as TABLE_CAT, SchemaName AS TABLE_SCHEM, TableName AS TABLE_NAME").append(", k.Name AS COLUMN_NAME, convert(Position, short) AS KEY_SEQ, KeyName AS PK_NAME").append(" FROM ").append("SYS").append(".KeyColumns k").append(" WHERE UCASE(VDBName)").append(" LIKE ? ESCAPE '\\' ").append(" AND UCASE(SchemaName)").append(" LIKE ? ESCAPE '\\' ").append(" AND UCASE(TableName)").append(" LIKE ? ESCAPE '\\' ").append(" AND KeyType LIKE 'Primary'").append(" ORDER BY COLUMN_NAME, KEY_SEQ").toString();
    private static final String QUERY_PROCEDURES = new StringBuffer("SELECT VDBName AS PROCEDURE_CAT, SchemaName AS PROCEDURE_SCHEM").append(", p.Name AS PROCEDURE_NAME, convert(null, string) AS RESERVED_1").append(", convert(null, string) AS RESERVED_2, convert(null, string) AS RESERVED_3, p.Description AS REMARKS").append(", convert(decodeString(p.ReturnsResults, 'true, ").append(2).append(", false, ").append(1).append("'), short) AS PROCEDURE_TYPE, p.Name AS SPECIFIC_NAME FROM ").append("SYS").append(".Procedures as p").append(" WHERE UCASE(VDBName)").append(" LIKE ? ESCAPE '\\' ").append(" AND UCASE(SchemaName)").append(" LIKE ? ESCAPE '\\' ").append(" AND UCASE(p.Name)").append(" LIKE ? ESCAPE '\\' ").append(" ORDER BY PROCEDURE_SCHEM, PROCEDURE_NAME").toString();
    private static final String QUERY_PROCEDURE_COLUMNS = new StringBuffer("SELECT VDBName PROCEDURE_CAT, SchemaName AS PROCEDURE_SCHEM").append(", ProcedureName AS PROCEDURE_NAME, p.Name AS COLUMN_NAME").append(", convert(decodeString(TYPE, '").append(PARAM_DIRECTION_MAPPING).append("', ','), short) AS COLUMN_TYPE").append(", 1 AS DATA_TYPE").append(", DataType AS TYPE_NAME, p.Precision AS \"PRECISION\", TypeLength  AS LENGTH, convert(Scale, short) AS SCALE").append(", Radix AS RADIX, convert(decodeString(NullType, '").append(PROC_COLUMN_NULLABILITY_MAPPING).append("', ','), integer) AS NULLABLE").append(", p.Description AS REMARKS, NULL AS COLUMN_DEF").append(", NULL AS SQL_DATA_TYPE, NULL AS SQL_DATETIME_SUB, NULL AS CHAR_OCTET_LENGTH, p.Position AS ORDINAL_POSITION").append(", CASE NullType WHEN 'Nullable' THEN 'YES' WHEN 'No Nulls' THEN 'NO' ELSE '' END AS IS_NULLABLE, p.ProcedureName as SPECIFIC_NAME FROM ").append("SYS").append(".ProcedureParams as p").append(" WHERE UCASE(VDBName)").append(" LIKE ? ESCAPE '\\' ").append(" AND UCASE(SchemaName)").append(" LIKE ? ESCAPE '\\' ").append(" AND UCASE(ProcedureName)").append(" LIKE ? ESCAPE '\\' ").append(" AND UCASE(p.Name)").append(" LIKE ? ESCAPE '\\' ").append(" ORDER BY PROCEDURE_SCHEM, PROCEDURE_NAME, COLUMN_TYPE, POSITION").toString();
    private static final String QUERY_SCHEMAS = new StringBuffer("SELECT Name AS TABLE_SCHEM, VDBName AS TABLE_CATALOG").append(" FROM ").append("SYS").append(".Schemas").append(" WHERE UCASE(VDBName)").append(" LIKE ? ESCAPE '\\' ").append(" AND UCASE(Name)").append(" LIKE ? ESCAPE '\\' ").append(" ORDER BY TABLE_SCHEM").toString();
    private final String TABLE_TYPE;
    private final String QUERY_TABLES;
    private ConnectionImpl driverConnection;

    DatabaseMetaDataImpl(ConnectionImpl connection) {
        this.driverConnection = connection;
        this.TABLE_TYPE = PropertiesUtils.getBooleanProperty(connection.getConnectionProps(), REPORT_AS_VIEWS, false) ? "CASE WHEN IsSystem = 'true' and UCASE(Type) = 'TABLE' THEN 'SYSTEM TABLE' WHEN IsPhysical <> 'true' AND UCASE(Type) = 'TABLE' THEN 'VIEW' ELSE UCASE(Type) END" : "CASE WHEN IsSystem = 'true' and UCASE(Type) = 'TABLE' THEN 'SYSTEM TABLE' ELSE UCASE(Type) END";
        this.QUERY_TABLES = new StringBuffer("SELECT VDBName AS TABLE_CAT, SchemaName AS TABLE_SCHEM, Name AS TABLE_NAME").append(", ").append(this.TABLE_TYPE).append(" AS TABLE_TYPE, Description AS REMARKS, NULL AS TYPE_CAT, NULL AS TYPE_SCHEM").append(", NULL AS TYPE_NAME, NULL AS SELF_REFERENCING_COL_NAME, NULL AS REF_GENERATION, IsPhysical AS ISPHYSICAL").append(" FROM ").append("SYS").append(".Tables g ").append(" WHERE UCASE(VDBName)").append(LIKE_ESCAPE).append(" AND UCASE(SchemaName)").append(LIKE_ESCAPE).append(" AND UCASE(Name)").append(LIKE_ESCAPE).toString();
    }

    @Override
    public boolean allProceduresAreCallable() throws SQLException {
        return true;
    }

    @Override
    public boolean allTablesAreSelectable() throws SQLException {
        return true;
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return false;
    }

    @Override
    public boolean deletesAreDetected(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return false;
    }

    @Override
    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        ArrayList records = new ArrayList(0);
        Map[] metadataList = new Map[]{StatementImpl.getColumnMetadata(null, "SCOPE", "short", ResultsMetadataConstants.NULL_TYPES.NOT_NULL, this.driverConnection), StatementImpl.getColumnMetadata(null, "COLUMN_NAME", "string", ResultsMetadataConstants.NULL_TYPES.NOT_NULL, this.driverConnection), StatementImpl.getColumnMetadata(null, "DATA_TYPE", "short", ResultsMetadataConstants.NULL_TYPES.NOT_NULL, this.driverConnection), StatementImpl.getColumnMetadata(null, "TYPE_NAME", "string", ResultsMetadataConstants.NULL_TYPES.NOT_NULL, this.driverConnection), StatementImpl.getColumnMetadata(null, "COLUMN_SIZE", "integer", ResultsMetadataConstants.NULL_TYPES.NOT_NULL, this.driverConnection), StatementImpl.getColumnMetadata(null, "BUFFER_LENGTH", "integer", ResultsMetadataConstants.NULL_TYPES.NULLABLE, this.driverConnection), StatementImpl.getColumnMetadata(null, "DECIMAL_DIGITS", "short", ResultsMetadataConstants.NULL_TYPES.NOT_NULL, this.driverConnection), StatementImpl.getColumnMetadata(null, "PSEUDO_COLUMN", "short", ResultsMetadataConstants.NULL_TYPES.NOT_NULL, this.driverConnection)};
        String logMsg = JDBCPlugin.Util.getString("MMDatabaseMetadata.Best_row_sucess", table);
        logger.fine(logMsg);
        return this.dummyStatement().createResultSet(records, metadataList);
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        ArrayList<List<String>> records = new ArrayList<List<String>>(1);
        records.add(Arrays.asList(this.driverConnection.getCatalog()));
        Map[] metadataList = new Map[]{StatementImpl.getColumnMetadata(null, "TABLE_CAT", "string", ResultsMetadataConstants.NULL_TYPES.NULLABLE, this.driverConnection)};
        String logMsg = JDBCPlugin.Util.getString("MMDatabaseMetadata.Catalog_success");
        logger.fine(logMsg);
        return this.dummyStatement().createResultSet(records, metadataList);
    }

    @Override
    public String getCatalogSeparator() throws SQLException {
        return EMPTY_STRING;
    }

    @Override
    public String getCatalogTerm() throws SQLException {
        return "VirtualDatabase";
    }

    @Override
    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnName) throws SQLException {
        ArrayList records = new ArrayList(0);
        Map[] metadataList = new Map[]{StatementImpl.getColumnMetadata(null, "TABLE_CAT", "string", ResultsMetadataConstants.NULL_TYPES.NULLABLE, this.driverConnection), StatementImpl.getColumnMetadata(null, "TABLE_SCHEM", "string", ResultsMetadataConstants.NULL_TYPES.NULLABLE, this.driverConnection), StatementImpl.getColumnMetadata(null, "TABLE_NAME", "string", ResultsMetadataConstants.NULL_TYPES.NOT_NULL, this.driverConnection), StatementImpl.getColumnMetadata(null, "COLUMN_NAME", "string", ResultsMetadataConstants.NULL_TYPES.NOT_NULL, this.driverConnection), StatementImpl.getColumnMetadata(null, "GRANTOR", "string", ResultsMetadataConstants.NULL_TYPES.NULLABLE, this.driverConnection), StatementImpl.getColumnMetadata(null, "GRANTEE", "string", ResultsMetadataConstants.NULL_TYPES.NOT_NULL, this.driverConnection), StatementImpl.getColumnMetadata(null, "PRIVILEGE", "string", ResultsMetadataConstants.NULL_TYPES.NOT_NULL, this.driverConnection), StatementImpl.getColumnMetadata(null, "IS_GRANTABLE", "string", ResultsMetadataConstants.NULL_TYPES.NULLABLE, this.driverConnection)};
        return this.dummyStatement().createResultSet(records, metadataList);
    }

    @Override
    public ResultSet getColumns(String catalog, String schema, String tableNamePattern, String columnNamePattern) throws SQLException {
        if (catalog == null) {
            catalog = PERCENT;
        }
        if (schema == null) {
            schema = PERCENT;
        }
        if (tableNamePattern == null) {
            tableNamePattern = PERCENT;
        }
        if (columnNamePattern == null) {
            columnNamePattern = PERCENT;
        }
        ArrayList records = new ArrayList();
        ResultSetMetaData rmetadata = null;
        ResultSetImpl results = null;
        PreparedStatementImpl prepareQuery = null;
        try {
            Object typeName;
            prepareQuery = this.driverConnection.prepareStatement(QUERY_COLUMNS);
            prepareQuery.setObject(1, (Object)schema.toUpperCase());
            prepareQuery.setObject(2, (Object)tableNamePattern.toUpperCase());
            prepareQuery.setObject(3, (Object)columnNamePattern.toUpperCase());
            prepareQuery.setObject(4, (Object)catalog.toUpperCase());
            results = (ResultSetImpl)prepareQuery.executeQuery();
            while (results.next()) {
                ArrayList<Object> currentRow = new ArrayList<Object>(23);
                for (int i = 0; i < 23; ++i) {
                    currentRow.add(results.getObject(i + 1));
                }
                typeName = (String)currentRow.get(5);
                Integer length = (Integer)currentRow.get(4);
                Integer precision = (Integer)currentRow.get(6);
                if (typeName != null) {
                    currentRow.set(4, JDBCSQLTypeInfo.getSQLType((String)typeName));
                    if (!Number.class.isAssignableFrom(DataTypeManager.getDataTypeClass((String)typeName))) {
                        if (length != null && length <= 0) {
                            currentRow.set(6, JDBCSQLTypeInfo.getDefaultPrecision((String)typeName));
                        } else {
                            currentRow.set(6, length);
                        }
                    } else if (precision != null && precision <= 0) {
                        currentRow.set(6, JDBCSQLTypeInfo.getDefaultPrecision((String)typeName));
                    }
                } else {
                    currentRow.set(4, null);
                    currentRow.set(6, null);
                }
                records.add(currentRow);
            }
            rmetadata = results.getMetaData();
            String logMsg = JDBCPlugin.Util.getString("MMDatabaseMetadata.getCols_success", columnNamePattern, tableNamePattern);
            logger.fine(logMsg);
            typeName = this.dummyStatement().createResultSet(records, rmetadata);
            return typeName;
        }
        catch (Exception e) {
            String logMsg = JDBCPlugin.Util.getString("MMDatabaseMetadata.getCols_error", columnNamePattern, tableNamePattern, e.getMessage());
            throw TeiidSQLException.create(e, logMsg);
        }
        finally {
            if (prepareQuery != null) {
                prepareQuery.close();
            }
        }
    }

    @Override
    public ResultSet getCrossReference(String primaryCatalog, String primarySchema, String primaryTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        if (primaryCatalog == null) {
            primaryCatalog = PERCENT;
        }
        if (foreignCatalog == null) {
            foreignCatalog = PERCENT;
        }
        if (primarySchema == null) {
            primarySchema = PERCENT;
        }
        if (foreignSchema == null) {
            foreignSchema = PERCENT;
        }
        if (primaryTable == null) {
            primaryTable = PERCENT;
        }
        if (foreignTable == null) {
            foreignTable = PERCENT;
        }
        ResultSet results = null;
        PreparedStatementImpl prepareQuery = null;
        try {
            prepareQuery = this.driverConnection.prepareStatement(QUERY_CROSS_REFERENCES);
            prepareQuery.setObject(1, (Object)primaryCatalog.toUpperCase());
            prepareQuery.setObject(2, (Object)foreignCatalog.toUpperCase());
            prepareQuery.setObject(3, (Object)primarySchema.toUpperCase());
            prepareQuery.setObject(4, (Object)foreignSchema.toUpperCase());
            prepareQuery.setObject(5, (Object)primaryTable.toUpperCase());
            prepareQuery.setObject(6, (Object)foreignTable.toUpperCase());
            results = prepareQuery.executeQuery();
            ResultSet resultSet = this.getReferenceKeys(results);
            String logMsg = JDBCPlugin.Util.getString("MMDatabaseMetadata.getCrossRef_success", primaryTable, foreignTable);
            logger.fine(logMsg);
            ResultSet resultSet2 = resultSet;
            return resultSet2;
        }
        catch (Exception e) {
            String logMsg = JDBCPlugin.Util.getString("MMDatabaseMetadata.getCrossRef_error", primaryTable, foreignTable, e.getMessage());
            throw TeiidSQLException.create(e, logMsg);
        }
        finally {
            if (prepareQuery != null) {
                prepareQuery.close();
            }
        }
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLException {
        return TeiidDriver.getInstance().getMinorVersion();
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLException {
        return TeiidDriver.getInstance().getMajorVersion();
    }

    @Override
    public int getJDBCMajorVersion() throws SQLException {
        return 3;
    }

    @Override
    public int getJDBCMinorVersion() throws SQLException {
        return 0;
    }

    @Override
    public String getDatabaseProductName() throws SQLException {
        return this.driverConnection.getDatabaseName();
    }

    @Override
    public String getDatabaseProductVersion() throws SQLException {
        return TeiidDriver.getInstance().getMajorVersion() + "." + TeiidDriver.getInstance().getMinorVersion();
    }

    @Override
    public int getDefaultTransactionIsolation() throws SQLException {
        return 2;
    }

    @Override
    public int getDriverMajorVersion() {
        return TeiidDriver.getInstance().getMajorVersion();
    }

    @Override
    public int getDriverMinorVersion() {
        return TeiidDriver.getInstance().getMinorVersion();
    }

    @Override
    public String getDriverName() throws SQLException {
        return TeiidDriver.getInstance().getDriverName();
    }

    @Override
    public String getDriverVersion() throws SQLException {
        return this.getDriverMajorVersion() + "." + this.getDriverMinorVersion();
    }

    @Override
    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        if (catalog == null) {
            catalog = PERCENT;
        }
        if (schema == null) {
            schema = PERCENT;
        }
        if (table == null) {
            table = PERCENT;
        }
        ResultSet results = null;
        PreparedStatementImpl prepareQuery = null;
        try {
            prepareQuery = this.driverConnection.prepareStatement(QUERY_EXPORTED_KEYS);
            prepareQuery.setObject(1, (Object)catalog.toUpperCase());
            prepareQuery.setObject(2, (Object)schema.toUpperCase());
            prepareQuery.setObject(3, (Object)table.toUpperCase());
            results = prepareQuery.executeQuery();
            ResultSet resultSet = this.getReferenceKeys(results);
            logger.fine(JDBCPlugin.Util.getString("MMDatabaseMetadata.getExpKey_success", table));
            ResultSet resultSet2 = resultSet;
            return resultSet2;
        }
        catch (Exception e) {
            String logMsg = JDBCPlugin.Util.getString("MMDatabaseMetadata.getExpKey_error", table, e.getMessage());
            throw TeiidSQLException.create(e, logMsg);
        }
        finally {
            if (prepareQuery != null) {
                prepareQuery.close();
            }
        }
    }

    @Override
    public String getExtraNameCharacters() throws SQLException {
        return EXTRA_CHARS;
    }

    @Override
    public String getIdentifierQuoteString() throws SQLException {
        return DOUBLE_QUOTE;
    }

    @Override
    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        if (catalog == null) {
            catalog = PERCENT;
        }
        if (schema == null) {
            schema = PERCENT;
        }
        if (table == null) {
            table = PERCENT;
        }
        ResultSet results = null;
        PreparedStatementImpl prepareQuery = null;
        try {
            prepareQuery = this.driverConnection.prepareStatement(QUERY_IMPORTED_KEYS);
            prepareQuery.setObject(1, (Object)catalog.toUpperCase());
            prepareQuery.setObject(2, (Object)schema.toUpperCase());
            prepareQuery.setObject(3, (Object)table.toUpperCase());
            results = prepareQuery.executeQuery();
            ResultSet resultSet = this.getReferenceKeys(results);
            logger.fine(JDBCPlugin.Util.getString("MMDatabaseMetadata.getImpKey_success", table));
            ResultSet resultSet2 = resultSet;
            return resultSet2;
        }
        catch (Exception e) {
            String logMsg = JDBCPlugin.Util.getString("MMDatabaseMetadata.getImpKey_error", table, e.getMessage());
            throw TeiidSQLException.create(e, logMsg);
        }
        finally {
            if (prepareQuery != null) {
                prepareQuery.close();
            }
        }
    }

    @Override
    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        if (catalog == null) {
            catalog = PERCENT;
        }
        if (schema == null) {
            schema = PERCENT;
        }
        if (table == null) {
            table = PERCENT;
        }
        ArrayList records = new ArrayList();
        ResultSetMetaData rmetadata = null;
        ResultSetImpl results = null;
        PreparedStatementImpl prepareQuery = null;
        try {
            Object currentRow;
            prepareQuery = this.driverConnection.prepareStatement(QUERY_INDEX_INFO);
            prepareQuery.setObject(1, (Object)catalog.toUpperCase());
            prepareQuery.setObject(2, (Object)schema.toUpperCase());
            prepareQuery.setObject(3, (Object)table.toUpperCase());
            prepareQuery.setObject(4, (Object)(unique ? null : "Index"));
            results = (ResultSetImpl)prepareQuery.executeQuery();
            while (results.next()) {
                currentRow = new ArrayList<Object>(13);
                for (int i = 0; i < 13; ++i) {
                    currentRow.add(results.getObject(i + 1));
                }
                records.add(currentRow);
            }
            rmetadata = results.getMetaData();
            logger.fine(JDBCPlugin.Util.getString("MMDatabaseMetadata.getIndex_success", table));
            currentRow = this.dummyStatement().createResultSet(records, rmetadata);
            return currentRow;
        }
        catch (Exception e) {
            throw TeiidSQLException.create(e, JDBCPlugin.Util.getString("MMDatabaseMetadata.getIndex_error", table, e.getMessage()));
        }
        finally {
            if (prepareQuery != null) {
                prepareQuery.close();
            }
        }
    }

    @Override
    public int getMaxBinaryLiteralLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCatalogNameLength() throws SQLException {
        return 255;
    }

    @Override
    public int getMaxCharLiteralLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnNameLength() throws SQLException {
        return 255;
    }

    @Override
    public int getMaxColumnsInGroupBy() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInIndex() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInOrderBy() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInSelect() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInTable() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxConnections() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCursorNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxIndexLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxProcedureNameLength() throws SQLException {
        return 255;
    }

    @Override
    public int getMaxRowSize() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxSchemaNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxStatementLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxStatements() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxTableNameLength() throws SQLException {
        return 255;
    }

    @Override
    public int getMaxTablesInSelect() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxUserNameLength() throws SQLException {
        return 255;
    }

    @Override
    public String getNumericFunctions() throws SQLException {
        return NUMERIC_FUNCTIONS;
    }

    @Override
    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        if (catalog == null) {
            catalog = PERCENT;
        }
        if (schema == null) {
            schema = PERCENT;
        }
        if (table == null) {
            table = PERCENT;
        }
        ArrayList records = new ArrayList();
        ResultSetMetaData rmetadata = null;
        ResultSetImpl results = null;
        PreparedStatementImpl prepareQuery = null;
        try {
            Object currentRow;
            prepareQuery = this.driverConnection.prepareStatement(QUERY_PRIMARY_KEYS);
            prepareQuery.setObject(1, (Object)catalog.toUpperCase());
            prepareQuery.setObject(2, (Object)schema.toUpperCase());
            prepareQuery.setObject(3, (Object)table.toUpperCase());
            results = (ResultSetImpl)prepareQuery.executeQuery();
            while (results.next()) {
                currentRow = new ArrayList<Object>(7);
                for (int i = 0; i < 6; ++i) {
                    currentRow.add(results.getObject(i + 1));
                }
                records.add(currentRow);
            }
            rmetadata = results.getMetaData();
            logger.fine(JDBCPlugin.Util.getString("MMDatabaseMetadata.getPrimaryKey_success"));
            currentRow = this.dummyStatement().createResultSet(records, rmetadata);
            return currentRow;
        }
        catch (Exception e) {
            throw TeiidSQLException.create(e, JDBCPlugin.Util.getString("MMDatabaseMetadata.getPrimaryKey_error", table, e.getMessage()));
        }
        finally {
            if (prepareQuery != null) {
                prepareQuery.close();
            }
        }
    }

    @Override
    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        if (catalog == null) {
            catalog = PERCENT;
        }
        if (schemaPattern == null) {
            schemaPattern = PERCENT;
        }
        if (procedureNamePattern == null) {
            procedureNamePattern = PERCENT;
        }
        if (columnNamePattern == null) {
            columnNamePattern = PERCENT;
        }
        ArrayList<Object> records = new ArrayList<Object>();
        ResultSetMetaData rmetadata = null;
        ResultSetImpl results = null;
        PreparedStatementImpl prepareQuery = null;
        try {
            Object currentRow;
            prepareQuery = this.driverConnection.prepareStatement(QUERY_PROCEDURE_COLUMNS);
            prepareQuery.setObject(1, (Object)catalog.toUpperCase());
            prepareQuery.setObject(2, (Object)schemaPattern.toUpperCase());
            prepareQuery.setObject(3, (Object)procedureNamePattern.toUpperCase());
            prepareQuery.setObject(4, (Object)columnNamePattern.toUpperCase());
            results = (ResultSetImpl)prepareQuery.executeQuery();
            while (results.next()) {
                currentRow = new ArrayList<Object>(13);
                for (int i = 0; i < 20; ++i) {
                    currentRow.add(results.getObject(i + 1));
                }
                String typeName = (String)currentRow.get(6);
                Integer length = (Integer)currentRow.get(8);
                Integer precision = (Integer)currentRow.get(7);
                if (precision != null && precision <= 0) {
                    currentRow.set(7, JDBCSQLTypeInfo.getDefaultPrecision(typeName));
                }
                if (length != null && length <= 0) {
                    currentRow.set(8, JDBCSQLTypeInfo.getDefaultPrecision(typeName));
                }
                if (typeName != null) {
                    currentRow.set(5, JDBCSQLTypeInfo.getSQLType(typeName));
                } else {
                    currentRow.set(5, null);
                }
                records.add(currentRow);
            }
            rmetadata = results.getMetaData();
            logger.fine(JDBCPlugin.Util.getString("MMDatabaseMetadata.getProcCol_success", columnNamePattern, procedureNamePattern));
            currentRow = this.dummyStatement().createResultSet(records, rmetadata);
            return currentRow;
        }
        catch (Exception e) {
            throw TeiidSQLException.create(e, JDBCPlugin.Util.getString("MMDatabaseMetadata.getProcCol_error", columnNamePattern, e.getMessage()));
        }
        finally {
            if (prepareQuery != null) {
                prepareQuery.close();
            }
        }
    }

    @Override
    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        if (catalog == null) {
            catalog = PERCENT;
        }
        if (schemaPattern == null) {
            schemaPattern = PERCENT;
        }
        if (procedureNamePattern == null) {
            procedureNamePattern = PERCENT;
        }
        ArrayList records = new ArrayList();
        ResultSetMetaData rmetadata = null;
        ResultSetImpl results = null;
        PreparedStatementImpl prepareQuery = null;
        try {
            Object currentRow;
            prepareQuery = this.driverConnection.prepareStatement(QUERY_PROCEDURES);
            prepareQuery.setObject(1, (Object)catalog.toUpperCase());
            prepareQuery.setObject(2, (Object)schemaPattern.toUpperCase());
            prepareQuery.setObject(3, (Object)procedureNamePattern.toUpperCase());
            results = (ResultSetImpl)prepareQuery.executeQuery();
            while (results.next()) {
                currentRow = new ArrayList<Object>(9);
                for (int i = 0; i < 9; ++i) {
                    currentRow.add(results.getObject(i + 1));
                }
                records.add(currentRow);
            }
            rmetadata = results.getMetaData();
            logger.fine(JDBCPlugin.Util.getString("MMDatabaseMetadata.getProc_success", procedureNamePattern));
            currentRow = this.dummyStatement().createResultSet(records, rmetadata);
            return currentRow;
        }
        catch (Exception e) {
            throw TeiidSQLException.create(e, JDBCPlugin.Util.getString("MMDatabaseMetadata.getProc_error", procedureNamePattern, e.getMessage()));
        }
        finally {
            if (prepareQuery != null) {
                prepareQuery.close();
            }
        }
    }

    @Override
    public String getProcedureTerm() throws SQLException {
        return PROCEDURE_TERM;
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        return this.getSchemas(null, null);
    }

    @Override
    public String getSchemaTerm() throws SQLException {
        return SCHEMA_TERM;
    }

    @Override
    public String getSearchStringEscape() throws SQLException {
        return ESCAPE_SEARCH_STRING;
    }

    @Override
    public String getSQLKeywords() throws SQLException {
        return KEY_WORDS;
    }

    @Override
    public int getSQLStateType() throws SQLException {
        return 2;
    }

    @Override
    public String getStringFunctions() throws SQLException {
        return STRING_FUNCTIONS;
    }

    @Override
    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        ArrayList records = new ArrayList(0);
        Map[] metadataList = new Map[]{StatementImpl.getColumnMetadata(null, "TABLE_CAT", "string", ResultsMetadataConstants.NULL_TYPES.NULLABLE, this.driverConnection), StatementImpl.getColumnMetadata(null, "TABLE_SCHEM", "string", ResultsMetadataConstants.NULL_TYPES.NULLABLE, this.driverConnection), StatementImpl.getColumnMetadata(null, "TABLE_NAME", "string", ResultsMetadataConstants.NULL_TYPES.NOT_NULL, this.driverConnection), StatementImpl.getColumnMetadata(null, "SUPERTABLE_NAME", "string", ResultsMetadataConstants.NULL_TYPES.NOT_NULL, this.driverConnection)};
        return this.dummyStatement().createResultSet(records, metadataList);
    }

    @Override
    public ResultSet getSuperTypes(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        ArrayList records = new ArrayList(0);
        Map[] metadataList = new Map[]{StatementImpl.getColumnMetadata(null, "TYPE_CAT", "string", ResultsMetadataConstants.NULL_TYPES.NULLABLE, this.driverConnection), StatementImpl.getColumnMetadata(null, "TYPE_SCHEM", "string", ResultsMetadataConstants.NULL_TYPES.NULLABLE, this.driverConnection), StatementImpl.getColumnMetadata(null, "TYPE_NAME", "string", ResultsMetadataConstants.NULL_TYPES.NOT_NULL, this.driverConnection), StatementImpl.getColumnMetadata(null, "SUPERTYPE_CAT", "string", ResultsMetadataConstants.NULL_TYPES.NULLABLE, this.driverConnection), StatementImpl.getColumnMetadata(null, "SUPERTYPE_SCHEM", "string", ResultsMetadataConstants.NULL_TYPES.NULLABLE, this.driverConnection), StatementImpl.getColumnMetadata(null, "SUPERTYPE_NAME", "string", ResultsMetadataConstants.NULL_TYPES.NOT_NULL, this.driverConnection)};
        return this.dummyStatement().createResultSet(records, metadataList);
    }

    @Override
    public String getSystemFunctions() throws SQLException {
        return SYSTEM_FUNCTIONS;
    }

    @Override
    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableName) throws SQLException {
        ArrayList records = new ArrayList(0);
        Map[] metadataList = new Map[]{StatementImpl.getColumnMetadata(null, "TABLE_CAT", "string", ResultsMetadataConstants.NULL_TYPES.NULLABLE, this.driverConnection), StatementImpl.getColumnMetadata(null, "TABLE_SCHEM", "string", ResultsMetadataConstants.NULL_TYPES.NULLABLE, this.driverConnection), StatementImpl.getColumnMetadata(null, "TABLE_NAME", "string", ResultsMetadataConstants.NULL_TYPES.NOT_NULL, this.driverConnection), StatementImpl.getColumnMetadata(null, "GRANTOR", "string", ResultsMetadataConstants.NULL_TYPES.NULLABLE, this.driverConnection), StatementImpl.getColumnMetadata(null, "GRANTEE", "string", ResultsMetadataConstants.NULL_TYPES.NOT_NULL, this.driverConnection), StatementImpl.getColumnMetadata(null, "PRIVILEGE", "string", ResultsMetadataConstants.NULL_TYPES.NOT_NULL, this.driverConnection), StatementImpl.getColumnMetadata(null, "IS_GRANTABLE", "string", ResultsMetadataConstants.NULL_TYPES.NULLABLE, this.driverConnection)};
        return this.dummyStatement().createResultSet(records, metadataList);
    }

    @Override
    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        if (catalog == null) {
            catalog = PERCENT;
        }
        if (schemaPattern == null) {
            schemaPattern = PERCENT;
        }
        if (tableNamePattern == null) {
            tableNamePattern = PERCENT;
        }
        ArrayList records = new ArrayList();
        StringBuffer sqlQuery = new StringBuffer(this.QUERY_TABLES);
        if (types != null) {
            StringBuffer typesString = new StringBuffer("(");
            if (types.length == 0) {
                typesString.append("1 = 0");
            } else {
                for (int i = 0; i < types.length; ++i) {
                    if (types[i] == null || types[i].length() <= 0) continue;
                    if (i > 0) {
                        typesString.append(" OR ");
                    }
                    typesString.append(this.TABLE_TYPE).append(LIKE_ESCAPE);
                }
            }
            typesString.append(")");
            sqlQuery.append(" AND ").append(typesString.toString());
        }
        sqlQuery.append(" ORDER BY TABLE_TYPE, TABLE_SCHEM, TABLE_NAME");
        ResultSetMetaData rmetadata = null;
        ResultSetImpl results = null;
        PreparedStatementImpl prepareQuery = null;
        try {
            prepareQuery = this.driverConnection.prepareStatement(sqlQuery.toString());
            int columnIndex = 0;
            prepareQuery.setObject(++columnIndex, (Object)catalog.toUpperCase());
            prepareQuery.setObject(++columnIndex, (Object)schemaPattern.toUpperCase());
            prepareQuery.setObject(++columnIndex, (Object)tableNamePattern.toUpperCase());
            if (types != null) {
                for (int i = 0; i < types.length; ++i) {
                    if (types[i] == null || types[i].length() <= 0) continue;
                    prepareQuery.setObject(++columnIndex, (Object)types[i].toUpperCase());
                }
            }
            results = (ResultSetImpl)prepareQuery.executeQuery();
            while (results.next()) {
                ArrayList<Object> currentRow = new ArrayList<Object>(11);
                for (int i = 0; i < 11; ++i) {
                    currentRow.add(results.getObject(i + 1));
                }
                records.add(currentRow);
            }
            rmetadata = results.getMetaData();
            logger.fine(JDBCPlugin.Util.getString("MMDatabaseMetadata.getTable_success", tableNamePattern));
            ResultSetImpl resultSetImpl = this.dummyStatement().createResultSet(records, rmetadata);
            return resultSetImpl;
        }
        catch (Exception e) {
            throw TeiidSQLException.create(e, JDBCPlugin.Util.getString("MMDatabaseMetadata.getTable_error", tableNamePattern, e.getMessage()));
        }
        finally {
            if (prepareQuery != null) {
                prepareQuery.close();
            }
        }
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        ArrayList<List<String>> records = new ArrayList<List<String>>(5);
        records.add(Arrays.asList("DOCUMENT"));
        records.add(Arrays.asList("TABLE"));
        records.add(Arrays.asList("VIEW"));
        records.add(Arrays.asList("XMLSTAGINGTABLE"));
        records.add(Arrays.asList("SYSTEM TABLE"));
        Map[] metadataList = new Map[]{StatementImpl.getColumnMetadata(null, "TABLE_TYPE", "string", ResultsMetadataConstants.NULL_TYPES.NOT_NULL, this.driverConnection)};
        logger.fine(JDBCPlugin.Util.getString("MMDatabaseMetadata.getTableType_success"));
        return this.dummyStatement().createResultSet(records, metadataList);
    }

    @Override
    public String getTimeDateFunctions() throws SQLException {
        return DATE_FUNCTIONS;
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        ArrayList<List<Object>> records = new ArrayList<List<Object>>();
        records.add(Arrays.asList(this.createTypeInfoRow("boolean", "{b'", "}", Boolean.TRUE, Boolean.TRUE, 0)));
        records.add(Arrays.asList(this.createTypeInfoRow("byte", null, null, Boolean.TRUE, Boolean.TRUE, 0)));
        records.add(Arrays.asList(this.createTypeInfoRow("tinyint", null, null, Boolean.TRUE, Boolean.TRUE, 0)));
        records.add(Arrays.asList(this.createTypeInfoRow("long", null, null, Boolean.FALSE, Boolean.FALSE, 10)));
        records.add(Arrays.asList(this.createTypeInfoRow("bigint", null, null, Boolean.FALSE, Boolean.FALSE, 10)));
        records.add(Arrays.asList(this.createTypeInfoRow("char", "'", "'", Boolean.TRUE, Boolean.TRUE, 0)));
        records.add(Arrays.asList(this.createTypeInfoRow("bigdecimal", null, null, Boolean.FALSE, Boolean.TRUE, 10)));
        records.add(Arrays.asList(this.createTypeInfoRow("decimal", null, null, Boolean.FALSE, Boolean.TRUE, 10)));
        records.add(Arrays.asList(this.createTypeInfoRow("biginteger", null, null, Boolean.FALSE, Boolean.FALSE, 10)));
        records.add(Arrays.asList(this.createTypeInfoRow("integer", null, null, Boolean.FALSE, Boolean.FALSE, 10)));
        records.add(Arrays.asList(this.createTypeInfoRow("short", null, null, Boolean.FALSE, Boolean.FALSE, 10)));
        records.add(Arrays.asList(this.createTypeInfoRow("smallint", null, null, Boolean.FALSE, Boolean.FALSE, 10)));
        records.add(Arrays.asList(this.createTypeInfoRow("float", null, null, Boolean.FALSE, Boolean.FALSE, 10)));
        records.add(Arrays.asList(this.createTypeInfoRow("real", null, null, Boolean.FALSE, Boolean.FALSE, 10)));
        records.add(Arrays.asList(this.createTypeInfoRow("double", null, null, Boolean.FALSE, Boolean.FALSE, 10)));
        records.add(Arrays.asList(this.createTypeInfoRow("string", "'", "'", Boolean.TRUE, Boolean.TRUE, 0)));
        records.add(Arrays.asList(this.createTypeInfoRow("varchar", "'", "'", Boolean.TRUE, Boolean.TRUE, 0)));
        records.add(Arrays.asList(this.createTypeInfoRow("xml", null, null, Boolean.TRUE, Boolean.TRUE, 0)));
        records.add(Arrays.asList(this.createTypeInfoRow("date", "{d'", "}", Boolean.TRUE, Boolean.TRUE, 0)));
        records.add(Arrays.asList(this.createTypeInfoRow("time", "{t'", "}", Boolean.TRUE, Boolean.TRUE, 0)));
        records.add(Arrays.asList(this.createTypeInfoRow("timestamp", "{ts'", "}", Boolean.TRUE, Boolean.TRUE, 0)));
        records.add(Arrays.asList(this.createTypeInfoRow("object", null, null, Boolean.TRUE, Boolean.TRUE, 0)));
        records.add(Arrays.asList(this.createTypeInfoRow("blob", null, null, Boolean.TRUE, Boolean.TRUE, 0)));
        records.add(Arrays.asList(this.createTypeInfoRow("varbinary", "X'", "'", Boolean.TRUE, Boolean.TRUE, 0)));
        records.add(Arrays.asList(this.createTypeInfoRow("clob", null, null, Boolean.TRUE, Boolean.TRUE, 0)));
        Map[] metadataList = new Map[]{StatementImpl.getColumnMetadata("SYS.DataTypes", "TYPE_NAME", "string", ResultsMetadataConstants.NULL_TYPES.NOT_NULL, ResultsMetadataConstants.SEARCH_TYPES.SEARCHABLE, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, this.driverConnection), StatementImpl.getColumnMetadata("SYS.DataTypes", "DATA_TYPE", "integer", ResultsMetadataConstants.NULL_TYPES.NULLABLE, ResultsMetadataConstants.SEARCH_TYPES.SEARCHABLE, Boolean.TRUE, Boolean.TRUE, Boolean.FALSE, this.driverConnection), StatementImpl.getColumnMetadata("SYS.DataTypes", "PRECISION", "integer", ResultsMetadataConstants.NULL_TYPES.NULLABLE, ResultsMetadataConstants.SEARCH_TYPES.SEARCHABLE, Boolean.TRUE, Boolean.TRUE, Boolean.FALSE, this.driverConnection), StatementImpl.getColumnMetadata("SYS.DataTypes", "LITERAL_PREFIX", "string", ResultsMetadataConstants.NULL_TYPES.NULLABLE, ResultsMetadataConstants.SEARCH_TYPES.SEARCHABLE, Boolean.TRUE, Boolean.TRUE, Boolean.FALSE, this.driverConnection), StatementImpl.getColumnMetadata("SYS.DataTypes", "LITERAL_SUFFIX", "string", ResultsMetadataConstants.NULL_TYPES.NULLABLE, ResultsMetadataConstants.SEARCH_TYPES.SEARCHABLE, Boolean.TRUE, Boolean.TRUE, Boolean.FALSE, this.driverConnection), StatementImpl.getColumnMetadata("SYS.DataTypes", "CREATE_PARAMS", "string", ResultsMetadataConstants.NULL_TYPES.NULLABLE, ResultsMetadataConstants.SEARCH_TYPES.SEARCHABLE, Boolean.TRUE, Boolean.TRUE, Boolean.FALSE, this.driverConnection), StatementImpl.getColumnMetadata("SYS.DataTypes", "NULLABLE", "short", ResultsMetadataConstants.NULL_TYPES.NULLABLE, ResultsMetadataConstants.SEARCH_TYPES.SEARCHABLE, Boolean.TRUE, Boolean.TRUE, Boolean.FALSE, this.driverConnection), StatementImpl.getColumnMetadata("SYS.DataTypes", "CASE_SENSITIVE", "boolean", ResultsMetadataConstants.NULL_TYPES.NOT_NULL, ResultsMetadataConstants.SEARCH_TYPES.SEARCHABLE, Boolean.FALSE, Boolean.FALSE, Boolean.TRUE, this.driverConnection), StatementImpl.getColumnMetadata("SYS.DataTypes", "SEARCHABLE", "short", ResultsMetadataConstants.NULL_TYPES.NULLABLE, ResultsMetadataConstants.SEARCH_TYPES.SEARCHABLE, Boolean.TRUE, Boolean.TRUE, Boolean.FALSE, this.driverConnection), StatementImpl.getColumnMetadata("SYS.DataTypes", "UNSIGNED_ATTRIBUTE", "boolean", ResultsMetadataConstants.NULL_TYPES.NULLABLE, ResultsMetadataConstants.SEARCH_TYPES.SEARCHABLE, Boolean.TRUE, Boolean.TRUE, Boolean.FALSE, this.driverConnection), StatementImpl.getColumnMetadata("SYS.DataTypes", "FIXED_PREC_SCALE", "boolean", ResultsMetadataConstants.NULL_TYPES.NULLABLE, ResultsMetadataConstants.SEARCH_TYPES.SEARCHABLE, Boolean.TRUE, Boolean.TRUE, Boolean.FALSE, this.driverConnection), StatementImpl.getColumnMetadata("SYS.DataTypes", "AUTO_INCREMENT", "boolean", ResultsMetadataConstants.NULL_TYPES.NOT_NULL, ResultsMetadataConstants.SEARCH_TYPES.SEARCHABLE, Boolean.FALSE, Boolean.TRUE, Boolean.TRUE, this.driverConnection), StatementImpl.getColumnMetadata("SYS.DataTypes", "LOCAL_TYPE_NAME", "string", ResultsMetadataConstants.NULL_TYPES.NOT_NULL, ResultsMetadataConstants.SEARCH_TYPES.SEARCHABLE, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, this.driverConnection), StatementImpl.getColumnMetadata("SYS.DataTypes", "MINIMUM_SCALE", "short", ResultsMetadataConstants.NULL_TYPES.NULLABLE, ResultsMetadataConstants.SEARCH_TYPES.SEARCHABLE, Boolean.TRUE, Boolean.TRUE, Boolean.FALSE, this.driverConnection), StatementImpl.getColumnMetadata("SYS.DataTypes", "MAXIMUM_SCALE", "short", ResultsMetadataConstants.NULL_TYPES.NULLABLE, ResultsMetadataConstants.SEARCH_TYPES.SEARCHABLE, Boolean.TRUE, Boolean.TRUE, Boolean.FALSE, this.driverConnection), StatementImpl.getColumnMetadata("SYS.DataTypes", "SQL_DATA_TYPE", "integer", ResultsMetadataConstants.NULL_TYPES.NULLABLE, ResultsMetadataConstants.SEARCH_TYPES.SEARCHABLE, Boolean.TRUE, Boolean.TRUE, Boolean.FALSE, this.driverConnection), StatementImpl.getColumnMetadata("SYS.DataTypes", "SQL_DATETIME_SUB", "integer", ResultsMetadataConstants.NULL_TYPES.NULLABLE, ResultsMetadataConstants.SEARCH_TYPES.SEARCHABLE, Boolean.TRUE, Boolean.TRUE, Boolean.FALSE, this.driverConnection), StatementImpl.getColumnMetadata("SYS.DataTypes", "NUM_PREC_RADIX", "integer", ResultsMetadataConstants.NULL_TYPES.NULLABLE, ResultsMetadataConstants.SEARCH_TYPES.SEARCHABLE, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, this.driverConnection)};
        ResultSetMetaDataImpl rmetadata = new ResultSetMetaDataImpl(new MetadataProvider(metadataList), null);
        logger.fine(JDBCPlugin.Util.getString("MMDatabaseMetadata.getTypes_success"));
        return this.dummyStatement().createResultSet(records, rmetadata);
    }

    private Object[] createTypeInfoRow(String typeName, String prefix, String suffix, Boolean unsigned, Boolean fixedPrecScale, int radix) {
        return new Object[]{typeName, new Integer(JDBCSQLTypeInfo.getSQLType(typeName)), JDBCSQLTypeInfo.getDefaultPrecision(typeName), prefix, suffix, null, new Short(1), Boolean.FALSE, new Short(3), unsigned, fixedPrecScale, Boolean.FALSE, typeName, new Short(0), new Short(255), null, null, new Integer(radix)};
    }

    @Override
    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        return this.emptyUDTSResultSet();
    }

    private ResultSet emptyUDTSResultSet() throws SQLException {
        String[] columnNames = new String[]{"TYPE_CAT", "TYPE_SCHEM", "TYPE_NAME", "CLASS_NAME", "DATA_TYPE", "REMARKS", "BASE_TYPE"};
        String[] dataTypes = new String[]{"string", "string", "string", "string", "string", "string", "short"};
        return this.dummyStatement().createResultSet(Collections.EMPTY_LIST, columnNames, dataTypes);
    }

    private StatementImpl dummyStatement() {
        return new StatementImpl(this.driverConnection, 1004, 1007);
    }

    @Override
    public String getURL() throws SQLException {
        return this.driverConnection.getUrl();
    }

    @Override
    public String getUserName() throws SQLException {
        return this.driverConnection.getUserName();
    }

    @Override
    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        ResultSet resultSet = this.getBestRowIdentifier(catalog, schema, table, 0, true);
        logger.fine(JDBCPlugin.Util.getString("MMDatabaseMetadata.getVersionCols_success"));
        return resultSet;
    }

    @Override
    public boolean isCatalogAtStart() throws SQLException {
        return false;
    }

    @Override
    public boolean insertsAreDetected(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return false;
    }

    @Override
    public boolean locatorsUpdateCopy() throws SQLException {
        return false;
    }

    @Override
    public boolean nullPlusNonNullIsNull() throws SQLException {
        return true;
    }

    @Override
    public boolean nullsAreSortedAtEnd() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedAtStart() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedHigh() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedLow() throws SQLException {
        return true;
    }

    @Override
    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean ownDeletesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean ownInsertsAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean othersDeletesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean othersInsertsAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        return true;
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        return true;
    }

    @Override
    public boolean storesUpperCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92FullSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsBatchUpdates() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsColumnAliasing() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsConvert() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        String toName;
        String fromName = JDBCSQLTypeInfo.getTypeName(fromType);
        if (fromName.equals(toName = JDBCSQLTypeInfo.getTypeName(toType))) {
            return !fromName.equals("object") || fromName == toName;
        }
        return DataTypeManager.isTransformable(fromName, toName);
    }

    @Override
    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCoreSQLGrammar() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsExtendedSQLGrammar() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsFullOuterJoins() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGetGeneratedKeys() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupBy() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupByUnrelated() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsLikeEscapeClause() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsLimitedOuterJoins() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMultipleResultSets() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMultipleOpenResults() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMultipleTransactions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsNamedParameters() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsNonNullableColumns() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOrderByUnrelated() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOuterJoins() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsPositionedDelete() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsPositionedUpdate() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        if (type == 1003 || type == 1004) {
            return concurrency == 1007;
        }
        return false;
    }

    @Override
    public boolean supportsResultSetHoldability(int holdability) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsResultSetType(int type) throws SQLException {
        return type == 1003 || type == 1004;
    }

    @Override
    public boolean supportsSavepoints() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSelectForUpdate() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsStatementPooling() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsStoredProcedures() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInExists() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInIns() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsTableCorrelationNames() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsTransactions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsUnion() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsUnionAll() throws SQLException {
        return true;
    }

    @Override
    public boolean updatesAreDetected(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean usesLocalFilePerTable() throws SQLException {
        return false;
    }

    @Override
    public boolean usesLocalFiles() throws SQLException {
        return false;
    }

    private ResultSet getReferenceKeys(ResultSet results) throws SQLException {
        ArrayList records = new ArrayList();
        ResultSetMetaData rmetadata = null;
        try {
            while (results.next()) {
                ArrayList<Object> currentRow = new ArrayList<Object>(15);
                for (int i = 0; i < 14; ++i) {
                    currentRow.add(results.getObject(i + 1));
                }
                records.add(currentRow);
            }
            rmetadata = results.getMetaData();
        }
        catch (Exception e) {
            String msg = JDBCPlugin.Util.getString("MMDatabaseMetadata.Err_getting_primary_keys");
            throw TeiidSQLException.create(e, msg);
        }
        logger.fine(JDBCPlugin.Util.getString("MMDatabaseMetadata.getRefKey_success"));
        return this.dummyStatement().createResultSet(records, rmetadata);
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        return false;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 1;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.driverConnection;
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        return false;
    }

    @Override
    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public RowIdLifetime getRowIdLifetime() throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        if (catalog == null) {
            catalog = PERCENT;
        }
        if (schemaPattern == null) {
            schemaPattern = PERCENT;
        }
        ArrayList records = new ArrayList();
        ResultSetMetaData rmetadata = null;
        ResultSetImpl results = null;
        PreparedStatementImpl prepareQuery = null;
        try {
            Object currentRow;
            prepareQuery = this.driverConnection.prepareStatement(QUERY_SCHEMAS);
            prepareQuery.setObject(1, (Object)catalog.toUpperCase());
            prepareQuery.setObject(2, (Object)schemaPattern.toUpperCase());
            results = (ResultSetImpl)prepareQuery.executeQuery();
            while (results.next()) {
                currentRow = new ArrayList<Object>(2);
                for (int i = 0; i < 2; ++i) {
                    currentRow.add(results.getObject(i + 1));
                }
                records.add(currentRow);
            }
            rmetadata = results.getMetaData();
            logger.fine(JDBCPlugin.Util.getString("MMDatabaseMetadata.getschema_success"));
            currentRow = this.dummyStatement().createResultSet(records, rmetadata);
            return currentRow;
        }
        catch (Exception e) {
            throw TeiidSQLException.create(e, JDBCPlugin.Util.getString("MMDatabaseMetadata.getschema_error", e.getMessage()));
        }
        finally {
            if (prepareQuery != null) {
                prepareQuery.close();
            }
        }
    }

    @Override
    public boolean generatedKeyAlwaysReturned() throws SQLException {
        return false;
    }

    @Override
    public ResultSet getPseudoColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    private static final class RUNTIME_MODEL {
        public static final String VIRTUAL_MODEL_NAME = "SYS";

        private RUNTIME_MODEL() {
        }
    }
}

