/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer.relational.rules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryPlannerException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TempMetadataAdapter;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.SourceCapabilities;
import org.teiid.query.optimizer.relational.OptimizerRule;
import org.teiid.query.optimizer.relational.RuleStack;
import org.teiid.query.optimizer.relational.plantree.NodeConstants;
import org.teiid.query.optimizer.relational.plantree.NodeEditor;
import org.teiid.query.optimizer.relational.plantree.PlanNode;
import org.teiid.query.optimizer.relational.rules.CapabilitiesUtil;
import org.teiid.query.optimizer.relational.rules.CriteriaCapabilityValidatorVisitor;
import org.teiid.query.optimizer.relational.rules.FrameUtil;
import org.teiid.query.optimizer.relational.rules.JoinUtil;
import org.teiid.query.optimizer.relational.rules.RuleChooseJoinStrategy;
import org.teiid.query.optimizer.relational.rules.RuleConstants;
import org.teiid.query.optimizer.relational.rules.RulePlaceAccess;
import org.teiid.query.optimizer.relational.rules.RulePushAggregates;
import org.teiid.query.optimizer.relational.rules.RulePushLimit;
import org.teiid.query.optimizer.relational.rules.RulePushSelectCriteria;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.processor.relational.AccessNode;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.CompareCriteria;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.ExistsCriteria;
import org.teiid.query.sql.lang.JoinType;
import org.teiid.query.sql.lang.OrderBy;
import org.teiid.query.sql.lang.OrderByItem;
import org.teiid.query.sql.lang.SetQuery;
import org.teiid.query.sql.lang.SourceHint;
import org.teiid.query.sql.lang.SubqueryContainer;
import org.teiid.query.sql.symbol.AggregateSymbol;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.ScalarSubquery;
import org.teiid.query.sql.util.SymbolMap;
import org.teiid.query.sql.visitor.AggregateSymbolCollectorVisitor;
import org.teiid.query.sql.visitor.ValueIteratorProviderCollectorVisitor;
import org.teiid.query.util.CommandContext;
import org.teiid.translator.ExecutionFactory;

public final class RuleRaiseAccess
implements OptimizerRule {
    @Override
    public PlanNode execute(PlanNode plan, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, RuleStack rules, AnalysisRecord analysisRecord, CommandContext context) throws QueryPlannerException, QueryMetadataException, TeiidComponentException {
        boolean afterJoinPlanning = !rules.contains(RuleConstants.PLAN_JOINS);
        for (PlanNode accessNode : NodeEditor.findAllNodes(plan, 1)) {
            PlanNode newRoot;
            while ((newRoot = RuleRaiseAccess.raiseAccessNode(plan, accessNode, metadata, capFinder, afterJoinPlanning, analysisRecord, context)) != null) {
                plan = newRoot;
            }
        }
        return plan;
    }

    static PlanNode raiseAccessNode(PlanNode rootNode, PlanNode accessNode, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, boolean afterJoinPlanning, AnalysisRecord record, CommandContext context) throws QueryPlannerException, QueryMetadataException, TeiidComponentException {
        PlanNode parentNode = accessNode.getParent();
        if (parentNode == null) {
            return null;
        }
        Object modelID = RuleRaiseAccess.getModelIDFromAccess(accessNode, metadata);
        if (modelID == null) {
            return null;
        }
        switch (parentNode.getType()) {
            case 4: {
                modelID = RuleRaiseAccess.canRaiseOverJoin(modelID, parentNode, metadata, capFinder, afterJoinPlanning, record, context);
                if (modelID != null && RuleRaiseAccess.checkConformedSubqueries(accessNode, parentNode, true)) {
                    RuleRaiseAccess.raiseAccessOverJoin(parentNode, accessNode, modelID, capFinder, metadata, true);
                    return rootNode;
                }
                return null;
            }
            case 8: {
                List projectCols = (List)parentNode.getProperty(NodeConstants.Info.PROJECT_COLS);
                for (int i = 0; i < projectCols.size(); ++i) {
                    Expression symbol = (Expression)projectCols.get(i);
                    if (RuleRaiseAccess.canPushSymbol(symbol, true, modelID, metadata, capFinder, record)) continue;
                    return null;
                }
                if (FrameUtil.isProcedure(parentNode)) {
                    return null;
                }
                PlanNode orderBy = NodeEditor.findParent(parentNode, 32, 64);
                if (orderBy != null && orderBy.hasBooleanProperty(NodeConstants.Info.UNRELATED_SORT) && !RuleRaiseAccess.canRaiseOverSort(accessNode, metadata, capFinder, orderBy, record, false)) {
                    return null;
                }
                if (accessNode.hasBooleanProperty(NodeConstants.Info.IS_MULTI_SOURCE)) {
                    ArrayList windowFunctions = new ArrayList(2);
                    for (Expression ex : projectCols) {
                        AggregateSymbolCollectorVisitor.getAggregates(ex, null, null, null, windowFunctions, null);
                        if (windowFunctions.isEmpty()) continue;
                        return null;
                    }
                }
                return RuleRaiseAccess.performRaise(rootNode, accessNode, parentNode);
            }
            case 2: {
                if (!CapabilitiesUtil.supportsSelectDistinct(modelID, metadata, capFinder)) {
                    parentNode.recordDebugAnnotation("distinct is not supported by source", modelID, "cannot push dupremove", record, metadata);
                    return null;
                }
                if (!RuleRaiseAccess.supportsDistinct(metadata, parentNode, accessNode.hasBooleanProperty(NodeConstants.Info.IS_MULTI_SOURCE))) {
                    parentNode.recordDebugAnnotation("not all columns are comparable at the source", modelID, "cannot push dupremove", record, metadata);
                    return null;
                }
                return RuleRaiseAccess.performRaise(rootNode, accessNode, parentNode);
            }
            case 32: {
                if (RuleRaiseAccess.canRaiseOverSort(accessNode, metadata, capFinder, parentNode, record, false)) {
                    return RuleRaiseAccess.performRaise(rootNode, accessNode, parentNode);
                }
                return null;
            }
            case 128: {
                LinkedHashSet<AggregateSymbol> aggregates = RulePushAggregates.collectAggregates(parentNode);
                if (RuleRaiseAccess.canRaiseOverGroupBy(parentNode, accessNode, aggregates, metadata, capFinder, record, true)) {
                    accessNode.getGroups().clear();
                    accessNode.getGroups().addAll(parentNode.getGroups());
                    return RuleRaiseAccess.performRaise(rootNode, accessNode, parentNode);
                }
                return null;
            }
            case 256: {
                if (!RuleRaiseAccess.canRaiseOverSetQuery(parentNode, metadata, capFinder)) {
                    return null;
                }
                String sourceName = null;
                boolean multiSource = false;
                for (PlanNode node : new ArrayList<PlanNode>(parentNode.getChildren())) {
                    multiSource |= accessNode.hasBooleanProperty(NodeConstants.Info.IS_MULTI_SOURCE);
                    if (sourceName == null) {
                        sourceName = (String)accessNode.getProperty(NodeConstants.Info.SOURCE_NAME);
                    }
                    if (node == accessNode) continue;
                    RuleRaiseAccess.combineSourceHints(accessNode, node);
                    RuleRaiseAccess.combineConformedSources(accessNode, node);
                    NodeEditor.removeChildNode(parentNode, node);
                }
                accessNode.getGroups().clear();
                if (multiSource) {
                    accessNode.setProperty(NodeConstants.Info.IS_MULTI_SOURCE, true);
                } else if (sourceName != null) {
                    accessNode.setProperty(NodeConstants.Info.SOURCE_NAME, sourceName);
                }
                return RuleRaiseAccess.performRaise(rootNode, accessNode, parentNode);
            }
            case 16: {
                JoinType jt;
                if (parentNode.hasBooleanProperty(NodeConstants.Info.IS_DEPENDENT_SET)) {
                    return null;
                }
                if (RuleRaiseAccess.canRaiseOverSelect(accessNode, metadata, capFinder, parentNode, record)) {
                    RulePushSelectCriteria.satisfyConditions(parentNode, accessNode, metadata);
                    return RuleRaiseAccess.performRaise(rootNode, accessNode, parentNode);
                }
                if (parentNode.getParent() == null) {
                    return null;
                }
                PlanNode selectRoot = parentNode;
                while (selectRoot.getParent() != null && selectRoot.getParent().getType() == 16) {
                    selectRoot = selectRoot.getParent();
                }
                if (selectRoot.getParent() == null || (selectRoot.getParent().getType() & 0x88) == selectRoot.getParent().getType()) {
                    return null;
                }
                PlanNode grandParent = selectRoot.getParent();
                boolean isLeft = false;
                boolean bl = isLeft = grandParent.getFirstChild() == selectRoot;
                if (grandParent.getType() == 4 && ((jt = (JoinType)grandParent.getProperty(NodeConstants.Info.JOIN_TYPE)) == JoinType.JOIN_FULL_OUTER || jt == JoinType.JOIN_LEFT_OUTER && !isLeft)) {
                    return null;
                }
                grandParent.removeChild(selectRoot);
                if (isLeft) {
                    grandParent.addFirstChild(accessNode);
                } else {
                    grandParent.addLastChild(accessNode);
                }
                PlanNode newParent = grandParent.getParent();
                PlanNode newRoot = RuleRaiseAccess.raiseAccessNode(rootNode, accessNode, metadata, capFinder, afterJoinPlanning, record, context);
                if (newRoot == null) {
                    parentNode.addFirstChild(accessNode);
                    if (isLeft) {
                        grandParent.addFirstChild(selectRoot);
                    } else {
                        grandParent.addLastChild(selectRoot);
                    }
                } else {
                    accessNode = grandParent.getParent();
                    if (newParent != null) {
                        boolean bl2 = isLeft = newParent.getFirstChild() == accessNode;
                        if (isLeft) {
                            newParent.addFirstChild(selectRoot);
                        } else {
                            newParent.addLastChild(selectRoot);
                        }
                    } else {
                        newRoot = selectRoot;
                    }
                    parentNode.addFirstChild(accessNode);
                    return newRoot;
                }
                return null;
            }
            case 64: {
                if (parentNode.hasCollectionProperty(NodeConstants.Info.ACCESS_PATTERNS)) {
                    return null;
                }
                SymbolMap references = (SymbolMap)parentNode.getProperty(NodeConstants.Info.CORRELATED_REFERENCES);
                if (references != null) {
                    return null;
                }
                PlanNode parentProject = NodeEditor.findParent(parentNode, 8);
                GroupSymbol intoGroup = (GroupSymbol)parentProject.getProperty(NodeConstants.Info.INTO_GROUP);
                if (intoGroup != null && parentProject.getParent() == null) {
                    if (!parentProject.hasProperty(NodeConstants.Info.CONSTRAINT) && CapabilitiesUtil.supports(SourceCapabilities.Capability.INSERT_WITH_QUERYEXPRESSION, modelID, metadata, capFinder) && CapabilitiesUtil.isSameConnector(modelID, metadata.getModelID(intoGroup.getMetadataID()), metadata, capFinder)) {
                        rootNode = RuleRaiseAccess.performRaise(rootNode, accessNode, parentNode);
                        return RuleRaiseAccess.performRaise(rootNode, accessNode, parentProject);
                    }
                    return null;
                }
                if (!CapabilitiesUtil.supportsInlineView(modelID, metadata, capFinder)) {
                    return null;
                }
                if (FrameUtil.getNonQueryCommand(accessNode) != null || FrameUtil.getNestedPlan(accessNode) != null) {
                    return null;
                }
                parentNode.setProperty(NodeConstants.Info.INLINE_VIEW, Boolean.TRUE);
                accessNode.getGroups().clear();
                accessNode.addGroups(parentNode.getGroups());
                RulePlaceAccess.copyDependentHints(parentNode, accessNode);
                return RuleRaiseAccess.performRaise(rootNode, accessNode, parentNode);
            }
            case 1024: {
                return RulePushLimit.raiseAccessOverLimit(rootNode, accessNode, metadata, capFinder, parentNode, record);
            }
        }
        return null;
    }

    private static void combineSourceHints(PlanNode accessNode, PlanNode parentNode) {
        accessNode.setProperty(NodeConstants.Info.SOURCE_HINT, SourceHint.combine((SourceHint)parentNode.getProperty(NodeConstants.Info.SOURCE_HINT), (SourceHint)accessNode.getProperty(NodeConstants.Info.SOURCE_HINT)));
    }

    static boolean canRaiseOverGroupBy(PlanNode groupNode, PlanNode accessNode, Collection<? extends AggregateSymbol> aggregates, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, AnalysisRecord record, boolean considerMultiSource) throws QueryMetadataException, TeiidComponentException {
        Object modelID = RuleRaiseAccess.getModelIDFromAccess(accessNode, metadata);
        if (modelID == null) {
            return false;
        }
        if (considerMultiSource && accessNode.hasBooleanProperty(NodeConstants.Info.IS_MULTI_SOURCE)) {
            return false;
        }
        List groupCols = (List)groupNode.getProperty(NodeConstants.Info.GROUP_COLS);
        if (!CapabilitiesUtil.supportsAggregates(groupCols, modelID, metadata, capFinder)) {
            groupNode.recordDebugAnnotation("group by is not supported by source", modelID, "cannot push group by", record, metadata);
            return false;
        }
        if (CapabilitiesUtil.supports(SourceCapabilities.Capability.QUERY_ONLY_SINGLE_TABLE_GROUP_BY, modelID, metadata, capFinder) && !NodeEditor.findAllNodes(groupNode, 4, 64).isEmpty()) {
            groupNode.recordDebugAnnotation("joined group by is not supported by source", modelID, "cannot push group by", record, metadata);
            return false;
        }
        if (groupCols != null) {
            for (Expression expression : groupCols) {
                if (RuleRaiseAccess.canPushSymbol(expression, false, modelID, metadata, capFinder, record)) continue;
                return false;
            }
        }
        if (aggregates != null) {
            for (AggregateSymbol aggregateSymbol : aggregates) {
                if (CriteriaCapabilityValidatorVisitor.canPushLanguageObject(aggregateSymbol, modelID, metadata, capFinder, record)) continue;
                return false;
            }
        }
        if (!CapabilitiesUtil.checkElementsAreSearchable(groupCols, metadata, 2)) {
            groupNode.recordDebugAnnotation("non-searchable group by column", modelID, "cannot push group by", record, metadata);
            return false;
        }
        if (groupNode.hasBooleanProperty(NodeConstants.Info.ROLLUP) && !CapabilitiesUtil.supports(SourceCapabilities.Capability.QUERY_GROUP_BY_ROLLUP, modelID, metadata, capFinder)) {
            groupNode.recordDebugAnnotation("source does not support rollup", modelID, "cannot push group by", record, metadata);
            return false;
        }
        return true;
    }

    static boolean canRaiseOverSort(PlanNode accessNode, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, PlanNode parentNode, AnalysisRecord record, boolean compensateForUnrelated) throws QueryMetadataException, TeiidComponentException {
        Object modelID = RuleRaiseAccess.getModelIDFromAccess(accessNode, metadata);
        if (modelID == null) {
            return false;
        }
        List<OrderByItem> sortCols = ((OrderBy)parentNode.getProperty(NodeConstants.Info.SORT_ORDER)).getOrderByItems();
        for (OrderByItem symbol : sortCols) {
            if (!RuleRaiseAccess.canPushSymbol(symbol.getSymbol(), true, modelID, metadata, capFinder, record)) {
                return false;
            }
            if (CapabilitiesUtil.supportsNullOrdering(metadata, capFinder, modelID, symbol)) continue;
            return false;
        }
        if (accessNode.getLastChild() != null) {
            if (accessNode.getLastChild().getType() == 256) {
                return CapabilitiesUtil.supportsSetQueryOrderBy(modelID, metadata, capFinder);
            }
            if (accessNode.getLastChild().getType() == 1024) {
                return false;
            }
        }
        if (!CapabilitiesUtil.checkElementsAreSearchable(sortCols, metadata, 2)) {
            return false;
        }
        if (!CapabilitiesUtil.supportsOrderBy(modelID, metadata, capFinder)) {
            return false;
        }
        if (parentNode.hasBooleanProperty(NodeConstants.Info.UNRELATED_SORT) && !CapabilitiesUtil.supports(SourceCapabilities.Capability.QUERY_ORDERBY_UNRELATED, modelID, metadata, capFinder) && NodeEditor.findParent(accessNode, 8, 64) == null && !compensateForUnrelated) {
            return false;
        }
        return !accessNode.hasBooleanProperty(NodeConstants.Info.IS_MULTI_SOURCE);
    }

    static boolean canRaiseOverSelect(PlanNode accessNode, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, PlanNode parentNode, AnalysisRecord record) throws QueryMetadataException, TeiidComponentException, QueryPlannerException {
        if (parentNode.hasBooleanProperty(NodeConstants.Info.IS_PHANTOM)) {
            return true;
        }
        Object modelID = RuleRaiseAccess.getModelIDFromAccess(accessNode, metadata);
        if (modelID == null) {
            return false;
        }
        if (parentNode.hasBooleanProperty(NodeConstants.Info.IS_HAVING) && !CapabilitiesUtil.supports(SourceCapabilities.Capability.QUERY_HAVING, modelID, metadata, capFinder) && !CapabilitiesUtil.supports(SourceCapabilities.Capability.QUERY_FROM_INLINE_VIEWS, modelID, metadata, capFinder)) {
            parentNode.recordDebugAnnotation("having is not supported by source", modelID, "cannot push having", record, metadata);
            return false;
        }
        PlanNode limitNode = NodeEditor.findNodePreOrder(accessNode, 1024, 64);
        if (limitNode != null && FrameUtil.isOrderedOrStrictLimit(limitNode)) {
            return false;
        }
        Criteria crit = (Criteria)parentNode.getProperty(NodeConstants.Info.SELECT_CRITERIA);
        if (!CriteriaCapabilityValidatorVisitor.canPushLanguageObject(crit, modelID, metadata, capFinder, record)) {
            return false;
        }
        return accessNode.getFirstChild() == null || accessNode.getFirstChild().getType() != 256;
    }

    static boolean canPushSymbol(Expression symbol, boolean inSelectClause, Object modelID, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, AnalysisRecord record) throws TeiidComponentException, QueryMetadataException {
        Expression expr = SymbolMap.getExpression(symbol);
        if (!CriteriaCapabilityValidatorVisitor.canPushLanguageObject(expr, modelID, metadata, capFinder, record)) {
            return false;
        }
        return !inSelectClause || expr instanceof ElementSymbol || expr instanceof AggregateSymbol || CapabilitiesUtil.supportsSelectExpression(modelID, metadata, capFinder);
    }

    static PlanNode performRaise(PlanNode rootNode, PlanNode accessNode, PlanNode parentNode) {
        if (!RuleRaiseAccess.checkConformedSubqueries(accessNode, parentNode, true)) {
            return rootNode;
        }
        accessNode.removeProperty((Object)NodeConstants.Info.EST_CARDINALITY);
        RuleRaiseAccess.combineSourceHints(accessNode, parentNode);
        NodeEditor.removeChildNode(parentNode, accessNode);
        parentNode.addAsParent(accessNode);
        PlanNode grandparentNode = accessNode.getParent();
        if (grandparentNode != null) {
            return rootNode;
        }
        return accessNode;
    }

    static boolean checkConformedSubqueries(PlanNode accessNode, PlanNode parentNode, boolean updateConformed) {
        HashSet<Object> conformedSources = (HashSet<Object>)accessNode.getProperty(NodeConstants.Info.CONFORMED_SOURCES);
        if (conformedSources == null) {
            return true;
        }
        conformedSources = new HashSet<Object>(conformedSources);
        for (SubqueryContainer<?> container : parentNode.getSubqueryContainers()) {
            AccessNode aNode;
            ProcessorPlan plan;
            if (container instanceof ExistsCriteria && ((ExistsCriteria)container).shouldEvaluate() || container instanceof ScalarSubquery && ((ScalarSubquery)container).shouldEvaluate() || (plan = ((Command)container.getCommand()).getProcessorPlan()) == null || (aNode = CriteriaCapabilityValidatorVisitor.getAccessNode(plan)) == null) continue;
            Set<Object> conformedTo = aNode.getConformedTo();
            if (conformedTo == null) {
                conformedSources.retainAll(Collections.singletonList(aNode.getModelId()));
            } else {
                conformedSources.retainAll(conformedTo);
            }
            if (!conformedSources.isEmpty()) continue;
            return false;
        }
        if (updateConformed) {
            RuleRaiseAccess.updateConformed(accessNode, conformedSources);
        }
        return true;
    }

    private static Object canRaiseOverJoin(Object modelId, PlanNode joinNode, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, boolean afterJoinPlanning, AnalysisRecord record, CommandContext context) throws QueryMetadataException, TeiidComponentException {
        JoinType jt;
        List crits = (List)joinNode.getProperty(NodeConstants.Info.JOIN_CRITERIA);
        JoinType type = (JoinType)joinNode.getProperty(NodeConstants.Info.JOIN_TYPE);
        if (!afterJoinPlanning && type == JoinType.JOIN_CROSS && joinNode.getParent().getType() == 4 && !(jt = (JoinType)joinNode.getParent().getProperty(NodeConstants.Info.JOIN_TYPE)).isOuter()) {
            return null;
        }
        if (joinNode.getProperty(NodeConstants.Info.DEPENDENT_VALUE_SOURCE) != null) {
            return null;
        }
        if (joinNode.hasCollectionProperty(NodeConstants.Info.ACCESS_PATTERNS)) {
            return null;
        }
        if (type.isOuter() && CapabilitiesUtil.getSupportedJoinCriteria(modelId, metadata, capFinder) != ExecutionFactory.SupportedJoinCriteria.ANY) {
            PlanNode critNode = NodeEditor.findNodePreOrder(joinNode.getLastChild(), 16, 64);
            if (critNode != null) {
                return null;
            }
            if (type == JoinType.JOIN_FULL_OUTER && (critNode = NodeEditor.findNodePreOrder(joinNode.getFirstChild(), 16, 64)) != null) {
                return null;
            }
        }
        return RuleRaiseAccess.canRaiseOverJoin(joinNode.getChildren(), metadata, capFinder, crits, type, record, context, afterJoinPlanning);
    }

    static Object canRaiseOverJoin(List<PlanNode> children, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, List<Criteria> crits, JoinType type, AnalysisRecord record, CommandContext context, boolean considerOptional) throws QueryMetadataException, TeiidComponentException {
        if (children.size() != 2) {
            return null;
        }
        Object modelID = null;
        boolean multiSource = false;
        HashSet<Object> groupIDs = new HashSet<Object>();
        int groupCount = 0;
        LinkedList<CompareCriteria> thetaCriteria = new LinkedList<CompareCriteria>();
        ExecutionFactory.SupportedJoinCriteria sjc = null;
        for (PlanNode childNode : children) {
            if (childNode.getType() != 1 || childNode.hasCollectionProperty(NodeConstants.Info.ACCESS_PATTERNS)) {
                return null;
            }
            Object accessModelID = RuleRaiseAccess.getModelIDFromAccess(childNode, metadata);
            if (accessModelID == null) {
                return null;
            }
            groupCount += childNode.getGroups().size();
            boolean supportsSelfJoins = CapabilitiesUtil.supportsSelfJoins(accessModelID, metadata, capFinder);
            if (!supportsSelfJoins) {
                for (GroupSymbol groupSymbol : childNode.getGroups()) {
                    Object groupID = groupSymbol.getMetadataID();
                    if (groupIDs.add(groupID)) continue;
                    return null;
                }
            }
            if (modelID == null) {
                if (!CapabilitiesUtil.supportsJoin(accessModelID, type, metadata, capFinder)) {
                    return null;
                }
                sjc = CapabilitiesUtil.getSupportedJoinCriteria(accessModelID, metadata, capFinder);
                if (!(type.isOuter() || CapabilitiesUtil.supports(SourceCapabilities.Capability.QUERY_FROM_JOIN_INNER, accessModelID, metadata, capFinder) || crits == null || crits.isEmpty())) {
                    if (!CapabilitiesUtil.supports(SourceCapabilities.Capability.CRITERIA_ISNULL, accessModelID, metadata, capFinder) || !CapabilitiesUtil.supports(SourceCapabilities.Capability.CRITERIA_NOT, accessModelID, metadata, capFinder)) {
                        return null;
                    }
                    if (sjc == ExecutionFactory.SupportedJoinCriteria.ANY) {
                        boolean valid = false;
                        for (Criteria crit : crits) {
                            CompareCriteria cc;
                            if (!(crit instanceof CompareCriteria) || !((cc = (CompareCriteria)crit).getLeftExpression() instanceof ElementSymbol) && !(cc.getRightExpression() instanceof ElementSymbol)) continue;
                            valid = true;
                        }
                        if (!valid) {
                            return null;
                        }
                    }
                }
                if (crits != null && !crits.isEmpty()) {
                    for (Criteria crit : crits) {
                        if (!RuleRaiseAccess.isSupportedJoinCriteria(sjc, crit, accessModelID, metadata, capFinder, record)) {
                            CompareCriteria cc;
                            if (crit instanceof CompareCriteria && (cc = (CompareCriteria)crit).isOptional()) {
                                cc.setOptional(true);
                                continue;
                            }
                            return null;
                        }
                        if (!(crit instanceof CompareCriteria)) continue;
                        thetaCriteria.add((CompareCriteria)crit);
                    }
                    if (sjc == ExecutionFactory.SupportedJoinCriteria.KEY) {
                        PlanNode left = children.get(0);
                        PlanNode right = children.get(1);
                        if (left.getGroups().size() != 1) {
                            if (right.getGroups().size() != 1) {
                                return null;
                            }
                            if (type != JoinType.JOIN_INNER) {
                                return null;
                            }
                            left = children.get(1);
                            right = children.get(0);
                        }
                        LinkedList<Expression> leftExpressions = new LinkedList<Expression>();
                        LinkedList<Expression> rightExpressions = new LinkedList<Expression>();
                        RuleChooseJoinStrategy.separateCriteria(left.getGroups(), right.getGroups(), leftExpressions, rightExpressions, crits, new LinkedList<Criteria>());
                        ArrayList<Object> leftIds = new ArrayList<Object>(leftExpressions.size());
                        ArrayList<Object> rightIds = new ArrayList<Object>(rightExpressions.size());
                        for (Expression expr : leftExpressions) {
                            if (!(expr instanceof ElementSymbol)) continue;
                            leftIds.add(((ElementSymbol)expr).getMetadataID());
                        }
                        GroupSymbol rightGroup = null;
                        for (Expression expr : rightExpressions) {
                            if (!(expr instanceof ElementSymbol)) continue;
                            ElementSymbol es = (ElementSymbol)expr;
                            if (rightGroup == null) {
                                rightGroup = es.getGroupSymbol();
                            } else if (!rightGroup.equals(es.getGroupSymbol())) {
                                return null;
                            }
                            rightIds.add(es.getMetadataID());
                        }
                        if (rightGroup == null) {
                            return null;
                        }
                        if (!RuleRaiseAccess.matchesForeignKey(metadata, leftIds, rightIds, left.getGroups().iterator().next(), true, !type.isOuter() || type == JoinType.JOIN_LEFT_OUTER) && !RuleRaiseAccess.matchesForeignKey(metadata, rightIds, leftIds, rightGroup, true, !type.isOuter())) {
                            return null;
                        }
                    }
                }
                if (sjc != ExecutionFactory.SupportedJoinCriteria.ANY && thetaCriteria.isEmpty()) {
                    return null;
                }
                modelID = accessModelID;
                multiSource = childNode.hasBooleanProperty(NodeConstants.Info.IS_MULTI_SOURCE);
                continue;
            }
            if (!CapabilitiesUtil.isSameConnector(modelID, accessModelID, metadata, capFinder) && !RuleRaiseAccess.isConformed(metadata, capFinder, (Set)childNode.getProperty(NodeConstants.Info.CONFORMED_SOURCES), modelID, (Set)children.get(0).getProperty(NodeConstants.Info.CONFORMED_SOURCES), accessModelID)) {
                return null;
            }
            if (!multiSource && !childNode.hasBooleanProperty(NodeConstants.Info.IS_MULTI_SOURCE) || context.getOptions().isImplicitMultiSourceJoin()) continue;
            boolean multiSourceOther = childNode.hasBooleanProperty(NodeConstants.Info.IS_MULTI_SOURCE);
            if (multiSource && multiSourceOther && (type == JoinType.JOIN_ANTI_SEMI || type == JoinType.JOIN_CROSS)) {
                return null;
            }
            ArrayList<Expression> leftExpressions = new ArrayList<Expression>();
            ArrayList<Expression> rightExpressions = new ArrayList<Expression>();
            RuleChooseJoinStrategy.separateCriteria(children.get(0).getGroups(), children.get(1).getGroups(), leftExpressions, rightExpressions, crits, new LinkedList<Criteria>());
            boolean needsOtherCrit = sjc != ExecutionFactory.SupportedJoinCriteria.ANY;
            boolean partitioned = !multiSource || !multiSourceOther;
            for (int i = 0; i < leftExpressions.size() && (!partitioned || needsOtherCrit); ++i) {
                boolean multi;
                boolean bl = multi = RuleRaiseAccess.isMultiSourceColumn(metadata, leftExpressions.get(i), children.get(0)) && RuleRaiseAccess.isMultiSourceColumn(metadata, rightExpressions.get(i), children.get(1));
                if (multi) {
                    partitioned = true;
                    continue;
                }
                needsOtherCrit = false;
            }
            if (!needsOtherCrit && partitioned) continue;
            return null;
        }
        int maxGroups = CapabilitiesUtil.getMaxFromGroups(modelID, metadata, capFinder);
        if (maxGroups != -1 && maxGroups < groupCount) {
            return null;
        }
        if (crits != null && !crits.isEmpty()) {
            if (considerOptional) {
                for (CompareCriteria criteria : thetaCriteria) {
                    criteria.setOptional(false);
                }
            } else {
                boolean hasCriteria = false;
                for (CompareCriteria criteria : thetaCriteria) {
                    if (criteria.getIsOptional() != null && criteria.isOptional()) continue;
                    hasCriteria = true;
                    break;
                }
                if (!hasCriteria) {
                    return null;
                }
            }
        }
        return modelID;
    }

    static boolean isConformed(QueryMetadataInterface metadata, CapabilitiesFinder capFinder, Set<Object> sources, Object id, Set<Object> sources1, Object id1) throws QueryMetadataException, TeiidComponentException, AssertionError {
        if (sources == null) {
            if (sources1 == null) {
                return false;
            }
            return sources1.contains(id);
        }
        if (sources1 == null) {
            return sources.contains(id1);
        }
        return !Collections.disjoint(sources, sources1);
    }

    static boolean isSupportedJoinCriteria(ExecutionFactory.SupportedJoinCriteria sjc, Criteria crit, Object accessModelID, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, AnalysisRecord record) throws QueryMetadataException, TeiidComponentException {
        if (!CriteriaCapabilityValidatorVisitor.canPushLanguageObject(crit, accessModelID, metadata, capFinder, record, true)) {
            return false;
        }
        if (sjc == ExecutionFactory.SupportedJoinCriteria.ANY) {
            boolean subqueryOn = CapabilitiesUtil.supports(SourceCapabilities.Capability.CRITERIA_ON_SUBQUERY, accessModelID, metadata, capFinder);
            return subqueryOn || ValueIteratorProviderCollectorVisitor.getValueIteratorProviders(crit).isEmpty();
        }
        if (!(crit instanceof CompareCriteria)) {
            return false;
        }
        CompareCriteria cc = (CompareCriteria)crit;
        if (!(cc.getLeftExpression() instanceof ElementSymbol) || !(cc.getRightExpression() instanceof ElementSymbol)) {
            return false;
        }
        if (sjc == ExecutionFactory.SupportedJoinCriteria.THETA) {
            return true;
        }
        return cc.getOperator() == 1;
    }

    public static boolean matchesForeignKey(QueryMetadataInterface metadata, Collection<Object> leftIds, Collection<Object> rightIds, GroupSymbol leftGroup, boolean exact, boolean inner) throws TeiidComponentException, QueryMetadataException {
        Collection fks = metadata.getForeignKeysInGroup(leftGroup.getMetadataID());
        for (Object fk : fks) {
            String allow;
            if (exact && (allow = metadata.getExtensionProperty(fk, "{http://www.teiid.org/ext/relational/2012}allow-join", false)) != null) {
                boolean allowed = true;
                if (!Boolean.valueOf(allow).booleanValue() && (!allow.equalsIgnoreCase("INNER") || !inner)) continue;
            }
            List fkColumns = metadata.getElementIDsInKey(fk);
            if (exact && leftIds.size() != fkColumns.size() || !leftIds.containsAll(fkColumns)) continue;
            Object pk = metadata.getPrimaryKeyIDForForeignKeyID(fk);
            List pkColumns = metadata.getElementIDsInKey(pk);
            if (exact && rightIds.size() != pkColumns.size() || !rightIds.containsAll(pkColumns)) continue;
            return true;
        }
        return false;
    }

    static PlanNode raiseAccessOverJoin(PlanNode joinNode, PlanNode accessNode, Object modelID, CapabilitiesFinder capFinder, QueryMetadataInterface metadata, boolean insert) throws QueryMetadataException, TeiidComponentException {
        String sourceName;
        PlanNode leftAccess = joinNode.getFirstChild();
        PlanNode rightAccess = joinNode.getLastChild();
        boolean switchChildren = false;
        if (leftAccess.getGroups().size() != 1 && joinNode.getProperty(NodeConstants.Info.JOIN_TYPE) == JoinType.JOIN_INNER && CapabilitiesUtil.getSupportedJoinCriteria(modelID, metadata, capFinder) == ExecutionFactory.SupportedJoinCriteria.KEY) {
            switchChildren = true;
        }
        PlanNode other = leftAccess == accessNode ? rightAccess : leftAccess;
        NodeEditor.removeChildNode(joinNode, leftAccess);
        NodeEditor.removeChildNode(joinNode, rightAccess);
        RuleRaiseAccess.combineConformedSources(accessNode, other);
        joinNode.setProperty(NodeConstants.Info.MODEL_ID, modelID);
        accessNode.addGroups(other.getGroups());
        RulePlaceAccess.copyDependentHints(other, accessNode);
        RulePlaceAccess.copyDependentHints(joinNode, other);
        RuleRaiseAccess.combineSourceHints(accessNode, other);
        if (other.hasBooleanProperty(NodeConstants.Info.IS_MULTI_SOURCE)) {
            accessNode.setProperty(NodeConstants.Info.IS_MULTI_SOURCE, Boolean.TRUE);
        }
        if ((sourceName = (String)other.getProperty(NodeConstants.Info.SOURCE_NAME)) != null) {
            accessNode.setProperty(NodeConstants.Info.SOURCE_NAME, sourceName);
        }
        if (insert) {
            joinNode.addAsParent(accessNode);
        } else {
            accessNode.addFirstChild(joinNode);
        }
        if (switchChildren) {
            JoinUtil.swapJoinChildren(joinNode);
        }
        return accessNode;
    }

    private static void combineConformedSources(PlanNode accessNode, PlanNode other) {
        Set conformedSources = (Set)accessNode.getProperty(NodeConstants.Info.CONFORMED_SOURCES);
        Set conformedSourcesOther = (Set)other.getProperty(NodeConstants.Info.CONFORMED_SOURCES);
        if (conformedSources == null || conformedSources.isEmpty() || conformedSourcesOther == null || conformedSourcesOther.isEmpty()) {
            accessNode.setProperty(NodeConstants.Info.CONFORMED_SOURCES, null);
            return;
        }
        conformedSources.retainAll(conformedSourcesOther);
        RuleRaiseAccess.updateConformed(accessNode, conformedSources);
    }

    private static void updateConformed(PlanNode accessNode, Set<Object> conformedSources) throws AssertionError {
        if (conformedSources.isEmpty()) {
            throw new AssertionError((Object)"Planning error, no conformed sources in common.");
        }
        if (!conformedSources.contains(accessNode.getProperty(NodeConstants.Info.MODEL_ID))) {
            accessNode.setProperty(NodeConstants.Info.MODEL_ID, conformedSources.iterator().next());
        }
        if (conformedSources.size() == 1) {
            accessNode.setProperty(NodeConstants.Info.CONFORMED_SOURCES, null);
        }
    }

    static Object getModelIDFromAccess(PlanNode accessNode, QueryMetadataInterface metadata) throws QueryMetadataException, TeiidComponentException {
        Object accessModelID = accessNode.getProperty(NodeConstants.Info.MODEL_ID);
        if (accessModelID == null && accessNode.getGroups().size() > 0) {
            GroupSymbol group = accessNode.getGroups().iterator().next();
            if (metadata.isVirtualGroup(group.getMetadataID())) {
                if (metadata.isTemporaryTable(group.getMetadataID())) {
                    return TempMetadataAdapter.TEMP_MODEL;
                }
                return null;
            }
            accessModelID = metadata.getModelID(group.getMetadataID());
            accessNode.setProperty(NodeConstants.Info.MODEL_ID, accessModelID);
        }
        return accessModelID;
    }

    private static boolean canRaiseOverSetQuery(PlanNode setOpNode, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryMetadataException, TeiidComponentException {
        Object modelID = null;
        String sourceName = null;
        boolean multiSource = false;
        for (PlanNode childNode : setOpNode.getChildren()) {
            if (childNode.getType() != 1) {
                return false;
            }
            if (FrameUtil.getNonQueryCommand(childNode) != null || FrameUtil.getNestedPlan(childNode) != null) {
                return false;
            }
            Object accessModelID = RuleRaiseAccess.getModelIDFromAccess(childNode, metadata);
            if (accessModelID == null) {
                return false;
            }
            multiSource |= childNode.hasBooleanProperty(NodeConstants.Info.IS_MULTI_SOURCE);
            String name = (String)childNode.getProperty(NodeConstants.Info.SOURCE_NAME);
            if (modelID == null) {
                modelID = accessModelID;
                SetQuery.Operation op = (SetQuery.Operation)((Object)setOpNode.getProperty(NodeConstants.Info.SET_OPERATION));
                if (!CapabilitiesUtil.supportsSetOp(accessModelID, op, metadata, capFinder)) {
                    return false;
                }
                if (multiSource && op != SetQuery.Operation.UNION) {
                    return false;
                }
            } else if (!CapabilitiesUtil.isSameConnector(modelID, accessModelID, metadata, capFinder)) {
                return false;
            }
            if (!multiSource) {
                if (sourceName == null) {
                    sourceName = name;
                } else if (name != null && !sourceName.equals(name)) {
                    return false;
                }
            }
            if (setOpNode.hasBooleanProperty(NodeConstants.Info.USE_ALL) || RuleRaiseAccess.supportsDistinct(metadata, childNode, multiSource)) continue;
            return false;
        }
        return true;
    }

    static boolean supportsDistinct(QueryMetadataInterface metadata, PlanNode childNode, boolean multiSource) throws QueryMetadataException, TeiidComponentException {
        boolean partitioned;
        List project = (List)NodeEditor.findNodePreOrder(childNode, 8).getProperty(NodeConstants.Info.PROJECT_COLS);
        if (multiSource && !(partitioned = RuleRaiseAccess.isPartitioned(metadata, project, childNode))) {
            return false;
        }
        return CapabilitiesUtil.checkElementsAreSearchable(project, metadata, 2);
    }

    static boolean isPartitioned(QueryMetadataInterface metadata, Collection<? extends Expression> project, PlanNode node) throws QueryMetadataException, TeiidComponentException {
        boolean partitioned = false;
        for (Expression expression : project) {
            Expression ex = SymbolMap.getExpression(expression);
            if (ex.getType() != DataTypeManager.DefaultDataClasses.STRING || !RuleRaiseAccess.isMultiSourceColumn(metadata, ex, node)) continue;
            partitioned = true;
            break;
        }
        return partitioned;
    }

    private static boolean isMultiSourceColumn(QueryMetadataInterface metadata, Expression ex, PlanNode node) throws QueryMetadataException, TeiidComponentException {
        if (!(ex instanceof ElementSymbol)) {
            return false;
        }
        ElementSymbol es = (ElementSymbol)ex;
        if (metadata.isMultiSourceElement(es.getMetadataID())) {
            return true;
        }
        if (node == null || node.getFirstChild() == null) {
            return false;
        }
        if ((node = FrameUtil.findOriginatingNode(node.getFirstChild(), Collections.singleton(es.getGroupSymbol()))) == null || node.getType() != 64) {
            return false;
        }
        SymbolMap map = (SymbolMap)node.getProperty(NodeConstants.Info.SYMBOL_MAP);
        if (node.getChildren().isEmpty() || map == null) {
            return false;
        }
        PlanNode set = NodeEditor.findNodePreOrder(node.getFirstChild(), 256, 64);
        if (set == null) {
            ex = map.getMappedExpression(es);
            return RuleRaiseAccess.isMultiSourceColumn(metadata, ex, node.getFirstChild());
        }
        int index = map.getKeys().indexOf(ex);
        if (index == -1) {
            return false;
        }
        for (PlanNode child : set.getChildren()) {
            PlanNode project = NodeEditor.findNodePreOrder(child, 8, 64);
            if (project == null) {
                return false;
            }
            List cols = (List)project.getProperty(NodeConstants.Info.PROJECT_COLS);
            if (RuleRaiseAccess.isMultiSourceColumn(metadata, (Expression)cols.get(index), child)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "RaiseAccess";
    }
}

