/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.xml;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.teiid.core.TeiidComponentException;
import org.teiid.query.processor.xml.FakePlanExecutor;
import org.teiid.query.processor.xml.PlanExecutor;
import org.teiid.query.processor.xml.XMLContext;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.GroupSymbol;

public class TestXMLContext
extends TestCase {
    static String resultSetName = "ResultSet";

    public void testGetCurrentRow() throws Exception {
        XMLContext context = new XMLContext();
        List[] rows = new List[]{Arrays.asList("Lamp", new Integer(5), null), Arrays.asList("Screwdriver", new Integer(100), null), Arrays.asList("Goat", new Integer(4), null)};
        FakePlanExecutor executor = new FakePlanExecutor(resultSetName, rows);
        context.setResultSet(resultSetName, (PlanExecutor)executor);
        List currentRow = context.getCurrentRow(resultSetName);
        TestXMLContext.assertNull((Object)currentRow);
        currentRow = context.getNextRow(resultSetName);
        TestXMLContext.assertEquals(Arrays.asList("Lamp", new Integer(5), null), (Object)currentRow);
        currentRow = context.getCurrentRow(resultSetName);
        TestXMLContext.assertEquals(Arrays.asList("Lamp", new Integer(5), null), (Object)currentRow);
        currentRow = context.getCurrentRow(resultSetName);
        TestXMLContext.assertEquals(Arrays.asList("Lamp", new Integer(5), null), (Object)currentRow);
        context.removeResultSet(resultSetName);
        try {
            currentRow = context.getCurrentRow(resultSetName);
            TestXMLContext.fail((String)"must have failed because the results are removed.");
        }
        catch (TeiidComponentException e) {
            // empty catch block
        }
    }

    public void testGetCurrentRows() throws Exception {
        XMLContext parentContext = new XMLContext();
        XMLContext childContext = new XMLContext(parentContext);
        List[] rows1 = new List[]{Arrays.asList("Lamp", new Integer(5), null), Arrays.asList("Screwdriver", new Integer(100), null), Arrays.asList("Goat", new Integer(4), null)};
        List[] rows2 = new List[]{Arrays.asList("Lamp2", new Integer(54), null), Arrays.asList("Screwdriver2", new Integer(1000), null), Arrays.asList("Goat2", new Integer(43), null)};
        String results1 = "resultsOne";
        String results2 = "resultsTwo";
        FakePlanExecutor executor = new FakePlanExecutor(results1, rows1);
        parentContext.setResultSet(results1, (PlanExecutor)executor);
        parentContext.getNextRow(results1);
        executor = new FakePlanExecutor(results2, rows2);
        childContext.setResultSet(results2, (PlanExecutor)executor);
        childContext.getNextRow(results2);
        TestXMLContext.assertEquals(Arrays.asList("Lamp", new Integer(5), null), (Object)parentContext.getCurrentRow(results1));
        try {
            parentContext.getCurrentRow(results2);
            TestXMLContext.fail((String)"should fail to get child contexts results from parent..");
        }
        catch (TeiidComponentException e) {
            // empty catch block
        }
        TestXMLContext.assertEquals(Arrays.asList("Lamp", new Integer(5), null), (Object)childContext.getCurrentRow(results1));
        TestXMLContext.assertEquals(Arrays.asList("Lamp2", new Integer(54), null), (Object)childContext.getCurrentRow(results2));
        childContext.getNextRow(results2);
        TestXMLContext.assertEquals(Arrays.asList("Lamp", new Integer(5), null), (Object)childContext.getCurrentRow(results1));
        TestXMLContext.assertEquals(Arrays.asList("Screwdriver2", new Integer(1000), null), (Object)childContext.getCurrentRow(results2));
    }

    public void testGetCurrentRowRecursive() throws Exception {
        XMLContext parentContext = new XMLContext();
        XMLContext childContext = new XMLContext(parentContext);
        List[] rows1 = new List[]{Arrays.asList("Lamp", new Integer(5), null), Arrays.asList("Screwdriver", new Integer(100), null), Arrays.asList("Goat", new Integer(4), null)};
        List[] rows2 = new List[]{Arrays.asList("Lamp2", new Integer(54), null), Arrays.asList("Screwdriver2", new Integer(1000), null), Arrays.asList("Goat2", new Integer(43), null)};
        FakePlanExecutor executor = new FakePlanExecutor(resultSetName, rows1);
        parentContext.setResultSet(resultSetName, (PlanExecutor)executor);
        parentContext.getNextRow(resultSetName);
        executor = new FakePlanExecutor("FakeName", rows2);
        childContext.setResultSet(resultSetName, (PlanExecutor)executor);
        childContext.getNextRow(resultSetName);
        TestXMLContext.assertEquals(Arrays.asList("Lamp", new Integer(5), null), (Object)parentContext.getCurrentRow(resultSetName));
        TestXMLContext.assertEquals(Arrays.asList("Lamp2", new Integer(54), null), (Object)childContext.getCurrentRow(resultSetName));
    }

    public void testGetReferenceValues() throws Exception {
        XMLContext context = new XMLContext();
        String FOO = "Foo";
        String BAR = "Bar";
        ElementSymbol X = new ElementSymbol("Foo.X");
        ElementSymbol Y = new ElementSymbol("Foo.Y");
        GroupSymbol Foo = new GroupSymbol(FOO);
        X.setGroupSymbol(Foo);
        Y.setGroupSymbol(Foo);
        ElementSymbol AX = new ElementSymbol("Bar.X");
        ElementSymbol AY = new ElementSymbol("Bar.Y");
        GroupSymbol Bar = new GroupSymbol(BAR);
        AX.setGroupSymbol(Bar);
        AY.setGroupSymbol(Bar);
        List<Object> fooSchema = Arrays.asList(X, Y);
        List<Object> barSchema = Arrays.asList(AX, AY);
        List[] fooRows = new List[]{Arrays.asList("Lamp", new Integer(5)), Arrays.asList("Screwdriver", new Integer(100)), Arrays.asList("Goat", new Integer(4))};
        List[] barRows = new List[]{Arrays.asList("Lamp2", new Integer(54)), Arrays.asList("Screwdriver2", new Integer(1000)), Arrays.asList("Goat2", new Integer(43))};
        FakePlanExecutor executorFoo = new FakePlanExecutor(FOO, fooSchema, fooRows);
        context.setResultSet(FOO, (PlanExecutor)executorFoo);
        context.setVariableValues(FOO, context.getNextRow(FOO));
        XMLContext childContext = new XMLContext(context);
        FakePlanExecutor executorBar = new FakePlanExecutor(BAR, barSchema, barRows);
        childContext.setResultSet(FOO, (PlanExecutor)executorBar);
        childContext.setVariableValues(FOO, childContext.getNextRow(FOO));
        Map referenceValues = childContext.getReferenceValues();
        TestXMLContext.assertEquals((int)2, (int)referenceValues.size());
        TestXMLContext.assertEquals((Object)"Lamp2", referenceValues.get(X));
        TestXMLContext.assertEquals((Object)new Integer(54), referenceValues.get(Y));
        childContext.setVariableValues(FOO, childContext.getNextRow(FOO));
        referenceValues = childContext.getReferenceValues();
        TestXMLContext.assertEquals((Object)"Screwdriver2", referenceValues.get(X));
        TestXMLContext.assertEquals((Object)new Integer(1000), referenceValues.get(Y));
    }
}

