/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jdbc;

import java.util.Arrays;
import java.util.Properties;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.teiid.core.TeiidException;
import org.teiid.core.util.PropertiesUtils;
import org.teiid.core.util.ReflectionHelper;
import org.teiid.jdbc.JDBCPlugin;
import org.teiid.net.ConnectionException;
import org.teiid.net.ServerConnection;

class ModuleHelper {
    ModuleHelper() {
    }

    static ServerConnection createFromModule(Properties info) throws ConnectionException, TeiidException {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            ModuleLoader callerModuleLoader = Module.getCallerModuleLoader();
            if (callerModuleLoader == null) {
                throw new ConnectionException(JDBCPlugin.Event.TEIID20033, null, JDBCPlugin.Util.gs(JDBCPlugin.Event.TEIID20033, new Object[0]));
            }
            Module module = callerModuleLoader.loadModule(ModuleIdentifier.create((String)"org.jboss.teiid"));
            Thread.currentThread().setContextClassLoader((ClassLoader)module.getClassLoader());
            ServerConnection serverConnection = (ServerConnection)ReflectionHelper.create("org.teiid.transport.LocalServerConnection", Arrays.asList(info, PropertiesUtils.getBooleanProperty(info, "useCallingThread", true)), Thread.currentThread().getContextClassLoader());
            return serverConnection;
        }
        catch (ModuleLoadException e) {
            throw new ConnectionException(JDBCPlugin.Event.TEIID20008, e, JDBCPlugin.Util.gs(JDBCPlugin.Event.TEIID20008, new Object[0]));
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
    }
}

