/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer.relational.rules;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryPlannerException;
import org.teiid.api.exception.query.QueryResolverException;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.id.IDGenerator;
import org.teiid.core.types.DataTypeManager;
import org.teiid.query.QueryPlugin;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TempMetadataAdapter;
import org.teiid.query.metadata.TempMetadataStore;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.SourceCapabilities;
import org.teiid.query.optimizer.relational.OptimizerRule;
import org.teiid.query.optimizer.relational.RelationalPlanner;
import org.teiid.query.optimizer.relational.RuleStack;
import org.teiid.query.optimizer.relational.plantree.NodeConstants;
import org.teiid.query.optimizer.relational.plantree.NodeEditor;
import org.teiid.query.optimizer.relational.plantree.NodeFactory;
import org.teiid.query.optimizer.relational.plantree.PlanNode;
import org.teiid.query.optimizer.relational.rules.CapabilitiesUtil;
import org.teiid.query.optimizer.relational.rules.FrameUtil;
import org.teiid.query.optimizer.relational.rules.NewCalculateCostUtil;
import org.teiid.query.optimizer.relational.rules.RuleAssignOutputElements;
import org.teiid.query.optimizer.relational.rules.RuleChooseJoinStrategy;
import org.teiid.query.optimizer.relational.rules.RuleDecomposeJoin;
import org.teiid.query.optimizer.relational.rules.RuleMergeVirtual;
import org.teiid.query.optimizer.relational.rules.RuleRaiseAccess;
import org.teiid.query.resolver.util.ResolverUtil;
import org.teiid.query.resolver.util.ResolverVisitor;
import org.teiid.query.rewriter.QueryRewriter;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.CompareCriteria;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.IsNullCriteria;
import org.teiid.query.sql.lang.JoinType;
import org.teiid.query.sql.lang.OrderBy;
import org.teiid.query.sql.lang.Select;
import org.teiid.query.sql.lang.SetQuery;
import org.teiid.query.sql.symbol.AggregateSymbol;
import org.teiid.query.sql.symbol.AliasSymbol;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.ExpressionSymbol;
import org.teiid.query.sql.symbol.Function;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.SearchedCaseExpression;
import org.teiid.query.sql.symbol.Symbol;
import org.teiid.query.sql.util.SymbolMap;
import org.teiid.query.sql.visitor.AggregateSymbolCollectorVisitor;
import org.teiid.query.sql.visitor.ElementCollectorVisitor;
import org.teiid.query.sql.visitor.ExpressionMappingVisitor;
import org.teiid.query.sql.visitor.GroupsUsedByElementsVisitor;
import org.teiid.query.util.CommandContext;

public class RulePushAggregates
implements OptimizerRule {
    private IDGenerator idGenerator;
    private CommandContext context;
    private List<PlanNode> groupingNodes;

    public RulePushAggregates(IDGenerator idGenerator) {
        this.idGenerator = idGenerator;
    }

    @Override
    public PlanNode execute(PlanNode plan, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, RuleStack rules, AnalysisRecord analysisRecord, CommandContext ctx) throws QueryPlannerException, QueryMetadataException, TeiidComponentException {
        this.context = ctx;
        this.groupingNodes = NodeEditor.findAllNodes(plan, 128, 1);
        block2: for (int i = 0; i < this.groupingNodes.size(); ++i) {
            PlanNode groupNode = this.groupingNodes.get(i);
            if (groupNode.hasBooleanProperty(NodeConstants.Info.ROLLUP)) continue;
            PlanNode child = groupNode.getFirstChild();
            List<Expression> groupingExpressions = (List<Expression>)groupNode.getProperty(NodeConstants.Info.GROUP_COLS);
            if (groupingExpressions == null) {
                groupingExpressions = Collections.emptyList();
            }
            try {
                if (child.getType() == 64) {
                    PlanNode setOp = child.getFirstChild();
                    this.pushGroupNodeOverUnion(metadata, capFinder, groupNode, child, groupingExpressions, setOp, analysisRecord);
                    continue;
                }
                if (child.getType() != 4) {
                    PlanNode access = NodeEditor.findNodePreOrder(child, 1, 324);
                    if (access == null) continue;
                    for (PlanNode parent = access.getParent(); parent != groupNode; parent = parent.getParent()) {
                        if (parent.getType() != 16) continue block2;
                    }
                    Set<AggregateSymbol> aggregates = RulePushAggregates.collectAggregates(groupNode);
                    if (!access.hasBooleanProperty(NodeConstants.Info.IS_MULTI_SOURCE)) continue;
                    if (!RuleRaiseAccess.isPartitioned(metadata, groupingExpressions, groupNode)) {
                        for (AggregateSymbol agg : aggregates) {
                            if (agg.canStage()) continue;
                            continue block2;
                        }
                        boolean shouldPushdown = this.canPushGroupByToUnionChild(metadata, capFinder, groupingExpressions, aggregates, access, analysisRecord, groupNode);
                        if (!shouldPushdown) continue;
                        LinkedHashSet<Expression> stagedGroupingSymbols = new LinkedHashSet<Expression>();
                        stagedGroupingSymbols.addAll(groupingExpressions);
                        aggregates = this.stageAggregates(groupNode, metadata, stagedGroupingSymbols, aggregates);
                        if (aggregates.isEmpty() && stagedGroupingSymbols.isEmpty()) continue;
                        this.addGroupBy(child, new ArrayList<Expression>(stagedGroupingSymbols), aggregates, metadata, groupNode.getParent(), capFinder, false, stagedGroupingSymbols.isEmpty() && this.containsNullDependent(aggregates));
                        continue;
                    }
                    if (groupNode.getFirstChild() != access || !RuleRaiseAccess.canRaiseOverGroupBy(groupNode, child, aggregates, metadata, capFinder, analysisRecord, false) || !this.canFilterEmpty(metadata, capFinder, child, groupingExpressions)) continue;
                    if (groupingExpressions.isEmpty()) {
                        this.addEmptyFilter(aggregates, groupNode, metadata, capFinder, RuleRaiseAccess.getModelIDFromAccess(child, metadata));
                    }
                    FrameUtil.convertNode(groupNode.getParent(), null, null, ((SymbolMap)groupNode.getProperty(NodeConstants.Info.SYMBOL_MAP)).inserseMapping(), metadata, false);
                    RuleRaiseAccess.performRaise(null, access, access.getParent());
                    if (!groupingExpressions.isEmpty() || !RuleRaiseAccess.canRaiseOverSelect(access, metadata, capFinder, access.getParent(), null)) continue;
                    RuleRaiseAccess.performRaise(null, access, access.getParent());
                    continue;
                }
            }
            catch (QueryResolverException e) {
                throw new TeiidComponentException((BundleUtil.Event)QueryPlugin.Event.TEIID30264, (Throwable)e);
            }
            LinkedHashSet<AggregateSymbol> aggregates = RulePushAggregates.collectAggregates(groupNode);
            this.pushGroupNode(groupNode, groupingExpressions, aggregates, metadata, capFinder, this.context);
        }
        return plan;
    }

    private void pushGroupNodeOverUnion(QueryMetadataInterface metadata, CapabilitiesFinder capFinder, PlanNode groupNode, PlanNode unionSourceParent, List<Expression> groupingExpressions, PlanNode setOp, AnalysisRecord record) throws TeiidComponentException, QueryMetadataException, QueryPlannerException, QueryResolverException {
        if (setOp == null || setOp.getProperty(NodeConstants.Info.SET_OPERATION) != SetQuery.Operation.UNION) {
            return;
        }
        LinkedHashSet<AggregateSymbol> aggregates = RulePushAggregates.collectAggregates(groupNode);
        Map partitionInfo = (Map)unionSourceParent.getProperty(NodeConstants.Info.PARTITION_INFO);
        boolean cardinalityDependent = AggregateSymbol.areAggregatesCardinalityDependent(aggregates);
        LinkedList<PlanNode> unionChildren = new LinkedList<PlanNode>();
        RulePushAggregates.findUnionChildren(unionChildren, cardinalityDependent, setOp);
        SymbolMap parentMap = (SymbolMap)unionSourceParent.getProperty(NodeConstants.Info.SYMBOL_MAP);
        if (partitionInfo != null && !Collections.disjoint(partitionInfo.keySet(), groupingExpressions)) {
            this.decomposeGroupBy(groupNode, unionSourceParent, groupingExpressions, aggregates, unionChildren, parentMap, metadata, capFinder);
            return;
        }
        if (aggregates.isEmpty()) {
            if (!groupingExpressions.isEmpty()) {
                setOp.setProperty(NodeConstants.Info.USE_ALL, Boolean.FALSE);
                boolean allCols = true;
                for (Expression ex : groupingExpressions) {
                    if (ex instanceof ElementSymbol) continue;
                    allCols = false;
                    break;
                }
                if (allCols) {
                    RuleAssignOutputElements.removeGroupBy(groupNode, metadata);
                }
            }
            return;
        }
        for (AggregateSymbol agg : aggregates) {
            if (agg.canStage()) continue;
            return;
        }
        if (unionChildren.size() < 2) {
            return;
        }
        ArrayList<AggregateSymbol> copy = new ArrayList<AggregateSymbol>(aggregates);
        aggregates.clear();
        Map<AggregateSymbol, Expression> aggMap = RulePushAggregates.buildAggregateMap(copy, metadata, aggregates);
        boolean shouldPushdown = false;
        ArrayList<Boolean> pushdownList = new ArrayList<Boolean>(unionChildren.size());
        for (PlanNode planNode : unionChildren) {
            boolean pushdown = this.canPushGroupByToUnionChild(metadata, capFinder, groupingExpressions, aggregates, planNode, record, groupNode);
            pushdownList.add(pushdown);
            shouldPushdown |= pushdown;
        }
        if (!shouldPushdown) {
            return;
        }
        GroupSymbol group = unionSourceParent.getGroups().iterator().next().clone();
        Iterator pushdownIterator = pushdownList.iterator();
        boolean first = true;
        for (PlanNode planNode : unionChildren) {
            this.addUnionGroupBy(groupingExpressions, aggregates, parentMap, metadata, capFinder, group, first, planNode, (Boolean)pushdownIterator.next() == false, false);
            first = false;
        }
        this.updateParentAggs(groupNode, aggMap, metadata);
        List symbols = (List)NodeEditor.findNodePreOrder(unionSourceParent, 8).getProperty(NodeConstants.Info.PROJECT_COLS);
        GroupSymbol modifiedGroup = group.clone();
        SymbolMap symbolMap = RulePushAggregates.createSymbolMap(modifiedGroup, symbols, unionSourceParent, metadata);
        unionSourceParent.setProperty(NodeConstants.Info.SYMBOL_MAP, symbolMap);
        HashMap<Expression, ElementSymbol> mapping = new HashMap<Expression, ElementSymbol>();
        Iterator<ElementSymbol> elemIter = symbolMap.getKeys().iterator();
        for (Expression expr : groupingExpressions) {
            mapping.put(expr, elemIter.next());
        }
        for (AggregateSymbol agg : aggregates) {
            mapping.put(agg, elemIter.next());
        }
        for (PlanNode node = unionSourceParent; node != groupNode.getParent(); node = node.getParent()) {
            FrameUtil.convertNode(node, null, null, mapping, metadata, false);
        }
        this.removeUnnecessaryViews(unionSourceParent, metadata, capFinder);
    }

    private void updateParentAggs(PlanNode groupNode, Map<AggregateSymbol, Expression> aggMap, QueryMetadataInterface metadata) throws QueryMetadataException, TeiidComponentException, QueryPlannerException {
        LinkedHashSet<AggregateSymbol> compositeAggs = new LinkedHashSet<AggregateSymbol>();
        boolean hasExpressionMapping = false;
        SymbolMap oldGroupingMap = (SymbolMap)groupNode.getProperty(NodeConstants.Info.SYMBOL_MAP);
        for (Expression ex : oldGroupingMap.asMap().values()) {
            if (!(ex instanceof AggregateSymbol)) continue;
            Expression mappedAgg = aggMap.get(ex);
            if (mappedAgg != null) {
                if (mappedAgg instanceof AggregateSymbol) {
                    compositeAggs.add((AggregateSymbol)mappedAgg);
                    continue;
                }
                compositeAggs.addAll(AggregateSymbolCollectorVisitor.getAggregates(mappedAgg, false));
                hasExpressionMapping = true;
                continue;
            }
            compositeAggs.add((AggregateSymbol)ex);
        }
        if (!hasExpressionMapping) {
            FrameUtil.correctSymbolMap(aggMap, groupNode);
        } else {
            groupNode.getGroups().clear();
            GroupSymbol oldGroup = oldGroupingMap.asMap().keySet().iterator().next().getGroupSymbol();
            SymbolMap groupingMap = RelationalPlanner.buildGroupingNode(compositeAggs, (List)groupNode.getProperty(NodeConstants.Info.GROUP_COLS), groupNode, this.context, this.idGenerator);
            ArrayList<AliasSymbol> projectCols = new ArrayList<AliasSymbol>(oldGroupingMap.asMap().size());
            SymbolMap correctedMap = new SymbolMap();
            Map<Expression, ElementSymbol> inverseMap = groupingMap.inserseMapping();
            for (Map.Entry<ElementSymbol, Expression> entry : oldGroupingMap.asMap().entrySet()) {
                Expression ses = null;
                if (entry.getValue() instanceof AggregateSymbol) {
                    Expression ex = aggMap.get(entry.getValue());
                    if (ex == null) {
                        ses = inverseMap.get(entry.getValue());
                    } else if (ex instanceof AggregateSymbol) {
                        ses = inverseMap.get(ex);
                    } else {
                        ExpressionMappingVisitor.mapExpressions(ex, inverseMap);
                        ses = new ExpressionSymbol("expr", ex);
                    }
                } else {
                    ses = inverseMap.get(entry.getValue());
                }
                ses = (Expression)ses.clone();
                projectCols.add(new AliasSymbol(Symbol.getShortName(entry.getKey()), ses));
                correctedMap.addMapping(entry.getKey(), SymbolMap.getExpression(ses));
            }
            PlanNode projectNode = groupNode.getParent();
            if (projectNode.getType() != 8) {
                projectNode = NodeFactory.getNewNode(8);
                groupNode.addAsParent(projectNode);
                projectNode.setProperty(NodeConstants.Info.PROJECT_COLS, projectCols);
                RuleDecomposeJoin.createSource(oldGroup, projectNode, correctedMap);
            } else {
                FrameUtil.convertFrame(projectNode, oldGroup, null, correctedMap.asMap(), metadata);
            }
        }
    }

    private void decomposeGroupBy(PlanNode groupNode, PlanNode sourceNode, List<Expression> groupingExpressions, LinkedHashSet<AggregateSymbol> aggregates, LinkedList<PlanNode> unionChildren, SymbolMap parentMap, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryPlannerException, QueryMetadataException, TeiidComponentException, QueryResolverException {
        groupNode.getParent().replaceChild(groupNode, groupNode.getFirstChild());
        GroupSymbol group = sourceNode.getGroups().iterator().next().clone();
        boolean first = true;
        for (PlanNode planNode : unionChildren) {
            this.addUnionGroupBy(groupingExpressions, aggregates, parentMap, metadata, capFinder, group, first, planNode, false, true);
            first = false;
        }
        List symbols = (List)NodeEditor.findNodePreOrder(sourceNode, 8).getProperty(NodeConstants.Info.PROJECT_COLS);
        GroupSymbol modifiedGroup = group.clone();
        SymbolMap symbolMap = RulePushAggregates.createSymbolMap(modifiedGroup, symbols, sourceNode, metadata);
        sourceNode.setProperty(NodeConstants.Info.SYMBOL_MAP, symbolMap);
        SymbolMap map = (SymbolMap)groupNode.getProperty(NodeConstants.Info.SYMBOL_MAP);
        Map<Expression, ElementSymbol> inverse = map.inserseMapping();
        SymbolMap newMapping = (SymbolMap)NodeEditor.findNodePreOrder(sourceNode, 128).getProperty(NodeConstants.Info.SYMBOL_MAP);
        GroupSymbol oldGroup = null;
        HashMap<ElementSymbol, ElementSymbol> updatedMapping = new HashMap<ElementSymbol, ElementSymbol>();
        for (Map.Entry<ElementSymbol, Expression> entry : symbolMap.asMap().entrySet()) {
            Expression ex = newMapping.getMappedExpression((ElementSymbol)entry.getValue());
            ElementSymbol orig = inverse.get(ex);
            oldGroup = orig.getGroupSymbol();
            updatedMapping.put(orig, entry.getKey());
        }
        FrameUtil.convertFrame(sourceNode, oldGroup, Collections.singleton(modifiedGroup), updatedMapping, metadata);
        this.removeUnnecessaryViews(sourceNode, metadata, capFinder);
    }

    private void removeUnnecessaryViews(PlanNode sourceNode, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryPlannerException, QueryMetadataException, TeiidComponentException {
        for (PlanNode source : NodeEditor.findAllNodes(sourceNode.getFirstChild(), 64, 1)) {
            PlanNode planNode = source.getFirstChild();
            if (planNode == null || planNode.getType() != 1) continue;
            NodeEditor.removeChildNode(source, planNode);
            PlanNode parent = RuleMergeVirtual.doMerge(source, source.getParent(), false, metadata, capFinder);
            if (parent.getFirstChild() == source) {
                source.getFirstChild().addAsParent(planNode);
            } else {
                parent.getFirstChild().addAsParent(planNode);
            }
            while (RuleRaiseAccess.raiseAccessNode(planNode, planNode, metadata, capFinder, true, null, this.context) != null) {
            }
        }
    }

    private void addUnionGroupBy(List<Expression> groupingExpressions, LinkedHashSet<AggregateSymbol> aggregates, SymbolMap parentMap, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, GroupSymbol group, boolean first, PlanNode planNode, boolean viewOnly, boolean partitioned) throws QueryMetadataException, TeiidComponentException, QueryPlannerException, QueryResolverException {
        ArrayList<Expression> groupingColumns = LanguageObject.Util.deepClone(groupingExpressions, Expression.class);
        if (!first) {
            PlanNode sortNode = NodeEditor.findNodePreOrder(planNode, 32, 64);
            List<Expression> sortOrder = null;
            OrderBy orderBy = null;
            if (sortNode != null) {
                orderBy = (OrderBy)sortNode.getProperty(NodeConstants.Info.SORT_ORDER);
                sortOrder = orderBy.getSortKeys();
            }
            List<Expression> projectCols = FrameUtil.findTopCols(planNode);
            List<ElementSymbol> virtualElements = parentMap.getKeys();
            for (int i = 0; i < virtualElements.size(); ++i) {
                int sortIndex;
                ElementSymbol virtualElem = virtualElements.get(i);
                Expression projectedSymbol = projectCols.get(i);
                if (Symbol.getShortName(projectedSymbol).equals(Symbol.getShortName(virtualElem))) continue;
                if (sortOrder != null && (sortIndex = sortOrder.indexOf(projectedSymbol)) > -1) {
                    this.updateSymbolName(sortOrder, sortIndex, virtualElem, sortOrder.get(sortIndex));
                    orderBy.getOrderByItems().get(sortIndex).setSymbol(sortOrder.get(sortIndex));
                }
                this.updateSymbolName(projectCols, i, virtualElem, projectedSymbol);
            }
        }
        PlanNode view = RuleDecomposeJoin.createSource(group, planNode, parentMap);
        PlanNode projectPlanNode = NodeFactory.getNewNode(8);
        Select allSymbols = new Select();
        for (Expression expr : groupingColumns) {
            allSymbols.addSymbol(new ExpressionSymbol("expr", expr));
        }
        if (viewOnly) {
            for (AggregateSymbol agg : aggregates) {
                if ((agg = (AggregateSymbol)agg.clone()).getAggregateFunction() == AggregateSymbol.Type.COUNT) {
                    if (agg.getArgs().length == 0) {
                        allSymbols.addSymbol(new ExpressionSymbol("stagedAgg", new Constant(1)));
                        continue;
                    }
                    SearchedCaseExpression count = new SearchedCaseExpression(Arrays.asList(new IsNullCriteria(agg.getArg(0))), Arrays.asList(new Constant(0)));
                    count.setElseExpression(new Constant(1));
                    count.setType(DataTypeManager.DefaultDataClasses.INTEGER);
                    allSymbols.addSymbol(new ExpressionSymbol("stagedAgg", count));
                    continue;
                }
                assert (agg.getArgs().length == 1);
                Expression ex = agg.getArg(0);
                ex = ResolverUtil.convertExpression(ex, DataTypeManager.getDataTypeName(agg.getType()), metadata);
                allSymbols.addSymbol(new ExpressionSymbol("stagedAgg", ex));
            }
        } else {
            allSymbols.addSymbols(aggregates);
        }
        if (first) {
            QueryRewriter.makeSelectUnique(allSymbols, false);
        }
        projectPlanNode.setProperty(NodeConstants.Info.PROJECT_COLS, allSymbols.getSymbols());
        projectPlanNode.addGroups(view.getGroups());
        view.addAsParent(projectPlanNode);
        if (!viewOnly) {
            this.addGroupBy(view, groupingColumns, aggregates, metadata, projectPlanNode.getParent(), capFinder, true, groupingColumns.isEmpty() && (partitioned || this.containsNullDependent(aggregates)));
        }
    }

    private void updateSymbolName(List<Expression> projectCols, int i, ElementSymbol virtualElem, Expression projectedSymbol) {
        if (projectedSymbol instanceof AliasSymbol) {
            ((AliasSymbol)projectedSymbol).setShortName(Symbol.getShortName(virtualElem));
        } else {
            projectCols.set(i, new AliasSymbol(Symbol.getShortName(virtualElem), projectedSymbol));
        }
    }

    private boolean canPushGroupByToUnionChild(QueryMetadataInterface metadata, CapabilitiesFinder capFinder, List<Expression> groupingExpressions, Set<AggregateSymbol> aggregates, PlanNode planNode, AnalysisRecord record, PlanNode groupingNode) throws QueryMetadataException, TeiidComponentException {
        if (planNode.getType() != 1) {
            return false;
        }
        boolean result = RuleRaiseAccess.canRaiseOverGroupBy(groupingNode, planNode, aggregates, metadata, capFinder, record, false);
        if (!result) {
            return false;
        }
        return !this.containsNullDependent(aggregates) || this.canFilterEmpty(metadata, capFinder, planNode, groupingExpressions);
    }

    private boolean containsNullDependent(Collection<AggregateSymbol> aggregates) {
        for (AggregateSymbol aggregateSymbol : aggregates) {
            if (aggregateSymbol.getFunctionDescriptor() == null || !aggregateSymbol.getFunctionDescriptor().isNullDependent()) continue;
            return true;
        }
        return false;
    }

    private boolean canFilterEmpty(QueryMetadataInterface metadata, CapabilitiesFinder capFinder, PlanNode planNode, List<Expression> groupingExpressions) throws QueryMetadataException, TeiidComponentException {
        if (!groupingExpressions.isEmpty()) {
            return true;
        }
        Object modelId = RuleRaiseAccess.getModelIDFromAccess(planNode, metadata);
        return CapabilitiesUtil.supports(SourceCapabilities.Capability.QUERY_AGGREGATES_COUNT_STAR, modelId, metadata, capFinder);
    }

    static PlanNode findUnionChildren(List<PlanNode> unionChildren, boolean carinalityDependent, PlanNode setOp) {
        if (setOp.getType() != 256 || setOp.getProperty(NodeConstants.Info.SET_OPERATION) != SetQuery.Operation.UNION) {
            return setOp;
        }
        if (!setOp.hasBooleanProperty(NodeConstants.Info.USE_ALL)) {
            if (carinalityDependent) {
                return setOp;
            }
            setOp.setProperty(NodeConstants.Info.USE_ALL, Boolean.TRUE);
        }
        for (PlanNode planNode : setOp.getChildren()) {
            PlanNode child = RulePushAggregates.findUnionChildren(unionChildren, carinalityDependent, planNode);
            if (child == null) continue;
            unionChildren.add(child);
        }
        return null;
    }

    static SymbolMap createSymbolMap(GroupSymbol group, List<? extends Expression> virtualElements, PlanNode child, QueryMetadataInterface metadata) throws TeiidComponentException, QueryMetadataException {
        List<ElementSymbol> projectedSymbols = RulePushAggregates.defineNewGroup(group, virtualElements, metadata);
        SymbolMap symbolMap = SymbolMap.createSymbolMap(projectedSymbols, (List)NodeEditor.findNodePreOrder(child, 8).getProperty(NodeConstants.Info.PROJECT_COLS));
        return symbolMap;
    }

    static List<ElementSymbol> defineNewGroup(GroupSymbol group, List<? extends Expression> virtualElements, QueryMetadataInterface metadata) throws TeiidComponentException, QueryMetadataException {
        TempMetadataStore store = new TempMetadataStore();
        TempMetadataAdapter tma = new TempMetadataAdapter(metadata, store);
        try {
            group.setMetadataID(ResolverUtil.addTempGroup(tma, group, virtualElements, false));
        }
        catch (QueryResolverException e) {
            throw new TeiidComponentException((BundleUtil.Event)QueryPlugin.Event.TEIID30265, (Throwable)e);
        }
        List<ElementSymbol> projectedSymbols = ResolverUtil.resolveElementsInGroup(group, metadata);
        return projectedSymbols;
    }

    static LinkedHashSet<AggregateSymbol> collectAggregates(PlanNode groupNode) {
        LinkedHashSet<AggregateSymbol> aggregates = new LinkedHashSet<AggregateSymbol>();
        SymbolMap symbolMap = (SymbolMap)groupNode.getProperty(NodeConstants.Info.SYMBOL_MAP);
        for (PlanNode currentNode = groupNode.getParent(); currentNode != null; currentNode = currentNode.getParent()) {
            if (currentNode.getType() == 8) {
                List projectedSymbols = (List)currentNode.getProperty(NodeConstants.Info.PROJECT_COLS);
                for (Expression symbol : projectedSymbols) {
                    RulePushAggregates.mapAggregates(ElementCollectorVisitor.getAggregates(symbol, true), symbolMap, aggregates);
                }
                break;
            }
            if (currentNode.getType() != 16) continue;
            Criteria crit = (Criteria)currentNode.getProperty(NodeConstants.Info.SELECT_CRITERIA);
            RulePushAggregates.mapAggregates(ElementCollectorVisitor.getAggregates(crit, true), symbolMap, aggregates);
        }
        return aggregates;
    }

    static void mapAggregates(Collection<ElementSymbol> symbols, SymbolMap map, Collection<? super AggregateSymbol> aggs) {
        for (ElementSymbol es : symbols) {
            Expression ex = map.getMappedExpression(es);
            if (!(ex instanceof AggregateSymbol)) continue;
            aggs.add((AggregateSymbol)ex);
        }
    }

    private void pushGroupNode(PlanNode groupNode, List<Expression> groupingExpressions, Set<AggregateSymbol> allAggregates, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, CommandContext cc) throws TeiidComponentException, QueryMetadataException, QueryPlannerException {
        Map<PlanNode, List<AggregateSymbol>> aggregateMap = this.createNodeMapping(groupNode, allAggregates, true);
        if (aggregateMap == null) {
            return;
        }
        Map<PlanNode, List<Expression>> groupingMap = this.createNodeMapping(groupNode, groupingExpressions, false);
        LinkedHashSet<PlanNode> possibleTargetNodes = new LinkedHashSet<PlanNode>(aggregateMap.keySet());
        possibleTargetNodes.addAll(groupingMap.keySet());
        for (Map.Entry<PlanNode, List<AggregateSymbol>> entry : aggregateMap.entrySet()) {
            if (!AggregateSymbol.areAggregatesCardinalityDependent((Collection<AggregateSymbol>)entry.getValue())) continue;
            possibleTargetNodes.clear();
            possibleTargetNodes.add(entry.getKey());
            break;
        }
        for (PlanNode planNode : possibleTargetNodes) {
            LinkedHashSet<Expression> stagedGroupingSymbols = new LinkedHashSet<Expression>();
            Collection<AggregateSymbol> aggregates = (ArrayList<AggregateSymbol>)aggregateMap.get(planNode);
            if ((planNode = this.canPush(groupNode, stagedGroupingSymbols, planNode)) == null) continue;
            this.filterExpressions(stagedGroupingSymbols, planNode.getGroups(), groupingExpressions, false);
            this.collectSymbolsFromOtherAggregates(allAggregates, aggregates, planNode, stagedGroupingSymbols);
            float cardinality = NewCalculateCostUtil.computeCostForTree(planNode, metadata);
            float ndv = NewCalculateCostUtil.getNDVEstimate(planNode, metadata, cardinality, stagedGroupingSymbols, false);
            if (ndv != -1.0f && cardinality / ndv < 4.0f || (aggregates = aggregates != null ? this.stageAggregates(groupNode, metadata, stagedGroupingSymbols, aggregates) : new ArrayList<AggregateSymbol>(1)).isEmpty() && stagedGroupingSymbols.isEmpty()) continue;
            this.addGroupBy(planNode, new ArrayList<Expression>(stagedGroupingSymbols), aggregates, metadata, groupNode.getParent(), capFinder, true, stagedGroupingSymbols.isEmpty() && this.containsNullDependent(aggregates));
        }
    }

    private void addGroupBy(PlanNode child, List<Expression> stagedGroupingSymbols, Collection<AggregateSymbol> aggregates, QueryMetadataInterface metadata, PlanNode endNode, CapabilitiesFinder capFinder, boolean considerMultiSource, boolean filterEmpty) throws QueryMetadataException, TeiidComponentException, QueryPlannerException {
        PlanNode stageGroup = NodeFactory.getNewNode(128);
        child.addAsParent(stageGroup);
        aggregates = new LinkedHashSet<AggregateSymbol>(aggregates);
        if (filterEmpty) {
            this.addEmptyFilter(aggregates, stageGroup, metadata, capFinder, RuleRaiseAccess.getModelIDFromAccess(NodeEditor.findNodePreOrder(child, 1), metadata));
        }
        Map<Expression, ElementSymbol> reverseMapping = RelationalPlanner.buildGroupingNode(aggregates, stagedGroupingSymbols, stageGroup, this.context, this.idGenerator).inserseMapping();
        GroupSymbol newGroup = reverseMapping.values().iterator().next().getGroupSymbol();
        for (PlanNode node = stageGroup.getParent(); node != endNode; node = node.getParent()) {
            if (node.getType() == 4) {
                node.getGroups().removeAll(FrameUtil.findJoinSourceNode(stageGroup.getFirstChild()).getGroups());
                node.getGroups().add(newGroup);
            }
            FrameUtil.convertNode(node, null, null, reverseMapping, metadata, false);
            if (node.getType() != 4) continue;
            RuleChooseJoinStrategy.chooseJoinStrategy(node, metadata);
        }
        PlanNode accessNode = stageGroup.getFirstChild();
        if (accessNode.getType() != 1) {
            this.groupingNodes.add(stageGroup);
        } else if (RuleRaiseAccess.canRaiseOverGroupBy(stageGroup, accessNode, aggregates, metadata, capFinder, null, false)) {
            if (considerMultiSource && accessNode.hasBooleanProperty(NodeConstants.Info.IS_MULTI_SOURCE)) {
                this.groupingNodes.add(stageGroup);
            } else {
                accessNode.getGroups().clear();
                accessNode.getGroups().addAll(stageGroup.getGroups());
                RuleRaiseAccess.performRaise(null, accessNode, stageGroup);
                if (filterEmpty && RuleRaiseAccess.canRaiseOverSelect(accessNode, metadata, capFinder, accessNode.getParent(), null)) {
                    RuleRaiseAccess.performRaise(null, accessNode, accessNode.getParent());
                }
            }
        }
    }

    private void addEmptyFilter(Collection<AggregateSymbol> aggregates, PlanNode stageGroup, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, Object modelId) throws QueryMetadataException, TeiidComponentException {
        PlanNode selectNode = NodeFactory.getNewNode(16);
        AggregateSymbol count = new AggregateSymbol("COUNT", false, null);
        aggregates.add(count);
        CompareCriteria crit = new CompareCriteria(count, 4, new Constant(new Integer(0)));
        selectNode.setProperty(NodeConstants.Info.SELECT_CRITERIA, crit);
        selectNode.setProperty(NodeConstants.Info.IS_HAVING, Boolean.TRUE);
        stageGroup.addAsParent(selectNode);
    }

    Set<AggregateSymbol> stageAggregates(PlanNode groupNode, QueryMetadataInterface metadata, Set<Expression> stagedGroupingSymbols, Collection<AggregateSymbol> aggregates) throws TeiidComponentException, QueryPlannerException {
        Map<AggregateSymbol, Expression> aggMap;
        Iterator<AggregateSymbol> iterator = aggregates.iterator();
        while (iterator.hasNext()) {
            Expression expr;
            AggregateSymbol symbol = iterator.next();
            if (symbol.getArgs().length != 1 || symbol.isCardinalityDependent() || !stagedGroupingSymbols.contains(expr = symbol.getArg(0))) continue;
            iterator.remove();
        }
        if (aggregates.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<AggregateSymbol> newAggs = new HashSet<AggregateSymbol>();
        try {
            aggMap = RulePushAggregates.buildAggregateMap(aggregates, metadata, newAggs);
        }
        catch (QueryResolverException e) {
            throw new QueryPlannerException((BundleUtil.Event)QueryPlugin.Event.TEIID30266, (Throwable)e);
        }
        this.updateParentAggs(groupNode, aggMap, metadata);
        return newAggs;
    }

    private void collectSymbolsFromOtherAggregates(Collection<AggregateSymbol> allAggregates, Collection<AggregateSymbol> aggregates, PlanNode current, Set<Expression> stagedGroupingSymbols) {
        HashSet<AggregateSymbol> otherAggs = new HashSet<AggregateSymbol>(allAggregates);
        if (aggregates != null) {
            otherAggs.removeAll(aggregates);
        }
        PlanNode source = FrameUtil.findJoinSourceNode(current);
        for (AggregateSymbol aggregateSymbol : otherAggs) {
            for (ElementSymbol symbol : ElementCollectorVisitor.getElements((LanguageObject)aggregateSymbol, true)) {
                if (!source.getGroups().contains(symbol.getGroupSymbol())) continue;
                stagedGroupingSymbols.add(symbol);
            }
        }
    }

    private PlanNode canPush(PlanNode groupNode, Set<Expression> stagedGroupingSymbols, PlanNode planNode) {
        Set<GroupSymbol> groups = FrameUtil.findJoinSourceNode(planNode).getGroups();
        PlanNode result = planNode;
        for (PlanNode parentJoin = planNode.getParent(); parentJoin != groupNode; parentJoin = parentJoin.getParent()) {
            List criteria;
            if (parentJoin.getType() != 4 || ((JoinType)parentJoin.getProperty(NodeConstants.Info.JOIN_TYPE)).isOuter()) {
                return null;
            }
            if (!parentJoin.hasCollectionProperty(NodeConstants.Info.LEFT_EXPRESSIONS) || !parentJoin.hasCollectionProperty(NodeConstants.Info.RIGHT_EXPRESSIONS)) {
                criteria = (List)parentJoin.getProperty(NodeConstants.Info.JOIN_CRITERIA);
                if (!this.findStagedGroupingExpressions(groups, criteria, stagedGroupingSymbols)) {
                    return null;
                }
            } else {
                criteria = (List)parentJoin.getProperty(NodeConstants.Info.NON_EQUI_JOIN_CRITERIA);
                if (!this.findStagedGroupingExpressions(groups, criteria, stagedGroupingSymbols)) {
                    return null;
                }
                if (planNode == parentJoin.getFirstChild()) {
                    if (this.filterExpressions(stagedGroupingSymbols, groups, (List)parentJoin.getProperty(NodeConstants.Info.LEFT_EXPRESSIONS), true)) {
                        result = parentJoin;
                        groups = result.getGroups();
                    }
                } else if (this.filterExpressions(stagedGroupingSymbols, groups, (List)parentJoin.getProperty(NodeConstants.Info.RIGHT_EXPRESSIONS), true)) {
                    result = parentJoin;
                    groups = result.getGroups();
                }
            }
            planNode = parentJoin;
        }
        if (result.getParent() == groupNode) {
            return null;
        }
        return result;
    }

    private boolean findStagedGroupingExpressions(Set<GroupSymbol> groups, List<Criteria> criteria, Set<Expression> stagedGroupingExpressions) {
        if (criteria != null && !criteria.isEmpty()) {
            HashSet<Expression> subExpressions = new HashSet<Expression>();
            this.filterExpressions(subExpressions, groups, criteria, false);
            for (Expression ses : subExpressions) {
                if (!DataTypeManager.isNonComparable(DataTypeManager.getDataTypeName(ses.getType()))) continue;
                return false;
            }
            stagedGroupingExpressions.addAll(subExpressions);
        }
        return true;
    }

    private boolean filterExpressions(Set<Expression> stagedGroupingSymbols, Set<GroupSymbol> groups, Collection<? extends Expression> symbols, boolean wholeExpression) {
        boolean result = false;
        for (Expression expression : symbols) {
            Set<GroupSymbol> groups2 = GroupsUsedByElementsVisitor.getGroups(expression);
            if (Collections.disjoint(groups, groups2)) continue;
            if (!result) {
                boolean containsAll = groups.containsAll(groups2);
                if (!wholeExpression && !containsAll) {
                    this.filterExpressions(stagedGroupingSymbols, groups, ElementCollectorVisitor.getElements((LanguageObject)expression, true), true);
                    continue;
                }
                result = !containsAll;
            }
            stagedGroupingSymbols.add(SymbolMap.getExpression(expression));
        }
        return result;
    }

    private <T extends Expression> Map<PlanNode, List<T>> createNodeMapping(PlanNode groupNode, Collection<T> expressions, boolean aggs) {
        LinkedHashMap<PlanNode, List<T>> result = new LinkedHashMap<PlanNode, List<T>>();
        if (expressions == null) {
            return result;
        }
        for (Expression aggregateSymbol : expressions) {
            AggregateSymbol as;
            if (aggs && (!(as = (AggregateSymbol)aggregateSymbol).canStage() && as.isCardinalityDependent() || as.getAggregateFunction() == AggregateSymbol.Type.COUNT && as.getArgs().length == 0)) {
                return null;
            }
            Set<GroupSymbol> groups = GroupsUsedByElementsVisitor.getGroups(aggregateSymbol);
            if (groups.isEmpty()) continue;
            PlanNode originatingNode = FrameUtil.findOriginatingNode(groupNode.getFirstChild(), groups);
            if (originatingNode == null) {
                if (!aggs) continue;
                return null;
            }
            PlanNode parentAccess = NodeEditor.findParent(originatingNode, 1, 128);
            if (parentAccess != null) {
                while (parentAccess.getType() == 16) {
                    parentAccess = parentAccess.getParent();
                }
                originatingNode = parentAccess;
            }
            if (originatingNode.getParent() == groupNode) {
                if (!aggs || !((AggregateSymbol)aggregateSymbol).isCardinalityDependent()) continue;
                return null;
            }
            if (originatingNode.getType() != 1 || aggs && ((AggregateSymbol)aggregateSymbol).isDistinct()) continue;
            LinkedList<Expression> symbols = (LinkedList<Expression>)result.get(originatingNode);
            if (symbols == null) {
                symbols = new LinkedList<Expression>();
                result.put(originatingNode, symbols);
            }
            symbols.add(aggregateSymbol);
        }
        return result;
    }

    private static Map<AggregateSymbol, Expression> buildAggregateMap(Collection<? extends AggregateSymbol> aggregateExpressions, QueryMetadataInterface metadata, Set<AggregateSymbol> nestedAggregates) throws QueryResolverException, TeiidComponentException {
        LinkedHashMap<AggregateSymbol, Expression> aggMap = new LinkedHashMap<AggregateSymbol, Expression>();
        for (AggregateSymbol aggregateSymbol : aggregateExpressions) {
            AggregateSymbol sumAgg;
            AggregateSymbol countAgg;
            Expression newExpression = null;
            AggregateSymbol.Type aggFunction = aggregateSymbol.getAggregateFunction();
            if (aggFunction == AggregateSymbol.Type.COUNT) {
                AggregateSymbol newAgg = new AggregateSymbol("SUM", false, aggregateSymbol);
                Function convertFunc = new Function("convert", new Expression[]{newAgg, new Constant(DataTypeManager.getDataTypeName(aggregateSymbol.getType()))});
                Function ifnull = new Function("IFNULL", new Expression[]{convertFunc, new Constant(0, DataTypeManager.DefaultDataClasses.INTEGER)});
                ResolverVisitor.resolveLanguageObject(ifnull, metadata);
                newExpression = ifnull;
                nestedAggregates.add(aggregateSymbol);
            } else if (aggFunction == AggregateSymbol.Type.AVG) {
                countAgg = new AggregateSymbol("COUNT", false, aggregateSymbol.getArg(0));
                sumAgg = new AggregateSymbol("SUM", false, aggregateSymbol.getArg(0));
                AggregateSymbol sumSumAgg = new AggregateSymbol("SUM", false, sumAgg);
                AggregateSymbol sumCountAgg = new AggregateSymbol("SUM", false, countAgg);
                Function convertedSum = new Function("convert", new Expression[]{sumSumAgg, new Constant(DataTypeManager.getDataTypeName(aggregateSymbol.getType()))});
                Function convertCount = new Function("convert", new Expression[]{sumCountAgg, new Constant(DataTypeManager.getDataTypeName(aggregateSymbol.getType()))});
                Function divideFunc = new Function("/", new Expression[]{convertedSum, convertCount});
                ResolverVisitor.resolveLanguageObject(divideFunc, metadata);
                newExpression = divideFunc;
                nestedAggregates.add(countAgg);
                nestedAggregates.add(sumAgg);
            } else if (aggregateSymbol.isEnhancedNumeric()) {
                countAgg = new AggregateSymbol("COUNT", false, aggregateSymbol.getArg(0));
                sumAgg = new AggregateSymbol("SUM", false, aggregateSymbol.getArg(0));
                AggregateSymbol sumSqAgg = new AggregateSymbol("SUM", false, new Function("power", new Expression[]{aggregateSymbol.getArg(0), new Constant(2)}));
                AggregateSymbol sumSumAgg = new AggregateSymbol("SUM", false, sumAgg);
                AggregateSymbol sumCountAgg = new AggregateSymbol("SUM", false, countAgg);
                AggregateSymbol sumSumSqAgg = new AggregateSymbol("SUM", false, sumSqAgg);
                Function convertedSum = new Function("convert", new Expression[]{sumSumAgg, new Constant("double")});
                Function divideFunc = new Function("/", new Expression[]{new Function("power", new Expression[]{convertedSum, new Constant(2)}), sumCountAgg});
                Function minusFunc = new Function("-", new Expression[]{sumSumSqAgg, divideFunc});
                Function divisor = null;
                divisor = aggFunction == AggregateSymbol.Type.STDDEV_SAMP || aggFunction == AggregateSymbol.Type.VAR_SAMP ? new Function("-", new Expression[]{sumCountAgg, new Constant(1)}) : sumCountAgg;
                Expression result = new Function("/", new Expression[]{minusFunc, divisor});
                result = aggFunction == AggregateSymbol.Type.STDDEV_POP || aggFunction == AggregateSymbol.Type.STDDEV_SAMP ? new Function("sqrt", new Expression[]{result}) : new Function("convert", new Expression[]{result, new Constant("double")});
                Constant n = new Constant(0);
                if (aggFunction == AggregateSymbol.Type.STDDEV_SAMP || aggFunction == AggregateSymbol.Type.VAR_SAMP) {
                    n = new Constant(1);
                }
                result = new SearchedCaseExpression(Arrays.asList(new CompareCriteria(sumCountAgg, 4, n)), Arrays.asList(result));
                ResolverVisitor.resolveLanguageObject(result, metadata);
                newExpression = result;
                nestedAggregates.add(countAgg);
                nestedAggregates.add(sumAgg);
                nestedAggregates.add(sumSqAgg);
            } else {
                newExpression = new AggregateSymbol(aggFunction.name(), false, aggregateSymbol);
                if (aggregateSymbol.getFunctionDescriptor() != null) {
                    newExpression.setFunctionDescriptor(aggregateSymbol.getFunctionDescriptor().clone());
                }
                nestedAggregates.add(aggregateSymbol);
            }
            aggMap.put(aggregateSymbol, newExpression);
        }
        return aggMap;
    }

    public String toString() {
        return "PushAggregates";
    }
}

