/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.lang;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.teiid.core.util.EquivalenceUtil;
import org.teiid.core.util.HashCodeUtil;
import org.teiid.query.QueryPlugin;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.LogicalCriteria;

public class CompoundCriteria
extends LogicalCriteria {
    public static final int OR = 1;
    public static final int AND = 0;
    private List<Criteria> criteria = new ArrayList<Criteria>(2);
    private int operator = 0;

    public CompoundCriteria() {
    }

    public CompoundCriteria(List<? extends Criteria> criteria) {
        this();
        Iterator<? extends Criteria> iter = criteria.iterator();
        while (iter.hasNext()) {
            this.addCriteria(iter.next());
        }
    }

    public CompoundCriteria(int operator, Criteria left, Criteria right) {
        this();
        this.set(operator, left, right);
    }

    public CompoundCriteria(int operator, List criteria) {
        this();
        this.set(operator, criteria);
    }

    public int getOperator() {
        return this.operator;
    }

    private boolean isValidOperator(int operator) {
        return operator == 1 || operator == 0;
    }

    public void setOperator(int operator) {
        if (!this.isValidOperator(operator)) {
            throw new IllegalArgumentException(QueryPlugin.Util.getString("ERR.015.010.0002", operator));
        }
        this.operator = operator;
    }

    public List<Criteria> getCriteria() {
        return this.criteria;
    }

    public void setCriteria(List<Criteria> criteria) {
        this.criteria = criteria;
    }

    public int getCriteriaCount() {
        return this.criteria.size();
    }

    public Criteria getCriteria(int index) {
        return this.criteria.get(index);
    }

    public void addCriteria(Criteria criteria) {
        this.criteria.add(criteria);
    }

    protected void reset() {
        this.criteria.clear();
    }

    public void set(int operator, Criteria left, Criteria right) {
        this.reset();
        this.setOperator(operator);
        this.addCriteria(left);
        this.addCriteria(right);
    }

    public void set(int operator, Criteria criteria) {
        this.reset();
        this.setOperator(operator);
        this.addCriteria(criteria);
    }

    public void set(int operator, List criteria) {
        this.reset();
        this.setOperator(operator);
        Iterator iter = criteria.iterator();
        while (iter.hasNext()) {
            this.addCriteria((Criteria)iter.next());
        }
    }

    @Override
    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    public int hashCode() {
        int hc = 0;
        hc = HashCodeUtil.hashCode(hc, this.getOperator());
        hc = HashCodeUtil.hashCode(hc, this.getCriteria());
        return hc;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CompoundCriteria)) {
            return false;
        }
        CompoundCriteria cc = (CompoundCriteria)obj;
        return cc.getOperator() == this.getOperator() && EquivalenceUtil.areEqual(cc.getCriteria(), this.getCriteria());
    }

    @Override
    public Object clone() {
        CompoundCriteria copy = new CompoundCriteria();
        copy.setOperator(this.getOperator());
        List<Criteria> crits = this.getCriteria();
        for (int i = 0; i < crits.size(); ++i) {
            Criteria crit = crits.get(i);
            if (crit == null) {
                copy.addCriteria(null);
                continue;
            }
            copy.addCriteria((Criteria)crit.clone());
        }
        return copy;
    }
}

