/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.symbol;

import java.util.LinkedList;
import java.util.List;
import org.teiid.core.util.EquivalenceUtil;
import org.teiid.core.util.HashCodeUtil;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.visitor.SQLStringVisitor;

public class MultipleElementSymbol
implements Expression {
    private List<ElementSymbol> elementSymbols;
    private GroupSymbol group;

    public MultipleElementSymbol() {
    }

    public MultipleElementSymbol(String name) {
        this.group = new GroupSymbol(name);
    }

    @Override
    public Class<?> getType() {
        return null;
    }

    public void setElementSymbols(List<ElementSymbol> elementSymbols) {
        this.elementSymbols = elementSymbols;
    }

    public List<ElementSymbol> getElementSymbols() {
        return this.elementSymbols;
    }

    public void addElementSymbol(ElementSymbol symbol) {
        if (this.getElementSymbols() == null) {
            this.setElementSymbols(new LinkedList<ElementSymbol>());
        }
        this.getElementSymbols().add(symbol);
    }

    @Override
    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Object clone() {
        List<ElementSymbol> elements;
        MultipleElementSymbol copy = new MultipleElementSymbol();
        if (this.group != null) {
            copy.group = this.group.clone();
        }
        if ((elements = this.getElementSymbols()) != null && elements.size() > 0) {
            copy.setElementSymbols(LanguageObject.Util.deepClone(elements, ElementSymbol.class));
        }
        return copy;
    }

    public GroupSymbol getGroup() {
        return this.group;
    }

    public void setGroup(GroupSymbol group) {
        this.group = group;
    }

    public String toString() {
        return SQLStringVisitor.getSQLString(this);
    }

    public int hashCode() {
        return HashCodeUtil.hashCode(0, this.group);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof MultipleElementSymbol)) {
            return false;
        }
        MultipleElementSymbol other = (MultipleElementSymbol)obj;
        return EquivalenceUtil.areEqual(this.group, other.group);
    }
}

