/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.vdb.runtime;

import java.io.Serializable;
import org.teiid.core.util.HashCodeUtil;

public class VDBKey
implements Serializable,
Comparable<VDBKey> {
    private static final long serialVersionUID = -7249750823144856081L;
    private String name;
    private int version;
    private int hashCode;

    public VDBKey(String name, String version) {
        this.name = name;
        if (version != null) {
            this.version = Integer.parseInt(version);
        }
    }

    public VDBKey(String name, int version) {
        this.name = name;
        this.version = version;
    }

    public String getName() {
        return this.name;
    }

    public int getVersion() {
        return this.version;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = HashCodeUtil.hashCode(HashCodeUtil.expHashCode(this.name, false), this.version);
        }
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof VDBKey)) {
            return false;
        }
        VDBKey other = (VDBKey)obj;
        return this.version == other.version && other.name.equalsIgnoreCase(this.name);
    }

    public String toString() {
        return this.name + " " + this.version;
    }

    @Override
    public int compareTo(VDBKey o) {
        int compare = String.CASE_INSENSITIVE_ORDER.compare(this.name, o.name);
        if (compare == 0) {
            return this.version - o.version;
        }
        return compare;
    }
}

