/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.process;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.TupleBuffer;
import org.teiid.common.buffer.TupleSource;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.query.processor.ProcessorDataManager;
import org.teiid.query.processor.RegisterRequestParameter;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.DependentSetCriteria;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.util.CommandContext;

public class TupleSourceCache {
    private Map<Integer, SharedState> sharedStates;

    public void close() {
        if (this.sharedStates != null) {
            for (SharedState ss : this.sharedStates.values()) {
                ss.remove();
            }
            this.sharedStates = null;
        }
    }

    public TupleSource getSharedTupleSource(CommandContext context, Command command, String modelName, RegisterRequestParameter parameterObject, BufferManager bufferMgr, ProcessorDataManager pdm) throws TeiidComponentException, TeiidProcessingException {
        SharedState state;
        if (this.sharedStates == null) {
            this.sharedStates = new HashMap<Integer, SharedState>();
        }
        if ((state = this.sharedStates.get(parameterObject.info.id)) == null) {
            state = new SharedState();
            state.expectedReaders = parameterObject.info.sharingCount;
            RegisterRequestParameter param = new RegisterRequestParameter(parameterObject.connectorBindingId, parameterObject.nodeID, -1);
            param.fetchSize = parameterObject.fetchSize;
            state.ts = pdm.registerRequest(context, command, modelName, param);
            if (param.doNotCache) {
                return state.ts;
            }
            state.tb = bufferMgr.createTupleBuffer(command.getProjectedSymbols(), context.getConnectionId(), BufferManager.TupleSourceType.PROCESSOR);
            state.id = parameterObject.info.id;
            this.sharedStates.put(parameterObject.info.id, state);
        }
        return new SharedTupleSource(state);
    }

    private class SharedTupleSource
    extends CopyOnReadTupleSource {
        private SharedState state;

        public SharedTupleSource(SharedState state) {
            super(state.tb, state.ts);
            this.state = state;
        }

        @Override
        public void closeSource() {
            if (--this.state.expectedReaders == 0 && TupleSourceCache.this.sharedStates != null && TupleSourceCache.this.sharedStates.containsKey(this.state.id)) {
                this.state.remove();
                TupleSourceCache.this.sharedStates.remove(this.state.id);
            }
        }
    }

    public static abstract class CopyOnReadTupleSource
    implements TupleSource {
        int rowNumber = 1;
        TupleBuffer tb;
        TupleSource ts;

        protected CopyOnReadTupleSource(TupleBuffer tb, TupleSource ts) {
            this.tb = tb;
            this.ts = ts;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<?> nextTuple() throws TeiidComponentException, TeiidProcessingException {
            TupleBuffer tupleBuffer = this.tb;
            synchronized (tupleBuffer) {
                if (this.rowNumber <= this.tb.getRowCount()) {
                    return this.tb.getBatch(this.rowNumber).getTuple(this.rowNumber++);
                }
                if (this.tb.isFinal()) {
                    return null;
                }
                List<?> row = this.ts.nextTuple();
                if (row == null) {
                    this.tb.setFinal(true);
                } else {
                    this.tb.addTuple(row);
                    ++this.rowNumber;
                }
                return row;
            }
        }
    }

    private static class SharedState {
        TupleBuffer tb;
        TupleSource ts;
        int id;
        int expectedReaders;

        private SharedState() {
        }

        private void remove() {
            this.ts.closeSource();
            this.tb.remove();
            this.tb = null;
            this.ts = null;
        }
    }

    static final class CachableVisitor
    extends LanguageVisitor {
        boolean cacheable = true;
        List<Object> parameters;

        CachableVisitor() {
        }

        @Override
        public void visit(Constant c) {
            if (c.isMultiValued()) {
                this.notCachable();
            } else if (DataTypeManager.isLOB(c.getType())) {
                if (this.parameters == null) {
                    this.parameters = new ArrayList<Object>();
                }
                this.parameters.add(c.getValue());
            }
        }

        private void notCachable() {
            this.cacheable = false;
            this.setAbort(true);
        }

        @Override
        public void visit(DependentSetCriteria obj) {
            this.notCachable();
        }
    }
}

