/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.analysis;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import org.teiid.client.plan.Annotation;
import org.teiid.client.plan.PlanNode;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.util.PropertiesUtils;
import org.teiid.logging.LogManager;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.SubqueryContainer;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.Symbol;
import org.teiid.query.sql.visitor.ValueIteratorProviderCollectorVisitor;

public class AnalysisRecord {
    private static final int MAX_PLAN_LENGTH = PropertiesUtils.getIntProperty((Properties)System.getProperties(), (String)"org.teiid.maxPlanLength", (int)0x2000000);
    public static final String PROP_OUTPUT_COLS = "Output Columns";
    public static final String PROP_CRITERIA = "Criteria";
    public static final String PROP_SELECT_COLS = "Select Columns";
    public static final String PROP_GROUP_COLS = "Grouping Columns";
    public static final String PROP_SQL = "Query";
    public static final String PROP_MODEL_NAME = "Model Name";
    public static final String PROP_SHARING_ID = "Sharing ID";
    public static final String PROP_DEPENDENT = "Dependent Join";
    public static final String PROP_JOIN_STRATEGY = "Join Strategy";
    public static final String PROP_JOIN_TYPE = "Join Type";
    public static final String PROP_JOIN_CRITERIA = "Join Criteria";
    public static final String PROP_EXECUTION_PLAN = "Execution Plan";
    public static final String PROP_INTO_GROUP = "Into Target";
    public static final String PROP_SORT_COLS = "Sort Columns";
    public static final String PROP_SORT_MODE = "Sort Mode";
    public static final String PROP_ROLLUP = "Rollup";
    public static final String PROP_NODE_STATS_LIST = "Statistics";
    public static final String PROP_NODE_COST_ESTIMATES = "Cost Estimates";
    public static final String PROP_ROW_OFFSET = "Row Offset";
    public static final String PROP_ROW_LIMIT = "Row Limit";
    public static final String PROP_WITH = "With";
    public static final String PROP_MESSAGE = "Message";
    public static final String PROP_TAG = "Tag";
    public static final String PROP_NAMESPACE = "Namespace";
    public static final String PROP_DATA_COL = "Data Column";
    public static final String PROP_NAMESPACE_DECL = "Namespace Declarations";
    public static final String PROP_OPTIONAL = "Optional Flag";
    public static final String PROP_DEFAULT = "Default Value";
    public static final String PROP_RECURSE_DIR = "Recursion Direction";
    public static final String PROP_BINDINGS = "Bindings";
    public static final String PROP_IS_STAGING = "Is Staging Flag";
    public static final String PROP_IN_MEMORY = "Source In Memory Flag";
    public static final String PROP_CONDITION = "Condition";
    public static final String PROP_DEFAULT_PROGRAM = "Default Program";
    public static final String PROP_ENCODING = "Encoding";
    public static final String PROP_FORMATTED = "Formatted Flag";
    public static final String PROP_EXPRESSION = "Expression";
    public static final String PROP_RESULT_SET = "Result Set";
    public static final String PROP_PROGRAM = "Program";
    public static final String PROP_VARIABLE = "Variable";
    public static final String PROP_THEN = "Then";
    public static final String PROP_ELSE = "Else";
    private boolean recordQueryPlan;
    private boolean recordDebug;
    private Collection<Annotation> annotations;
    private StringWriter stringWriter;
    private PrintWriter debugWriter;

    public AnalysisRecord(boolean recordQueryPlan, boolean recordDebug) {
        this.recordQueryPlan = recordQueryPlan | LogManager.isMessageToBeRecorded((String)"org.teiid.PLANNER", (int)5);
        this.recordDebug = recordDebug | LogManager.isMessageToBeRecorded((String)"org.teiid.PLANNER", (int)6);
        if (this.recordQueryPlan) {
            this.annotations = new ArrayList<Annotation>();
        }
        if (this.recordDebug) {
            this.stringWriter = new StringWriter();
            this.debugWriter = new PrintWriter(this.stringWriter);
        }
    }

    public static AnalysisRecord createNonRecordingRecord() {
        return new AnalysisRecord(false, false);
    }

    public boolean recordQueryPlan() {
        return this.recordQueryPlan;
    }

    public boolean recordAnnotations() {
        return this.recordQueryPlan;
    }

    public boolean recordDebug() {
        return this.recordDebug;
    }

    public void addAnnotation(String category, String annotation, String resolution, Annotation.Priority priority) {
        this.addAnnotation(new Annotation(category, annotation, resolution, priority));
    }

    public void addAnnotation(Annotation annotation) {
        this.annotations.add(annotation);
        if (this.recordDebug()) {
            this.println(annotation.getPriority() + " " + annotation.getCategory() + " " + annotation.getAnnotation() + " - " + annotation.getResolution());
        }
    }

    public Collection<Annotation> getAnnotations() {
        return this.annotations;
    }

    public void println(String debugLine) {
        if (this.stringWriter.getBuffer().length() > MAX_PLAN_LENGTH) {
            this.stringWriter.getBuffer().delete(0, this.stringWriter.getBuffer().length() - MAX_PLAN_LENGTH * 3 / 4);
        }
        this.debugWriter.println(debugLine);
    }

    public String getDebugLog() {
        if (this.recordDebug) {
            return this.stringWriter.getBuffer().toString();
        }
        return null;
    }

    public void stopDebugLog() {
        this.stringWriter = null;
        this.recordDebug = false;
    }

    public static List<String> getOutputColumnProperties(List<? extends Expression> projectedSymbols) {
        if (projectedSymbols != null) {
            ArrayList<String> outputCols = new ArrayList<String>(projectedSymbols.size());
            for (int i = 0; i < projectedSymbols.size(); ++i) {
                Expression symbol = projectedSymbols.get(i);
                outputCols.add(Symbol.getShortName(symbol) + " (" + DataTypeManager.getDataTypeName(symbol.getType()) + ")");
            }
            return outputCols;
        }
        return Collections.emptyList();
    }

    public static void addLanaguageObjects(PlanNode node, String key, List<? extends LanguageObject> objects) {
        ArrayList<String> values = new ArrayList<String>();
        int index = 0;
        for (LanguageObject languageObject : objects) {
            values.add(languageObject.toString());
            List<SubqueryContainer<?>> subqueries = ValueIteratorProviderCollectorVisitor.getValueIteratorProviders(languageObject);
            ListIterator<SubqueryContainer<?>> iterator = subqueries.listIterator();
            while (iterator.hasNext()) {
                SubqueryContainer<?> subqueryContainer = iterator.next();
                node.addProperty(key + " Subplan " + index++, ((Command)subqueryContainer.getCommand()).getProcessorPlan().getDescriptionProperties());
            }
        }
        node.addProperty(key, values);
    }
}

