/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.types;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.sql.SQLXML;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.core.types.InputStreamFactory;
import org.teiid.core.types.SQLXMLImpl;
import org.teiid.core.types.Streamable;
import org.teiid.core.types.XMLType;
import org.teiid.core.util.UnitTestUtil;

public class TestXMLValue {
    @Test
    public void testXMLValue() throws Exception {
        String testString = "<foo>this is an xml value test</foo>";
        SQLXMLImpl xml = new SQLXMLImpl(testString);
        XMLType xv = new XMLType((SQLXML)xml);
        Assert.assertEquals((Object)testString, (Object)xv.getString());
    }

    @Test
    public void testXMLValuePersistence() throws Exception {
        String testString = "<foo>this is an xml value test</foo>";
        SQLXMLImpl xml = new SQLXMLImpl(testString);
        XMLType xv = new XMLType((SQLXML)xml);
        String key = xv.getReferenceStreamId();
        XMLType read = UnitTestUtil.helpSerialize(xv);
        Assert.assertEquals((Object)key, (Object)read.getReferenceStreamId());
        Assert.assertNull((Object)read.getReference());
    }

    @Test
    public void testReferencePersistence() throws Exception {
        String testString = "<foo>this is an xml value test</foo>";
        SQLXMLImpl xml = new SQLXMLImpl(testString);
        XMLType xv = new XMLType((SQLXML)xml);
        xv.setReferenceStreamId(null);
        XMLType read = UnitTestUtil.helpSerialize(xv);
        Assert.assertEquals((Object)testString, (Object)read.getString());
    }

    @Test
    public void testLength() throws Exception {
        String testString = "<foo>this is an xml value test</foo>";
        SQLXMLImpl xml = new SQLXMLImpl(testString);
        XMLType xv = new XMLType((SQLXML)xml);
        Assert.assertEquals((long)36L, (long)xv.length());
        xml = new SQLXMLImpl(new InputStreamFactory(){

            public InputStream getInputStream() throws IOException {
                return new ByteArrayInputStream("<bar/>".getBytes(Streamable.CHARSET));
            }
        });
        xv = new XMLType((SQLXML)xml);
        try {
            xv.length();
            Assert.fail();
        }
        catch (SQLException e) {
            // empty catch block
        }
    }
}

