/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer.relational.rules;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryPlannerException;
import org.teiid.core.TeiidComponentException;
import org.teiid.metadata.FunctionMethod;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.relational.RelationalPlanner;
import org.teiid.query.optimizer.relational.plantree.NodeConstants;
import org.teiid.query.optimizer.relational.plantree.PlanNode;
import org.teiid.query.optimizer.relational.rules.NewCalculateCostUtil;
import org.teiid.query.optimizer.relational.rules.RuleChooseJoinStrategy;
import org.teiid.query.optimizer.relational.rules.RulePlanJoins;
import org.teiid.query.resolver.util.AccessPattern;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.CompareCriteria;
import org.teiid.query.sql.lang.CompoundCriteria;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.Function;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.visitor.ElementCollectorVisitor;
import org.teiid.query.sql.visitor.FunctionCollectorVisitor;
import org.teiid.query.sql.visitor.GroupsUsedByElementsVisitor;
import org.teiid.query.util.CommandContext;

class JoinRegion {
    private PlanNode joinRoot;
    public static final int UNKNOWN_TUPLE_EST = 100000;
    private LinkedHashMap<PlanNode, PlanNode> dependentJoinSourceNodes = new LinkedHashMap();
    private LinkedHashMap<PlanNode, PlanNode> joinSourceNodes = new LinkedHashMap();
    private List<PlanNode> dependentCritieraNodes = new ArrayList<PlanNode>();
    private List<PlanNode> criteriaNodes = new ArrayList<PlanNode>();
    private List<Collection<AccessPattern>> unsatisfiedAccessPatterns = new LinkedList<Collection<AccessPattern>>();
    private boolean containsNestedTable;
    private Map<ElementSymbol, Set<Collection<GroupSymbol>>> dependentCriteriaElements;
    private Map<PlanNode, Set<PlanNode>> critieriaToSourceMap;
    private HashMap<List<Object>, Float> depCache;

    JoinRegion() {
    }

    public PlanNode getJoinRoot() {
        return this.joinRoot;
    }

    public void setContainsNestedTable(boolean containsNestedTable) {
        this.containsNestedTable = containsNestedTable;
    }

    public boolean containsNestedTable() {
        return this.containsNestedTable;
    }

    public List<Collection<AccessPattern>> getUnsatisfiedAccessPatterns() {
        return this.unsatisfiedAccessPatterns;
    }

    public Map<PlanNode, PlanNode> getJoinSourceNodes() {
        return this.joinSourceNodes;
    }

    public Map<PlanNode, PlanNode> getDependentJoinSourceNodes() {
        return this.dependentJoinSourceNodes;
    }

    public List<PlanNode> getCriteriaNodes() {
        return this.criteriaNodes;
    }

    public List<PlanNode> getDependentCriteriaNodes() {
        return this.dependentCritieraNodes;
    }

    public Map<ElementSymbol, Set<Collection<GroupSymbol>>> getDependentCriteriaElements() {
        return this.dependentCriteriaElements;
    }

    public Map<PlanNode, Set<PlanNode>> getCritieriaToSourceMap() {
        return this.critieriaToSourceMap;
    }

    public void addJoinSourceNode(PlanNode sourceNode) {
        PlanNode root = sourceNode;
        while (root.getParent() != null && root.getParent().getType() == 16) {
            root = root.getParent();
        }
        if (sourceNode.hasCollectionProperty(NodeConstants.Info.ACCESS_PATTERNS)) {
            Collection aps = (Collection)sourceNode.getProperty(NodeConstants.Info.ACCESS_PATTERNS);
            this.unsatisfiedAccessPatterns.add(aps);
            this.dependentJoinSourceNodes.put(sourceNode, root);
        } else {
            this.joinSourceNodes.put(sourceNode, root);
        }
        if (this.joinRoot == null) {
            this.joinRoot = root;
        }
    }

    public void addParentCriteria(PlanNode sourceNode) {
        for (PlanNode parent = sourceNode.getParent(); parent != null && parent.getType() == 16; parent = parent.getParent()) {
            this.criteriaNodes.add(parent);
            sourceNode = parent;
        }
        if (this.joinRoot == null) {
            this.joinRoot = sourceNode;
        }
    }

    public void addJoinCriteriaList(List<? extends Criteria> joinCriteria) {
        if (joinCriteria == null || joinCriteria.isEmpty()) {
            return;
        }
        for (Criteria criteria : joinCriteria) {
            this.criteriaNodes.add(RelationalPlanner.createSelectNode(criteria, false));
        }
    }

    public void reconstructJoinRegoin() {
        LinkedHashMap<PlanNode, PlanNode> combined = new LinkedHashMap<PlanNode, PlanNode>(this.joinSourceNodes);
        combined.putAll(this.dependentJoinSourceNodes);
        PlanNode root = null;
        if (combined.size() < 2) {
            root = combined.values().iterator().next();
        } else {
            root = RulePlanJoins.createJoinNode();
            for (Map.Entry<PlanNode, PlanNode> entry : combined.entrySet()) {
                PlanNode joinSourceRoot = entry.getValue();
                if (root.getChildCount() == 2) {
                    PlanNode parentJoin = RulePlanJoins.createJoinNode();
                    parentJoin.addFirstChild(root);
                    parentJoin.addGroups(root.getGroups());
                    root = parentJoin;
                }
                root.addLastChild(joinSourceRoot);
                root.addGroups(entry.getKey().getGroups());
            }
        }
        LinkedList<PlanNode> criteria = new LinkedList<PlanNode>(this.dependentCritieraNodes);
        criteria.addAll(this.criteriaNodes);
        PlanNode parent = this.joinRoot.getParent();
        boolean isLeftChild = parent.getFirstChild() == this.joinRoot;
        parent.removeChild(this.joinRoot);
        for (PlanNode critNode : criteria) {
            critNode.removeFromParent();
            critNode.removeAllChildren();
            critNode.addFirstChild(root);
            root = critNode;
            critNode.removeProperty((Object)NodeConstants.Info.IS_COPIED);
            critNode.removeProperty((Object)NodeConstants.Info.EST_CARDINALITY);
        }
        if (isLeftChild) {
            parent.addFirstChild(root);
        } else {
            parent.addLastChild(root);
        }
        this.joinRoot = root;
    }

    public double scoreRegion(Object[] joinOrder, int startIndex, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, CommandContext context) throws QueryMetadataException, TeiidComponentException, QueryPlannerException {
        ArrayList<Map.Entry<PlanNode, PlanNode>> joinSourceEntries = new ArrayList<Map.Entry<PlanNode, PlanNode>>(this.joinSourceNodes.entrySet());
        double totalIntermediatCost = 0.0;
        double cost = 1.0;
        HashSet<PlanNode> criteria = new HashSet<PlanNode>(this.criteriaNodes);
        HashSet<GroupSymbol> groups = new HashSet<GroupSymbol>(this.joinSourceNodes.size());
        boolean hasUnknown = false;
        for (int i = 0; i < joinOrder.length - 1; ++i) {
            PlanNode joinSource;
            Collection requiredGroups;
            Integer source = (Integer)joinOrder[i];
            Map.Entry entry = (Map.Entry)joinSourceEntries.get(source);
            PlanNode joinSourceRoot = (PlanNode)entry.getValue();
            if (!(startIndex != 0 || this.unsatisfiedAccessPatterns.isEmpty() && !this.containsNestedTable || (requiredGroups = (Collection)(joinSource = (PlanNode)entry.getKey()).getProperty(NodeConstants.Info.REQUIRED_ACCESS_PATTERN_GROUPS)) == null || groups.containsAll(requiredGroups))) {
                return Double.MAX_VALUE;
            }
            groups.addAll(joinSourceRoot.getGroups());
            if (startIndex > 0) continue;
            float sourceCost = ((Float)joinSourceRoot.getProperty(NodeConstants.Info.EST_CARDINALITY)).floatValue();
            List<PlanNode> applicableCriteria = null;
            if (!criteria.isEmpty() && i > 0) {
                applicableCriteria = this.getJoinCriteriaForGroups(groups, criteria);
            }
            if (sourceCost == -1.0f) {
                sourceCost = 100000.0f;
                hasUnknown = true;
                if (applicableCriteria != null && !applicableCriteria.isEmpty()) {
                    CompoundCriteria cc = new CompoundCriteria();
                    for (PlanNode planNode : applicableCriteria) {
                        cc.addCriteria((Criteria)planNode.getProperty(NodeConstants.Info.SELECT_CRITERIA));
                    }
                    sourceCost = (float)cost;
                    criteria.removeAll(applicableCriteria);
                    applicableCriteria = null;
                    sourceCost = NewCalculateCostUtil.usesKey(cc, metadata) || i >= 1 && joinSourceRoot.hasProperty(NodeConstants.Info.MAKE_DEP) && !joinSourceRoot.hasBooleanProperty(NodeConstants.Info.MAKE_NOT_DEP) ? Math.min(100000.0f, sourceCost * Math.min(20.0f, sourceCost)) : Math.min(100000.0f, sourceCost * 20.0f * 8.0f);
                }
            } else {
                if (Double.isInfinite(sourceCost) || Double.isNaN(sourceCost)) {
                    return Double.MAX_VALUE;
                }
                if (i == 1 && applicableCriteria != null && !applicableCriteria.isEmpty()) {
                    List<Object> key = Arrays.asList(joinOrder[0], joinOrder[1]);
                    Float depJoinCost = null;
                    if (this.depCache != null && this.depCache.containsKey(key)) {
                        depJoinCost = this.depCache.get(key);
                    } else {
                        Integer indIndex = (Integer)joinOrder[0];
                        Map.Entry indEntry = (Map.Entry)joinSourceEntries.get(indIndex);
                        PlanNode possibleInd = (PlanNode)indEntry.getValue();
                        depJoinCost = this.getDepJoinCost(metadata, capFinder, context, possibleInd, applicableCriteria, joinSourceRoot);
                        if (this.depCache == null) {
                            this.depCache = new HashMap();
                        }
                        this.depCache.put(key, depJoinCost);
                    }
                    if (depJoinCost != null) {
                        sourceCost = depJoinCost.floatValue();
                    }
                }
            }
            if (i > 0 && (applicableCriteria == null || applicableCriteria.isEmpty()) && hasUnknown) {
                sourceCost *= 10.0f;
            }
            cost *= (double)sourceCost;
            if (applicableCriteria != null) {
                for (PlanNode criteriaNode : applicableCriteria) {
                    float filter = ((Float)criteriaNode.getProperty(NodeConstants.Info.EST_SELECTIVITY)).floatValue();
                    cost *= (double)filter;
                }
                criteria.removeAll(applicableCriteria);
            }
            totalIntermediatCost += cost;
        }
        return totalIntermediatCost;
    }

    private Float getDepJoinCost(QueryMetadataInterface metadata, CapabilitiesFinder capFinder, CommandContext context, PlanNode indNode, List<PlanNode> applicableCriteria, PlanNode depNode) throws QueryMetadataException, TeiidComponentException, QueryPlannerException {
        if (depNode.hasBooleanProperty(NodeConstants.Info.MAKE_NOT_DEP)) {
            return null;
        }
        float indCost = indNode.getCardinality();
        if (indCost == -1.0f) {
            return null;
        }
        ArrayList<Criteria> crits = new ArrayList<Criteria>(applicableCriteria.size());
        for (PlanNode planNode : applicableCriteria) {
            crits.add((Criteria)planNode.getProperty(NodeConstants.Info.SELECT_CRITERIA));
        }
        LinkedList<Expression> leftExpressions = new LinkedList<Expression>();
        LinkedList<Expression> rightExpressions = new LinkedList<Expression>();
        RuleChooseJoinStrategy.separateCriteria(indNode.getGroups(), depNode.getGroups(), leftExpressions, rightExpressions, crits, new LinkedList<Criteria>());
        if (leftExpressions.isEmpty()) {
            return null;
        }
        return NewCalculateCostUtil.computeCostForDepJoin((PlanNode)indNode, (PlanNode)depNode, leftExpressions, rightExpressions, (QueryMetadataInterface)metadata, (CapabilitiesFinder)capFinder, (CommandContext)context).expectedCardinality;
    }

    public boolean isSatisfiable() {
        for (Collection<AccessPattern> accessPatterns : this.getUnsatisfiedAccessPatterns()) {
            boolean matchedAll = false;
            for (AccessPattern ap : accessPatterns) {
                if (!this.dependentCriteriaElements.keySet().containsAll(ap.getUnsatisfied())) continue;
                matchedAll = true;
                break;
            }
            if (matchedAll) continue;
            return false;
        }
        return true;
    }

    public void initializeCostingInformation(QueryMetadataInterface metadata) throws QueryMetadataException, TeiidComponentException {
        for (PlanNode node : this.joinSourceNodes.values()) {
            NewCalculateCostUtil.computeCostForTree(node, metadata);
        }
        this.estimateCriteriaSelectivity(metadata);
    }

    private void estimateCriteriaSelectivity(QueryMetadataInterface metadata) throws QueryMetadataException, TeiidComponentException {
        for (PlanNode node : this.criteriaNodes) {
            Criteria crit = (Criteria)node.getProperty(NodeConstants.Info.SELECT_CRITERIA);
            float[] baseCosts = new float[]{100.0f, 10000.0f, 1000000.0f};
            float filterValue = 0.0f;
            for (int j = 0; j < baseCosts.length; ++j) {
                float filter = NewCalculateCostUtil.recursiveEstimateCostOfCriteria(baseCosts[j], node, crit, metadata);
                filterValue += filter / baseCosts[j];
            }
            node.setProperty(NodeConstants.Info.EST_SELECTIVITY, new Float(filterValue /= (float)baseCosts.length));
        }
    }

    public void initializeJoinInformation() {
        this.critieriaToSourceMap = new HashMap<PlanNode, Set<PlanNode>>();
        LinkedList<PlanNode> crits = new LinkedList<PlanNode>(this.criteriaNodes);
        crits.addAll(this.dependentCritieraNodes);
        LinkedHashMap<PlanNode, PlanNode> source = new LinkedHashMap<PlanNode, PlanNode>(this.joinSourceNodes);
        source.putAll(this.dependentJoinSourceNodes);
        for (PlanNode critNode : crits) {
            block1: for (GroupSymbol group : critNode.getGroups()) {
                for (PlanNode node : source.keySet()) {
                    if (!node.getGroups().contains(group)) continue;
                    Set<PlanNode> sources = this.critieriaToSourceMap.get(critNode);
                    if (sources == null) {
                        sources = new HashSet<PlanNode>();
                        this.critieriaToSourceMap.put(critNode, sources);
                    }
                    sources.add(node);
                    continue block1;
                }
            }
        }
        if (this.unsatisfiedAccessPatterns.isEmpty()) {
            return;
        }
        HashMap<GroupSymbol, PlanNode> dependentGroupToSourceMap = new HashMap<GroupSymbol, PlanNode>();
        for (PlanNode node : this.dependentJoinSourceNodes.keySet()) {
            for (GroupSymbol symbol : node.getGroups()) {
                dependentGroupToSourceMap.put(symbol, node);
            }
        }
        Iterator<PlanNode> i = this.getCriteriaNodes().iterator();
        block5: while (i.hasNext()) {
            PlanNode node;
            node = i.next();
            for (GroupSymbol symbol : node.getGroups()) {
                if (!dependentGroupToSourceMap.containsKey(symbol)) continue;
                i.remove();
                this.dependentCritieraNodes.add(node);
                continue block5;
            }
        }
        this.dependentCriteriaElements = new HashMap<ElementSymbol, Set<Collection<GroupSymbol>>>();
        for (PlanNode critNode : this.dependentCritieraNodes) {
            CompareCriteria compCrit;
            Criteria crit = (Criteria)critNode.getProperty(NodeConstants.Info.SELECT_CRITERIA);
            if (!(crit instanceof CompareCriteria) || (compCrit = (CompareCriteria)crit).getOperator() != 1) continue;
            CompareCriteria compareCriteria = (CompareCriteria)crit;
            Collection[] critElements = new Collection[2];
            critElements[0] = ElementCollectorVisitor.getElements((LanguageObject)compareCriteria.getLeftExpression(), true);
            if (critElements[0].isEmpty()) continue;
            critElements[1] = ElementCollectorVisitor.getElements((LanguageObject)compareCriteria.getRightExpression(), true);
            if (critElements[1].isEmpty()) continue;
            for (int expr = 0; expr < critElements.length; ++expr) {
                ElementSymbol elem;
                if (critElements[expr].size() != 1 || !dependentGroupToSourceMap.containsKey((elem = (ElementSymbol)critElements[expr].iterator().next()).getGroupSymbol()) || JoinRegion.containsFunctionsThatCannotBePushed(expr == 0 ? compareCriteria.getRightExpression() : compareCriteria.getLeftExpression())) continue;
                Set<Collection<GroupSymbol>> independentGroups = this.dependentCriteriaElements.get(elem);
                if (independentGroups == null) {
                    independentGroups = new HashSet<Collection<GroupSymbol>>();
                    this.dependentCriteriaElements.put(elem, independentGroups);
                }
                independentGroups.add(GroupsUsedByElementsVisitor.getGroups(critElements[(expr + 1) % 2]));
            }
        }
    }

    private static boolean containsFunctionsThatCannotBePushed(Expression expression) {
        for (Function function : FunctionCollectorVisitor.getFunctions((LanguageObject)expression, true)) {
            if (function.getFunctionDescriptor().getPushdown() != FunctionMethod.PushDown.CANNOT_PUSHDOWN) continue;
            return true;
        }
        return false;
    }

    public List<PlanNode> getJoinCriteriaForGroups(Set<GroupSymbol> groups) {
        return this.getJoinCriteriaForGroups(groups, this.getCriteriaNodes());
    }

    protected List<PlanNode> getJoinCriteriaForGroups(Set<GroupSymbol> groups, Collection<PlanNode> nodes) {
        LinkedList<PlanNode> result = new LinkedList<PlanNode>();
        for (PlanNode critNode : nodes) {
            if (!groups.containsAll(critNode.getGroups())) continue;
            result.add(critNode);
        }
        return result;
    }

    public void changeJoinOrder(Object[] joinOrder) {
        ArrayList<Map.Entry<PlanNode, PlanNode>> joinSourceEntries = new ArrayList<Map.Entry<PlanNode, PlanNode>>(this.joinSourceNodes.entrySet());
        for (int i = 0; i < joinOrder.length; ++i) {
            Integer source = (Integer)joinOrder[i];
            Map.Entry entry = (Map.Entry)joinSourceEntries.get(source);
            this.joinSourceNodes.remove(entry.getKey());
            this.joinSourceNodes.put((PlanNode)entry.getKey(), (PlanNode)entry.getValue());
        }
    }
}

