/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer;

import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.teiid.metadata.Table;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.optimizer.TestOptimizer;
import org.teiid.query.optimizer.capabilities.BasicSourceCapabilities;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.DefaultCapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.SourceCapabilities;
import org.teiid.query.processor.relational.AccessNode;
import org.teiid.query.processor.relational.RelationalPlan;
import org.teiid.query.unittest.RealMetadataFactory;

public class TestConformedTables {
    private static TransformationMetadata tm;

    @BeforeClass
    public static void oneTimeSetup() throws Exception {
        tm = RealMetadataFactory.example1();
        Table t = tm.getGroupID("pm1.g1");
        t.setProperty("{http://www.teiid.org/ext/relational/2012}conformed-sources", "pm2");
        t = tm.getGroupID("pm2.g3");
        t.setProperty("{http://www.teiid.org/ext/relational/2012}conformed-sources", "pm1");
        t = tm.getGroupID("pm2.g1");
        t.setProperty("{http://www.teiid.org/ext/relational/2012}conformed-sources", "pm3");
    }

    @Test
    public void testConformedJoin() throws Exception {
        String sql = "select pm1.g1.e1 from pm1.g1, pm2.g2 where g1.e1=g2.e1";
        RelationalPlan plan = (RelationalPlan)TestOptimizer.helpPlan(sql, (QueryMetadataInterface)tm, new String[]{"SELECT g_0.e1 FROM pm1.g1 AS g_0, pm2.g2 AS g_1 WHERE g_0.e1 = g_1.e1"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        AccessNode anode = (AccessNode)plan.getRootNode();
        Assert.assertEquals((Object)"pm2", (Object)anode.getModelName());
        sql = "select pm1.g1.e1 from pm2.g2, pm1.g1 where g1.e1=g2.e1";
        plan = (RelationalPlan)TestOptimizer.helpPlan(sql, (QueryMetadataInterface)tm, new String[]{"SELECT g_1.e1 FROM pm2.g2 AS g_0, pm1.g1 AS g_1 WHERE g_1.e1 = g_0.e1"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        anode = (AccessNode)plan.getRootNode();
        Assert.assertEquals((Object)"pm2", (Object)anode.getModelName());
    }

    @Test
    public void testConformedJoin1() throws Exception {
        String sql = "select pm1.g1.e1 from pm1.g1, pm2.g1 where pm1.g1.e1=pm2.g1.e1";
        TestOptimizer.helpPlan(sql, (QueryMetadataInterface)tm, new String[]{"SELECT g_0.e1 FROM pm1.g1 AS g_0, pm2.g1 AS g_1 WHERE g_0.e1 = g_1.e1"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
    }

    @Test
    public void testConformedSubquery() throws Exception {
        String sql = "select pm2.g2.e1 from pm2.g2 where e1 in (select e1 from pm1.g1)";
        BasicSourceCapabilities bsc = TestOptimizer.getTypicalCapabilities();
        bsc.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_IN_SUBQUERY, true);
        TestOptimizer.helpPlan(sql, (QueryMetadataInterface)tm, new String[]{"SELECT g_0.e1 FROM pm2.g2 AS g_0 WHERE g_0.e1 IN (SELECT g_1.e1 FROM pm1.g1 AS g_1)"}, (CapabilitiesFinder)new DefaultCapabilitiesFinder((SourceCapabilities)bsc), TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        sql = "select pm1.g1.e1 from pm1.g1 where e2 in (select e2 from pm2.g2)";
    }

    @Test
    public void testConformedSubquery1() throws Exception {
        String sql = "select pm2.g3.e1 from pm2.g3 where e1 in (select e1 from pm1.g1)";
        BasicSourceCapabilities bsc = TestOptimizer.getTypicalCapabilities();
        bsc.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_IN_SUBQUERY, true);
        TestOptimizer.helpPlan(sql, (QueryMetadataInterface)tm, new String[]{"SELECT g_0.e1 FROM pm2.g3 AS g_0 WHERE g_0.e1 IN (SELECT g_1.e1 FROM pm1.g1 AS g_1)"}, (CapabilitiesFinder)new DefaultCapabilitiesFinder((SourceCapabilities)bsc), TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
    }
}

