/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.datamgr;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.InitialContext;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.util.Assertion;
import org.teiid.dqp.internal.datamgr.CapabilitiesConverter;
import org.teiid.dqp.internal.datamgr.ConnectorWork;
import org.teiid.dqp.internal.datamgr.ConnectorWorkItem;
import org.teiid.dqp.message.AtomicRequestID;
import org.teiid.dqp.message.AtomicRequestMessage;
import org.teiid.logging.CommandLogMessage;
import org.teiid.logging.LogManager;
import org.teiid.metadata.FunctionMethod;
import org.teiid.query.QueryPlugin;
import org.teiid.query.function.metadata.FunctionMetadataValidator;
import org.teiid.query.optimizer.capabilities.BasicSourceCapabilities;
import org.teiid.query.optimizer.capabilities.SourceCapabilities;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.validator.ValidatorReport;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ExecutionFactory;
import org.teiid.translator.TranslatorException;

public class ConnectorManager {
    private static final String JAVA_CONTEXT = "java:/";
    private final String translatorName;
    private final String connectionName;
    private final String jndiName;
    private final List<String> id;
    private final ConcurrentHashMap<AtomicRequestID, ConnectorWork> requestStates = new ConcurrentHashMap();
    private volatile SourceCapabilities cachedCapabilities;
    private volatile boolean stopped;
    private final ExecutionFactory<Object, Object> executionFactory;
    private List<FunctionMethod> functions;

    public ConnectorManager(String translatorName, String connectionName) {
        this(translatorName, connectionName, (ExecutionFactory<Object, Object>)new ExecutionFactory());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectorManager(String translatorName, String connectionName, ExecutionFactory<Object, Object> ef) {
        this.translatorName = translatorName;
        this.connectionName = connectionName;
        this.jndiName = this.connectionName != null ? (!this.connectionName.startsWith(JAVA_CONTEXT) ? JAVA_CONTEXT + this.connectionName : this.connectionName) : null;
        this.executionFactory = ef;
        this.id = Arrays.asList(translatorName, connectionName);
        if (ef != null) {
            ClassLoader originalCL = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(ef.getClass().getClassLoader());
                this.functions = ef.getPushDownFunctions();
            }
            finally {
                Thread.currentThread().setContextClassLoader(originalCL);
            }
            if (this.functions != null) {
                for (FunctionMethod functionMethod : this.functions) {
                    functionMethod.setProperty("{http://www.teiid.org/ext/relational/2012}system-name", functionMethod.getName());
                }
                ValidatorReport report = new ValidatorReport("Function Validation");
                FunctionMetadataValidator.validateFunctionMethods(this.functions, report);
                if (report.hasItems()) {
                    throw new TeiidRuntimeException(report.getFailureMessage());
                }
            }
        }
    }

    public String getStausMessage() {
        String msg = "";
        ExecutionFactory<Object, Object> ef = this.getExecutionFactory();
        if (ef != null) {
            if (ef.isSourceRequired()) {
                Object conn = null;
                try {
                    conn = this.getConnectionFactory();
                }
                catch (TranslatorException e) {
                    // empty catch block
                }
                if (conn == null) {
                    msg = QueryPlugin.Util.getString("datasource_not_found", new Object[]{this.connectionName});
                }
            }
        } else {
            msg = QueryPlugin.Util.getString("translator_not_found", new Object[]{this.translatorName});
        }
        return msg;
    }

    public List<FunctionMethod> getPushDownFunctions() {
        return this.functions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SourceCapabilities getCapabilities() throws TranslatorException, TeiidComponentException {
        if (this.cachedCapabilities != null) {
            return this.cachedCapabilities;
        }
        this.checkStatus();
        ExecutionFactory<Object, Object> translator = this.getExecutionFactory();
        ConnectorManager connectorManager = this;
        synchronized (connectorManager) {
            if (this.cachedCapabilities != null) {
                return this.cachedCapabilities;
            }
            ClassLoader originalCL = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(translator.getClass().getClassLoader());
                this.cachedCapabilities = this.buildCapabilities(translator);
            }
            finally {
                Thread.currentThread().setContextClassLoader(originalCL);
            }
        }
        return this.cachedCapabilities;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private BasicSourceCapabilities buildCapabilities(ExecutionFactory<Object, Object> translator) throws TranslatorException {
        if (!translator.isSourceRequiredForCapabilities()) return CapabilitiesConverter.convertCapabilities(translator, this.id);
        Object connection = null;
        Object connectionFactory = null;
        try {
            connectionFactory = this.getConnectionFactory();
            if (connectionFactory != null) {
                connection = translator.getConnection(connectionFactory, null);
            }
            if (connection == null) {
                throw new TranslatorException((BundleUtil.Event)QueryPlugin.Event.TEIID31108, QueryPlugin.Util.getString("datasource_not_found", new Object[]{this.getConnectionName()}));
            }
            LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object)"Initializing the capabilities for", (Object)this.translatorName);
            this.executionFactory.initCapabilities(connection);
            if (connection == null) return CapabilitiesConverter.convertCapabilities(translator, this.id);
        }
        catch (Throwable throwable) {
            if (connection == null) throw throwable;
            translator.closeConnection(connection, connectionFactory);
            throw throwable;
        }
        translator.closeConnection(connection, connectionFactory);
        return CapabilitiesConverter.convertCapabilities(translator, this.id);
    }

    public ConnectorWork registerRequest(AtomicRequestMessage message) throws TeiidComponentException {
        this.checkStatus();
        AtomicRequestID atomicRequestId = message.getAtomicRequestID();
        LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object[])new Object[]{atomicRequestId, "Create State"});
        final ConnectorWorkItem item = new ConnectorWorkItem(message, this);
        ConnectorWork proxy = (ConnectorWork)Proxy.newProxyInstance(ConnectorWork.class.getClassLoader(), new Class[]{ConnectorWork.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                ClassLoader originalCL = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(ConnectorManager.this.getExecutionFactory().getClass().getClassLoader());
                    Object object = method.invoke((Object)item, args);
                    return object;
                }
                catch (InvocationTargetException e) {
                    throw e.getTargetException();
                }
                finally {
                    Thread.currentThread().setContextClassLoader(originalCL);
                }
            }
        });
        Assertion.isNull((Object)this.requestStates.put(atomicRequestId, proxy), (String)"State already existed");
        return proxy;
    }

    ConnectorWork getState(AtomicRequestID requestId) {
        return this.requestStates.get(requestId);
    }

    boolean removeState(AtomicRequestID sid) {
        LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object)sid, (Object)"Remove State");
        return this.requestStates.remove(sid) != null;
    }

    int size() {
        return this.requestStates.size();
    }

    public void start() {
        LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object)QueryPlugin.Util.getString("ConnectorManagerImpl.Initializing_connector", new Object[]{this.translatorName}));
    }

    public void stop() {
        this.stopped = true;
        for (ConnectorWork workItem : this.requestStates.values()) {
            workItem.cancel();
        }
    }

    void logSRCCommand(AtomicRequestMessage qr, ExecutionContext context, CommandLogMessage.Event cmdStatus, Integer finalRowCnt) {
        if (!LogManager.isMessageToBeRecorded((String)"org.teiid.COMMAND_LOG", (int)5)) {
            return;
        }
        String sqlStr = null;
        if (cmdStatus == CommandLogMessage.Event.NEW) {
            Command cmd = qr.getCommand();
            sqlStr = cmd != null ? cmd.toString() : null;
        }
        String userName = qr.getWorkContext().getUserName();
        String transactionID = null;
        if (qr.isTransactional()) {
            transactionID = qr.getTransactionContext().getTransactionId();
        }
        String modelName = qr.getModelName();
        AtomicRequestID sid = qr.getAtomicRequestID();
        String principal = userName == null ? "unknown" : userName;
        CommandLogMessage message = null;
        message = cmdStatus == CommandLogMessage.Event.NEW ? new CommandLogMessage(System.currentTimeMillis(), qr.getRequestID().toString(), (long)sid.getNodeID(), transactionID, modelName, this.translatorName, qr.getWorkContext().getSessionId(), principal, sqlStr, context) : new CommandLogMessage(System.currentTimeMillis(), qr.getRequestID().toString(), (long)sid.getNodeID(), transactionID, modelName, this.translatorName, qr.getWorkContext().getSessionId(), principal, finalRowCnt, cmdStatus, context);
        LogManager.log((int)5, (String)"org.teiid.COMMAND_LOG", (Object)message);
    }

    public ExecutionFactory<Object, Object> getExecutionFactory() {
        return this.executionFactory;
    }

    public Object getConnectionFactory() throws TranslatorException {
        if (this.connectionName != null) {
            try {
                InitialContext ic = new InitialContext();
                try {
                    return ic.lookup(this.jndiName);
                }
                catch (Exception e) {
                    if (!this.jndiName.equals(this.connectionName)) {
                        return ic.lookup(this.connectionName);
                    }
                    throw e;
                }
            }
            catch (Exception e) {
                throw new TranslatorException((BundleUtil.Event)QueryPlugin.Event.TEIID30481, (Throwable)e, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30481, new Object[]{this.connectionName}));
            }
        }
        return null;
    }

    private void checkStatus() throws TeiidComponentException {
        if (this.stopped) {
            throw new TeiidComponentException((BundleUtil.Event)QueryPlugin.Event.TEIID30482, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30482, new Object[]{this.translatorName}));
        }
    }

    public String getTranslatorName() {
        return this.translatorName;
    }

    public String getConnectionName() {
        return this.connectionName;
    }

    public List<String> getId() {
        return this.id;
    }
}

