/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.function;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.teiid.api.exception.query.InvalidFunctionException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.types.Transform;
import org.teiid.metadata.AggregateAttributes;
import org.teiid.metadata.FunctionMethod;
import org.teiid.metadata.FunctionParameter;
import org.teiid.query.QueryPlugin;
import org.teiid.query.function.FunctionDescriptor;
import org.teiid.query.function.FunctionTree;
import org.teiid.query.resolver.util.ResolverUtil;
import org.teiid.query.sql.symbol.AggregateSymbol;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.Function;

public class FunctionLibrary {
    public static final String CONVERT = "convert";
    public static final String CAST = "cast";
    public static final String LOOKUP = "lookup";
    public static final String USER = "user";
    public static final String ENV = "env";
    public static final String SESSION_ID = "session_id";
    public static final String CONTEXT = "context";
    public static final String ROWLIMIT = "rowlimit";
    public static final String ROWLIMITEXCEPTION = "rowlimitexception";
    public static final String DECODESTRING = "decodestring";
    public static final String DECODEINTEGER = "decodeinteger";
    public static final String COMMAND_PAYLOAD = "commandpayload";
    public static final String CONCAT = "CONCAT";
    public static final String CONCAT2 = "CONCAT2";
    public static final String CONCAT_OPERATOR = "||";
    public static final String SUBSTRING = "substring";
    public static final String NVL = "NVL";
    public static final String IFNULL = "IFNULL";
    public static final String FROM_UNIXTIME = "from_unixtime";
    public static final String TIMESTAMPADD = "timestampadd";
    public static final String PARSETIME = "parsetime";
    public static final String PARSEDATE = "parsedate";
    public static final String FORMATTIME = "formattime";
    public static final String FORMATDATE = "formatdate";
    public static final String NULLIF = "nullif";
    public static final String COALESCE = "coalesce";
    public static final String SPACE = "space";
    public static final String ARRAY_GET = "array_get";
    public static final String JSONARRAY = "jsonarray";
    public static final String MVSTATUS = "mvstatus";
    public static final Set<String> INTERNAL_SCHEMAS = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
    private FunctionTree systemFunctions;
    private FunctionTree[] userFunctions;
    private static final InvalidFunctionException GENERIC_EXCEPTION;

    public FunctionLibrary(FunctionTree systemFuncs, FunctionTree ... userFuncs) {
        this.systemFunctions = systemFuncs;
        this.userFunctions = userFuncs;
    }

    public FunctionTree[] getUserFunctions() {
        return this.userFunctions;
    }

    public FunctionTree getSystemFunctions() {
        return this.systemFunctions;
    }

    public List<String> getFunctionCategories() {
        TreeSet<String> categories = new TreeSet<String>();
        categories.addAll(this.systemFunctions.getCategories());
        if (this.userFunctions != null) {
            for (FunctionTree tree : this.userFunctions) {
                categories.addAll(tree.getCategories());
            }
        }
        ArrayList<String> categoryList = new ArrayList<String>(categories);
        return categoryList;
    }

    public List<FunctionMethod> getFunctionsInCategory(String category) {
        ArrayList<FunctionMethod> forms = new ArrayList<FunctionMethod>();
        forms.addAll(this.systemFunctions.getFunctionsInCategory(category));
        if (this.userFunctions != null) {
            for (FunctionTree tree : this.userFunctions) {
                forms.addAll(tree.getFunctionsInCategory(category));
            }
        }
        return forms;
    }

    public boolean hasFunctionMethod(String name, int numArgs) {
        List<FunctionMethod> methods = this.systemFunctions.findFunctionMethods(name, numArgs);
        if (!methods.isEmpty()) {
            return true;
        }
        if (this.userFunctions != null) {
            for (FunctionTree tree : this.userFunctions) {
                methods = tree.findFunctionMethods(name, numArgs);
                if (methods.isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    public FunctionDescriptor findFunction(String name, Class<?>[] types) {
        FunctionDescriptor descriptor = this.systemFunctions.getFunction(name, types);
        if (descriptor == null && this.userFunctions != null) {
            FunctionTree tree;
            FunctionTree[] arr$ = this.userFunctions;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && (descriptor = (tree = arr$[i$]).getFunction(name, types)) == null; ++i$) {
            }
        }
        return descriptor;
    }

    public List<FunctionDescriptor> findAllFunctions(String name, Class<?>[] types) {
        FunctionDescriptor descriptor = this.systemFunctions.getFunction(name, types);
        if (descriptor == null && this.userFunctions != null) {
            LinkedList<FunctionDescriptor> result = new LinkedList<FunctionDescriptor>();
            for (FunctionTree tree : this.userFunctions) {
                descriptor = tree.getFunction(name, types);
                if (descriptor == null) continue;
                if ("SYS".equals(descriptor.getSchema())) {
                    return Arrays.asList(descriptor);
                }
                result.add(descriptor);
            }
            return result;
        }
        if (descriptor != null) {
            return Arrays.asList(descriptor);
        }
        return Collections.emptyList();
    }

    public ConversionResult determineNecessaryConversions(String name, Class<?> returnType, Expression[] args, Class<?>[] types, boolean hasUnknownType) throws InvalidFunctionException {
        LinkedList<FunctionMethod> functionMethods = new LinkedList<FunctionMethod>();
        functionMethods.addAll(this.systemFunctions.findFunctionMethods(name, types.length));
        if (this.userFunctions != null) {
            for (FunctionTree tree : this.userFunctions) {
                functionMethods.addAll(tree.findFunctionMethods(name, types.length));
            }
        }
        int bestScore = Integer.MAX_VALUE;
        boolean ambiguous = false;
        FunctionMethod result = null;
        boolean isSystem = false;
        boolean narrowing = false;
        block5: for (FunctionMethod nextMethod : functionMethods) {
            boolean isSystemNext;
            int currentScore = 0;
            boolean nextNarrowing = false;
            List methodTypes = nextMethod.getInputParameters();
            for (int i = 0; i < types.length; ++i) {
                String tmpTypeName = ((FunctionParameter)methodTypes.get(Math.min(i, methodTypes.size() - 1))).getType();
                Class targetType = DataTypeManager.getDataTypeClass((String)tmpTypeName);
                Class sourceType = types[i];
                if (sourceType == null) {
                    ++currentScore;
                    continue;
                }
                if (sourceType.isArray() && targetType.isArray() && sourceType.getComponentType().equals(targetType.getComponentType())) {
                    ++currentScore;
                    continue;
                }
                if (sourceType.isArray()) {
                    if (this.isVarArgArrayParam(nextMethod, types, i, targetType)) continue;
                    sourceType = DataTypeManager.DefaultDataClasses.OBJECT;
                }
                try {
                    Transform t = this.getConvertFunctionDescriptor(sourceType, targetType);
                    if (t == null) continue;
                    if (t.isExplicit()) {
                        if (!(args[i] instanceof Constant) || ResolverUtil.convertConstant(DataTypeManager.getDataTypeName((Class)sourceType), tmpTypeName, (Constant)args[i]) == null) continue block5;
                        nextNarrowing = true;
                        ++currentScore;
                        continue;
                    }
                    ++currentScore;
                    continue;
                }
                catch (InvalidFunctionException e) {
                    continue block5;
                }
            }
            if (currentScore > bestScore) continue;
            if (hasUnknownType && returnType != null) {
                try {
                    Transform t = this.getConvertFunctionDescriptor(DataTypeManager.getDataTypeClass((String)nextMethod.getOutputParameter().getType()), returnType);
                    if (t != null) {
                        if (t.isExplicit()) {
                            currentScore += types.length + 1;
                            nextNarrowing = true;
                        } else {
                            ++currentScore;
                        }
                    }
                }
                catch (InvalidFunctionException e) {
                    currentScore += types.length * types.length;
                }
            }
            if (nextNarrowing && result != null && !narrowing) continue;
            boolean useNext = false;
            if (!nextNarrowing && narrowing) {
                useNext = true;
            }
            boolean bl = isSystemNext = nextMethod.getParent() == null || INTERNAL_SCHEMAS.contains(nextMethod.getParent().getName());
            if (isSystem && isSystemNext || !isSystem && !isSystemNext && result != null) {
                int nextPartCount;
                int partCount = this.partCount(result.getName());
                if (partCount < (nextPartCount = this.partCount(nextMethod.getName()))) continue;
                if (nextPartCount < partCount) {
                    useNext = true;
                }
            } else if (isSystemNext) {
                useNext = true;
            }
            if (currentScore == bestScore && !useNext) {
                ambiguous = true;
                boolean useCurrent = false;
                List bestParams = result.getInputParameters();
                for (int j = 0; j < types.length; ++j) {
                    String t1 = ((FunctionParameter)bestParams.get(Math.min(j, bestParams.size() - 1))).getType();
                    String t2 = ((FunctionParameter)methodTypes.get(Math.min(j, methodTypes.size() - 1))).getType();
                    if (types[j] == null || t1.equals(t2)) continue;
                    String commonType = ResolverUtil.getCommonType(new String[]{t1, t2});
                    if (commonType == null) continue block5;
                    if (commonType.equals(t1)) {
                        if (useCurrent) continue;
                        useNext = true;
                        continue;
                    }
                    if (!commonType.equals(t2)) continue block5;
                    if (useNext) continue;
                    useCurrent = true;
                }
                if (useCurrent) {
                    ambiguous = false;
                } else {
                    String sysName = result.getProperty("{http://www.teiid.org/ext/relational/2012}system-name", false);
                    String sysNameOther = nextMethod.getProperty("{http://www.teiid.org/ext/relational/2012}system-name", false);
                    if (sysName != null && sysName.equalsIgnoreCase(sysNameOther)) {
                        ambiguous = false;
                    }
                }
            }
            if (currentScore >= bestScore && !useNext) continue;
            ambiguous = false;
            if (currentScore == 0 && isSystemNext) {
                return new ConversionResult(nextMethod);
            }
            bestScore = currentScore;
            result = nextMethod;
            isSystem = isSystemNext;
            narrowing = nextNarrowing;
        }
        if (ambiguous) {
            throw GENERIC_EXCEPTION;
        }
        ConversionResult cr = new ConversionResult(result);
        if (result != null) {
            cr.needsConverion = bestScore != 0;
        }
        return cr;
    }

    private int partCount(String name) {
        int result = 0;
        int index = 0;
        while ((index = name.indexOf(46, index + 1)) > 0) {
            ++result;
        }
        return result;
    }

    public FunctionDescriptor[] getConverts(FunctionMethod method, Class<?>[] types) {
        List methodTypes = method.getInputParameters();
        FunctionDescriptor[] result = new FunctionDescriptor[types.length];
        for (int i = 0; i < types.length; ++i) {
            String tmpTypeName = ((FunctionParameter)methodTypes.get(Math.min(i, methodTypes.size() - 1))).getType();
            Class targetType = DataTypeManager.getDataTypeClass((String)tmpTypeName);
            Class<?> sourceType = types[i];
            if (sourceType == null) {
                result[i] = this.findTypedConversionFunction(DataTypeManager.DefaultDataClasses.NULL, targetType);
                continue;
            }
            if (sourceType == targetType || this.isVarArgArrayParam(method, types, i, targetType)) continue;
            result[i] = this.findTypedConversionFunction(sourceType, targetType);
        }
        return result;
    }

    public boolean isVarArgArrayParam(FunctionMethod method, Class<?>[] types, int i, Class<?> targetType) {
        return i == types.length - 1 && method.isVarArgs() && i == method.getInputParameterCount() - 1 && types[i].isArray() && targetType.isAssignableFrom(types[i].getComponentType());
    }

    private Transform getConvertFunctionDescriptor(Class<?> sourceType, Class<?> targetType) throws InvalidFunctionException {
        if (sourceType.equals(targetType)) {
            return null;
        }
        Transform result = DataTypeManager.getTransform(sourceType, targetType);
        if (result == null) {
            throw GENERIC_EXCEPTION;
        }
        return result;
    }

    public FunctionDescriptor findTypedConversionFunction(Class<?> sourceType, Class<?> targetType) {
        FunctionDescriptor fd = this.findFunction(CONVERT, new Class[]{sourceType, DataTypeManager.DefaultDataClasses.STRING});
        if (fd != null) {
            return this.copyFunctionChangeReturnType(fd, targetType);
        }
        return null;
    }

    public FunctionDescriptor copyFunctionChangeReturnType(FunctionDescriptor fd, Class<?> returnType) {
        if (fd != null) {
            FunctionDescriptor fdImpl = fd;
            FunctionDescriptor copy = fdImpl.clone();
            copy.setReturnType(returnType);
            return copy;
        }
        return fd;
    }

    public static boolean isConvert(Function function) {
        Expression[] args = function.getArgs();
        String funcName = function.getName();
        return args.length == 2 && (funcName.equalsIgnoreCase(CONVERT) || funcName.equalsIgnoreCase(CAST));
    }

    /*
     * Enabled aggressive block sorting
     */
    public List<FunctionMethod> getBuiltInAggregateFunctions(boolean includeAnalytic) {
        ArrayList<FunctionMethod> result = new ArrayList<FunctionMethod>();
        AggregateSymbol.Type[] arr$ = AggregateSymbol.Type.values();
        int len$ = arr$.length;
        int i$ = 0;
        while (true) {
            block15: {
                if (i$ >= len$) {
                    return result;
                }
                AggregateSymbol.Type type = arr$[i$];
                AggregateAttributes aa = new AggregateAttributes();
                String returnType = null;
                String[] argTypes = null;
                aa.setAllowsDistinct(true);
                switch (type) {
                    case USER_DEFINED: {
                        break block15;
                    }
                    case DENSE_RANK: 
                    case RANK: 
                    case ROW_NUMBER: {
                        if (includeAnalytic) {
                            aa.setAllowsDistinct(false);
                            aa.setAnalytic(true);
                            returnType = "integer";
                            argTypes = new String[]{};
                            break;
                        }
                        break block15;
                    }
                    case ANY: 
                    case SOME: 
                    case EVERY: {
                        returnType = "boolean";
                        argTypes = new String[]{"boolean"};
                        break;
                    }
                    case COUNT: {
                        returnType = "integer";
                        argTypes = new String[]{"object"};
                        break;
                    }
                    case MAX: 
                    case MIN: 
                    case AVG: 
                    case SUM: {
                        returnType = "object";
                        argTypes = new String[]{"object"};
                        break;
                    }
                    case STDDEV_POP: 
                    case STDDEV_SAMP: 
                    case VAR_POP: 
                    case VAR_SAMP: {
                        returnType = "double";
                        argTypes = new String[]{"double"};
                        break;
                    }
                    case STRING_AGG: {
                        returnType = "object";
                        argTypes = new String[]{"object"};
                        aa.setAllowsOrderBy(true);
                        break;
                    }
                    case ARRAY_AGG: {
                        returnType = "object";
                        argTypes = new String[]{DataTypeManager.getDataTypeName((Class)DataTypeManager.getArrayType((Class)DataTypeManager.DefaultDataClasses.OBJECT))};
                        aa.setAllowsOrderBy(true);
                        aa.setAllowsDistinct(false);
                        break;
                    }
                    case JSONARRAY_AGG: {
                        returnType = "clob";
                        argTypes = new String[]{"object"};
                        aa.setAllowsOrderBy(true);
                        aa.setAllowsDistinct(false);
                        break;
                    }
                    case XMLAGG: {
                        returnType = "xml";
                        argTypes = new String[]{"xml"};
                        aa.setAllowsOrderBy(true);
                        aa.setAllowsDistinct(false);
                    }
                }
                FunctionMethod fm = FunctionMethod.createFunctionMethod((String)type.name(), (String)type.name(), (String)"Aggregatee", (String)returnType, argTypes);
                fm.setAggregateAttributes(aa);
                result.add(fm);
            }
            ++i$;
        }
    }

    static {
        INTERNAL_SCHEMAS.add("SYS");
        INTERNAL_SCHEMAS.add("SYSADMIN");
        INTERNAL_SCHEMAS.add("pg_catalog");
        GENERIC_EXCEPTION = new InvalidFunctionException(QueryPlugin.Event.TEIID30419);
    }

    public static class ConversionResult {
        public FunctionMethod method;
        public boolean needsConverion;

        public ConversionResult(FunctionMethod method) {
            this.method = method;
        }
    }
}

