/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer.relational.rules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryPlannerException;
import org.teiid.core.TeiidComponentException;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.relational.OptimizerRule;
import org.teiid.query.optimizer.relational.RuleStack;
import org.teiid.query.optimizer.relational.plantree.NodeConstants;
import org.teiid.query.optimizer.relational.plantree.NodeEditor;
import org.teiid.query.optimizer.relational.plantree.NodeFactory;
import org.teiid.query.optimizer.relational.plantree.PlanNode;
import org.teiid.query.optimizer.relational.rules.FrameUtil;
import org.teiid.query.optimizer.relational.rules.RuleChooseJoinStrategy;
import org.teiid.query.optimizer.relational.rules.RulePlaceAccess;
import org.teiid.query.optimizer.relational.rules.RulePlanUnions;
import org.teiid.query.optimizer.relational.rules.RulePushAggregates;
import org.teiid.query.optimizer.relational.rules.RulePushSelectCriteria;
import org.teiid.query.processor.relational.JoinNode;
import org.teiid.query.rewriter.QueryRewriter;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.JoinType;
import org.teiid.query.sql.lang.Select;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.util.SymbolMap;
import org.teiid.query.util.CommandContext;

public class RuleDecomposeJoin
implements OptimizerRule {
    @Override
    public PlanNode execute(PlanNode plan, QueryMetadataInterface metadata, CapabilitiesFinder capabilitiesFinder, RuleStack rules, AnalysisRecord analysisRecord, CommandContext context) throws QueryPlannerException, QueryMetadataException, TeiidComponentException {
        for (PlanNode joinNode : NodeEditor.findAllNodes(plan, 4, 1)) {
            plan = this.decomposeJoin(joinNode, plan, metadata, context);
        }
        return plan;
    }

    public PlanNode decomposeJoin(PlanNode joinNode, PlanNode root, QueryMetadataInterface metadata, CommandContext context) throws TeiidComponentException, QueryPlannerException {
        if (joinNode.getParent() == null) {
            return root;
        }
        JoinType joinType = (JoinType)joinNode.getProperty(NodeConstants.Info.JOIN_TYPE);
        if (joinType == JoinType.JOIN_ANTI_SEMI || joinType == JoinType.JOIN_CROSS) {
            return root;
        }
        PlanNode left = joinNode.getFirstChild();
        if (left.getType() != 64) {
            return root;
        }
        Map partitionInfo = (Map)left.getProperty(NodeConstants.Info.PARTITION_INFO);
        if (partitionInfo == null) {
            return root;
        }
        PlanNode unionNode = left.getFirstChild();
        if (unionNode.getType() != 256) {
            return root;
        }
        PlanNode right = joinNode.getLastChild();
        if (right.getType() != 64) {
            return root;
        }
        Map rightPartionInfo = (Map)right.getProperty(NodeConstants.Info.PARTITION_INFO);
        if (rightPartionInfo == null) {
            return root;
        }
        List criteria = (List)joinNode.getProperty(NodeConstants.Info.JOIN_CRITERIA);
        ArrayList<Expression> expr = new ArrayList<Expression>();
        ArrayList<Expression> exprOther = new ArrayList<Expression>();
        RuleChooseJoinStrategy.separateCriteria(unionNode.getParent().getGroups(), right.getGroups(), expr, exprOther, criteria, new LinkedList<Criteria>());
        if (expr.isEmpty()) {
            return root;
        }
        List<int[]> matches = this.findMatches(partitionInfo, rightPartionInfo, expr, exprOther);
        if (matches == null) {
            return root;
        }
        int branchSize = ((List)partitionInfo.values().iterator().next()).size();
        int otherBranchSize = ((List)rightPartionInfo.values().iterator().next()).size();
        if (matches.isEmpty()) {
            if (joinType == JoinType.JOIN_INNER || joinType == JoinType.JOIN_SEMI) {
                PlanNode critNode = NodeFactory.getNewNode(16);
                critNode.setProperty(NodeConstants.Info.SELECT_CRITERIA, QueryRewriter.FALSE_CRITERIA);
                unionNode.addAsParent(critNode);
            } else if (joinType == JoinType.JOIN_LEFT_OUTER) {
                joinNode.getParent().replaceChild(joinNode, left);
            } else if (joinType == JoinType.JOIN_FULL_OUTER) {
                joinNode.setProperty(NodeConstants.Info.JOIN_CRITERIA, QueryRewriter.FALSE_CRITERIA);
            }
            return root;
        }
        ArrayList<PlanNode> branches = new ArrayList<PlanNode>();
        RulePushSelectCriteria.collectUnionChildren(unionNode, branches);
        if (branches.size() != branchSize) {
            return root;
        }
        ArrayList<PlanNode> otherBranches = new ArrayList<PlanNode>();
        RulePushSelectCriteria.collectUnionChildren(right.getFirstChild(), otherBranches);
        if (otherBranches.size() != otherBranchSize) {
            return root;
        }
        PlanNode newUnion = this.buildUnion(unionNode, right, criteria, matches, branches, otherBranches, joinType);
        PlanNode view = RuleDecomposeJoin.rebuild(left.getGroups().iterator().next(), joinNode, newUnion, metadata, context, left, right);
        SymbolMap symbolmap = (SymbolMap)view.getProperty(NodeConstants.Info.SYMBOL_MAP);
        LinkedHashMap<ElementSymbol, List<Set<Constant>>> newPartitionInfo = new LinkedHashMap<ElementSymbol, List<Set<Constant>>>();
        for (int[] match : matches) {
            this.updatePartitionInfo(partitionInfo, matches, symbolmap, newPartitionInfo, 0, match[0]);
            this.updatePartitionInfo(rightPartionInfo, matches, symbolmap, newPartitionInfo, partitionInfo.size(), match[1]);
        }
        view.setProperty(NodeConstants.Info.PARTITION_INFO, newPartitionInfo);
        if (view.getParent().getType() == 4) {
            return this.decomposeJoin(view.getParent(), root, metadata, context);
        }
        return root;
    }

    private void updatePartitionInfo(Map<ElementSymbol, List<Set<Constant>>> partitionInfo, List<int[]> matches, SymbolMap symbolmap, HashMap<ElementSymbol, List<Set<Constant>>> newPartitionInfo, int start, int index) {
        for (Map.Entry<ElementSymbol, List<Set<Constant>>> entry : partitionInfo.entrySet()) {
            ElementSymbol newSymbol = symbolmap.getKeys().get(start++);
            List<Set<Constant>> values = newPartitionInfo.get(newSymbol);
            if (values == null) {
                values = new ArrayList<Set<Constant>>(matches.size());
                newPartitionInfo.put(newSymbol, values);
            }
            values.add(entry.getValue().get(index));
        }
    }

    static PlanNode rebuild(GroupSymbol group, PlanNode toReplace, PlanNode newUnion, QueryMetadataInterface metadata, CommandContext context, PlanNode ... toMap) throws TeiidComponentException, QueryPlannerException, QueryMetadataException {
        Set<String> groups = context.getGroups();
        group = RulePlaceAccess.recontextSymbol(group, groups);
        PlanNode projectNode = NodeEditor.findNodePreOrder(newUnion, 8);
        List projectedSymbols = (List)projectNode.getProperty(NodeConstants.Info.PROJECT_COLS);
        SymbolMap newSymbolMap = RulePushAggregates.createSymbolMap(group, projectedSymbols, newUnion, metadata);
        PlanNode view = RuleDecomposeJoin.createSource(group, newUnion, newSymbolMap);
        Map<Expression, ElementSymbol> inverseMap = newSymbolMap.inserseMapping();
        toReplace.getParent().replaceChild(toReplace, view);
        Set<GroupSymbol> newGroups = Collections.singleton(group);
        for (PlanNode node : toMap) {
            FrameUtil.convertFrame(view, node.getGroups().iterator().next(), newGroups, inverseMap, metadata);
        }
        return view;
    }

    private List<int[]> findMatches(Map<ElementSymbol, List<Set<Constant>>> partitionInfo, Map<ElementSymbol, List<Set<Constant>>> partitionInfoOther, List<Expression> expr, List<Expression> exprOther) {
        List<int[]> matches = null;
        for (int i = 0; i < expr.size() && matches == null; ++i) {
            if (!(expr.get(i) instanceof ElementSymbol) || !(exprOther.get(i) instanceof ElementSymbol)) continue;
            ElementSymbol es = (ElementSymbol)expr.get(i);
            ElementSymbol esOther = (ElementSymbol)exprOther.get(i);
            List<Set<Constant>> partLists = partitionInfo.get(es);
            List<Set<Constant>> partListsOther = partitionInfoOther.get(esOther);
            if (partLists == null || partListsOther == null) continue;
            matches = this.findMatches(partLists, partListsOther);
        }
        return matches;
    }

    private List<int[]> findMatches(List<Set<Constant>> partLists, List<Set<Constant>> partListsOther) {
        LinkedList<int[]> matches = new LinkedList<int[]>();
        for (int j = 0; j < partLists.size(); ++j) {
            int[] match = null;
            Set<Constant> vals = partLists.get(j);
            for (int k = 0; k < partListsOther.size(); ++k) {
                if (Collections.disjoint(vals, (Collection)partListsOther.get(k))) continue;
                if (match == null) {
                    match = new int[]{j, k};
                    continue;
                }
                return null;
            }
            if (match == null) continue;
            matches.add(match);
        }
        return matches;
    }

    private PlanNode buildUnion(PlanNode unionNode, PlanNode otherSide, List<Criteria> criteria, List<int[]> matches, List<PlanNode> branches, List<PlanNode> otherBranches, JoinType joinType) {
        SymbolMap symbolMap = (SymbolMap)unionNode.getParent().getProperty(NodeConstants.Info.SYMBOL_MAP);
        SymbolMap otherSymbolMap = (SymbolMap)otherSide.getProperty(NodeConstants.Info.SYMBOL_MAP);
        LinkedList<PlanNode> joins = new LinkedList<PlanNode>();
        for (int i = 0; i < matches.size(); ++i) {
            int[] is = matches.get(i);
            PlanNode branch = branches.get(is[0]);
            PlanNode branchSource = RuleDecomposeJoin.createSource(unionNode.getParent().getGroups().iterator().next(), branch, symbolMap);
            PlanNode otherBranch = otherBranches.get(is[1]);
            PlanNode otherBranchSource = RuleDecomposeJoin.createSource(otherSide.getGroups().iterator().next(), otherBranch, otherSymbolMap);
            PlanNode newJoinNode = NodeFactory.getNewNode(4);
            newJoinNode.addLastChild(branchSource);
            newJoinNode.addLastChild(otherBranchSource);
            newJoinNode.setProperty(NodeConstants.Info.JOIN_STRATEGY, (Object)JoinNode.JoinStrategyType.NESTED_LOOP);
            newJoinNode.setProperty(NodeConstants.Info.JOIN_TYPE, joinType);
            newJoinNode.setProperty(NodeConstants.Info.JOIN_CRITERIA, LanguageObject.Util.deepClone(criteria, Criteria.class));
            newJoinNode.addGroups(branchSource.getGroups());
            newJoinNode.addGroups(otherBranchSource.getGroups());
            PlanNode projectPlanNode = NodeFactory.getNewNode(8);
            newJoinNode.addAsParent(projectPlanNode);
            Select allSymbols = new Select(symbolMap.getKeys());
            allSymbols.addSymbols(otherSymbolMap.getKeys());
            if (i == 0) {
                QueryRewriter.makeSelectUnique(allSymbols, false);
            }
            projectPlanNode.setProperty(NodeConstants.Info.PROJECT_COLS, allSymbols.getSymbols());
            projectPlanNode.addGroups(newJoinNode.getGroups());
            joins.add(projectPlanNode);
        }
        PlanNode newUnion = RulePlanUnions.buildUnionTree(unionNode, joins);
        return newUnion;
    }

    static PlanNode createSource(GroupSymbol group, PlanNode child, SymbolMap symbolMap) {
        return RuleDecomposeJoin.createSource(group, child, symbolMap.getKeys());
    }

    static PlanNode createSource(GroupSymbol group, PlanNode child, List<ElementSymbol> newProject) {
        PlanNode branchSource = NodeFactory.getNewNode(64);
        branchSource.addGroup(group);
        PlanNode projectNode = NodeEditor.findNodePreOrder(child, 8);
        branchSource.setProperty(NodeConstants.Info.SYMBOL_MAP, SymbolMap.createSymbolMap(newProject, (List)projectNode.getProperty(NodeConstants.Info.PROJECT_COLS)));
        child.addAsParent(branchSource);
        return branchSource;
    }

    public String toString() {
        return "DecomposeJoin";
    }
}

