/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dv.xs;

import java.math.BigDecimal;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.xerces.impl.dv.InvalidDatatypeValueException;
import org.apache.xerces.impl.dv.ValidationContext;
import org.apache.xerces.impl.dv.xs.AbstractDateTimeDV;
import org.apache.xerces.impl.dv.xs.SchemaDateTimeException;

public class TimeDV
extends AbstractDateTimeDV {
    public Object getActualValue(String content, ValidationContext context) throws InvalidDatatypeValueException {
        try {
            return this.parse(content);
        }
        catch (Exception ex) {
            throw new InvalidDatatypeValueException("cvc-datatype-valid.1.2.1", new Object[]{content, "time"});
        }
    }

    protected AbstractDateTimeDV.DateTimeData parse(String str) throws SchemaDateTimeException {
        AbstractDateTimeDV.DateTimeData date = new AbstractDateTimeDV.DateTimeData(str, this);
        int len = str.length();
        date.year = 2000;
        date.month = 1;
        date.day = 15;
        this.getTime(str, 0, len, date);
        this.validateDateTime(date);
        this.saveUnnormalized(date);
        if (date.utc != 0 && date.utc != 90) {
            this.normalize(date);
        }
        date.position = 2;
        return date;
    }

    protected String dateToString(AbstractDateTimeDV.DateTimeData date) {
        StringBuffer message = new StringBuffer(16);
        this.append(message, date.hour, 2);
        message.append(':');
        this.append(message, date.minute, 2);
        message.append(':');
        this.append(message, date.second);
        this.append(message, (char)date.utc, 0);
        return message.toString();
    }

    protected XMLGregorianCalendar getXMLGregorianCalendar(AbstractDateTimeDV.DateTimeData date) {
        return this.factory.newXMLGregorianCalendar(null, Integer.MIN_VALUE, Integer.MIN_VALUE, date.unNormHour, date.unNormMinute, (int)date.unNormSecond, date.unNormSecond != 0.0 ? new BigDecimal(date.unNormSecond - (double)((int)date.unNormSecond)) : null, date.timezoneHr * 60 + date.timezoneMin);
    }
}

