/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.xml;

import org.teiid.client.plan.PlanNode;
import org.teiid.common.buffer.BlockedException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.logging.LogManager;
import org.teiid.query.processor.xml.ProcessorInstruction;
import org.teiid.query.processor.xml.XMLContext;
import org.teiid.query.processor.xml.XMLProcessorEnvironment;

public class EndBlockInstruction
extends ProcessorInstruction {
    private static final String CLOSE_FINISHED = "CLOSE finished result set:";
    private String resultSetName;

    public EndBlockInstruction(String resultSetName) {
        this.resultSetName = resultSetName;
    }

    @Override
    public XMLContext process(XMLProcessorEnvironment env, XMLContext context) throws BlockedException, TeiidComponentException, TeiidProcessingException {
        context = context.getParentContext();
        context.removeResultSet(this.resultSetName);
        LogManager.logTrace((String)"org.teiid.PROCESSOR.XML_PLAN", (Object[])new Object[]{CLOSE_FINISHED, this.resultSetName});
        env.incrementCurrentProgramCounter();
        return context;
    }

    public String toString() {
        return "CLOSE " + this.resultSetName;
    }

    @Override
    public PlanNode getDescriptionProperties() {
        PlanNode props = new PlanNode("CLOSE RESULTSET");
        props.addProperty("Result Set", this.resultSetName);
        return props;
    }

    String getResultSetName() {
        return this.resultSetName;
    }

    void setResultSetName(String resultSetName) {
        this.resultSetName = resultSetName;
    }
}

