/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.vdb.runtime;

import org.junit.Assert;
import org.junit.Test;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.vdb.runtime.VDBKey;

public class TestVDBKey {
    @Test
    public void testCaseInsensitive() {
        VDBKey key = new VDBKey("foo", 1);
        VDBKey key1 = new VDBKey("FOO", 1);
        UnitTestUtil.helpTestEquivalence((int)0, (Object)key, (Object)key1);
    }

    @Test
    public void testNotEqual() {
        VDBKey key = new VDBKey("a", 1);
        VDBKey key1 = new VDBKey("b", 1);
        Assert.assertFalse((boolean)key.equals((Object)key1));
    }

    @Test
    public void testNameEndingInNumber() {
        VDBKey key = new VDBKey("a1", 1);
        VDBKey key1 = new VDBKey("a", 11);
        Assert.assertFalse((boolean)key.equals((Object)key1));
    }

    @Test
    public void testDiffertVersion() {
        VDBKey key = new VDBKey("a", 1);
        VDBKey key1 = new VDBKey("a", 11);
        Assert.assertFalse((boolean)key.equals((Object)key1));
    }

    @Test
    public void testSemanticVersion() {
        VDBKey key = new VDBKey("a.v1.2.3", 1);
        VDBKey key1 = new VDBKey("a.v1.11.3", 1);
        Assert.assertTrue((boolean)key.isSemantic());
        Assert.assertTrue((boolean)key.isFullySpecified());
        Assert.assertFalse((boolean)key.isAtMost());
        Assert.assertFalse((boolean)key.equals((Object)key1));
        Assert.assertEquals((long)-1L, (long)key.compareTo(key1));
        Assert.assertEquals((long)1L, (long)key1.compareTo(key));
    }

    @Test
    public void testShortSemanticVersion() {
        VDBKey key = new VDBKey("a.v1.3", 1);
        VDBKey key1 = new VDBKey("a.v1.2.", 1);
        Assert.assertTrue((boolean)key.isSemantic());
        Assert.assertFalse((boolean)key.isFullySpecified());
        Assert.assertFalse((boolean)key.isAtMost());
        Assert.assertTrue((boolean)key1.isSemantic());
        Assert.assertFalse((boolean)key1.isFullySpecified());
        Assert.assertTrue((boolean)key1.isAtMost());
        Assert.assertFalse((boolean)key.equals((Object)key1));
        Assert.assertEquals((long)1L, (long)key.compareTo(key1));
        Assert.assertEquals((long)-1L, (long)key1.compareTo(key));
    }
}

