/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.symbol;

import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.util.ArgCheck;
import org.teiid.query.sql.symbol.AbstractCaseExpression;
import org.teiid.query.sql.symbol.CaseExpression;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.TestSearchedCaseExpression;

public class TestCaseExpression
extends TestCase {
    public TestCaseExpression(String name) {
        super(name);
    }

    public void testGetWhen() {
        CaseExpression expr = TestCaseExpression.example(3);
        TestCaseExpression.assertNotNull((Object)expr.getWhen());
        TestCaseExpression.assertEquals((int)3, (int)expr.getWhen().size());
        try {
            expr.getWhen().add(new Object());
            TestCaseExpression.fail((String)"Should not be modifiable");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testGetThen() {
        CaseExpression expr = TestCaseExpression.example(3);
        TestCaseExpression.assertNotNull((Object)expr.getThen());
        TestCaseExpression.assertEquals((int)3, (int)expr.getThen().size());
        try {
            expr.getThen().add(new Object());
            TestCaseExpression.fail((String)"Should not be modifiable");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public static List getWhenExpressions(int expressions) {
        return TestCaseExpression.getWhenExpressions(expressions, -1, false);
    }

    public static List getWhenExpressions(int expressions, int nullIndex, boolean includeNull) {
        ArrayList<Constant> list = new ArrayList<Constant>();
        for (int i = 0; i < expressions; ++i) {
            if (includeNull && i == nullIndex) {
                list.add(new Constant(null));
                continue;
            }
            list.add(new Constant((Object)String.valueOf((char)(97 + i))));
        }
        return list;
    }

    public static List getThenExpressions(int expressions) {
        ArrayList<Constant> list = new ArrayList<Constant>();
        for (int i = 0; i < expressions; ++i) {
            list.add(new Constant((Object)new Integer(i)));
        }
        return list;
    }

    public static CaseExpression example(int whens) {
        ElementSymbol x = new ElementSymbol("x");
        CaseExpression caseExpr = new CaseExpression((Expression)x, TestCaseExpression.getWhenExpressions(whens), TestCaseExpression.getThenExpressions(whens));
        caseExpr.setElseExpression((Expression)new Constant((Object)new Integer(9999)));
        return caseExpr;
    }

    public static CaseExpression example(int whens, int nullIndex, boolean includeNull) {
        ArgCheck.isTrue((nullIndex < whens ? 1 : 0) != 0, (String)"Null Index must be less than the number of When expressions");
        ElementSymbol x = new ElementSymbol("x");
        CaseExpression caseExpr = new CaseExpression((Expression)x, TestCaseExpression.getWhenExpressions(whens, nullIndex, includeNull), TestCaseExpression.getThenExpressions(whens));
        caseExpr.setElseExpression((Expression)new Constant((Object)new Integer(9999)));
        return caseExpr;
    }

    public static void helpTestWhenExpressions(CaseExpression caseExpr, int expectedWhens) {
        TestCaseExpression.assertEquals((int)expectedWhens, (int)caseExpr.getWhenCount());
        for (int i = 0; i < expectedWhens; ++i) {
            TestCaseExpression.assertEquals((Object)new Constant((Object)String.valueOf((char)(97 + i))), (Object)caseExpr.getWhenExpression(i));
        }
    }

    public static void helpTestThenExpressions(AbstractCaseExpression caseExpr, int expectedThens) {
        TestCaseExpression.assertEquals((int)expectedThens, (int)caseExpr.getWhenCount());
        for (int i = 0; i < expectedThens; ++i) {
            TestCaseExpression.assertEquals((Object)new Constant((Object)new Integer(i)), (Object)caseExpr.getThenExpression(i));
        }
    }

    public static void helpTestStrictEquivalence(Object obj1, Object obj2) {
        TestCaseExpression.assertTrue((obj1 != obj2 ? 1 : 0) != 0);
        TestCaseExpression.assertTrue((obj1 != null ? 1 : 0) != 0);
        TestCaseExpression.assertTrue((obj2 != null ? 1 : 0) != 0);
        TestCaseExpression.assertTrue((boolean)obj1.equals(obj2));
        TestCaseExpression.assertTrue((boolean)obj2.equals(obj1));
    }

    public void testGetWhenCount() {
        TestCaseExpression.assertEquals((int)1, (int)TestCaseExpression.example(1).getWhenCount());
        TestCaseExpression.assertEquals((int)2, (int)TestCaseExpression.example(2).getWhenCount());
        TestCaseExpression.assertEquals((int)3, (int)TestCaseExpression.example(3).getWhenCount());
        TestCaseExpression.assertEquals((int)4, (int)TestCaseExpression.example(4).getWhenCount());
    }

    public void testGetExpression() {
        TestCaseExpression.assertNotNull((Object)TestCaseExpression.example(1).getExpression());
        TestCaseExpression.assertEquals((Object)new ElementSymbol("x"), (Object)TestCaseExpression.example(1).getExpression());
    }

    public void testSetExpression() {
        CaseExpression caseExpr = TestCaseExpression.example(1);
        ElementSymbol y = new ElementSymbol("y");
        caseExpr.setExpression((Expression)y);
        TestCaseExpression.assertEquals((Object)y, (Object)caseExpr.getExpression());
        try {
            caseExpr.setExpression(null);
            TestCaseExpression.fail((String)"Setting the expression to null should fail.");
        }
        catch (IllegalArgumentException e) {
            TestCaseExpression.assertEquals((Object)y, (Object)caseExpr.getExpression());
        }
    }

    public void testClone() {
        ElementSymbol x = new ElementSymbol("x");
        Constant e1 = new Constant((Object)"abc");
        Constant e2 = new Constant((Object)"xyz");
        ArrayList<Constant> whens = new ArrayList<Constant>();
        whens.add(e1);
        whens.add(e2);
        Constant const1 = new Constant((Object)"a");
        Constant const2 = new Constant((Object)"b");
        ArrayList<Constant> thens = new ArrayList<Constant>();
        thens.add(const1);
        thens.add(const2);
        Constant elseExpression = new Constant((Object)"c");
        CaseExpression expr = new CaseExpression((Expression)x, whens, thens);
        expr.setElseExpression((Expression)elseExpression);
        expr.setType(DataTypeManager.DefaultDataClasses.STRING);
        CaseExpression clone = (CaseExpression)expr.clone();
        TestCaseExpression.assertTrue((expr != clone ? 1 : 0) != 0);
        TestCaseExpression.helpTestStrictEquivalence(x, clone.getExpression());
        TestCaseExpression.helpTestStrictEquivalence(expr.getExpression(), clone.getExpression());
        TestCaseExpression.assertEquals((int)2, (int)clone.getWhenCount());
        TestCaseExpression.helpTestStrictEquivalence(e1, clone.getWhenExpression(0));
        TestCaseExpression.helpTestStrictEquivalence(expr.getWhenExpression(0), clone.getWhenExpression(0));
        TestCaseExpression.helpTestStrictEquivalence(e2, clone.getWhenExpression(1));
        TestCaseExpression.helpTestStrictEquivalence(expr.getWhenExpression(1), clone.getWhenExpression(1));
        TestCaseExpression.helpTestStrictEquivalence(const1, clone.getThenExpression(0));
        TestCaseExpression.helpTestStrictEquivalence(expr.getThenExpression(0), clone.getThenExpression(0));
        TestCaseExpression.helpTestStrictEquivalence(const2, clone.getThenExpression(1));
        TestCaseExpression.helpTestStrictEquivalence(expr.getThenExpression(1), clone.getThenExpression(1));
        TestCaseExpression.helpTestStrictEquivalence(expr.getElseExpression(), clone.getElseExpression());
        TestCaseExpression.assertEquals((Object)expr.getType(), (Object)clone.getType());
    }

    public void testGetWhenExpression() {
        TestCaseExpression.helpTestWhenExpressions(TestCaseExpression.example(3), 3);
    }

    public void testSetWhen() {
        CaseExpression caseExpr = TestCaseExpression.example(4);
        try {
            caseExpr.setWhen(null, null);
            TestCaseExpression.fail((String)"Setting WHEN and THEN to null should have failed.");
        }
        catch (IllegalArgumentException e) {
            TestCaseExpression.helpTestWhenExpressions(caseExpr, 4);
            TestCaseExpression.helpTestThenExpressions((AbstractCaseExpression)caseExpr, 4);
        }
        try {
            caseExpr.setWhen(TestCaseExpression.getWhenExpressions(2), null);
            TestCaseExpression.fail((String)"Setting THEN to null should have failed.");
        }
        catch (IllegalArgumentException e) {
            TestCaseExpression.helpTestWhenExpressions(caseExpr, 4);
            TestCaseExpression.helpTestThenExpressions((AbstractCaseExpression)caseExpr, 4);
        }
        try {
            caseExpr.setWhen(null, TestCaseExpression.getThenExpressions(2));
            TestCaseExpression.fail((String)"Setting WHEN to null should have failed.");
        }
        catch (IllegalArgumentException e) {
            TestCaseExpression.helpTestWhenExpressions(caseExpr, 4);
            TestCaseExpression.helpTestThenExpressions((AbstractCaseExpression)caseExpr, 4);
        }
        try {
            caseExpr.setWhen(TestCaseExpression.getWhenExpressions(0), TestCaseExpression.getThenExpressions(0));
            TestCaseExpression.fail((String)"Setting WHEN and THEN to empty lists should have failed.");
        }
        catch (IllegalArgumentException e) {
            TestCaseExpression.helpTestWhenExpressions(caseExpr, 4);
            TestCaseExpression.helpTestThenExpressions((AbstractCaseExpression)caseExpr, 4);
        }
        caseExpr.setWhen(TestSearchedCaseExpression.getWhenCriteria(3), TestCaseExpression.getThenExpressions(3));
        caseExpr.setWhen(TestCaseExpression.getWhenExpressions(3), TestSearchedCaseExpression.getWhenCriteria(3));
        ArrayList<Constant> whens = new ArrayList<Constant>();
        whens.add(new Constant((Object)"abc"));
        whens.add(new Constant((Object)"xyz"));
        ArrayList<Constant> thens = new ArrayList<Constant>();
        thens.add(new Constant((Object)new Integer(20000)));
        thens.add(new Constant((Object)new Integer(30000)));
        caseExpr.setWhen(whens, thens);
        TestCaseExpression.assertEquals((int)2, (int)caseExpr.getWhenCount());
        TestCaseExpression.assertEquals((Object)new Constant((Object)"abc"), (Object)caseExpr.getWhenExpression(0));
        TestCaseExpression.assertEquals((Object)new Constant((Object)"xyz"), (Object)caseExpr.getWhenExpression(1));
        TestCaseExpression.assertEquals((Object)new Constant((Object)new Integer(20000)), (Object)caseExpr.getThenExpression(0));
        TestCaseExpression.assertEquals((Object)new Constant((Object)new Integer(30000)), (Object)caseExpr.getThenExpression(1));
    }

    public void testGetThenExpression() {
        TestCaseExpression.helpTestThenExpressions((AbstractCaseExpression)TestCaseExpression.example(3), 3);
    }

    public void testGetElseExpression() {
        CaseExpression expr = TestCaseExpression.example(3);
        TestCaseExpression.assertEquals((Object)new Constant((Object)new Integer(9999)), (Object)expr.getElseExpression());
    }

    public void testSetElseExpression() {
        CaseExpression expr = TestCaseExpression.example(3);
        expr.setElseExpression((Expression)new Constant((Object)new Integer(1000)));
        TestCaseExpression.assertEquals((Object)new Constant((Object)new Integer(1000)), (Object)expr.getElseExpression());
        expr.setElseExpression(null);
        TestCaseExpression.assertNull((Object)expr.getElseExpression());
    }

    public void testGetType() {
        CaseExpression expr = TestCaseExpression.example(4);
        TestCaseExpression.assertNull((Object)expr.getType());
        expr.setType(Integer.class);
        TestCaseExpression.assertEquals(Integer.class, (Object)expr.getType());
    }

    public void testSetType() {
        CaseExpression expr = TestCaseExpression.example(4);
        expr.setType(DataTypeManager.DefaultDataClasses.BIG_DECIMAL);
        TestCaseExpression.assertEquals((Object)DataTypeManager.DefaultDataClasses.BIG_DECIMAL, (Object)expr.getType());
        expr.setType(DataTypeManager.DefaultDataClasses.BIG_INTEGER);
        TestCaseExpression.assertEquals((Object)DataTypeManager.DefaultDataClasses.BIG_INTEGER, (Object)expr.getType());
        expr.setType(DataTypeManager.DefaultDataClasses.BLOB);
        TestCaseExpression.assertEquals((Object)DataTypeManager.DefaultDataClasses.BLOB, (Object)expr.getType());
        expr.setType(DataTypeManager.DefaultDataClasses.BOOLEAN);
        TestCaseExpression.assertEquals((Object)DataTypeManager.DefaultDataClasses.BOOLEAN, (Object)expr.getType());
        expr.setType(DataTypeManager.DefaultDataClasses.BYTE);
        TestCaseExpression.assertEquals((Object)DataTypeManager.DefaultDataClasses.BYTE, (Object)expr.getType());
        expr.setType(DataTypeManager.DefaultDataClasses.CHAR);
        TestCaseExpression.assertEquals((Object)DataTypeManager.DefaultDataClasses.CHAR, (Object)expr.getType());
        expr.setType(DataTypeManager.DefaultDataClasses.CLOB);
        TestCaseExpression.assertEquals((Object)DataTypeManager.DefaultDataClasses.CLOB, (Object)expr.getType());
        expr.setType(DataTypeManager.DefaultDataClasses.DATE);
        TestCaseExpression.assertEquals((Object)DataTypeManager.DefaultDataClasses.DATE, (Object)expr.getType());
        expr.setType(DataTypeManager.DefaultDataClasses.DOUBLE);
        TestCaseExpression.assertEquals((Object)DataTypeManager.DefaultDataClasses.DOUBLE, (Object)expr.getType());
        expr.setType(DataTypeManager.DefaultDataClasses.FLOAT);
        TestCaseExpression.assertEquals((Object)DataTypeManager.DefaultDataClasses.FLOAT, (Object)expr.getType());
        expr.setType(DataTypeManager.DefaultDataClasses.INTEGER);
        TestCaseExpression.assertEquals((Object)DataTypeManager.DefaultDataClasses.INTEGER, (Object)expr.getType());
        expr.setType(DataTypeManager.DefaultDataClasses.LONG);
        TestCaseExpression.assertEquals((Object)DataTypeManager.DefaultDataClasses.LONG, (Object)expr.getType());
        expr.setType(DataTypeManager.DefaultDataClasses.NULL);
        TestCaseExpression.assertEquals((Object)DataTypeManager.DefaultDataClasses.NULL, (Object)expr.getType());
        expr.setType(DataTypeManager.DefaultDataClasses.OBJECT);
        TestCaseExpression.assertEquals((Object)DataTypeManager.DefaultDataClasses.OBJECT, (Object)expr.getType());
        expr.setType(DataTypeManager.DefaultDataClasses.SHORT);
        TestCaseExpression.assertEquals((Object)DataTypeManager.DefaultDataClasses.SHORT, (Object)expr.getType());
        expr.setType(DataTypeManager.DefaultDataClasses.STRING);
        TestCaseExpression.assertEquals((Object)DataTypeManager.DefaultDataClasses.STRING, (Object)expr.getType());
        expr.setType(DataTypeManager.DefaultDataClasses.TIME);
        TestCaseExpression.assertEquals((Object)DataTypeManager.DefaultDataClasses.TIME, (Object)expr.getType());
        expr.setType(DataTypeManager.DefaultDataClasses.TIMESTAMP);
        TestCaseExpression.assertEquals((Object)DataTypeManager.DefaultDataClasses.TIMESTAMP, (Object)expr.getType());
        expr.setType(null);
        TestCaseExpression.assertNull((Object)expr.getType());
    }

    public void testEquals() {
        CaseExpression sc1 = TestCaseExpression.example(3);
        TestCaseExpression.assertTrue((boolean)sc1.equals((Object)sc1));
        TestCaseExpression.assertTrue((boolean)sc1.equals(sc1.clone()));
        TestCaseExpression.assertTrue((boolean)sc1.clone().equals(sc1));
        TestCaseExpression.assertTrue((boolean)sc1.equals((Object)TestCaseExpression.example(3)));
        CaseExpression sc2 = TestCaseExpression.example(4);
        TestCaseExpression.assertFalse((boolean)sc1.equals((Object)sc2));
        TestCaseExpression.assertFalse((boolean)sc2.equals((Object)sc1));
        CaseExpression sc3 = TestCaseExpression.example(3);
        sc3.setElseExpression((Expression)new ElementSymbol("y"));
        TestCaseExpression.assertFalse((boolean)sc1.equals((Object)sc3));
        TestCaseExpression.assertFalse((boolean)sc3.equals((Object)sc1));
        CaseExpression sc4 = TestCaseExpression.example(3);
        sc4.setExpression((Expression)new ElementSymbol("y"));
        TestCaseExpression.assertFalse((boolean)sc1.equals((Object)sc4));
        TestCaseExpression.assertFalse((boolean)sc4.equals((Object)sc1));
    }
}

