/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.visitor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import junit.framework.TestCase;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.BatchedUpdateCommand;
import org.teiid.query.sql.lang.Delete;
import org.teiid.query.sql.lang.From;
import org.teiid.query.sql.lang.FromClause;
import org.teiid.query.sql.lang.Insert;
import org.teiid.query.sql.lang.JoinPredicate;
import org.teiid.query.sql.lang.JoinType;
import org.teiid.query.sql.lang.UnaryFromClause;
import org.teiid.query.sql.lang.Update;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.visitor.GroupCollectorVisitor;

public class TestGroupCollectorVisitor
extends TestCase {
    public TestGroupCollectorVisitor(String name) {
        super(name);
    }

    public GroupSymbol exampleGroupSymbol(int number) {
        return new GroupSymbol("group." + number);
    }

    public void helpTestGroups(LanguageObject obj, boolean removeDuplicates, Collection expectedGroups) {
        Collection actualGroups = GroupCollectorVisitor.getGroups((LanguageObject)obj, (boolean)removeDuplicates);
        TestGroupCollectorVisitor.assertEquals((String)"Actual groups didn't meet expected groups: ", (Object)expectedGroups, (Object)actualGroups);
    }

    public void testGroupSymbol() {
        GroupSymbol gs = this.exampleGroupSymbol(1);
        HashSet<GroupSymbol> groups = new HashSet<GroupSymbol>();
        groups.add(gs);
        this.helpTestGroups((LanguageObject)gs, true, groups);
    }

    public void testUnaryFromClause() {
        GroupSymbol gs = this.exampleGroupSymbol(1);
        UnaryFromClause ufc = new UnaryFromClause(gs);
        HashSet<GroupSymbol> groups = new HashSet<GroupSymbol>();
        groups.add(gs);
        this.helpTestGroups((LanguageObject)ufc, true, groups);
    }

    public void testJoinPredicate1() {
        GroupSymbol gs1 = this.exampleGroupSymbol(1);
        GroupSymbol gs2 = this.exampleGroupSymbol(2);
        JoinPredicate jp = new JoinPredicate((FromClause)new UnaryFromClause(gs1), (FromClause)new UnaryFromClause(gs2), JoinType.JOIN_CROSS);
        HashSet<GroupSymbol> groups = new HashSet<GroupSymbol>();
        groups.add(gs1);
        groups.add(gs2);
        this.helpTestGroups((LanguageObject)jp, true, groups);
    }

    public void testJoinPredicate2() {
        GroupSymbol gs1 = this.exampleGroupSymbol(1);
        GroupSymbol gs2 = this.exampleGroupSymbol(2);
        GroupSymbol gs3 = this.exampleGroupSymbol(3);
        JoinPredicate jp1 = new JoinPredicate((FromClause)new UnaryFromClause(gs1), (FromClause)new UnaryFromClause(gs2), JoinType.JOIN_CROSS);
        JoinPredicate jp2 = new JoinPredicate((FromClause)new UnaryFromClause(gs3), (FromClause)jp1, JoinType.JOIN_CROSS);
        HashSet<GroupSymbol> groups = new HashSet<GroupSymbol>();
        groups.add(gs1);
        groups.add(gs2);
        groups.add(gs3);
        this.helpTestGroups((LanguageObject)jp2, true, groups);
    }

    public void testFrom1() {
        GroupSymbol gs1 = this.exampleGroupSymbol(1);
        GroupSymbol gs2 = this.exampleGroupSymbol(2);
        GroupSymbol gs3 = this.exampleGroupSymbol(3);
        From from = new From();
        from.addGroup(gs1);
        from.addGroup(gs2);
        from.addGroup(gs3);
        HashSet<GroupSymbol> groups = new HashSet<GroupSymbol>();
        groups.add(gs1);
        groups.add(gs2);
        groups.add(gs3);
        this.helpTestGroups((LanguageObject)from, true, groups);
    }

    public void testFrom2() {
        GroupSymbol gs1 = this.exampleGroupSymbol(1);
        GroupSymbol gs2 = this.exampleGroupSymbol(2);
        GroupSymbol gs3 = this.exampleGroupSymbol(3);
        From from = new From();
        from.addGroup(gs1);
        from.addGroup(gs2);
        from.addGroup(gs3);
        ArrayList<GroupSymbol> groups = new ArrayList<GroupSymbol>();
        groups.add(gs1);
        groups.add(gs2);
        groups.add(gs3);
        this.helpTestGroups((LanguageObject)from, false, groups);
    }

    public void testFrom3() {
        GroupSymbol gs1 = this.exampleGroupSymbol(1);
        GroupSymbol gs2 = this.exampleGroupSymbol(2);
        From from = new From();
        from.addGroup(gs1);
        from.addGroup(gs2);
        from.addGroup(gs2);
        HashSet<GroupSymbol> groups = new HashSet<GroupSymbol>();
        groups.add(gs1);
        groups.add(gs2);
        this.helpTestGroups((LanguageObject)from, true, groups);
    }

    public void testFrom4() {
        GroupSymbol gs1 = this.exampleGroupSymbol(1);
        GroupSymbol gs2 = this.exampleGroupSymbol(2);
        From from = new From();
        from.addGroup(gs1);
        from.addGroup(gs2);
        from.addGroup(gs1);
        ArrayList<GroupSymbol> groups = new ArrayList<GroupSymbol>();
        groups.add(gs1);
        groups.add(gs2);
        groups.add(gs1);
        this.helpTestGroups((LanguageObject)from, false, groups);
    }

    public void testInsert() {
        GroupSymbol gs1 = this.exampleGroupSymbol(1);
        Insert insert = new Insert();
        insert.setGroup(gs1);
        HashSet<GroupSymbol> groups = new HashSet<GroupSymbol>();
        groups.add(gs1);
        this.helpTestGroups((LanguageObject)insert, true, groups);
    }

    public void testUpdate() {
        GroupSymbol gs1 = this.exampleGroupSymbol(1);
        Update update = new Update();
        update.setGroup(gs1);
        HashSet<GroupSymbol> groups = new HashSet<GroupSymbol>();
        groups.add(gs1);
        this.helpTestGroups((LanguageObject)update, true, groups);
    }

    public void testDelete() {
        GroupSymbol gs1 = this.exampleGroupSymbol(1);
        Delete delete = new Delete();
        delete.setGroup(gs1);
        HashSet<GroupSymbol> groups = new HashSet<GroupSymbol>();
        groups.add(gs1);
        this.helpTestGroups((LanguageObject)delete, true, groups);
    }

    public void testBatchedUpdateCommand() {
        GroupSymbol g1 = this.exampleGroupSymbol(1);
        GroupSymbol g2 = this.exampleGroupSymbol(2);
        GroupSymbol g3 = this.exampleGroupSymbol(3);
        Insert insert = new Insert();
        insert.setGroup(g1);
        Update update = new Update();
        update.setGroup(g2);
        Delete delete = new Delete();
        delete.setGroup(g3);
        ArrayList<Object> updates = new ArrayList<Object>(3);
        updates.add(insert);
        updates.add(update);
        updates.add(delete);
        HashSet<GroupSymbol> groups = new HashSet<GroupSymbol>();
        groups.add(g1);
        groups.add(g2);
        groups.add(g3);
        this.helpTestGroups((LanguageObject)new BatchedUpdateCommand(updates), true, groups);
    }
}

