/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.relational;

import java.util.Collections;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.TupleBatch;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.query.processor.ProcessorDataManager;
import org.teiid.query.processor.relational.LimitNode;
import org.teiid.query.processor.relational.ProjectNode;
import org.teiid.query.processor.relational.RelationalNode;
import org.teiid.query.processor.relational.SelectNode;
import org.teiid.query.processor.relational.SortNode;
import org.teiid.query.util.CommandContext;

public class UnionAllNode
extends RelationalNode {
    private static final int SMALL_LIMIT = 10;
    private boolean[] sourceDone;
    private boolean[] sourceOpen;
    private int outputRow = 1;
    private int reserved;
    private int schemaSize;

    public UnionAllNode(int nodeID) {
        super(nodeID);
    }

    @Override
    public void reset() {
        super.reset();
        this.sourceDone = null;
        this.sourceOpen = null;
        this.outputRow = 1;
    }

    @Override
    public void initialize(CommandContext context, BufferManager bufferManager, ProcessorDataManager dataMgr) {
        super.initialize(context, bufferManager, dataMgr);
        this.schemaSize = this.getBufferManager().getSchemaSize(this.getOutputElements());
    }

    @Override
    public void open() throws TeiidComponentException, TeiidProcessingException {
        this.sourceDone = new boolean[this.getChildren().length];
        int rowLimit = -1;
        for (RelationalNode parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (parent instanceof LimitNode) {
                LimitNode limit = (LimitNode)parent;
                rowLimit = limit.getLimit();
                if (rowLimit == -1 || limit.getOffset() <= 0) break;
                rowLimit += limit.getOffset();
                break;
            }
            if (parent instanceof SortNode || !(parent instanceof SelectNode) || !(parent instanceof ProjectNode) || !(parent instanceof UnionAllNode)) break;
        }
        if (rowLimit != -1 && rowLimit < Integer.MAX_VALUE) {
            int toOpen = 2;
            if (rowLimit > 10) {
                if (rowLimit < 256) {
                    toOpen = Math.max(Math.min(this.getChildCount(), this.getContext().getUserRequestSourceConcurrency()) / 3, 2);
                } else {
                    Math.max(2, this.getChildCount() / 2 + this.getChildCount() % 2);
                }
            }
            if (toOpen < this.getContext().getUserRequestSourceConcurrency() * 2) {
                if (this.reserved == 0) {
                    this.reserved = this.getBufferManager().reserveBuffers(toOpen * this.schemaSize, BufferManager.BufferReserveMode.FORCE);
                }
                this.sourceOpen = new boolean[this.getChildCount()];
                RelationalNode[] children = this.getChildren();
                for (int i = 0; i < toOpen; ++i) {
                    children[i].open();
                    this.sourceOpen[i] = true;
                }
                return;
            }
        }
        if (this.reserved == 0) {
            this.reserved = this.getBufferManager().reserveBuffers(this.getChildCount() * this.schemaSize, BufferManager.BufferReserveMode.FORCE);
        }
        super.open();
    }

    @Override
    public TupleBatch nextBatchDirect() throws BlockedException, TeiidComponentException, TeiidProcessingException {
        RelationalNode[] children = this.getChildren();
        int childCount = this.getChildCount();
        int activeSources = 0;
        TupleBatch batch = null;
        boolean additionalSources = false;
        for (int i = 0; i < childCount; ++i) {
            if (children[i] == null || this.sourceDone[i]) continue;
            if (this.sourceOpen != null && !this.sourceOpen[i]) {
                additionalSources = true;
                continue;
            }
            ++activeSources;
            if (batch != null) break;
            try {
                batch = children[i].nextBatch();
                if (!batch.getTerminationFlag()) continue;
                this.sourceDone[i] = true;
                --activeSources;
                if (this.reserved <= 0) continue;
                this.getBufferManager().releaseBuffers(this.schemaSize);
                this.reserved -= this.schemaSize;
                continue;
            }
            catch (BlockedException e) {
                // empty catch block
            }
        }
        TupleBatch outputBatch = null;
        if (batch != null) {
            outputBatch = new TupleBatch((long)this.outputRow, batch.getTuples());
            outputBatch.setTerminationFlag(batch.getTerminationFlag() && activeSources == 0 && !additionalSources);
            this.outputRow += outputBatch.getRowCount();
        } else {
            if (activeSources > 0) {
                throw BlockedException.block(this.getContext().getRequestId(), "Blocking on union source.", this.getID());
            }
            boolean openedAny = false;
            int toOpen = 0;
            if (this.sourceOpen != null) {
                int i;
                for (i = 0; i < childCount; ++i) {
                    if (!this.sourceOpen[i] || !this.sourceDone[i]) continue;
                    ++toOpen;
                }
                for (i = 0; i < childCount && toOpen > 0; ++i) {
                    if (this.sourceOpen[i]) continue;
                    this.getBufferManager().reserveBuffers(this.schemaSize, BufferManager.BufferReserveMode.FORCE);
                    this.reserved += this.schemaSize;
                    children[i].open();
                    this.sourceOpen[i] = true;
                    openedAny = true;
                    --toOpen;
                }
            }
            if (openedAny) {
                return this.nextBatchDirect();
            }
            outputBatch = new TupleBatch((long)this.outputRow, Collections.EMPTY_LIST);
            outputBatch.setTerminationFlag(true);
        }
        return outputBatch;
    }

    @Override
    public void closeDirect() {
        if (this.reserved > 0) {
            this.getBufferManager().releaseBuffers(this.reserved);
            this.reserved = 0;
        }
    }

    @Override
    public Object clone() {
        UnionAllNode clonedNode = new UnionAllNode(super.getID());
        super.copyTo(clonedNode);
        return clonedNode;
    }
}

