/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.tempdata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import org.teiid.api.exception.query.QueryProcessingException;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.BufferManager;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.types.TransformationException;
import org.teiid.dqp.service.TransactionContext;
import org.teiid.logging.LogManager;
import org.teiid.metadata.FunctionMethod;
import org.teiid.metadata.Table;
import org.teiid.query.QueryPlugin;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TempMetadataID;
import org.teiid.query.metadata.TempMetadataStore;
import org.teiid.query.processor.BatchCollector;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.processor.QueryProcessor;
import org.teiid.query.resolver.command.TempTableResolver;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.Create;
import org.teiid.query.sql.lang.Insert;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.tempdata.GlobalTableStoreImpl;
import org.teiid.query.tempdata.TempTable;
import org.teiid.query.util.CommandContext;

public class TempTableStore {
    public static final String TEIID_MAX_RECURSION = "teiid.maxRecursion";
    private Map<String, TempTableSynchronization> synchronizations = new ConcurrentHashMap<String, TempTableSynchronization>();
    private TransactionMode transactionMode = TransactionMode.NONE;
    private TempMetadataStore tempMetadataStore = new TempMetadataStore(new ConcurrentSkipListMap<String, TempMetadataID>(String.CASE_INSENSITIVE_ORDER));
    private Map<String, TempTable> tempTables = new ConcurrentSkipListMap<String, TempTable>(String.CASE_INSENSITIVE_ORDER);
    private Map<String, Table> foreignTempTables = new ConcurrentSkipListMap<String, Table>(String.CASE_INSENSITIVE_ORDER);
    private String sessionID;
    private TempTableStore parentTempTableStore;
    private HashMap<String, TableProcessor> processors;

    public TempTableStore(String sessionID, TransactionMode transactionMode) {
        this.sessionID = sessionID;
        this.transactionMode = transactionMode;
    }

    public void setParentTempTableStore(TempTableStore parentTempTableStore) {
        this.parentTempTableStore = parentTempTableStore;
    }

    public TempTableStore getParentTempTableStore() {
        return this.parentTempTableStore;
    }

    public boolean hasTempTable(String tempTableName, boolean checkParent) {
        boolean local;
        boolean bl = local = this.tempTables.containsKey(tempTableName) || this.foreignTempTables.containsKey(tempTableName);
        if (local) {
            return true;
        }
        if (checkParent && this.parentTempTableStore != null) {
            return this.parentTempTableStore.hasTempTable(tempTableName, checkParent);
        }
        return false;
    }

    public void setProcessors(HashMap<String, TableProcessor> plans) {
        this.processors = plans;
    }

    void addForeignTempTable(String tempTableName, Create create) {
        TempMetadataID id = this.tempMetadataStore.getTempGroupID(tempTableName);
        if (id == null) {
            id = this.tempMetadataStore.addTempGroup(tempTableName, create.getColumnSymbols(), false, true);
            id.setOriginalMetadataID(create.getTableMetadata());
            id.getTableData().setModel(create.getTableMetadata().getParent());
        }
        this.foreignTempTables.put(tempTableName, create.getTableMetadata());
    }

    TempTable addTempTable(String tempTableName, Create create, BufferManager buffer, boolean add, CommandContext context) throws TeiidProcessingException {
        List<ElementSymbol> columns = create.getColumnSymbols();
        TempMetadataID id = this.tempMetadataStore.getTempGroupID(tempTableName);
        this.getSynchronization(context);
        if (id == null) {
            id = this.tempMetadataStore.addTempGroup(tempTableName, columns, false, true);
            TempTableResolver.addAdditionalMetadata(create, id);
        }
        columns = new ArrayList<ElementSymbol>(create.getColumnSymbols());
        if (!create.getPrimaryKey().isEmpty()) {
            List<ElementSymbol> primaryKey = create.getPrimaryKey();
            columns.removeAll(primaryKey);
            columns.addAll(0, primaryKey);
        }
        TempTable tempTable = new TempTable(id, buffer, columns, create.getPrimaryKey().size(), this.sessionID);
        if (add) {
            this.tempTables.put(tempTableName, tempTable);
        }
        return tempTable;
    }

    public void removeTempTableByName(String tempTableName, CommandContext context) throws TeiidProcessingException {
        TempTableSynchronization synch = this.getSynchronization(context);
        this.tempMetadataStore.removeTempGroup(tempTableName);
        TempTable table = this.tempTables.remove(tempTableName);
        if (table == null) {
            this.foreignTempTables.remove(tempTableName);
            return;
        }
        if (this.transactionMode != TransactionMode.ISOLATE_WRITES || synch == null || !synch.existingTables.contains(table.getId())) {
            table.remove();
        }
    }

    private TempTableSynchronization getSynchronization(CommandContext context) throws TeiidProcessingException {
        TempTableSynchronization synch = null;
        if (context == null || this.transactionMode == TransactionMode.NONE) {
            return null;
        }
        TransactionContext tc = context.getTransactionContext();
        if (tc == null || tc.getTransactionType() == TransactionContext.Scope.NONE) {
            return null;
        }
        String transactionId = tc.getTransactionId();
        synch = this.synchronizations.get(transactionId);
        if (synch == null) {
            boolean success = false;
            try {
                synch = new TempTableSynchronization(transactionId);
                this.synchronizations.put(transactionId, synch);
                tc.getTransaction().registerSynchronization((Synchronization)synch);
                success = true;
            }
            catch (RollbackException e) {
                throw new TeiidProcessingException((BundleUtil.Event)QueryPlugin.Event.TEIID30223, (Throwable)e);
            }
            catch (SystemException e) {
                throw new TeiidProcessingException((BundleUtil.Event)QueryPlugin.Event.TEIID30224, (Throwable)e);
            }
            finally {
                if (!success) {
                    this.synchronizations.remove(transactionId);
                }
            }
        }
        return synch;
    }

    public TempMetadataStore getMetadataStore() {
        return this.tempMetadataStore;
    }

    public void removeTempTables() throws TeiidComponentException {
        for (String name : this.tempTables.keySet()) {
            try {
                this.removeTempTableByName(name, null);
            }
            catch (TeiidProcessingException e) {
                throw new TeiidComponentException((BundleUtil.Event)QueryPlugin.Event.TEIID30225, (Throwable)e);
            }
        }
        for (String name : this.foreignTempTables.keySet()) {
            try {
                this.removeTempTableByName(name, null);
            }
            catch (TeiidProcessingException e) {
                throw new TeiidComponentException((BundleUtil.Event)QueryPlugin.Event.TEIID30225, (Throwable)e);
            }
        }
    }

    public void setUpdatable(String name, boolean updatable) {
        TempTable table = this.tempTables.get(name);
        if (table != null) {
            table.setUpdatable(updatable);
        }
    }

    TempTable getTempTable(String tempTableID) {
        return this.tempTables.get(tempTableID);
    }

    public HashMap<String, TableProcessor> getProcessors() {
        return this.processors;
    }

    TempTable getOrCreateTempTable(String tempTableID, Command command, BufferManager buffer, boolean delegate, boolean forUpdate, CommandContext context, GroupSymbol group) throws TeiidProcessingException, BlockedException, TeiidComponentException {
        if (!(group.getMetadataID() instanceof TempMetadataID)) {
            TempTableStore tts = context.getSessionTempTableStore();
            context.setDeterminismLevel(FunctionMethod.Determinism.SESSION_DETERMINISTIC);
            if (tts.getTempTable(tempTableID) == null) {
                LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object)"binding global temp table to session", (Object)group);
                QueryMetadataInterface metadata = context.getMetadata();
                Create create = GlobalTableStoreImpl.getCreateCommand(group, false, metadata);
                tts.addTempTable(tempTableID, create, buffer, true, context);
            }
            return this.getTempTable(tempTableID, command, buffer, delegate, forUpdate, context);
        }
        TempTable tempTable = this.getTempTable(tempTableID, command, buffer, delegate, forUpdate, context);
        if (tempTable != null) {
            TableProcessor withProcessor;
            if (this.processors != null && (withProcessor = this.processors.get(tempTableID)) != null) {
                TempTable tt = withProcessor.process(tempTable);
                if (tt != tempTable) {
                    return tt;
                }
                this.processors.remove(tempTableID);
            }
            return tempTable;
        }
        List<ElementSymbol> columns = null;
        if (command instanceof Insert) {
            Insert insert = (Insert)command;
            if (group.isImplicitTempGroupSymbol()) {
                columns = insert.getVariables();
            }
        }
        if (columns == null) {
            TableProcessor withProcessor;
            if (this.processors != null && (withProcessor = this.processors.get(tempTableID)) != null) {
                LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object)"Creating temporary table for with clause", (Object)tempTableID);
                Create create = new Create();
                create.setTable(new GroupSymbol(tempTableID));
                create.setElementSymbolsAsColumns(withProcessor.columns);
                withProcessor.alterCreate(create);
                tempTable = this.addTempTable(tempTableID, create, buffer, true, context);
                TempTable tt = withProcessor.process(tempTable);
                if (tt != tempTable) {
                    return tt;
                }
                this.processors.remove(tempTableID);
                return tempTable;
            }
            throw new QueryProcessingException((BundleUtil.Event)QueryPlugin.Event.TEIID30226, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30226, new Object[]{tempTableID}));
        }
        LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object)"Creating temporary table", (Object)tempTableID);
        Create create = new Create();
        create.setTable(new GroupSymbol(tempTableID));
        create.setElementSymbolsAsColumns(columns);
        return this.addTempTable(tempTableID, create, buffer, true, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TempTable getTempTable(String tempTableID, Command command, BufferManager buffer, boolean delegate, boolean forUpdate, CommandContext context) throws TeiidProcessingException {
        TempTable tempTable = this.tempTables.get(tempTableID);
        if (tempTable != null) {
            TempTableSynchronization synch;
            TransactionContext tc;
            if (forUpdate) {
                if (this.transactionMode == TransactionMode.ISOLATE_WRITES) {
                    TransactionContext tc2 = context.getTransactionContext();
                    if (tc2 != null) {
                        TempTableSynchronization synch2 = this.getSynchronization(context);
                        if (synch2 != null && synch2.existingTables.contains(tempTable.getId())) {
                            TempTable result = synch2.tables.get(tempTableID);
                            if (result == null) {
                                TempTableSynchronization tempTableSynchronization = synch2;
                                synchronized (tempTableSynchronization) {
                                    if (synch2.isCompleted()) {
                                        throw new AssertionError((Object)"Expected active transaction");
                                    }
                                    if (!tempTable.getActive().compareAndSet(0, 1)) {
                                        throw new TeiidProcessingException((BundleUtil.Event)QueryPlugin.Event.TEIID30227, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30227, new Object[]{tempTableID}));
                                    }
                                    synch2.tables.put(tempTableID, tempTable.clone());
                                }
                            }
                            return tempTable;
                        }
                    } else if (tempTable.getActive().get() != 0) {
                        throw new TeiidProcessingException((BundleUtil.Event)QueryPlugin.Event.TEIID30227, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30227, new Object[]{tempTableID}));
                    }
                }
            } else if (this.transactionMode == TransactionMode.ISOLATE_READS && (tc = context.getTransactionContext()) != null && tc.getIsolationLevel() > 2 && (synch = this.getSynchronization(context)) != null) {
                TempTable result = synch.tables.get(tempTableID);
                if (result == null) {
                    result = tempTable;
                    TempTableSynchronization tempTableSynchronization = synch;
                    synchronized (tempTableSynchronization) {
                        if (!synch.isCompleted()) {
                            synch.tables.put(tempTableID, tempTable);
                            result.getActive().getAndIncrement();
                        }
                    }
                }
                return result;
            }
            return tempTable;
        }
        if (delegate && this.parentTempTableStore != null) {
            return this.parentTempTableStore.getTempTable(tempTableID, command, buffer, delegate, forUpdate, context);
        }
        return null;
    }

    Map<String, TempTable> getTempTables() {
        return this.tempTables;
    }

    public class TempTableSynchronization
    implements Synchronization {
        private String id;
        Set<Long> existingTables = new HashSet<Long>();
        ConcurrentHashMap<String, TempTable> tables = new ConcurrentHashMap();
        private List<TransactionCallback> callbacks = new LinkedList<TransactionCallback>();
        private boolean completed;

        public TempTableSynchronization(final String id) {
            this.id = id;
            for (TempTable tempTable : TempTableStore.this.tempTables.values()) {
                this.existingTables.add(tempTable.getId());
            }
            if (TempTableStore.this.transactionMode == TransactionMode.ISOLATE_WRITES) {
                this.addCallback(new TransactionCallback(){
                    private Map<String, TempMetadataID> clonedMetadata;
                    private Map<String, TempTable> clonedTables;
                    {
                        this.clonedMetadata = new ConcurrentHashMap<String, TempMetadataID>(TempTableStore.this.tempMetadataStore.getData());
                        this.clonedTables = new ConcurrentHashMap<String, TempTable>(TempTableStore.this.tempTables);
                    }

                    @Override
                    public void rollback() {
                        LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object[])new Object[]{"Rolling back txn", id, "restoring", this.clonedTables.keySet(), "using rollback tables", TempTableSynchronization.this.tables});
                        TempTableStore.this.tempTables.values().removeAll(this.clonedTables.values());
                        for (TempTable table : TempTableStore.this.tempTables.values()) {
                            table.remove();
                        }
                        TempTableStore.this.tempMetadataStore.getData().clear();
                        TempTableStore.this.tempMetadataStore.getData().putAll(this.clonedMetadata);
                        TempTableStore.this.tempTables.clear();
                        TempTableStore.this.tempTables.putAll(this.clonedTables);
                        TempTableStore.this.tempTables.putAll(TempTableSynchronization.this.tables);
                    }

                    @Override
                    public void commit() {
                        this.clonedTables.values().removeAll(TempTableStore.this.tempTables.values());
                        for (TempTable table : this.clonedTables.values()) {
                            table.remove();
                        }
                    }
                });
            }
        }

        public synchronized void afterCompletion(int status) {
            this.completed = true;
            TempTableStore.this.synchronizations.remove(this.id);
            if (TempTableStore.this.transactionMode == TransactionMode.ISOLATE_READS) {
                for (TempTable table : this.tables.values()) {
                    table.getActive().decrementAndGet();
                }
            } else {
                HashSet current = new HashSet(TempTableStore.this.tempTables.values());
                current.retainAll(this.tables.values());
                for (TempTable table : current) {
                    table.getActive().set(0);
                    table.getTree().clearClonedFlags();
                }
            }
            for (TransactionCallback callback : this.callbacks) {
                if (status == 3) {
                    callback.commit();
                    continue;
                }
                callback.rollback();
            }
            this.callbacks.clear();
        }

        public boolean isCompleted() {
            return this.completed;
        }

        public void beforeCompletion() {
        }

        public synchronized boolean addCallback(TransactionCallback callback) {
            if (!this.completed) {
                this.callbacks.add(0, callback);
            }
            return !this.completed;
        }
    }

    public static class RecursiveTableProcessor
    extends TableProcessor {
        private ProcessorPlan recursive;
        private boolean all;
        private boolean initial = true;
        private TempTable working;
        private TempTable intermediate;
        private QueryProcessor workingQp;
        private boolean building;
        private int iterations;
        private int maxIterations = 10000;

        public RecursiveTableProcessor(QueryProcessor queryProcessor, List<ElementSymbol> columns, ProcessorPlan processorPlan, boolean all) throws TransformationException {
            super(queryProcessor, columns);
            Object value;
            this.recursive = processorPlan;
            this.all = all;
            if (queryProcessor.getContext() != null && (value = queryProcessor.getContext().getSessionVariable(TempTableStore.TEIID_MAX_RECURSION)) != null) {
                value = DataTypeManager.convertToRuntimeType((Object)value, (boolean)false);
                DataTypeManager.transformValue((Object)value, value.getClass(), (Class)DataTypeManager.DefaultDataClasses.INTEGER);
                if (value instanceof Number) {
                    this.maxIterations = ((Number)value).intValue();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public TempTable process(TempTable tempTable) throws TeiidComponentException, TeiidProcessingException {
            if (this.initial) {
                if (this.working == null) {
                    this.working = tempTable.clone();
                    this.intermediate = tempTable.clone();
                }
                this.processPlan(tempTable, this.working);
                this.initial = false;
            }
            while (this.working.getRowCount() > 0L) {
                if (this.building) {
                    return this.working;
                }
                this.building = true;
                try {
                    if (this.workingQp == null) {
                        this.recursive.reset();
                        this.workingQp = new QueryProcessor(this.recursive, this.queryProcessor.getContext(), this.queryProcessor.getBufferManager(), this.queryProcessor.getProcessorDataManager());
                        this.iterator = new BatchCollector.BatchProducerTupleSource(this.workingQp);
                    }
                    this.processPlan(tempTable, this.intermediate);
                    ++this.iterations;
                    if (this.maxIterations > 0 && this.iterations > this.maxIterations) {
                        throw new TeiidProcessingException((BundleUtil.Event)QueryPlugin.Event.TEIID31158, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31158, new Object[]{this.maxIterations, tempTable.getMetadataId().getName()}));
                    }
                    this.workingQp.closeProcessing();
                    this.workingQp = null;
                    this.working.truncate(true);
                    TempTable temp = this.working;
                    this.working = this.intermediate;
                    this.intermediate = temp;
                }
                finally {
                    this.building = false;
                }
            }
            this.working.truncate(true);
            this.intermediate.truncate(true);
            tempTable.setUpdatable(false);
            return tempTable;
        }

        private void processPlan(TempTable tempTable, TempTable target) throws TeiidComponentException, TeiidProcessingException {
            List<Object> row = null;
            List<Object> tuple = null;
            while ((tuple = this.iterator.nextTuple()) != null) {
                if (this.all) {
                    row = new ArrayList<Object>(tuple);
                    row.add(0, tempTable.getRowCount());
                } else {
                    row = tuple;
                }
                if (!tempTable.insertTuple(row, false, false)) continue;
                target.insertTuple(row, false, true);
            }
            this.iterator.closeSource();
        }

        @Override
        public void alterCreate(Create create) {
            if (!this.all) {
                create.getPrimaryKey().addAll(create.getColumnSymbols());
            }
        }

        @Override
        public void close() {
            super.close();
            if (this.workingQp != null) {
                this.workingQp.closeProcessing();
            }
            if (this.working != null) {
                this.working.remove();
            }
            if (this.intermediate != null) {
                this.intermediate.remove();
            }
        }
    }

    public static class TableProcessor {
        QueryProcessor queryProcessor;
        List<ElementSymbol> columns;
        BatchCollector.BatchProducerTupleSource iterator;

        public TableProcessor(QueryProcessor queryProcessor, List<ElementSymbol> columns) {
            this.queryProcessor = queryProcessor;
            this.columns = columns;
            this.iterator = new BatchCollector.BatchProducerTupleSource(queryProcessor);
        }

        public void close() {
            this.iterator.closeSource();
            this.queryProcessor.closeProcessing();
        }

        public TempTable process(TempTable tempTable) throws TeiidComponentException, TeiidProcessingException {
            tempTable.insert(this.iterator, this.columns, false, null);
            tempTable.setUpdatable(false);
            this.close();
            return tempTable;
        }

        public void alterCreate(Create create) {
        }
    }

    public static enum TransactionMode {
        ISOLATE_READS,
        ISOLATE_WRITES,
        NONE;

    }

    public static interface TransactionCallback {
        public void commit();

        public void rollback();
    }
}

