/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.systemmodel;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.jdbc.FakeServer;
import org.teiid.metadata.AbstractMetadataRecord;
import org.teiid.metadata.Column;
import org.teiid.metadata.ColumnStats;
import org.teiid.metadata.DefaultMetadataRepository;
import org.teiid.metadata.MetadataRepository;
import org.teiid.metadata.Procedure;
import org.teiid.metadata.Table;
import org.teiid.metadata.TableStats;

public class TestMetadataUpdates {
    Connection connection;
    static final String VDB = "metadata";
    private static FakeServer server;

    @BeforeClass
    public static void oneTimeSetUp() throws Exception {
        server = new FakeServer(true);
    }

    @AfterClass
    public static void oneTimeTearDown() throws Exception {
        server.stop();
    }

    @Before
    public void setup() throws Exception {
        server.undeployVDB(VDB);
        server.deployVDB(VDB, UnitTestUtil.getTestDataPath() + "/metadata.vdb", new FakeServer.DeployVDBParameter(null, (MetadataRepository<?, ?>)TestMetadataUpdates.getMetadataRepo()));
        this.connection = server.createConnection("jdbc:teiid:metadata");
    }

    @After
    public void tearDown() throws SQLException {
        if (this.connection != null) {
            this.connection.close();
            this.connection = null;
        }
    }

    private static DefaultMetadataRepository getMetadataRepo() {
        DefaultMetadataRepository repo = new DefaultMetadataRepository(){

            public void setColumnStats(String vdbName, String vdbVersion, Column column, ColumnStats columnStats) {
            }

            public void setInsteadOfTriggerDefinition(String vdbName, String vdbVersion, Table table, Table.TriggerEvent triggerOperation, String triggerDefinition) {
            }

            public void setInsteadOfTriggerEnabled(String vdbName, String vdbVersion, Table table, Table.TriggerEvent triggerOperation, boolean enabled) {
            }

            public void setProcedureDefinition(String vdbName, String vdbVersion, Procedure procedure, String procedureDefinition) {
            }

            public void setProperty(String vdbName, String vdbVersion, AbstractMetadataRecord record, String name, String value) {
            }

            public void setTableStats(String vdbName, String vdbVersion, Table table, TableStats tableStats) {
            }

            public void setViewDefinition(String vdbName, String vdbVersion, Table table, String viewDefinition) {
            }

            public String getViewDefinition(String vdbName, String vdbVersion, Table table) {
                if (table.getName().equals("vw")) {
                    return "select '2011'";
                }
                return null;
            }

            public String getProcedureDefinition(String vdbName, String vdbVersion, Procedure procedure) {
                if (procedure.getName().equals("proc")) {
                    return "create virtual procedure begin select '2011'; if ((call isLoggable())) call logMsg(msg=>'hello'); end";
                }
                return null;
            }

            public String getInsteadOfTriggerDefinition(String vdbName, String vdbVersion, Table table, Table.TriggerEvent triggerOperation) {
                return "for each row select 1/0;";
            }

            public Boolean isInsteadOfTriggerEnabled(String vdbName, String vdbVersion, Table table, Table.TriggerEvent triggerOperation) {
                return Boolean.TRUE;
            }
        };
        return repo;
    }

    @Test
    public void testViewMetadataRepositoryMerge() throws Exception {
        Statement s = this.connection.createStatement();
        ResultSet rs = s.executeQuery("select * from vw");
        rs.next();
        Assert.assertEquals((long)2011L, (long)rs.getInt(1));
    }

    @Test(expected=SQLException.class)
    public void testViewUpdateMetadataRepositoryMerge() throws Exception {
        Statement s = this.connection.createStatement();
        s.execute("delete from vw");
    }

    @Test
    public void testProcMetadataRepositoryMerge() throws Exception {
        Statement s = this.connection.createStatement();
        ResultSet rs = s.executeQuery("call proc(1)");
        rs.next();
        Assert.assertEquals((long)2011L, (long)rs.getInt(1));
    }

    @Test
    public void testSetProperty() throws Exception {
        CallableStatement s = this.connection.prepareCall("{? = call sysadmin.setProperty((select uid from tables where name='vw'), 'foo', 'bar')}");
        Assert.assertFalse((boolean)s.execute());
        Assert.assertNull((Object)s.getClob(1));
        Statement stmt = this.connection.createStatement();
        ResultSet rs = stmt.executeQuery("select name, \"value\" from properties where uid = (select uid from tables where name='vw') and name = 'foo'");
        rs.next();
        Assert.assertEquals((Object)"foo", (Object)rs.getString(1));
        Assert.assertEquals((Object)"bar", (Object)rs.getString(2));
    }

    @Test
    public void testSetPropertyNamespace() throws Exception {
        CallableStatement s = this.connection.prepareCall("{? = call sysadmin.setProperty((select uid from tables where name='vw'), 'teiid_rel:foo', 'bar')}");
        Assert.assertFalse((boolean)s.execute());
        Assert.assertNull((Object)s.getClob(1));
        Statement stmt = this.connection.createStatement();
        ResultSet rs = stmt.executeQuery("select name, \"value\" from properties where uid = (select uid from tables where name='vw') and name = '{http://www.teiid.org/ext/relational/2012}foo'");
        rs.next();
        Assert.assertEquals((Object)"{http://www.teiid.org/ext/relational/2012}foo", (Object)rs.getString(1));
        Assert.assertEquals((Object)"bar", (Object)rs.getString(2));
    }

    @Test(expected=SQLException.class)
    public void testSetProperty_Invalid() throws Exception {
        CallableStatement s = this.connection.prepareCall("{? = call sysadmin.setProperty('ah', 'foo', 'bar')}");
        s.execute();
    }

    @Test
    public void testAlterView() throws Exception {
        Statement s = this.connection.createStatement();
        ResultSet rs = s.executeQuery("select * from vw");
        rs.next();
        Assert.assertEquals((long)2011L, (long)rs.getInt(1));
        Assert.assertFalse((boolean)s.execute("alter view vw as select '2012'"));
        rs = s.executeQuery("select * from vw");
        rs.next();
        Assert.assertEquals((long)2012L, (long)rs.getInt(1));
    }

    @Test
    public void testAlterProcedure() throws Exception {
        Statement s = this.connection.createStatement();
        ResultSet rs = s.executeQuery("call proc(1)");
        rs.next();
        Assert.assertEquals((long)2011L, (long)rs.getInt(1));
        Assert.assertFalse((boolean)s.execute("alter procedure proc as begin select '2012'; end"));
        Thread.sleep(100L);
        rs = s.executeQuery("call proc(1)");
        rs.next();
        Assert.assertEquals((long)2012L, (long)rs.getInt(1));
    }

    @Test
    public void testAlterTriggerActionUpdate() throws Exception {
        Statement s = this.connection.createStatement();
        try {
            s.execute("update vw set x = 1");
            Assert.fail();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        Assert.assertFalse((boolean)s.execute("alter trigger on vw instead of update as for each row select 1;"));
        s.execute("update vw set x = 1");
        Assert.assertEquals((long)1L, (long)s.getUpdateCount());
    }

    @Test
    public void testAlterTriggerActionInsert() throws Exception {
        Statement s = this.connection.createStatement();
        try {
            s.execute("insert into vw (x) values ('a')");
            Assert.fail();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        Assert.assertFalse((boolean)s.execute("alter trigger on vw instead of insert as for each row select 1;"));
        s.execute("insert into vw (x) values ('a')");
        Assert.assertEquals((long)1L, (long)s.getUpdateCount());
    }

    @Test
    public void testAlterTriggerActionDelete() throws Exception {
        Statement s = this.connection.createStatement();
        try {
            s.execute("delete from vw");
            Assert.fail();
        }
        catch (SQLException e) {
            // empty catch block
        }
        Assert.assertFalse((boolean)s.execute("alter trigger on vw instead of delete as for each row select 1;"));
        s.execute("delete from vw");
        Assert.assertEquals((long)1L, (long)s.getUpdateCount());
        Assert.assertFalse((boolean)s.execute("alter trigger on vw instead of delete disabled"));
        try {
            s.execute("delete from vw");
            Assert.fail();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        Assert.assertFalse((boolean)s.execute("alter trigger on vw instead of delete enabled"));
        s.execute("delete from vw");
        Assert.assertEquals((long)1L, (long)s.getUpdateCount());
    }

    @Test(expected=SQLException.class)
    public void testCreateTriggerActionUpdate() throws Exception {
        Statement s = this.connection.createStatement();
        s.execute("create trigger on vw instead of update as for each row select 1;");
    }
}

