/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.vdb.runtime;

import org.junit.Assert;
import org.junit.Test;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.vdb.runtime.VDBKey;

public class TestVDBKey {
    @Test
    public void testCaseInsensitive() {
        VDBKey key = new VDBKey("foo", (Object)1);
        VDBKey key1 = new VDBKey("FOO", (Object)1);
        UnitTestUtil.helpTestEquivalence((int)0, (Object)key, (Object)key1);
    }

    @Test
    public void testNotEqual() {
        VDBKey key = new VDBKey("a", (Object)1);
        VDBKey key1 = new VDBKey("b", (Object)1);
        Assert.assertFalse((boolean)key.equals((Object)key1));
    }

    @Test
    public void testNameEndingInNumber() {
        VDBKey key = new VDBKey("a1", (Object)1);
        VDBKey key1 = new VDBKey("a", (Object)11);
        Assert.assertFalse((boolean)key.equals((Object)key1));
    }

    @Test
    public void testDiffertVersion() {
        VDBKey key = new VDBKey("a", (Object)1);
        VDBKey key1 = new VDBKey("a", (Object)11);
        Assert.assertFalse((boolean)key.equals((Object)key1));
    }

    @Test
    public void testSemanticVersion() {
        VDBKey key = new VDBKey("a.1.2.3", null);
        VDBKey key1 = new VDBKey("a.1.11.3", null);
        Assert.assertFalse((boolean)key.isAtMost());
        Assert.assertFalse((boolean)key.equals((Object)key1));
        Assert.assertEquals((long)-1L, (long)key.compareTo(key1));
        Assert.assertEquals((long)1L, (long)key1.compareTo(key));
    }

    @Test
    public void testShortSemanticVersion() {
        VDBKey key = new VDBKey("a.1.3", null);
        VDBKey key1 = new VDBKey("a", (Object)"1.2.");
        Assert.assertFalse((boolean)key.isAtMost());
        Assert.assertTrue((boolean)key1.isAtMost());
        Assert.assertFalse((boolean)key.equals((Object)key1));
        Assert.assertEquals((long)1L, (long)key.compareTo(key1));
        Assert.assertEquals((long)-1L, (long)key1.compareTo(key));
    }

    @Test(expected=TeiidRuntimeException.class)
    public void testInvalid() {
        new VDBKey("a", (Object)"abc");
    }

    @Test
    public void testPossiblyInvalid() {
        VDBKey key = new VDBKey("a.abc", null);
        Assert.assertEquals((Object)"a.abc", (Object)key.getName());
        Assert.assertTrue((boolean)key.isAtMost());
        Assert.assertEquals((Object)"a.abc.latest", (Object)key.toString());
    }

    @Test(expected=TeiidRuntimeException.class)
    public void testInvalidName() {
        new VDBKey("a.1", (Object)"1");
    }
}

