/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jdbc;

import java.io.ByteArrayInputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.deployers.VDBRepository;
import org.teiid.jdbc.ConnectionImpl;
import org.teiid.jdbc.TeiidSQLException;
import org.teiid.runtime.EmbeddedConfiguration;
import org.teiid.runtime.EmbeddedServer;
import org.teiid.runtime.MaterializationManager;

public class TestDataRoles {
    private ExtendedEmbeddedServer es;

    @After
    public void tearDown() {
        this.es.stop();
    }

    @Test
    public void testMaterializationWithSecurity() throws Exception {
        this.es = new ExtendedEmbeddedServer();
        EmbeddedConfiguration ec = new EmbeddedConfiguration();
        this.es.start(ec);
        this.es.deployVDB(new ByteArrayInputStream(new String("<vdb name=\"role-1\" version=\"1\"><model name=\"myschema\" type=\"virtual\"><metadata type = \"DDL\"><![CDATA[CREATE VIEW vw as select 'a' as col;]]></metadata></model><data-role name=\"y\" any-authenticated=\"true\"/></vdb>").getBytes()));
        ConnectionImpl c = this.es.getDriver().connect("jdbc:teiid:role-1", null);
        Statement s = c.createStatement();
        try {
            s.execute("select * from vw");
            Assert.fail();
        }
        catch (SQLException e) {
            // empty catch block
        }
        this.es.getMaterializationManager().executeQuery(this.es.getVDBRepository().getLiveVDB("role-1"), "select * from vw");
    }

    @Test
    public void testExecuteImmediate() throws Exception {
        this.es = new ExtendedEmbeddedServer();
        EmbeddedConfiguration ec = new EmbeddedConfiguration();
        this.es.start(ec);
        this.es.deployVDB(new ByteArrayInputStream(new String("<vdb name=\"role-1\" version=\"1\"><model name=\"myschema\" type=\"virtual\"><metadata type = \"DDL\"><![CDATA[CREATE VIEW vw as select 'a' as col;]]></metadata></model><data-role name=\"y\" any-authenticated=\"true\"/></vdb>").getBytes()));
        ConnectionImpl c = this.es.getDriver().connect("jdbc:teiid:role-1", null);
        Statement s = c.createStatement();
        s.execute("set autoCommitTxn off");
        try {
            s.execute("begin execute immediate 'select * from vw'; end");
            Assert.fail();
        }
        catch (TeiidSQLException e) {
            // empty catch block
        }
        s.execute("begin execute immediate 'select 1'; end");
        try {
            s.execute("begin execute immediate 'select 1' as x integer into #temp; end");
            Assert.fail();
        }
        catch (TeiidSQLException e) {
            // empty catch block
        }
        try {
            s.execute("begin execute immediate 'begin execute immediate ''select * from vw''; end'; end");
            Assert.fail();
        }
        catch (TeiidSQLException e) {
            // empty catch block
        }
    }

    @Test
    public void testMetadataWithSecurity() throws Exception {
        this.es = new ExtendedEmbeddedServer();
        EmbeddedConfiguration ec = new EmbeddedConfiguration();
        this.es.start(ec);
        this.es.deployVDB(new ByteArrayInputStream(new String("<vdb name=\"role-1\" version=\"1\"><model name=\"s1\" type=\"virtual\"><metadata type = \"DDL\"><![CDATA[CREATE VIEW t2 (col string primary key) options (x 'y') as select 'a' as col;\nCREATE VIEW t1 (col string, col_hidden string, primary key (col, col_hidden), foreign key (col) references t2) options (x 'y1') as select col, 'b' as col_hidden from t2;\nCREATE virtual procedure proc1 (param1 string) returns table (proc_col string) as begin end;\n]]></metadata></model><model name=\"s2\" type=\"virtual\"><metadata type = \"DDL\"><![CDATA[CREATE VIEW t3 as select 'a' as col, 'b' as col_hidden;\nCREATE virtual procedure proc2 (param2 string) returns table (proc_col string) as begin end;\n]]></metadata></model><data-role name=\"y\" any-authenticated=\"true\"><permission><resource-name>s1</resource-name><allow-read>true</allow-read></permission><permission><resource-name>s1.t1.col_hidden</resource-name><allow-read>false</allow-read></permission><permission><resource-name>s1.t2</resource-name><allow-read>false</allow-read></permission><permission><resource-name>sysadmin</resource-name><allow-read>true</allow-read></permission></data-role></vdb>").getBytes()));
        ConnectionImpl c = this.es.getDriver().connect("jdbc:teiid:role-1", null);
        Statement s = c.createStatement();
        ResultSet rs = s.executeQuery("select * from sys.tables where name like 't_'");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"t1", (Object)rs.getString("name"));
        Assert.assertFalse((boolean)rs.next());
        rs = s.executeQuery("select * from sys.schemas where name like 's_' order by name");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"s1", (Object)rs.getString("name"));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"s2", (Object)rs.getString("name"));
        Assert.assertFalse((boolean)rs.next());
        rs = s.executeQuery("select * from sys.columns where tablename like 't_'");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"col", (Object)rs.getString("name"));
        Assert.assertFalse((boolean)rs.next());
        rs = s.executeQuery("select * from sys.procedures where name like 'proc_'");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"proc1", (Object)rs.getString("name"));
        Assert.assertFalse((boolean)rs.next());
        rs = s.executeQuery("select * from sys.procedureparams where procedurename like 'proc_'");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"param1", (Object)rs.getString("name"));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"proc_col", (Object)rs.getString("name"));
        Assert.assertFalse((boolean)rs.next());
        rs = s.executeQuery("select * from sysadmin.usage where schemaname like 's_'");
        Assert.assertFalse((boolean)rs.next());
        rs = s.executeQuery("select * from sys.properties where name = 'x'");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"y1", (Object)rs.getString("Value"));
        Assert.assertFalse((boolean)rs.next());
        rs = s.executeQuery("select * from sys.keycolumns where tablename = 't1'");
        Assert.assertFalse((boolean)rs.next());
        rs = s.executeQuery("select * from sys.keys where tablename = 't1'");
        Assert.assertFalse((boolean)rs.next());
    }

    private static final class ExtendedEmbeddedServer
    extends EmbeddedServer {
        private ExtendedEmbeddedServer() {
        }

        public MaterializationManager getMaterializationManager() {
            return super.getMaterializationManager();
        }

        public VDBRepository getVDBRepository() {
            return super.getVDBRepository();
        }
    }
}

