/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.visitor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.lang.ExistsCriteria;
import org.teiid.query.sql.lang.SubqueryCompareCriteria;
import org.teiid.query.sql.lang.SubqueryContainer;
import org.teiid.query.sql.lang.SubqueryFromClause;
import org.teiid.query.sql.lang.SubquerySetCriteria;
import org.teiid.query.sql.navigator.PreOrderNavigator;
import org.teiid.query.sql.symbol.ScalarSubquery;

public class ValueIteratorProviderCollectorVisitor
extends LanguageVisitor {
    private List<SubqueryContainer<?>> valueIteratorProviders;
    private boolean collectLateral;

    public ValueIteratorProviderCollectorVisitor() {
        this.valueIteratorProviders = new ArrayList();
    }

    ValueIteratorProviderCollectorVisitor(List<SubqueryContainer<?>> valueIteratorProviders) {
        this.valueIteratorProviders = valueIteratorProviders;
    }

    public List<SubqueryContainer<?>> getValueIteratorProviders() {
        return this.valueIteratorProviders;
    }

    @Override
    public void visit(SubquerySetCriteria obj) {
        this.valueIteratorProviders.add(obj);
    }

    @Override
    public void visit(SubqueryCompareCriteria obj) {
        if (obj.getCommand() != null) {
            this.valueIteratorProviders.add(obj);
        }
    }

    @Override
    public void visit(ExistsCriteria obj) {
        this.valueIteratorProviders.add(obj);
    }

    @Override
    public void visit(ScalarSubquery obj) {
        this.valueIteratorProviders.add(obj);
    }

    @Override
    public void visit(SubqueryFromClause obj) {
        if (this.collectLateral && obj.isLateral()) {
            this.valueIteratorProviders.add(obj);
        }
    }

    public static final List<SubqueryContainer<?>> getValueIteratorProviders(LanguageObject obj) {
        ValueIteratorProviderCollectorVisitor visitor = new ValueIteratorProviderCollectorVisitor();
        PreOrderNavigator.doVisit(obj, visitor);
        return visitor.getValueIteratorProviders();
    }

    public static final void getValueIteratorProviders(LanguageObject obj, List<SubqueryContainer<?>> valueIteratorProviders) {
        ValueIteratorProviderCollectorVisitor visitor = new ValueIteratorProviderCollectorVisitor(valueIteratorProviders);
        PreOrderNavigator.doVisit(obj, visitor);
    }

    public static final List<SubqueryContainer<?>> getValueIteratorProviders(Collection<? extends LanguageObject> languageObjects) {
        if (languageObjects == null || languageObjects.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList result = new LinkedList();
        ValueIteratorProviderCollectorVisitor visitor = new ValueIteratorProviderCollectorVisitor(result);
        for (LanguageObject languageObject : languageObjects) {
            PreOrderNavigator.doVisit(languageObject, visitor);
        }
        return result;
    }

    public void setCollectLateral(boolean b) {
        this.collectLateral = true;
    }
}

