/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer;

import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.optimizer.TestOptimizer;
import org.teiid.query.optimizer.capabilities.BasicSourceCapabilities;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.DefaultCapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.FakeCapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.SourceCapabilities;
import org.teiid.query.processor.HardcodedDataManager;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.processor.TestProcessor;
import org.teiid.query.processor.relational.LimitNode;
import org.teiid.query.processor.relational.ProjectNode;
import org.teiid.query.processor.relational.RelationalPlan;
import org.teiid.query.unittest.RealMetadataFactory;

public class TestSortOptimization {
    @Test
    public void testSortDupCombination() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        String sql = "select distinct e1, e2 from pm1.g1 order by e2";
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT e1, e2 FROM pm1.g1"}, true);
        TestOptimizer.checkNodeTypes(plan, TestOptimizer.FULL_PUSHDOWN);
        TestOptimizer.checkNodeTypes(plan, new int[]{1}, new Class[]{TestOptimizer.DupRemoveSortNode.class});
    }

    @Test
    public void testSortDupCombination1() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        String sql = "select e1, e2 from pm1.g1 union select e1, e2 from pm1.g2 order by e2";
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT e1, e2 FROM pm1.g1", "SELECT e1, e2 FROM pm1.g2"}, true);
        TestOptimizer.checkNodeTypes(plan, new int[]{2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1});
        TestOptimizer.checkNodeTypes(plan, new int[]{1}, new Class[]{TestOptimizer.DupRemoveSortNode.class});
    }

    @Test
    public void testSortDupCombination2() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        String sql = "select x.*, y.* from (select distinct e1, e2 from pm1.g1) x, (select distinct e1, e2 from pm1.g2) y where x.e1 = y.e1";
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT e1, e2 FROM pm1.g1", "SELECT e1, e2 FROM pm1.g2"}, true);
        TestOptimizer.checkNodeTypes(plan, new int[]{2, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0});
        TestOptimizer.checkNodeTypes(plan, new int[]{0}, new Class[]{TestOptimizer.DupRemoveSortNode.class});
    }

    @Test
    public void testGroupDupCombination() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        String sql = "select max(e1), e2 from (select distinct e1, e2 from pm1.g1) x group by e2";
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT pm1.g1.e1, pm1.g1.e2 FROM pm1.g1"}, true);
        TestOptimizer.checkNodeTypes(plan, new int[]{1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0});
        TestOptimizer.checkNodeTypes(plan, new int[]{0}, new Class[]{TestOptimizer.DupRemoveSortNode.class});
    }

    @Test
    public void testGroupDupCombination1() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        String sql = "select max(e1), e2 || e1 from (select distinct e1, e2 from pm1.g1) x group by e2 || e1";
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT pm1.g1.e1, pm1.g1.e2 FROM pm1.g1"}, true);
        TestOptimizer.checkNodeTypes(plan, new int[]{1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0});
        TestOptimizer.checkNodeTypes(plan, new int[]{1}, new Class[]{TestOptimizer.DupRemoveSortNode.class});
    }

    @Test
    public void testSortGroupCombination() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        String sql = "select max(e1), e2 from pm1.g1 x group by e2 order by e2";
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT pm1.g1.e2, pm1.g1.e1 FROM pm1.g1"}, true);
        TestOptimizer.checkNodeTypes(plan, new int[]{1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0});
        TestOptimizer.checkNodeTypes(plan, new int[]{0}, new Class[]{TestOptimizer.DupRemoveSortNode.class});
    }

    @Test
    public void testProjectionRaisingWithLimit() {
        String sql = "select e1, (select e1 from pm2.g1 where e2 = x.e2) from pm1.g1 as x order by e1 limit 2";
        RelationalPlan plan = (RelationalPlan)TestOptimizer.helpPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), null, (CapabilitiesFinder)new DefaultCapabilitiesFinder(), new String[]{"SELECT pm1.g1.e1, pm1.g1.e2 FROM pm1.g1"}, true);
        Assert.assertTrue((boolean)(plan.getRootNode() instanceof ProjectNode));
    }

    @Test
    public void testProjectionRaisingWithLimit1() {
        String sql = "select (select e1 from pm2.g1 where e2 = x.e2) as z from pm1.g1 as x order by z limit 2";
        RelationalPlan plan = (RelationalPlan)TestOptimizer.helpPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), null, (CapabilitiesFinder)new DefaultCapabilitiesFinder(), new String[]{"SELECT pm1.g1.e2 FROM pm1.g1"}, true);
        Assert.assertTrue((boolean)(plan.getRootNode() instanceof LimitNode));
    }

    @Test
    public void testProjectionRaisingWithAccess() throws Exception {
        String sql = "select e1, (select e1 from pm2.g1 where e2 = x.e2) as z from pm1.g1 as x order by e1";
        TestOptimizer.helpPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), null, TestOptimizer.getGenericFinder(), new String[]{"SELECT g_0.e1 AS c_0, g_0.e2 AS c_1 FROM pm1.g1 AS g_0 ORDER BY c_0"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
    }

    @Test
    public void testProjectionRaisingWithAccess1() throws Exception {
        String sql = "select e1, 1 as z from pm1.g1 as x group by e1 order by e1";
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_GROUP_BY, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SELECT_EXPRESSION, false);
        RelationalPlan plan = (RelationalPlan)TestOptimizer.helpPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), null, (CapabilitiesFinder)new DefaultCapabilitiesFinder((SourceCapabilities)caps), new String[]{"SELECT g_0.e1 FROM pm1.g1 AS g_0 GROUP BY g_0.e1 ORDER BY g_0.e1"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        Assert.assertTrue((boolean)(plan.getRootNode() instanceof ProjectNode));
    }

    @Test
    public void testProjectionRaisingWithAccessAndLimit() throws Exception {
        String sql = "select e1, (select e1 from pm2.g1 where e2 = x.e2) as z from pm1.g1 as x order by e1 limit 1";
        TestOptimizer.helpPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), null, TestOptimizer.getGenericFinder(), new String[]{"SELECT g_0.e1 AS c_0, g_0.e2 AS c_1 FROM pm1.g1 AS g_0 ORDER BY c_0"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
    }

    @Test
    public void testProjectionRaisingForUnrelatedWithLimit() throws Exception {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.ROW_LIMIT, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_ORDERBY, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        capFinder.addCapabilities("pm2", (SourceCapabilities)caps);
        String sql = "select (select e1 from pm2.g1 where e2 = x.e2) as z from pm1.g1 as x order by e1 limit 1";
        TestOptimizer.helpPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT pm1.g1.e1, pm1.g1.e2 FROM pm1.g1 ORDER BY pm1.g1.e1 LIMIT 1"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
    }

    @Test
    public void testProjectionRaisingForUnrelated() throws Exception {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.ROW_LIMIT, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_ORDERBY, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        capFinder.addCapabilities("pm2", (SourceCapabilities)caps);
        String sql = "select e2 from pm1.g1 as x order by e1";
        TestOptimizer.helpPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT pm1.g1.e2, pm1.g1.e1 FROM pm1.g1 ORDER BY pm1.g1.e1"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
    }

    @Test
    public void testProjectionRaisingWithAlias() throws Exception {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.ROW_LIMIT, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_ORDERBY, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        capFinder.addCapabilities("pm2", (SourceCapabilities)caps);
        String sql = "select (select e1 from pm2.g1 where e2 = x.e2) as z, x.e1 as foo from pm1.g1 as x order by foo limit 1";
        TestOptimizer.helpPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT g_0.e1 AS c_0, g_0.e2 AS c_1 FROM pm1.g1 AS g_0 ORDER BY c_0 LIMIT 1"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
    }

    @Test
    public void testProjectionRaisingWithComplexOrdering() {
        String sql = "select e1 || 1, e2 / 2 from pm1.g1 as x order by e1 || 1 limit 2";
        BasicSourceCapabilities bsc = TestOptimizer.getTypicalCapabilities();
        bsc.setFunctionSupport("concat", true);
        bsc.setCapabilitySupport(SourceCapabilities.Capability.ROW_LIMIT, true);
        DefaultCapabilitiesFinder finder = new DefaultCapabilitiesFinder((SourceCapabilities)bsc);
        RelationalPlan plan = (RelationalPlan)TestOptimizer.helpPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), null, (CapabilitiesFinder)finder, new String[]{"SELECT concat(g_0.e1, '1') AS c_0, g_0.e2 AS c_1 FROM pm1.g1 AS g_0 ORDER BY c_0 LIMIT 2"}, true);
        Assert.assertTrue((boolean)(plan.getRootNode() instanceof ProjectNode));
    }

    @Test
    public void testProjectionRaisingWithComplexOrdering1() {
        String sql = "select e1 || 1 as a, e2 / 2 from pm1.g1 as x order by a, e2 limit 2";
        BasicSourceCapabilities bsc = TestOptimizer.getTypicalCapabilities();
        bsc.setFunctionSupport("concat", true);
        bsc.setCapabilitySupport(SourceCapabilities.Capability.ROW_LIMIT, true);
        DefaultCapabilitiesFinder finder = new DefaultCapabilitiesFinder((SourceCapabilities)bsc);
        RelationalPlan plan = (RelationalPlan)TestOptimizer.helpPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), null, (CapabilitiesFinder)finder, new String[]{"SELECT concat(g_0.e1, '1') AS c_0, g_0.e2 AS c_1 FROM pm1.g1 AS g_0 ORDER BY c_0, c_1 LIMIT 2"}, true);
        Assert.assertTrue((boolean)(plan.getRootNode() instanceof ProjectNode));
        HardcodedDataManager hdm = new HardcodedDataManager();
        hdm.addData("SELECT concat(g_0.e1, '1') AS c_0, g_0.e2 AS c_1 FROM pm1.g1 AS g_0 ORDER BY c_0, c_1 LIMIT 2", Arrays.asList("c1", 2), Arrays.asList("d1", 3));
        TestProcessor.helpProcess((ProcessorPlan)plan, hdm, new List[]{Arrays.asList("c1", 1), Arrays.asList("d1", 1)});
    }

    @Test
    public void testGroupDupCombination1Pushdown() throws TeiidComponentException, TeiidProcessingException {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SELECT_DISTINCT, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_INLINE_VIEWS, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_GROUP_BY, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        capFinder.addCapabilities("pm2", (SourceCapabilities)caps);
        String sql = "select e1, (select e1 from pm2.g1 where e2 = x.e2) as z from (select distinct e1, e2 from pm1.g1) as x group by e1, e2 order by e1";
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT v_0.c_0, v_0.c_1 FROM (SELECT DISTINCT g_0.e1 AS c_0, g_0.e2 AS c_1 FROM pm1.g1 AS g_0) AS v_0 GROUP BY v_0.c_0, v_0.c_1 ORDER BY c_0"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, new int[]{1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0});
        TestOptimizer.checkNodeTypes(plan, new int[]{0}, new Class[]{TestOptimizer.DupRemoveSortNode.class});
    }

    @Test
    public void testSortDupCombinationUnrelated() throws TeiidComponentException, TeiidProcessingException {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        String sql = "select e1 from (select e1, e2 from pm1.g1 union select e1, e2 from pm1.g2) as x order by e2";
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT pm1.g1.e1, pm1.g1.e2 FROM pm1.g1", "SELECT pm1.g2.e1, pm1.g2.e2 FROM pm1.g2"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, new int[]{2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1});
        TestOptimizer.checkNodeTypes(plan, new int[]{1}, new Class[]{TestOptimizer.DupRemoveSortNode.class});
    }

    @Test
    public void testSortDupCombinationUnrelated1() throws TeiidComponentException, TeiidProcessingException {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        String sql = "select e1 || 'a' from (select e1, e2 from pm1.g1 union select e1, e2 from pm1.g2) as x order by e2";
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT pm1.g1.e1, pm1.g1.e2 FROM pm1.g1", "SELECT pm1.g2.e1, pm1.g2.e2 FROM pm1.g2"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, new int[]{2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 1});
        TestOptimizer.checkNodeTypes(plan, new int[]{1}, new Class[]{TestOptimizer.DupRemoveSortNode.class});
    }

    @Test
    public void testUnrelatedSortFunctionOverUnion() throws Exception {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        String sql = "select e1 || 'a' from (select e1, e2 from pm1.g1 union select e1, e2 from pm1.g2) as x order by e2 || 'b'";
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT pm1.g1.e1, pm1.g1.e2 FROM pm1.g1", "SELECT pm1.g2.e1, pm1.g2.e2 FROM pm1.g2"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, new int[]{2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 1});
        TestOptimizer.checkNodeTypes(plan, new int[]{1}, new Class[]{TestOptimizer.DupRemoveSortNode.class});
    }

    @Test
    public void testUnionWithAggregation() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.fromDDL("create foreign table items (item_id varchar)", "x", "y");
        String sql = "select FOO.SOURCE SOURCE, FOO.FOO_ID FOO_ID from ((select 'X' SOURCE, ITEMS.ITEM_ID FOO_ID from ITEMS ITEMS group by ITEMS.ITEM_ID) union all (select 'Y' SOURCE, ITEMS.ITEM_ID FOO_ID from ITEMS ITEMS) union all (select 'Z' SOURCE, '123' FOO_ID) ) FOO order by FOO_ID desc limit 50";
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.ROW_LIMIT, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_UNION, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_GROUP_BY, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SET_ORDER_BY, true);
        TestOptimizer.helpPlan(sql, (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)new DefaultCapabilitiesFinder((SourceCapabilities)caps), new String[]{"SELECT 'X' AS c_0, g_1.item_id AS c_1 FROM y.items AS g_1 GROUP BY g_1.item_id UNION ALL SELECT 'Y' AS c_0, g_0.item_id AS c_1 FROM y.items AS g_0 ORDER BY c_1 DESC LIMIT 50"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
    }

    @Test
    public void testDistinctPushdownUnionWithConstant() throws Exception {
        String sql = "select distinct e1, 1 from (select 'a' as e1 from pm1.g1 union all select 'b' from pm1.g2) as x";
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SELECT_DISTINCT, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SELECT_EXPRESSION, false);
        caps.setCapabilitySupport(SourceCapabilities.Capability.ROW_LIMIT, true);
        TestOptimizer.helpPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), null, (CapabilitiesFinder)new DefaultCapabilitiesFinder((SourceCapabilities)caps), new String[]{"SELECT g_0.e1 FROM pm1.g1 AS g_0 LIMIT 1", "SELECT g_0.e1 FROM pm1.g2 AS g_0 LIMIT 1"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
    }

    @Test
    public void testDistinctPushdown() throws Exception {
        String sql = "select distinct e1, 1 from pm1.g1";
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SELECT_DISTINCT, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SELECT_EXPRESSION, false);
        caps.setCapabilitySupport(SourceCapabilities.Capability.ROW_LIMIT, true);
        TestOptimizer.helpPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), null, (CapabilitiesFinder)new DefaultCapabilitiesFinder((SourceCapabilities)caps), new String[]{"SELECT DISTINCT g_0.e1 FROM pm1.g1 AS g_0"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
    }

    @Test
    public void testDistinctPushdown1() throws Exception {
        String sql = "select distinct e1, 1 from pm1.g1 limit 1";
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SELECT_DISTINCT, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SELECT_EXPRESSION, false);
        caps.setCapabilitySupport(SourceCapabilities.Capability.ROW_LIMIT, true);
        TestOptimizer.helpPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), null, (CapabilitiesFinder)new DefaultCapabilitiesFinder((SourceCapabilities)caps), new String[]{"SELECT DISTINCT g_0.e1 FROM pm1.g1 AS g_0"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
    }

    @Test
    public void testDistinctPushdownWithGrouping() throws Exception {
        String sql = "select distinct e1, e2, 1, 2 from (select e1, e2 from pm1.g1 group by e1, e2) v";
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SELECT_DISTINCT, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SELECT_EXPRESSION, false);
        caps.setCapabilitySupport(SourceCapabilities.Capability.ROW_LIMIT, true);
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), null, (CapabilitiesFinder)new DefaultCapabilitiesFinder((SourceCapabilities)caps), new String[]{"SELECT DISTINCT g_0.e1, g_0.e2 FROM pm1.g1 AS g_0"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        HardcodedDataManager dataManager = new HardcodedDataManager();
        dataManager.addData("SELECT DISTINCT g_0.e1, g_0.e2 FROM pm1.g1 AS g_0", Arrays.asList("a", 1), Arrays.asList("b", 2));
        List[] expectedResults = new List[]{Arrays.asList("a", 1, 1, 2), Arrays.asList("b", 2, 1, 2)};
        TestProcessor.helpProcess(plan, dataManager, expectedResults);
    }
}

