/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer.proc;

import java.util.Collections;
import org.junit.Test;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryValidatorException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.metadata.Table;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TempMetadataID;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.optimizer.QueryOptimizer;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.DefaultCapabilitiesFinder;
import org.teiid.query.parser.QueryParser;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.resolver.QueryResolver;
import org.teiid.query.rewriter.QueryRewriter;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.proc.CreateProcedureCommand;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.unittest.RealMetadataFactory;
import org.teiid.query.validator.Validator;
import org.teiid.query.validator.ValidatorFailure;
import org.teiid.query.validator.ValidatorReport;

public class TestProcedurePlanner {
    private static boolean DEBUG = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProcessorPlan helpPlanProcedure(String userQuery, String procedure, Table.TriggerEvent procedureType) throws TeiidComponentException, QueryMetadataException, TeiidProcessingException {
        Command userCommand;
        TransformationMetadata metadata = RealMetadataFactory.exampleUpdateProc(procedureType, procedure);
        QueryParser parser = QueryParser.getQueryParser();
        Command command = userCommand = userQuery != null ? parser.parseCommand(userQuery) : parser.parseCommand(procedure);
        if (userCommand instanceof CreateProcedureCommand) {
            GroupSymbol gs = new GroupSymbol("proc");
            gs.setMetadataID((Object)new TempMetadataID("proc", Collections.EMPTY_LIST));
            ((CreateProcedureCommand)userCommand).setVirtualGroup(gs);
        }
        QueryResolver.resolveCommand((Command)userCommand, (QueryMetadataInterface)metadata);
        ValidatorReport report = Validator.validate((LanguageObject)userCommand, (QueryMetadataInterface)metadata);
        if (report.hasItems()) {
            ValidatorFailure firstFailure = (ValidatorFailure)report.getItems().iterator().next();
            throw new QueryValidatorException(firstFailure.getMessage());
        }
        userCommand = QueryRewriter.rewrite((Command)userCommand, (QueryMetadataInterface)metadata, null);
        AnalysisRecord analysisRecord = new AnalysisRecord(false, DEBUG);
        try {
            ProcessorPlan processorPlan = QueryOptimizer.optimizePlan((Command)userCommand, (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)new DefaultCapabilitiesFinder(), (AnalysisRecord)analysisRecord, null);
            return processorPlan;
        }
        finally {
            if (DEBUG) {
                System.out.println(analysisRecord.getDebugLog());
            }
        }
    }

    @Test
    public void testCreateVirtualProcedure1() throws Exception {
        String procedure = "CREATE VIRTUAL PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "SELECT e1 INTO #temptable FROM vm1.g1;\n";
        procedure = procedure + "SELECT e1 FROM #temptable;\n";
        procedure = procedure + "END\n";
        this.helpPlanProcedure(null, procedure, Table.TriggerEvent.UPDATE);
    }

    @Test
    public void testCreateVirtualProcedure2() throws Exception {
        String procedure = "CREATE VIRTUAL PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "SELECT e1, convert(e2, string) INTO #temptable FROM vm1.g1;\n";
        procedure = procedure + "SELECT e1 FROM #temptable;\n";
        procedure = procedure + "END\n";
        this.helpPlanProcedure(null, procedure, Table.TriggerEvent.UPDATE);
    }

    @Test
    public void testCreateVirtualProcedure3() throws Exception {
        String procedure = "CREATE VIRTUAL PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "SELECT e1, convert(e2, string) as a1 INTO #temptable FROM vm1.g1;\n";
        procedure = procedure + "SELECT e1 FROM #temptable;\n";
        procedure = procedure + "END\n";
        this.helpPlanProcedure(null, procedure, Table.TriggerEvent.UPDATE);
    }

    @Test
    public void testCase4504() throws Exception {
        String procedure = "CREATE VIRTUAL PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "SELECT y INTO #temptable FROM (select x.e1 as y from (select convert(pm1.g1.e1, date) e1 from pm1.g1) x) z;\n";
        procedure = procedure + "loop on (SELECT y FROM #temptable) as mycursor\n";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "select * from #temptable;\n";
        procedure = procedure + "END\n";
        procedure = procedure + "END\n";
        this.helpPlanProcedure(null, procedure, Table.TriggerEvent.UPDATE);
    }
}

